/*
 * Decompiled with CFR 0.152.
 */
package main;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXProgressBar;
import io.sentry.Sentry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Scanner;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import javax.net.ssl.HttpsURLConnection;

public class UpdaterController {
    @FXML
    private AnchorPane rootAnchor;
    @FXML
    private JFXButton submitBtn;
    @FXML
    private JFXButton cancelBtn;
    @FXML
    private JFXProgressBar progressBar;
    @FXML
    private Label fileLabel;
    @FXML
    private Label stateLabel;
    @FXML
    private Label nameFile;
    private File hashCodesFileLocal;
    private MessageDigest md5Digest;
    private FileInputStream myReader;
    private HashMap<String, String> fileHashLocal;
    private HashMap<String, String> fileHashServer;
    private String state;
    private double anchorX;
    private double anchorY;
    private String baseUrl = "https://assets.deepmine.ir/desktop/";

    public void initialize() {
        this.state = "pre";
    }

    @FXML
    void rootAnchorDrag(MouseEvent event) {
        Stage stage = (Stage)this.submitBtn.getScene().getWindow();
        stage.setX(event.getScreenX() - this.anchorX);
        stage.setY(event.getScreenY() - this.anchorY);
    }

    @FXML
    void rootAnchorPress(MouseEvent event) {
        this.anchorX = event.getSceneX();
        this.anchorY = event.getSceneY();
    }

    private void putHashCodeFileServer() {
        Scanner scanner = new Scanner(this.myReader);
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            this.fileHashServer.put(line.split("\\\\")[0], line.split("\\\\")[1]);
        }
        scanner.close();
        try {
            this.myReader.close();
        }
        catch (IOException e) {
            Sentry.captureException((Throwable)e);
        }
    }

    private void findAllFile(final File file, String relativePath) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                UpdaterController.this.nameFile.setText(file.getName());
            }
        });
        if (relativePath.equals("clientDb") || relativePath.contains("objectbox-jni-windows") || relativePath.equals("updater.jar") || relativePath.equals("resources/config.properties") || relativePath.equals("resources/hashes.txt") || relativePath.equals("HashForUpdate.jar") || relativePath.contains("git")) {
            System.out.println("unnecessary file: " + relativePath);
        } else if (file.isFile()) {
            try {
                String checksum = null;
                checksum = this.getFileChecksum(this.md5Digest, file);
                this.fileHashLocal.put(relativePath, checksum);
            }
            catch (IOException e) {
                System.out.println(file.getName() + "  : error");
                e.printStackTrace();
            }
        } else {
            File[] files;
            for (File curFile : files = file.listFiles()) {
                if (!relativePath.isEmpty()) {
                    this.findAllFile(curFile, relativePath + "/" + curFile.getName());
                    continue;
                }
                this.findAllFile(curFile, curFile.getName());
            }
        }
    }

    private String getFileChecksum(MessageDigest digest, File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        byte[] byteArray = new byte[1024];
        int bytesCount = 0;
        while ((bytesCount = fis.read(byteArray)) != -1) {
            digest.update(byteArray, 0, bytesCount);
        }
        fis.close();
        byte[] bytes = digest.digest();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(Integer.toString((bytes[i] & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    private void updateAllFiles() {
        ArrayList<String> removedFiles = new ArrayList<String>();
        float sum = 0.0f;
        float count = this.fileHashLocal.size();
        for (final String fileRelative : this.fileHashLocal.keySet()) {
            final float finalSum = sum += 1.0f;
            final float finalCount = count;
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    UpdaterController.this.fileLabel.setText(fileRelative);
                    UpdaterController.this.progressBar.setProgress((double)(finalSum / finalCount));
                }
            });
            if (this.fileHashServer.get(fileRelative) != null) {
                if (!this.fileHashLocal.get(fileRelative).equals(this.fileHashServer.get(fileRelative))) {
                    try {
                        System.out.println("download file: " + fileRelative);
                        this.download(fileRelative, fileRelative);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                this.fileHashServer.remove(fileRelative);
                continue;
            }
            removedFiles.add(fileRelative);
        }
        sum = 0.0f;
        count = this.fileHashServer.size();
        for (final String fileName : this.fileHashServer.keySet()) {
            final float finalSum1 = sum += 1.0f;
            final float finalCount1 = count;
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    UpdaterController.this.fileLabel.setText(fileName);
                    UpdaterController.this.progressBar.setProgress((double)(finalSum1 / finalCount1));
                }
            });
            try {
                this.download(fileName, fileName);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        for (String path : removedFiles) {
            try {
                Files.delete(Path.of(path, new String[0]));
            }
            catch (IOException e) {
                Sentry.captureException((Throwable)e);
                System.out.println("cannot delete file: " + path);
            }
            System.out.println("delete file: " + path);
        }
        try {
            Files.delete(Path.of("resources/hashes.txt", new String[0]));
        }
        catch (IOException e) {
            Sentry.captureException((Throwable)e);
            System.out.println("cannot delete file: resources/hashes.txt");
        }
    }

    public void download(String outputUrl, String inputPath) throws IOException {
        HttpURLConnection connection;
        URL input = new URL(this.baseUrl + inputPath);
        System.out.println("input : " + input);
        if ("http".equals(input.getProtocol())) {
            connection = (HttpURLConnection)input.openConnection();
        } else if ("https".equals(input.getProtocol())) {
            connection = (HttpsURLConnection)input.openConnection();
        } else {
            System.err.println("UNSUPPORTED PROTOCOL!");
            return;
        }
        connection.connect();
        if (connection.getResponseCode() / 100 != 2) {
            System.out.println("connection error");
            throw new IOException(connection.getResponseCode() + connection.getResponseMessage());
        }
        File file = new File(outputUrl);
        long contentLength = connection.getContentLengthLong();
        System.out.println("Content Length = " + contentLength + " bytes.");
        try (InputStream in = connection.getInputStream();
             FileOutputStream out = new FileOutputStream(file);){
            int read;
            int totalRead = 0;
            byte[] buffer = new byte[1024];
            while ((long)totalRead < contentLength && (read = in.read(buffer)) != -1) {
                out.write(buffer, 0, read);
                System.out.println("Downloading>>total read is " + (totalRead += read) + " bytes.");
            }
            System.out.println("Download finished!\nTotal Read = " + totalRead);
        }
        catch (IOException ex) {
            System.err.println("");
        }
    }

    private void closeAndRunZiType() {
        System.out.println("run exe");
        try {
            File test = new File(".");
            System.out.println(test.getCanonicalPath());
            System.out.println(test.getAbsolutePath());
            Process process = Runtime.getRuntime().exec("ZiType.exe", null, new File(test.getCanonicalPath()));
            System.exit(0);
        }
        catch (IOException e) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    UpdaterController.this.stateLabel.setText(e.getMessage());
                    System.out.println("message : " + e.getMessage());
                }
            });
            e.printStackTrace();
        }
        System.exit(0);
    }

    @FXML
    void cancel(ActionEvent event) {
        if (this.state.equals("pre")) {
            this.closeAndRunZiType();
        }
    }

    @FXML
    public void start(ActionEvent event) {
        this.stateLabel.setText("\u062f\u0631 \u062d\u0627\u0644 \u0627\u0645\u0627\u062f\u0647 \u0633\u0627\u0632\u06cc");
        this.stateLabel.setTextFill(Paint.valueOf((String)"#fafafa"));
        if (this.state.equals("pre")) {
            this.stateLabel.setVisible(true);
            File file = new File(".");
            Path currentRelativePath = Paths.get("", new String[0]);
            String s = currentRelativePath.toAbsolutePath().toString();
            System.out.println("s:" + s);
            System.out.println("file = " + file.getAbsoluteFile().getParent());
            final String currentFolder = file.getAbsoluteFile().getParent();
            System.out.println("current root : " + currentFolder);
            Task task = new Task(){

                protected Object call() throws Exception {
                    try {
                        UpdaterController.this.md5Digest = MessageDigest.getInstance("MD5");
                    }
                    catch (NoSuchAlgorithmException e) {
                        e.printStackTrace();
                    }
                    try {
                        UpdaterController.this.myReader = new FileInputStream("resources/hashes.txt");
                        System.out.println("Successfully wrote to the file.");
                    }
                    catch (IOException e) {
                        System.out.println("An error occurred.");
                        e.printStackTrace();
                    }
                    UpdaterController.this.fileHashLocal = new HashMap();
                    UpdaterController.this.fileHashServer = new HashMap();
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            UpdaterController.this.cancelBtn.setVisible(false);
                            UpdaterController.this.submitBtn.setDisable(true);
                            UpdaterController.this.stateLabel.setVisible(true);
                            UpdaterController.this.progressBar.setDisable(false);
                            UpdaterController.this.progressBar.setProgress(-1.0);
                        }
                    });
                    File file = new File(currentFolder);
                    UpdaterController.this.findAllFile(file, "");
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            UpdaterController.this.stateLabel.setText("\u062f\u0631 \u062d\u0627\u0644 \u06af\u0631\u0641\u062a\u0646 \u062a\u063a\u06cc\u06cc\u0631\u0627\u062a...");
                        }
                    });
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            UpdaterController.this.cancelBtn.setVisible(false);
                            UpdaterController.this.submitBtn.setDisable(true);
                            UpdaterController.this.stateLabel.setVisible(true);
                            UpdaterController.this.progressBar.setDisable(false);
                        }
                    });
                    UpdaterController.this.putHashCodeFileServer();
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            UpdaterController.this.stateLabel.setText("\u062f\u0631 \u062d\u0627\u0644 \u0628\u0631\u0648\u0632 \u0631\u0633\u0627\u0646\u06cc...");
                        }
                    });
                    UpdaterController.this.updateAllFiles();
                    return null;
                }
            };
            this.runATask((Task<Void>)task);
        } else if (this.state.equals("ok")) {
            this.closeAndRunZiType();
        }
    }

    public void runATask(Task<Void> task) {
        task.setOnSucceeded(event -> {
            this.state = "ok";
            this.stateLabel.setText("\u0628\u0631\u0648\u0632 \u0631\u0633\u0627\u0646\u06cc \u0628\u0627 \u0645\u0648\u0641\u0642\u06cc\u062a \u0627\u0646\u062c\u0627\u0645 \u0634\u062f.");
            this.stateLabel.setTextFill(Paint.valueOf((String)"#fff59d"));
            this.submitBtn.setText("\u062a\u0627\u06cc\u06cc\u062f");
            this.submitBtn.setDisable(false);
            try {
                this.myReader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        task.setOnCancelled(event -> System.out.println("cancel"));
        task.setOnFailed(event -> {
            task.getException().printStackTrace();
            Sentry.captureException((Throwable)task.getException());
            System.out.println("failed");
            this.submitBtn.setDisable(false);
            this.cancelBtn.setVisible(true);
            this.stateLabel.setText("\u0628\u0631\u0648\u0632 \u0631\u0633\u0627\u0646\u06cc \u0627\u0646\u062c\u0627\u0645 \u0646\u0634\u062f.");
            this.stateLabel.setTextFill(Paint.valueOf((String)"#fff59d"));
        });
        Thread th = new Thread((Runnable)task);
        th.setDaemon(true);
        th.start();
    }
}

