/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.utils;

import ir.deepmine.dictation.utils.Constants;
import ir.deepmine.dictation.utils.Tuple2;
import ir.deepmine.dictation.utils.Tuple4;
import ir.deepmine.dictation.utils.Utilities;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;

final class WordToNumber {
    private final Map<String, Tuple2<Long, Integer>> basicForms = Constants.basicForms;
    private final Map<String, Tuple2<Long, Integer>> scaleForms = Constants.scaleForms;
    private final Map<String, Integer> decimalForms = Constants.decimalForms;
    private static final Pattern splitPattern = Pattern.compile("[ \u0239]+");
    private static final WordToNumber instance = new WordToNumber();

    private WordToNumber() {
    }

    static WordToNumber getInstance() {
        return instance;
    }

    String convert(String str, boolean convertGeneralNumber, boolean convertDateAndTime, boolean convertPhoneNumber, boolean typeToWord, char dateDelimiter) {
        if (!(convertGeneralNumber || convertDateAndTime || convertPhoneNumber)) {
            return str;
        }
        String[] words = splitPattern.split(str);
        ArrayList<String> outputWords = new ArrayList<String>(words.length);
        int index = 0;
        while (index < words.length) {
            if (convertDateAndTime) {
                Tuple2<String, Integer> outputTime = this.wordToTime(words, index);
                if (((String)outputTime.Item1).length() == 5 || ((String)outputTime.Item1).length() == 8) {
                    outputWords.add(this.normalize((String)outputTime.Item1));
                    index = (Integer)outputTime.Item2;
                    continue;
                }
            }
            Tuple2<String, Integer> outputDigit = this.wordToNum(words, index);
            if (convertDateAndTime) {
                Tuple2<String, Integer> outputDate = this.wordToDate(words, index, typeToWord, dateDelimiter);
                if (((String)outputDate.Item1).length() >= 8 && (Integer)outputDate.Item2 > (Integer)outputDigit.Item2) {
                    outputWords.add(this.normalize((String)outputDate.Item1));
                    index = (Integer)outputDate.Item2;
                    continue;
                }
            }
            if (convertPhoneNumber) {
                Tuple2<String, Integer> outputPhone = this.wordToPhoneNumber(words, index, typeToWord);
                if (((String)outputPhone.Item1).length() >= 4 && (Integer)outputPhone.Item2 > (Integer)outputDigit.Item2) {
                    outputWords.add(this.normalize((String)outputPhone.Item1));
                    index = (Integer)outputPhone.Item2;
                    continue;
                }
            }
            if (((String)outputDigit.Item1).length() == 0 || !convertGeneralNumber) {
                outputWords.add(words[index]);
                ++index;
                continue;
            }
            outputWords.add(this.normalize((String)outputDigit.Item1));
            index = (Integer)outputDigit.Item2;
        }
        return Utilities.join(" ", outputWords);
    }

    private String normalize(String str) {
        return Utilities.normalizeDigits(str);
    }

    private Tuple2<String, Integer> wordToNum(String[] words, int index) {
        try {
            long tempVal = 0L;
            int len = words.length;
            Integer decimalPoints = null;
            int additionalZero = 0;
            boolean inDecimal = false;
            ArrayList<Tuple4<Long, Long, Integer, String>> levels = new ArrayList<Tuple4<Long, Long, Integer, String>>(4);
            ArrayList decimalLevels = new ArrayList(4);
            ArrayList<Tuple4<Long, Long, Integer, String>> currentLevels = levels;
            boolean vaIsRequired = false;
            int lastLevel = 1000;
            int lastLevel2 = 1000;
            while (index < len) {
                Tuple2<Long, Integer> temp1 = this.basicForms.get(words[index]);
                if (temp1 != null) {
                    if (vaIsRequired) break;
                    if ((Integer)temp1.Item2 < lastLevel || tempVal == 0L) {
                        tempVal += ((Long)temp1.Item1).longValue();
                    } else {
                        if (index <= 1 || !words[index - 1].equals("\u0648")) break;
                        --index;
                        break;
                    }
                    lastLevel = (Integer)temp1.Item2;
                    ++index;
                    if ((Long)temp1.Item1 != 0L) {
                        vaIsRequired = true;
                        continue;
                    }
                    if (inDecimal) {
                        ++additionalZero;
                        continue;
                    }
                    return new Tuple2<String, Integer>("0", index);
                }
                Tuple2<Long, Integer> temp2 = this.scaleForms.get(words[index]);
                if (temp2 != null) {
                    if (vaIsRequired || (Integer)temp2.Item2 < lastLevel2) {
                        if ((Long)temp2.Item1 != 100L) {
                            if (tempVal == 0L) {
                                tempVal = 1L;
                            }
                            currentLevels.add(new Tuple4<Long, Long, Integer, String>(tempVal, (Long)temp2.Item1, (Integer)temp2.Item2, words[index]));
                            tempVal = 0L;
                        } else {
                            if (tempVal >= 10L) {
                                if (index <= 1 || !words[index - 1].equals("\u0648")) break;
                                --index;
                                break;
                            }
                            tempVal = tempVal == 0L ? (Long)temp2.Item1 : tempVal * (Long)temp2.Item1;
                        }
                    } else {
                        if (index <= 1 || !words[index - 1].equals("\u0648")) break;
                        --index;
                        break;
                    }
                    lastLevel = 1000;
                    lastLevel2 = (Integer)temp2.Item2;
                    vaIsRequired = true;
                    ++index;
                    continue;
                }
                decimalPoints = this.decimalForms.get(words[index]);
                if (decimalPoints != null) {
                    ++index;
                    break;
                }
                if (words[index].equals("\u0645\u0645\u06cc\u0632")) {
                    vaIsRequired = false;
                    if (tempVal != 0L) {
                        currentLevels.add(new Tuple4<Long, Long, Integer, String>(tempVal, 1L, 0, ""));
                    }
                    currentLevels = decimalLevels;
                    tempVal = 0L;
                    lastLevel2 = 1000;
                    lastLevel = 1000;
                    inDecimal = true;
                    ++index;
                    continue;
                }
                if (words[index].equals("\u0648")) {
                    vaIsRequired = false;
                    if (levels.size() <= 0 && tempVal == 0L) break;
                    ++index;
                    continue;
                }
                if (!vaIsRequired) break;
            }
            if (tempVal != 0L) {
                currentLevels.add(new Tuple4<Long, Long, Integer, String>(tempVal, 1L, 0, ""));
            }
            long outputNum = 0L;
            StringBuilder outputStr = new StringBuilder(8);
            if (levels.size() > 0) {
                if ((Integer)((Tuple4)levels.get((int)(levels.size() - 1))).Item3 < 1) {
                    for (Tuple4 tuple4 : levels) {
                        outputNum += (Long)tuple4.Item1 * (Long)tuple4.Item2;
                    }
                    outputStr.append(outputNum);
                } else {
                    for (Tuple4 tuple4 : levels) {
                        outputStr.append(String.format(Locale.ENGLISH, "%d %s \u0648 ", tuple4.Item1, tuple4.Item4));
                    }
                    outputStr.setLength(outputStr.length() - 3);
                }
            }
            long decimalNum = 0L;
            Object decimalOutputStr = "";
            if (decimalLevels.size() > 0) {
                for (Tuple4 level : decimalLevels) {
                    decimalNum += (Long)level.Item1 * (Long)level.Item2;
                }
                decimalOutputStr = decimalPoints != null ? String.format(".%0" + decimalPoints + "d", decimalNum) : (additionalZero > 0 ? String.format(".%0" + additionalZero + "d%d", 0, decimalNum) : "." + decimalNum);
            }
            if (outputStr.length() == 0 && ((String)decimalOutputStr).length() > 0) {
                outputStr.append("0");
            }
            outputStr.append((String)decimalOutputStr);
            return new Tuple2<String, Integer>(outputStr.toString().replace('.', '\u066b'), index);
        }
        catch (Exception exp) {
            return new Tuple2<String, Integer>("", 0);
        }
    }

    private Tuple2<String, Integer> wordToPhoneNumber(String[] words, int index, boolean typeToWord) {
        try {
            long tempVal = 0L;
            long currentVal = 0L;
            int len = words.length;
            StringBuilder outputNumber = new StringBuilder(16);
            boolean commaWasLast = true;
            boolean zeroWasAdded = false;
            boolean fixSlash = false;
            int lastLevel = 1000;
            while (index < len) {
                Tuple2<Long, Integer> temp1 = this.basicForms.get(words[index]);
                if (temp1 != null) {
                    ++index;
                    if (!commaWasLast) {
                        if ((Long)temp1.Item1 == 0L && tempVal > 0L && tempVal < 10L && currentVal == 0L) {
                            while (tempVal > 0L) {
                                outputNumber.append("0");
                                --tempVal;
                            }
                            zeroWasAdded = true;
                        } else {
                            if (tempVal + currentVal != 0L || !zeroWasAdded) {
                                outputNumber.append(tempVal + currentVal);
                            }
                            zeroWasAdded = false;
                            currentVal = 0L;
                        }
                        tempVal = (Long)temp1.Item1;
                        lastLevel = (Integer)temp1.Item2;
                        continue;
                    }
                    if ((Long)temp1.Item1 == 0L) {
                        outputNumber.append('0');
                        lastLevel = (Integer)temp1.Item2;
                        continue;
                    }
                    commaWasLast = false;
                    tempVal += ((Long)temp1.Item1).longValue();
                    lastLevel = (Integer)temp1.Item2;
                    continue;
                }
                Tuple2<Long, Integer> temp2 = this.scaleForms.get(words[index]);
                if (temp2 != null) {
                    if (commaWasLast && tempVal > 0L && lastLevel <= (Integer)temp2.Item2) {
                        index -= 2;
                        break;
                    }
                    commaWasLast = false;
                    currentVal += tempVal == 0L ? (Long)temp2.Item1 : tempVal * (Long)temp2.Item1;
                    lastLevel = (Integer)temp2.Item2;
                    tempVal = 0L;
                    ++index;
                    continue;
                }
                if (words[index].equals("\u0645\u0645\u06cc\u0632") || words[index].equals("\u0627\u0633\u0644\u0634")) {
                    ++index;
                    fixSlash = true;
                    commaWasLast = true;
                    if (tempVal + currentVal != 0L) {
                        outputNumber.append(tempVal + currentVal);
                        currentVal = 0L;
                        tempVal = 0L;
                    }
                    outputNumber.append('/');
                    continue;
                }
                if (words[index].equals("\u0648")) {
                    commaWasLast = true;
                    if (outputNumber.length() <= 0 && tempVal + currentVal == 0L) break;
                    ++index;
                    continue;
                }
                if (commaWasLast) break;
            }
            if (tempVal + currentVal != 0L) {
                outputNumber.append(tempVal + currentVal);
            }
            String output = outputNumber.toString();
            if (typeToWord && fixSlash) {
                String[] parts = output.split("/");
                outputNumber.setLength(0);
                for (int i = parts.length - 1; i >= 0; --i) {
                    outputNumber.append(parts[i]);
                    outputNumber.append('/');
                }
                outputNumber.setLength(outputNumber.length() - 1);
                output = outputNumber.toString();
            }
            return new Tuple2<String, Integer>(output, index);
        }
        catch (Exception exp) {
            return new Tuple2<String, Integer>("", 0);
        }
    }

    private Tuple2<String, Integer> wordToDate(String[] words, int index, boolean typeToWord, char dateDelimiter) {
        try {
            long tempVal = 0L;
            long currentVal = 0L;
            int len = words.length;
            boolean commaWasLast = true;
            ArrayList<Long> parts = new ArrayList<Long>(4);
            while (index < len) {
                String tempWord;
                Tuple2<Long, Integer> temp1 = this.basicForms.get(words[index]);
                if (words[index].endsWith("\u0647")) {
                    tempWord = words[index].substring(0, words[index].length() - 1);
                    if (temp1 == null && !tempWord.isEmpty()) {
                        temp1 = this.basicForms.get(tempWord);
                    }
                } else {
                    tempWord = "";
                }
                if (temp1 != null) {
                    ++index;
                    if ((Long)temp1.Item1 == 0L) {
                        return new Tuple2<String, Integer>("", 0);
                    }
                    if (!commaWasLast) {
                        parts.add(tempVal + currentVal);
                        currentVal = 0L;
                        tempVal = (Long)temp1.Item1;
                        continue;
                    }
                    commaWasLast = false;
                    tempVal += ((Long)temp1.Item1).longValue();
                    continue;
                }
                Tuple2<Long, Integer> temp2 = this.scaleForms.get(words[index]);
                if (temp2 == null && !tempWord.isEmpty()) {
                    temp2 = this.scaleForms.get(tempWord);
                }
                if (temp2 != null) {
                    commaWasLast = false;
                    if (parts.size() == 1 && tempVal <= 12L) {
                        parts.add(tempVal);
                        tempVal = 1L;
                    }
                    currentVal += tempVal == 0L ? (Long)temp2.Item1 : tempVal * (Long)temp2.Item1;
                    tempVal = 0L;
                    ++index;
                    continue;
                }
                if (words[index].equals("\u0648")) {
                    commaWasLast = true;
                    if (parts.size() <= 0 && tempVal == 0L) break;
                    ++index;
                    continue;
                }
                if (commaWasLast) break;
            }
            if (tempVal + currentVal != 0L) {
                parts.add(tempVal + currentVal);
            }
            if (parts.size() != 3 || (Long)parts.get(0) > 31L || (Long)parts.get(1) > 12L || (Long)parts.get(2) > 9999L) {
                return new Tuple2<String, Integer>("", 0);
            }
            String outputNumber = typeToWord && dateDelimiter == '/' ? String.format(Locale.ENGLISH, "%02d%c%02d%c%d", parts.get(0), Character.valueOf(dateDelimiter), parts.get(1), Character.valueOf(dateDelimiter), parts.get(2)) : String.format(Locale.ENGLISH, "%d%c%02d%c%02d", parts.get(2), Character.valueOf(dateDelimiter), parts.get(1), Character.valueOf(dateDelimiter), parts.get(0));
            return new Tuple2<String, Integer>(outputNumber, index);
        }
        catch (Exception exp) {
            return new Tuple2<String, Integer>("", 0);
        }
    }

    private Tuple2<String, Integer> wordToTime(String[] words, int index) {
        try {
            long tempVal = 0L;
            int len = words.length;
            long lastAdded = 0L;
            boolean commaWasLast = true;
            boolean minWasSeen = false;
            boolean secWasSeen = false;
            ArrayList<Long> parts = new ArrayList<Long>(4);
            while (index < len) {
                Tuple2<Long, Integer> temp1 = this.basicForms.get(words[index]);
                if (temp1 != null) {
                    ++index;
                    if ((Long)temp1.Item1 == 0L || parts.size() == 0 && (Long)temp1.Item1 > 20L) {
                        return new Tuple2<String, Integer>("", 0);
                    }
                    if (parts.size() == 0) {
                        parts.add((Long)temp1.Item1);
                        commaWasLast = false;
                        tempVal = 0L;
                        continue;
                    }
                    if (parts.size() <= 2) {
                        if (!commaWasLast) {
                            parts.add(tempVal);
                            tempVal = (Long)temp1.Item1;
                        } else {
                            if (parts.size() == 1 && (Long)parts.get(0) == 20L && (Long)temp1.Item1 < 4L) {
                                lastAdded = (Long)temp1.Item1;
                                parts.set(0, (Long)parts.get(0) + (Long)temp1.Item1);
                            } else {
                                lastAdded = 0L;
                                tempVal += ((Long)temp1.Item1).longValue();
                            }
                            commaWasLast = false;
                            continue;
                        }
                    }
                }
                if (!commaWasLast && words[index].equals("\u0648")) {
                    commaWasLast = true;
                    if (parts.size() <= 0 && tempVal == 0L) continue;
                    ++index;
                    continue;
                }
                if (words[index].equals("\u062f\u0642\u06cc\u0642\u0647")) {
                    minWasSeen = true;
                    if (lastAdded > 0L && parts.size() == 1) {
                        parts.set(0, (Long)parts.get(0) - lastAdded);
                        parts.add(lastAdded);
                    }
                    ++index;
                    continue;
                }
                if (!words[index].equals("\u062b\u0627\u0646\u06cc\u0647")) break;
                secWasSeen = true;
                ++index;
                break;
            }
            if (!minWasSeen) {
                return new Tuple2<String, Integer>("", 0);
            }
            if (tempVal != 0L) {
                parts.add(tempVal);
            }
            if (parts.size() < 2 || (Long)parts.get(0) > 23L || (Long)parts.get(1) > 59L || parts.size() == 3 && (Long)parts.get(2) > 59L) {
                return new Tuple2<String, Integer>("", 0);
            }
            String outputNumber = String.format(Locale.ENGLISH, "%02d:%02d", parts.get(0), parts.get(1));
            if (secWasSeen) {
                outputNumber = String.format(Locale.ENGLISH, "%s:%02d", outputNumber, parts.get(2));
            }
            return new Tuple2<String, Integer>(outputNumber, index);
        }
        catch (Exception exp) {
            return new Tuple2<String, Integer>("", 0);
        }
    }
}

