/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.utils;

import java.util.Arrays;

public class VoiceActivityDetector {
    private static final int WINDOW_MILLIS = 1;
    private static final int FADE_MILLIS = 2;
    private static final int MIN_SILENCE_MILLIS = 4;
    private static final int MIN_VOICE_MILLIS = 200;
    private double threshold = 1.0E-4;
    private final int sampleRate;
    private double[] fadeInFactors;
    private double[] fadeOutFactors;

    public VoiceActivityDetector(int sampleRate) {
        this.sampleRate = sampleRate;
    }

    public double getAutocorrelationThreshold() {
        return this.threshold;
    }

    public void setAutocorrelationThreshold(double threshold) {
        this.threshold = threshold;
    }

    public double[] removeSilence(double[] voiceSample) {
        int oneMilliInSamples = this.sampleRate / 1000;
        int length = voiceSample.length;
        int minSilenceLength = 4 * oneMilliInSamples;
        int minActivityLength = this.getMinimumVoiceActivityLength();
        boolean[] result = new boolean[length];
        if (length < minActivityLength) {
            return voiceSample;
        }
        int windowSize = 1 * oneMilliInSamples;
        double[] correllation = new double[windowSize];
        double[] window = new double[windowSize];
        int position = 0;
        while (position + windowSize < length) {
            System.arraycopy(voiceSample, position, window, 0, windowSize);
            double mean = this.bruteForceAutocorrelation(window, correllation);
            Arrays.fill(result, position, position + windowSize, mean > this.threshold);
            position += windowSize;
        }
        this.mergeSmallSilentAreas(result, minSilenceLength);
        int silenceCounter = this.mergeSmallActiveAreas(result, minActivityLength);
        if (silenceCounter > 0) {
            int fadeLength = 2 * oneMilliInSamples;
            this.initFadeFactors(fadeLength);
            double[] shortenedVoiceSample = new double[voiceSample.length - silenceCounter];
            int copyCounter = 0;
            for (int i = 0; i < result.length; ++i) {
                if (!result[i]) continue;
                int startIndex = i;
                int counter = 0;
                while (i < result.length && result[i++]) {
                    ++counter;
                }
                int endIndex = startIndex + counter;
                this.applyFadeInFadeOut(voiceSample, fadeLength, startIndex, endIndex);
                System.arraycopy(voiceSample, startIndex, shortenedVoiceSample, copyCounter, counter);
                copyCounter += counter;
            }
            return shortenedVoiceSample;
        }
        return voiceSample;
    }

    public int getMinimumVoiceActivityLength() {
        return 200 * this.sampleRate / 1000;
    }

    private void applyFadeInFadeOut(double[] voiceSample, int fadeLength, int startIndex, int endIndex) {
        int fadeOutStart = endIndex - fadeLength;
        for (int j = 0; j < fadeLength; ++j) {
            int n = startIndex + j;
            voiceSample[n] = voiceSample[n] * this.fadeInFactors[j];
            int n2 = fadeOutStart + j;
            voiceSample[n2] = voiceSample[n2] * this.fadeOutFactors[j];
        }
    }

    private int mergeSmallActiveAreas(boolean[] result, int minActivityLength) {
        int increment;
        int silenceCounter = 0;
        for (int i = 0; i < result.length; i += increment) {
            boolean active = result[i];
            increment = 1;
            while (i + increment < result.length && result[i + increment] == active) {
                ++increment;
            }
            if (active && increment < minActivityLength) {
                Arrays.fill(result, i, i + increment, false);
                silenceCounter += increment;
            }
            if (active) continue;
            silenceCounter += increment;
        }
        return silenceCounter;
    }

    private void mergeSmallSilentAreas(boolean[] result, int minSilenceLength) {
        int increment;
        for (int i = 0; i < result.length; i += increment) {
            boolean active = result[i];
            increment = 1;
            while (i + increment < result.length && result[i + increment] == active) {
                ++increment;
            }
            if (active || increment >= minSilenceLength) continue;
            Arrays.fill(result, i, i + increment, true);
        }
    }

    private void initFadeFactors(int fadeLength) {
        int i;
        this.fadeInFactors = new double[fadeLength];
        this.fadeOutFactors = new double[fadeLength];
        for (i = 0; i < fadeLength; ++i) {
            this.fadeInFactors[i] = 1.0 / (double)fadeLength * (double)i;
        }
        for (i = 0; i < fadeLength; ++i) {
            this.fadeOutFactors[i] = 1.0 - this.fadeInFactors[i];
        }
    }

    private double bruteForceAutocorrelation(double[] voiceSample, double[] correllation) {
        Arrays.fill(correllation, 0.0);
        int n = voiceSample.length;
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < n; ++i) {
                int n2 = j;
                correllation[n2] = correllation[n2] + voiceSample[i] * voiceSample[(n + i - j) % n];
            }
        }
        double mean = 0.0;
        for (int i = 0; i < voiceSample.length; ++i) {
            mean += correllation[i];
        }
        return mean / (double)correllation.length;
    }
}

