/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.utils;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import io.sentry.Sentry;
import ir.deepmine.dictation.database.Boxes;
import ir.deepmine.dictation.database.DateDb;
import ir.deepmine.dictation.database.DefaultPunctuationMark;
import ir.deepmine.dictation.database.DocumentLabel;
import ir.deepmine.dictation.database.Label;
import ir.deepmine.dictation.database.Plan;
import ir.deepmine.dictation.database.PunctuationMark;
import ir.deepmine.dictation.database.SpeechModel;
import ir.deepmine.dictation.database.UserData;
import ir.deepmine.dictation.exceptions.ConnectionException;
import ir.deepmine.dictation.exceptions.ExceptionHandling;
import ir.deepmine.dictation.exceptions.GeneralException;
import ir.deepmine.dictation.exceptions.InvalidTokenException;
import ir.deepmine.dictation.exceptions.NotExistException;
import ir.deepmine.dictation.exceptions.ServerException;
import ir.deepmine.dictation.utils.DoActions;
import ir.deepmine.dictation.utils.PunctuationsProcessing;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javafx.concurrent.Task;

public class UserInfo
extends Task {
    public static long previousTime = 0L;
    public static int tryMaxCount = 4;
    private static UserInfo userInfo;
    private static UserData userData;
    private static DoActions doActions;
    private static ExceptionHandling exceptionHandling;
    private static PunctuationsProcessing punctuationsProcessing;
    private String access;
    private String refresh;
    private long user_id;
    private boolean haveGoldenPlan;

    private UserInfo() {
    }

    public static UserInfo getInstance() {
        if (userInfo == null) {
            userInfo = new UserInfo();
        }
        return userInfo;
    }

    public static boolean checkAccess() {
        if (userData != null && userData.getAccess() != null && userData.getRefresh() != null) {
            userInfo.setAccess(userData.getAccess());
            userInfo.setRefresh(userData.getRefresh());
            HashMap<String, String> res = null;
            try {
                res = doActions.renewAccessWithRefresh();
                userData.setRefresh(userInfo.getRefresh());
                userData.setAccess(userInfo.getAccess());
                UserData.put(userData);
                return true;
            }
            catch (ConnectionException | GeneralException | InvalidTokenException | ServerException e) {
                System.out.println("not access");
                return false;
            }
        }
        return false;
    }

    protected Object call() throws Exception {
        this.coordinationDbWithServer();
        return null;
    }

    public String getAccess() {
        return this.access;
    }

    public void setAccess(String access) {
        this.access = access;
    }

    public String getRefresh() {
        return this.refresh;
    }

    public void setRefresh(String refresh) {
        this.refresh = refresh;
    }

    public long getUser_id() {
        return this.user_id;
    }

    public void setUser_id(long user_id) {
        this.user_id = user_id;
    }

    public boolean isHaveGoldenPlan() {
        return this.haveGoldenPlan;
    }

    public void setHaveGoldenPlan(boolean haveGoldenPlan) {
        this.haveGoldenPlan = haveGoldenPlan;
    }

    public long decodeToken(String access) {
        String[] chunks = access.split("\\.");
        Base64.Decoder decoder = Base64.getDecoder();
        String header = new String(decoder.decode(chunks[0]));
        String payload = new String(decoder.decode(chunks[1]));
        JsonObject jsonObject = (JsonObject)new Gson().fromJson(payload, JsonObject.class);
        return Long.parseLong(String.valueOf(jsonObject.get("user_id")));
    }

    public void initializeBasic() throws InvalidTokenException, GeneralException, ConnectionException, NotExistException, ServerException {
        this.coordinationDbWithServer();
        System.out.println("here2");
        this.initializePunctuation();
    }

    public void coordinationDbWithServer() throws InvalidTokenException, GeneralException, ConnectionException, NotExistException, ServerException {
        boolean success = true;
        DocumentLabel.removeAll(this.user_id);
        SpeechModel.removeAll();
        Label.removeAll(this.user_id);
        Plan.removeAll(this.user_id);
        this.updateProgress(10L, 100L);
        doActions.getSpeechModel();
        if (this.access != null && this.refresh != null && this.user_id > 0L) {
            if (Boxes.dateDbBox.isEmpty()) {
                this.coordinationSubscriptions();
            }
            doActions.getDocumentLabels();
            this.updateProgress(20L, 100L);
            doActions.getUserPunctuationMark();
            this.updateProgress(30L, 100L);
            doActions.getUserPlans();
            this.updateProgress(45L, 100L);
            doActions.getLabels();
            this.updateProgress(60L, 100L);
            DateDb dateDb = DateDb.get(this.user_id);
            Object documents = null;
            if (dateDb == null) {
                doActions.getAllDocumentForCoordination();
                this.updateProgress(75L, 100L);
            } else {
                doActions.getAllDocumentForCoordination(dateDb.getDate());
                this.updateProgress(70L, 100L);
                doActions.coordinationRemoveDocument();
                this.updateProgress(100L, 100L);
            }
            if (dateDb == null) {
                dateDb = new DateDb();
            }
            if (success) {
                dateDb.setUserId(this.user_id);
                dateDb.setDate(new Date());
                DateDb.put(dateDb);
            }
        }
    }

    public void initializePunctuation() {
        List<DefaultPunctuationMark> defaultPunctuationMarkList = DefaultPunctuationMark.getAll(true);
        List<PunctuationMark> punctuationMarks = PunctuationMark.getAll(this.user_id, true);
        for (DefaultPunctuationMark defaultPunctuationMark : defaultPunctuationMarkList) {
            punctuationsProcessing.add(defaultPunctuationMark.getWord(), defaultPunctuationMark.getMark());
        }
        for (PunctuationMark punctuationMark : punctuationMarks) {
            punctuationsProcessing.add(punctuationMark.getWord(), punctuationMark.getMark());
        }
    }

    public void syncPlans() throws ConnectionException, GeneralException, InvalidTokenException, ServerException {
        Plan.removeAll(this.user_id);
        doActions.getUserPlans();
    }

    public void syncUserPunctuation() throws ConnectionException, GeneralException, InvalidTokenException, ServerException {
        PunctuationMark.removeAll(this.user_id);
        doActions.getUserPunctuationMark();
    }

    private void coordinationSubscriptions() {
        try {
            doActions.getAccents();
        }
        catch (ConnectionException e) {
            exceptionHandling.connectionExceptionHandling(e);
        }
        catch (ServerException e) {
            exceptionHandling.serverExceptionHandling(e);
        }
        catch (GeneralException e) {
            exceptionHandling.generalExceptionHandling(e);
        }
        try {
            doActions.getEducations();
        }
        catch (GeneralException e) {
            exceptionHandling.generalExceptionHandling(e);
        }
        catch (ServerException e) {
            exceptionHandling.serverExceptionHandling(e);
        }
        catch (ConnectionException e) {
            exceptionHandling.connectionExceptionHandling(e);
        }
        try {
            doActions.getProvinces();
        }
        catch (GeneralException e) {
            exceptionHandling.generalExceptionHandling(e);
        }
        catch (ConnectionException e) {
            exceptionHandling.connectionExceptionHandling(e);
        }
        catch (ServerException e) {
            exceptionHandling.serverExceptionHandling(e);
        }
        try {
            doActions.getDefaultPunctuation();
        }
        catch (GeneralException e) {
            exceptionHandling.generalExceptionHandling(e);
        }
        catch (ConnectionException e) {
            exceptionHandling.connectionExceptionHandling(e);
        }
        catch (ServerException e) {
            exceptionHandling.serverExceptionHandling(e);
        }
        try {
            doActions.getDefaultPlans();
        }
        catch (ConnectionException e) {
            exceptionHandling.connectionExceptionHandling(e);
        }
        catch (GeneralException e) {
            exceptionHandling.generalExceptionHandling(e);
        }
        catch (InvalidTokenException e) {
            exceptionHandling.invalidTokenExceptionHandling(e);
        }
        catch (ServerException e) {
            exceptionHandling.serverExceptionHandling(e);
        }
        catch (NotExistException e) {
            Sentry.captureException((Throwable)e);
            e.printStackTrace();
        }
    }

    public void logout() {
        UserData.remove();
        this.refresh = null;
        this.access = null;
        this.user_id = 0L;
        userData = null;
    }

    static {
        userData = UserData.get();
        doActions = DoActions.getInstance();
        exceptionHandling = ExceptionHandling.getInstance();
        punctuationsProcessing = PunctuationsProcessing.getInstance();
    }
}

