/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.utils;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class SilenceDetector {
    private static final int WINDOW_MILLIS = 1;
    private static final int MIN_SILENCE_WINDOW_COUNT = 10;
    private static final int MIN_VOICE_WINDOW_COUNT = 100;
    private double threshold = 0.001;
    private final int windowSize;
    private final float[] window;
    private final int maximumIdleWindowCount;
    private int silenceWindowCount = 0;
    private final ByteBuffer byteBuffer;
    private final SilenceObserver silenceObserver;

    public SilenceDetector(int sampleRate, int maximumIdleMillis, SilenceObserver silenceObserver) {
        int oneMilliInSamples = sampleRate / 1000;
        this.windowSize = 1 * oneMilliInSamples;
        this.maximumIdleWindowCount = maximumIdleMillis / 1;
        this.window = new float[this.windowSize];
        this.byteBuffer = ByteBuffer.allocate(5 * sampleRate);
        this.byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.silenceObserver = silenceObserver;
    }

    public double getAutocorrelationThreshold() {
        return this.threshold;
    }

    public void setAutocorrelationThreshold(double threshold) {
        this.threshold = threshold;
    }

    public void process(byte[] voiceSample) {
        float max = 32767.0f;
        float[] arr = new float[voiceSample.length / 2];
        for (int i = 0; i < voiceSample.length; i += 2) {
            short s = (short)(voiceSample[i + 1] << 8 | voiceSample[i] & 0xFF);
            arr[i / 2] = (float)s / max;
        }
        this.process(arr);
    }

    public void process(float[] voiceSample) {
        int length = voiceSample.length;
        int windowCount = length / this.windowSize;
        boolean[] result = new boolean[windowCount];
        try {
            for (int position = 0; position < windowCount; ++position) {
                System.arraycopy(voiceSample, position * this.windowSize, this.window, 0, this.windowSize);
                double mean = this.bruteForceAutocorrelation(this.window);
                result[position] = mean > this.threshold;
            }
            this.mergeSmallSilentAreas(result);
            int activeWindowCount = this.mergeSmallActiveAreas(result);
            if (activeWindowCount > 0) {
                System.out.println(activeWindowCount);
                int cnt = 0;
                for (int i = result.length - 1; i > 0; --i) {
                    if (result[i]) continue;
                    ++cnt;
                }
                this.silenceWindowCount = cnt;
            } else {
                this.silenceWindowCount += result.length;
                if (this.silenceWindowCount >= this.maximumIdleWindowCount) {
                    System.out.println("Maximum silence threshold has been reached.");
                    if (this.silenceObserver != null) {
                        this.silenceObserver.onSilenceThresholdReached();
                    }
                    this.silenceWindowCount = 0;
                }
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    private int mergeSmallActiveAreas(boolean[] result) {
        int increment;
        int silenceCounter = 0;
        for (int i = 0; i < result.length; i += increment) {
            boolean active = result[i];
            increment = 1;
            while (i + increment < result.length && result[i + increment] == active) {
                ++increment;
            }
            if (active && increment < 100) {
                Arrays.fill(result, i, i + increment, false);
                silenceCounter += increment;
            }
            if (active) continue;
            silenceCounter += increment;
        }
        return result.length - silenceCounter;
    }

    private void mergeSmallSilentAreas(boolean[] result) {
        int increment;
        for (int i = 0; i < result.length; i += increment) {
            boolean active = result[i];
            increment = 1;
            while (i + increment < result.length && result[i + increment] == active) {
                ++increment;
            }
            if (active || increment >= 10) continue;
            Arrays.fill(result, i, i + increment, true);
        }
    }

    private double bruteForceAutocorrelation(float[] voiceSample) {
        int n = voiceSample.length;
        double mean = 0.0;
        for (int j = 0; j < n; ++j) {
            double correllation = 0.0;
            for (int i = 0; i < n; ++i) {
                correllation += (double)(voiceSample[i] * voiceSample[(n + i - j) % n]);
            }
            mean += correllation;
        }
        return mean / (double)n;
    }

    public static interface SilenceObserver {
        public void onSilenceThresholdReached();
    }
}

