/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.utils;

import ir.deepmine.dictation.utils.Tuple2;
import ir.deepmine.dictation.utils.Tuple3;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Pattern;

public class PunctuationsProcessing {
    private static PunctuationsProcessing instance = null;
    private final HashMap<String, Tuple2<String, Pattern>> map;
    private final HashSet<Character> punctuationsWithoutSpaceAfter = new HashSet();
    private final HashSet<Character> punctuationsWithoutSpaceBefore = new HashSet();
    private final ArrayList<Tuple2<String, Pattern>> patterns;

    private PunctuationsProcessing() {
        this.map = new HashMap();
        this.patterns = new ArrayList(64);
    }

    public static synchronized PunctuationsProcessing getInstance() {
        if (instance == null) {
            instance = new PunctuationsProcessing();
        }
        return instance;
    }

    private static String normalizeWordSequence(String wordSequence) {
        return wordSequence.replaceAll("[\\s\u200c]+", " ").trim();
    }

    private static String normalizePunctuation(String punctuation) {
        if (punctuation.contains("$") && !punctuation.contains("\\$")) {
            punctuation = punctuation.replace("$", "\\$");
        }
        if (punctuation.contains("\\n")) {
            punctuation = punctuation.replace("\\n", "\n");
        }
        return "\u0239\u0277" + punctuation.replace(' ', '\u0238') + "\u0277\u0239";
    }

    public boolean add(String wordSequence, String punctuation) {
        if (punctuation.length() == 0 || wordSequence.length() == 0) {
            return false;
        }
        char temp = punctuation.charAt(0);
        if (temp != ' ') {
            this.punctuationsWithoutSpaceBefore.add(Character.valueOf(temp));
        }
        if ((temp = punctuation.charAt(punctuation.length() - 1)) != ' ') {
            this.punctuationsWithoutSpaceAfter.add(Character.valueOf(temp));
        }
        punctuation = PunctuationsProcessing.normalizePunctuation(punctuation);
        Tuple2<String, Pattern> value = this.map.get(wordSequence = PunctuationsProcessing.normalizeWordSequence(wordSequence));
        if (value != null) {
            if (((String)value.Item1).equals(punctuation)) {
                return false;
            }
            this.patterns.remove(value);
        }
        String[] words = wordSequence.split(" ");
        StringBuilder builder = new StringBuilder(wordSequence.length() + 7 * words.length + 7);
        builder.append("(^| |\u0239)");
        builder.append(words[0]);
        for (int i = 1; i < words.length; ++i) {
            builder.append("( |\u200c)?");
            builder.append(words[i]);
        }
        builder.append("($| |\u0239)");
        Tuple3<String, Pattern, String> tuple = new Tuple3<String, Pattern, String>(punctuation, Pattern.compile(builder.toString()), wordSequence);
        int lowerIdx = -1;
        int upperIdx = this.patterns.size();
        for (int i = 0; i < this.patterns.size(); ++i) {
            Tuple3 t = (Tuple3)this.patterns.get(i);
            if (((String)t.Item3).contains(wordSequence)) {
                lowerIdx = i;
            }
            if (!wordSequence.contains((CharSequence)t.Item3) || upperIdx <= i) continue;
            upperIdx = i;
        }
        if (lowerIdx >= upperIdx) {
            return false;
        }
        this.patterns.add(lowerIdx + 1, tuple);
        this.map.put(wordSequence, tuple);
        return true;
    }

    public boolean remove(String wordSequence) {
        Tuple2<String, Pattern> value = this.map.get(wordSequence = PunctuationsProcessing.normalizeWordSequence(wordSequence));
        if (value == null) {
            return false;
        }
        this.patterns.remove(value);
        this.map.remove(wordSequence);
        return true;
    }

    public String apply(String input) {
        String output = input;
        for (Tuple2<String, Pattern> tuple : this.patterns) {
            output = ((Pattern)tuple.Item2).matcher(output).replaceAll((String)tuple.Item1);
        }
        return output;
    }

    public boolean isSpaceNeededBeforeCharacter(Character inputChar) {
        return !this.punctuationsWithoutSpaceBefore.contains(inputChar);
    }

    public boolean isSpaceNeededAfterCharacter(Character inputChar) {
        return !this.punctuationsWithoutSpaceAfter.contains(inputChar);
    }
}

