/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.utils;

import ir.deepmine.dictation.utils.Settings;
import java.util.ArrayList;
import javafx.concurrent.Task;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;

public class AudioRecorder {
    private final ArrayList<RecordObserver> listeners;
    private TargetDataLine targetDataLine;
    private Task<Integer> recordingTask;
    private final int bufferSize;
    private final int sampleRate;
    private boolean isRecording;
    private byte[] buffer;

    public AudioRecorder() {
        this(Settings.getInstance().getIntegerProperty("recorder.sample_rate"));
    }

    public AudioRecorder(int sampleRate) {
        this(sampleRate, 8000);
    }

    public AudioRecorder(int sampleRate, int bufferSize) {
        this(sampleRate, bufferSize, null);
    }

    public AudioRecorder(int sampleRate, int bufferSize, RecordObserver recordObserver) {
        this.sampleRate = sampleRate;
        this.bufferSize = bufferSize;
        this.isRecording = false;
        this.listeners = new ArrayList(2);
        if (recordObserver != null) {
            this.listeners.add(recordObserver);
        }
    }

    public void addObserver(RecordObserver recordObserver) {
        this.listeners.add(recordObserver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRecording() throws LineUnavailableException {
        AudioRecorder audioRecorder = this;
        synchronized (audioRecorder) {
            if (this.isRecording) {
                System.out.println("Warning: recorder is already started.");
                return;
            }
            this.buffer = new byte[this.bufferSize];
            AudioFormat audioFormat = new AudioFormat(this.sampleRate, 16, 1, true, false);
            DataLine.Info targetInfo = new DataLine.Info(TargetDataLine.class, audioFormat);
            if (!AudioSystem.isLineSupported(targetInfo)) {
                throw new LineUnavailableException("\u0645\u06cc\u06a9\u0631\u0648\u0641\u0648\u0646 \u062f\u0633\u062a\u06af\u0627\u0647 \u0634\u0645\u0627 \u067e\u0634\u062a\u06cc\u0628\u0627\u0646\u06cc \u0646\u0645\u06cc\u200c\u0634\u0648\u062f.");
            }
            this.targetDataLine = (TargetDataLine)AudioSystem.getLine(targetInfo);
            this.targetDataLine.open(audioFormat);
            this.targetDataLine.start();
            final AudioInputStream audioInputStream = new AudioInputStream(this.targetDataLine);
            this.recordingTask = new Task<Integer>(){

                protected Integer call() throws Exception {
                    System.out.println("Recording task is started ...");
                    int count = 0;
                    while (!this.isCancelled()) {
                        int readCount = audioInputStream.read(AudioRecorder.this.buffer);
                        for (RecordObserver listener : AudioRecorder.this.listeners) {
                            listener.onBufferReady(AudioRecorder.this.buffer, readCount);
                        }
                        ++count;
                    }
                    System.out.println("Recording task is finished.");
                    return count;
                }
            };
            Thread thread = new Thread((Runnable)this.recordingTask);
            thread.setDaemon(true);
            thread.setName("Recording thread");
            thread.start();
            this.isRecording = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRecording() {
        AudioRecorder audioRecorder = this;
        synchronized (audioRecorder) {
            if (!this.isRecording) {
                System.out.println("Recording was not started.");
                return;
            }
            this.recordingTask.cancel();
            this.targetDataLine.stop();
            this.targetDataLine.close();
            this.isRecording = false;
        }
    }

    public static interface RecordObserver {
        public void onBufferReady(byte[] var1, int var2);
    }
}

