/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.ui.planpackage;

import ir.deepmine.dictation.ui.gauge.RingProgressIndicator;
import ir.deepmine.dictation.utils.Utilities;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.AnchorPane;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.TextAlignment;

public class CustomGauge
extends AnchorPane {
    private Label numberLabel = new Label("\u0660");
    private Label unitLabel = new Label();
    private Label remainingLabel = new Label("\u0645\u0627\u0646\u062f\u0647");
    private Label fromLabel = new Label();
    private RingProgressIndicator gauge;
    private AnchorPane root;
    ChangeListener changeListener;

    public CustomGauge(AnchorPane root, String limit, String unit) {
        float place = 40.0f;
        this.gauge = new RingProgressIndicator((int)Float.parseFloat(limit), 270, 28);
        this.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("/style/plan.css").toExternalForm());
        this.root = root;
        this.numberLabel.setLayoutY(16.0);
        AnchorPane.setLeftAnchor((Node)this.numberLabel, (Double)(12.0 - (double)place));
        this.numberLabel.setPrefWidth(50.0);
        this.numberLabel.setMinWidth(50.0);
        this.numberLabel.setAlignment(Pos.CENTER);
        this.numberLabel.setTextAlignment(TextAlignment.CENTER);
        this.numberLabel.setLineSpacing(0.0);
        this.numberLabel.getStyleClass().add((Object)"unit-label");
        this.numberLabel.setFont(Font.font((String)"Vazir", (FontWeight)FontWeight.BOLD, (double)12.0));
        this.unitLabel.setLayoutY(32.5);
        this.unitLabel.setText(unit);
        this.unitLabel.setTextAlignment(TextAlignment.CENTER);
        this.unitLabel.setAlignment(Pos.CENTER);
        this.unitLabel.setLineSpacing(0.0);
        this.unitLabel.getStyleClass().add((Object)"unit-label");
        this.unitLabel.setPrefWidth(50.0);
        this.unitLabel.setMinWidth(50.0);
        AnchorPane.setLeftAnchor((Node)this.unitLabel, (Double)(14.0 - (double)place));
        this.remainingLabel.setLayoutY(49.0);
        this.remainingLabel.setAlignment(Pos.CENTER);
        this.remainingLabel.setLineSpacing(0.0);
        this.remainingLabel.getStyleClass().add((Object)"unit-label");
        this.remainingLabel.setPrefWidth(30.0);
        this.remainingLabel.setMinWidth(30.0);
        this.remainingLabel.setTextAlignment(TextAlignment.CENTER);
        AnchorPane.setLeftAnchor((Node)this.remainingLabel, (Double)(23.0 - (double)place));
        this.fromLabel.setLayoutY(71.0);
        AnchorPane.setLeftAnchor((Node)this.fromLabel, (Double)(12.5 - (double)place));
        this.fromLabel.setText("\u0627\u0632 " + Utilities.normalizeDigits(limit));
        this.fromLabel.getStyleClass().add((Object)"from-label");
        this.fromLabel.setAlignment(Pos.CENTER);
        this.fromLabel.setTextAlignment(TextAlignment.CENTER);
        this.fromLabel.setPrefWidth(50.0);
        this.fromLabel.setMinWidth(50.0);
        this.gauge.setRotate(16.0);
        this.gauge.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
        this.gauge.setPrefHeight(65.0);
        this.gauge.setPrefWidth(65.0);
        this.gauge.setMaxHeight(65.0);
        this.gauge.setMaxWidth(65.0);
        this.gauge.setMinHeight(65.0);
        this.gauge.setMinWidth(65.0);
        this.gauge.setLayoutY(8.0);
        AnchorPane.setLeftAnchor((Node)this.gauge, (Double)(5.0 - (double)place));
        this.changeListener = new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                CustomGauge.this.numberLabel.setText(Utilities.normalizeDigits(String.valueOf((int)Math.floor((Double)newValue))));
            }
        };
        this.gauge.progressProperty().addListener(this.changeListener);
        this.getChildren().addAll((Object[])new Node[]{this.gauge, this.numberLabel, this.unitLabel, this.remainingLabel, this.fromLabel});
    }

    public RingProgressIndicator getGauge() {
        return this.gauge;
    }

    public void setFromLabelText(String fromText) {
        this.fromLabel.setText(fromText);
    }

    public void setFromUnitText(String unitText) {
        this.unitLabel.setText(unitText);
    }

    public void setNumberLabel(String numberText) {
        this.gauge.progressProperty().removeListener(this.changeListener);
        this.numberLabel.setText(numberText);
    }
}

