/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.ui.notification.animations;

import ir.deepmine.dictation.ui.notification.animations.Animation;
import ir.deepmine.dictation.ui.notification.models.CustomStage;
import javafx.animation.SequentialTransition;
import javafx.animation.Timeline;
import javafx.util.Duration;

public abstract class AbstractAnimation
implements Animation {
    protected final CustomStage stage;
    protected final Timeline showAnimation;
    protected final Timeline dismissAnimation;
    protected final SequentialTransition sq;
    protected volatile boolean trayIsShowing;

    protected AbstractAnimation(CustomStage stage) {
        this.stage = stage;
        this.showAnimation = this.setupShowAnimation();
        this.dismissAnimation = this.setupDismissAnimation();
        this.sq = new SequentialTransition(new javafx.animation.Animation[]{this.setupShowAnimation(), this.setupDismissAnimation()});
    }

    protected abstract Timeline setupShowAnimation();

    protected abstract Timeline setupDismissAnimation();

    @Override
    public final CustomStage getStage() {
        return this.stage;
    }

    @Override
    public final void playSequential(Duration dismissDelay) {
        ((javafx.animation.Animation)this.sq.getChildren().get(1)).setDelay(dismissDelay);
        this.sq.play();
    }

    @Override
    public final void playShowAnimation() {
        this.showAnimation.play();
    }

    @Override
    public final void playDismissAnimation() {
        this.dismissAnimation.play();
    }

    @Override
    public final boolean isShowing() {
        return this.trayIsShowing;
    }
}

