/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.ui.notification;

import ir.deepmine.dictation.ui.notification.Notification;
import ir.deepmine.dictation.ui.notification.Notifications;
import ir.deepmine.dictation.ui.notification.animations.Animation;
import ir.deepmine.dictation.ui.notification.animations.Animations;
import ir.deepmine.dictation.ui.notification.models.CustomStage;
import java.io.IOException;
import java.net.URL;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.stage.StageStyle;
import javafx.util.Duration;

public final class TrayNotification {
    @FXML
    private Label lblTitle;
    @FXML
    private Label lblMessage;
    @FXML
    private Label lblClose;
    @FXML
    private ImageView imageIcon;
    @FXML
    private Rectangle rectangleColor;
    @FXML
    private AnchorPane rootNode;
    private CustomStage stage;
    private Notification notification;
    private Animation animation;
    private int duration;
    private EventHandler<ActionEvent> onDismissedCallBack;
    private EventHandler<ActionEvent> onShownCallback;

    public TrayNotification(String title, String body, Image img, Paint rectangleFill, Notification notification) {
        this.initTrayNotification(title, body, notification);
        this.setImage(img);
        this.setRectangleFill(rectangleFill);
    }

    public TrayNotification(String title, String body, Notification notification) {
        this.initTrayNotification(title, body, notification);
        this.duration = 2000;
    }

    public TrayNotification(String title, String body, int duration, Notification notification) {
        this.initTrayNotification(title, body, notification);
        this.duration = duration;
    }

    public TrayNotification(Notification notification) {
        this("", "", notification);
    }

    public TrayNotification(String title, Notification notification) {
        this(title, "", notification);
    }

    public TrayNotification() {
        this(Notifications.NOTICE);
    }

    private void initTrayNotification(String title, String message, Notification type) {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/fxml/TrayNotification.fxml"));
        fxmlLoader.setController((Object)this);
        try {
            fxmlLoader.load();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        this.initStage();
        this.initAnimations();
        this.setTray(title, message, type);
    }

    private void initAnimations() {
        this.setAnimation(Animations.SLIDE);
    }

    private void initStage() {
        this.stage = new CustomStage(this.rootNode, StageStyle.UNDECORATED);
        this.stage.setScene(new Scene((Parent)this.rootNode));
        this.stage.setAlwaysOnTop(true);
        this.stage.setLocation(this.stage.getBottomRight());
        this.lblClose.setOnMouseClicked(e -> this.dismiss());
    }

    public void setNotification(Notification nType) {
        this.notification = nType;
        URL imageLocation = this.getClass().getClassLoader().getResource(nType.getURLResource());
        this.setRectangleFill(Paint.valueOf((String)nType.getPaintHex()));
        this.setImage(new Image(imageLocation.toString()));
        this.setTrayIcon(this.imageIcon.getImage());
    }

    public Notification getNotification() {
        return this.notification;
    }

    public void setTray(String title, String message, Notification type) {
        this.setTitle(title);
        this.setMessage(message);
        this.setNotification(type);
    }

    public void setTray(String title, String message, Image img, Paint rectangleFill, Animation animation) {
        this.setTitle(title);
        this.setMessage(message);
        this.setImage(img);
        this.setRectangleFill(rectangleFill);
        this.setAnimation(animation);
    }

    public boolean isTrayShowing() {
        return this.animation.isShowing();
    }

    public void showAndDismiss() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!TrayNotification.this.isTrayShowing()) {
                    TrayNotification.this.stage.show();
                    TrayNotification.this.onShown();
                    TrayNotification.this.animation.playSequential(Duration.millis((double)TrayNotification.this.duration));
                } else {
                    TrayNotification.this.dismiss();
                }
                TrayNotification.this.onDismissed();
            }
        });
    }

    public void showAndWait() {
        if (!this.isTrayShowing()) {
            this.stage.show();
            this.animation.playShowAnimation();
            this.onShown();
        }
    }

    public void dismiss() {
        if (this.isTrayShowing()) {
            this.animation.playDismissAnimation();
            this.onDismissed();
        }
    }

    private void onShown() {
        if (this.onShownCallback != null) {
            this.onShownCallback.handle((Event)new ActionEvent());
        }
    }

    private void onDismissed() {
        if (this.onDismissedCallBack != null) {
            this.onDismissedCallBack.handle((Event)new ActionEvent());
        }
    }

    public void setOnDismiss(EventHandler<ActionEvent> event) {
        this.onDismissedCallBack = event;
    }

    public void setOnShown(EventHandler<ActionEvent> event) {
        this.onShownCallback = event;
    }

    public void setTrayIcon(Image img) {
        this.stage.getIcons().clear();
        this.stage.getIcons().add((Object)img);
    }

    public Image getTrayIcon() {
        return (Image)this.stage.getIcons().get(0);
    }

    public void setTitle(String txt) {
        Platform.runLater(() -> this.lblTitle.setText(txt));
    }

    public String getTitle() {
        return this.lblTitle.getText();
    }

    public void setMessage(String txt) {
        this.lblMessage.setText(txt);
    }

    public String getMessage() {
        return this.lblMessage.getText();
    }

    public void setImage(Image img) {
        this.imageIcon.setImage(img);
        this.setTrayIcon(img);
    }

    public Image getImage() {
        return this.imageIcon.getImage();
    }

    public void setRectangleFill(Paint value) {
        this.rectangleColor.setFill(value);
    }

    public Paint getRectangleFill() {
        return this.rectangleColor.getFill();
    }

    public void setAnimation(Animation animation) {
        this.animation = animation;
    }

    public void setAnimation(Animations animation) {
        this.setAnimation(animation.newInstance(this.stage));
    }

    public Animation getAnimation() {
        return this.animation;
    }
}

