/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.ui.gauge;

import ir.deepmine.dictation.ui.gauge.RingProgressIndicator;
import java.util.Collection;
import javafx.animation.Interpolator;
import javafx.animation.RotateTransition;
import javafx.scene.Node;
import javafx.scene.control.Skin;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Arc;
import javafx.util.Duration;

public class RingProgressIndicatorSkin
implements Skin<RingProgressIndicator> {
    private final RingProgressIndicator indicator;
    private final StackPane container = new StackPane();
    private final Arc fillerArc = new Arc();
    private final RotateTransition transition = new RotateTransition(Duration.millis((double)500.0), (Node)this.fillerArc);

    public RingProgressIndicatorSkin(RingProgressIndicator indicator) {
        this.indicator = indicator;
        this.setColor(indicator.progressProperty().intValue());
        this.initContainer(indicator);
        this.initFillerArc();
        this.container.widthProperty().addListener((o, oldVal, newVal) -> this.fillerArc.setCenterX((double)(newVal.intValue() / 2)));
        this.container.heightProperty().addListener((o, oldVal, newVal) -> this.fillerArc.setCenterY((double)(newVal.intValue() / 2)));
        this.updateRadii();
        this.indicator.indeterminateProperty().addListener((o, oldVal, newVal) -> this.initIndeterminate((boolean)newVal));
        this.indicator.progressProperty().addListener((o, oldVal, newVal) -> {
            if (newVal.intValue() >= 0) {
                this.fillerArc.setLength((double)((float)newVal.intValue() * -(indicator.getRange() * 1.0f / (float)indicator.getMaxValue())));
            }
            int newValue = newVal.intValue();
            this.setColor(newValue);
        });
        this.indicator.ringWidthProperty().addListener((o, oldVal, newVal) -> this.updateRadii());
        this.initTransition();
        this.initIndeterminate(indicator.isIndeterminate());
        indicator.visibleProperty().addListener((o, oldVal, newVal) -> {
            if (newVal.booleanValue() && this.indicator.isIndeterminate()) {
                this.transition.play();
            } else {
                this.transition.pause();
            }
        });
        this.container.getChildren().addAll((Object[])new Node[]{this.fillerArc});
    }

    public void setColor(int newValue) {
        if (this.indicator.getType().equals("volume_indicator")) {
            if (newValue >= 0 && newValue < 10) {
                this.fillerArc.setStyle("-fx-stroke: linear-gradient(#76f91f , #76f91f);");
            } else if (newValue >= 10 && newValue < 20) {
                this.fillerArc.setStyle("-fx-stroke: linear-gradient(#fff700, #76f91f);");
            } else if (newValue >= 20 && newValue < 30) {
                this.fillerArc.setStyle("-fx-stroke: linear-gradient(#fff700, #fff700, #76f91f);");
            } else if (newValue >= 30 && newValue < 40) {
                this.fillerArc.setStyle("-fx-stroke: linear-gradient(#fbb81d, #fff700, #fff700, #76f91f);");
            } else if (newValue >= 40 && newValue < 50) {
                this.fillerArc.setStyle("-fx-stroke: linear-gradient(#fbb81d, #fbb81d, #fff700, #fff700, #76f91f);");
            } else if (newValue >= 50 && newValue < 60) {
                this.fillerArc.setStyle("-fx-stroke: linear-gradient(#fbbf1d, #fbb81d, #fbb81d, #fff700, #fff700, #76f91f);");
            } else if (newValue >= 60 && newValue < 70) {
                this.fillerArc.setStyle("-fx-stroke: linear-gradient(#fbbf1d, #fbbf1d, #fbb81d, #fbb81d, #fff700, #fff700, #76f91f);");
            } else if (newValue >= 70 && newValue < 80) {
                this.fillerArc.setStyle("-fx-stroke: linear-gradient(#ff5700,#fbbf1d, #fbbf1d, #fbb81d, #fbb81d, #fff700, #fff700, #76f91f);");
            } else if (newValue >= 80 && newValue < 90) {
                this.fillerArc.setStyle("-fx-stroke: linear-gradient(#ff5700, #ff5700,#fbbf1d, #fbbf1d, #fbb81d, #fbb81d, #fff700, #fff700, #76f91f);");
            } else if (newValue >= 90 && newValue <= 100) {
                this.fillerArc.setStyle("-fx-stroke: linear-gradient(#ff5700, #ff5700,#ff5700,#fbbf1d, #fbbf1d, #fbb81d, #fbb81d, #fff700, #fff700, #76f91f );");
            }
        } else if (newValue >= 0 && (double)newValue < (double)this.indicator.getMaxValue() * 0.3) {
            this.fillerArc.setStyle("-fx-stroke: #ef9a9a;");
        } else if ((double)newValue >= (double)this.indicator.getMaxValue() * 0.3 && (double)newValue < (double)this.indicator.getMaxValue() * 0.7) {
            this.fillerArc.setStyle("-fx-stroke: #ffff8d;");
        } else {
            this.fillerArc.setStyle("-fx-stroke: #69f0ae;");
        }
    }

    private void initTransition() {
        this.transition.setAutoReverse(false);
        this.transition.setCycleCount(-1);
        this.transition.setDelay(Duration.ZERO);
        this.transition.setInterpolator(Interpolator.LINEAR);
        this.transition.setByAngle((double)this.indicator.getRange());
    }

    private void initFillerArc() {
        this.fillerArc.setManaged(false);
        this.fillerArc.getStyleClass().add((Object)"ringindicator-filler");
        this.fillerArc.setStartAngle(240.0);
        this.fillerArc.setLength(this.indicator.getProgress() * (double)(-(this.indicator.getRange() * 1.0f / (float)this.indicator.getMaxValue())));
    }

    private void initContainer(RingProgressIndicator indicator) {
        this.container.getStylesheets().addAll((Collection)indicator.getStylesheets());
        this.container.getStyleClass().addAll((Object[])new String[]{"circleindicator-container"});
        this.container.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.container.setMaxWidth(Double.NEGATIVE_INFINITY);
    }

    private void updateRadii() {
        double ringWidth = this.indicator.getRingWidth();
        double innerCircleRadius = this.indicator.getInnerCircleRadius();
        this.fillerArc.setRadiusY(innerCircleRadius - 1.0 + ringWidth / 2.0);
        this.fillerArc.setRadiusX(innerCircleRadius - 1.0 + ringWidth / 2.0);
        this.fillerArc.setStrokeWidth(ringWidth);
    }

    private void initIndeterminate(boolean newVal) {
        if (newVal) {
            this.fillerArc.setLength((double)this.indicator.getRange());
            this.fillerArc.getStyleClass().add((Object)"indeterminate");
            if (this.indicator.isVisible()) {
                this.transition.play();
            }
        } else {
            this.fillerArc.getStyleClass().remove((Object)"indeterminate");
            this.fillerArc.setRotate(0.0);
            this.transition.stop();
        }
    }

    public RingProgressIndicator getSkinnable() {
        return this.indicator;
    }

    public Node getNode() {
        return this.container;
    }

    public void dispose() {
        this.transition.stop();
    }
}

