/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.ui;

import io.sentry.Sentry;
import ir.deepmine.dictation.Main;
import ir.deepmine.dictation.controller.ResizeHelper;
import ir.deepmine.dictation.controller.ToolbarWithSettingController;
import ir.deepmine.dictation.utils.Utilities;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.paint.Paint;
import javafx.scene.text.FontWeight;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Duration;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class TitleBar
extends AnchorPane {
    public static JFrame frame;
    private static TitleBar titleBar;
    private static String page;
    double xOffset;
    double yOffset;
    private Button closeBtn = new Button();
    private Button minimizeBtn = new Button();
    private Button launchBtn = new Button();
    private Button maximizeBtn = new Button();
    private double lastX = 0.0;
    private double lastY = 0.0;
    private double lastWidth = 0.0;
    private double lastHeight = 0.0;
    private boolean autoMaximize = false;

    private TitleBar() {
        TitleBar.setRightAnchor((Node)this.closeBtn, (Double)0.0);
        TitleBar.setRightAnchor((Node)this.maximizeBtn, (Double)30.0);
        TitleBar.setRightAnchor((Node)this.minimizeBtn, (Double)60.0);
        TitleBar.setRightAnchor((Node)this.launchBtn, (Double)114.0);
        this.setPrefSize(960.0, 24.0);
        this.setMinSize(960.0, 24.0);
        this.setStyle("-fx-background-color: #fff59d");
        this.closeBtn.setPrefSize(24.0, 24.0);
        this.maximizeBtn.setPrefSize(24.0, 24.0);
        this.minimizeBtn.setPrefSize(24.0, 24.0);
        this.launchBtn.setPrefSize(24.0, 24.0);
        this.closeBtn.setPrefSize(24.0, 24.0);
        this.closeBtn.setMinSize(24.0, 24.0);
        this.maximizeBtn.setMinSize(24.0, 24.0);
        this.minimizeBtn.setMinSize(24.0, 24.0);
        this.launchBtn.setMinSize(24.0, 24.0);
        this.closeBtn.setMinSize(24.0, 24.0);
        ImageView closeImg = new ImageView(new Image(((Object)((Object)this)).getClass().getResourceAsStream("/icons/normal-close.png")));
        ImageView minimizeImg = new ImageView(new Image(((Object)((Object)this)).getClass().getResourceAsStream("/icons/minimize.png")));
        ImageView maximizeImg = new ImageView(new Image(((Object)((Object)this)).getClass().getResourceAsStream("/icons/maximize-big.png")));
        ImageView launchImg = new ImageView(new Image(((Object)((Object)this)).getClass().getResourceAsStream("/icons/launch.png")));
        Tooltip launchTooltip = new Tooltip("\u062d\u0627\u0644\u062a \u0646\u0648\u0627\u0631 \u0627\u0628\u0632\u0627\u0631");
        launchTooltip.setFont(javafx.scene.text.Font.font((String)"IranSans", (FontWeight)FontWeight.BLACK, (double)12.0));
        launchTooltip.setShowDelay(Duration.millis((double)400.0));
        launchImg.setRotate(180.0);
        closeImg.setFitHeight(15.0);
        closeImg.setFitWidth(15.0);
        maximizeImg.setFitHeight(15.0);
        maximizeImg.setFitWidth(15.0);
        minimizeImg.setFitHeight(15.0);
        minimizeImg.setFitWidth(15.0);
        launchImg.setFitHeight(15.0);
        launchImg.setFitWidth(15.0);
        this.closeBtn.setGraphic((Node)closeImg);
        this.maximizeBtn.setGraphic((Node)maximizeImg);
        this.minimizeBtn.setGraphic((Node)minimizeImg);
        this.launchBtn.setGraphic((Node)launchImg);
        this.launchBtn.setTooltip(launchTooltip);
        this.closeBtn.setStyle("-fx-background-color: rgb(0,0,0,0)");
        this.maximizeBtn.setStyle("-fx-background-color: rgb(0,0,0,0)");
        this.minimizeBtn.setStyle("-fx-background-color: rgb(0,0,0,0)");
        this.launchBtn.setStyle("-fx-background-color: rgb(0,0,0,0)");
        this.getChildren().add((Object)this.closeBtn);
        this.getChildren().add((Object)this.minimizeBtn);
        this.getChildren().add((Object)this.maximizeBtn);
        this.getChildren().add((Object)this.launchBtn);
        this.setEventForBackGroundColor();
        this.setMainEvents();
        this.addEventHandler(MouseEvent.MOUSE_RELEASED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (event.getScreenY() <= 0.0) {
                    TitleBar.this.maximizeBtn.setStyle("-fx-background-color: rgb(0,0,0,0)");
                    Window w = TitleBar.this.maximizeBtn.getScene().getWindow();
                    double currentX = w.getX();
                    double currentY = w.getY();
                    double currentWidth = w.getWidth();
                    double currentHeight = w.getHeight();
                    Screen screen = Screen.getPrimary();
                    Rectangle2D bounds = screen.getVisualBounds();
                    if (currentX != bounds.getMinX() && currentY != bounds.getMinY() && currentWidth != bounds.getWidth() && currentHeight != bounds.getHeight()) {
                        TitleBar.this.maximize(w, currentX, currentY, currentWidth, currentHeight, bounds);
                    }
                }
            }
        });
    }

    public static TitleBar getInstance(String pageKind) {
        page = pageKind;
        if (titleBar == null) {
            titleBar = new TitleBar();
        }
        return titleBar;
    }

    public void visibleLaunch(boolean launchVisibility) {
        if (launchVisibility) {
            this.launchBtn.setVisible(true);
            this.launchBtn.setDisable(false);
        } else {
            this.launchBtn.setVisible(false);
            this.launchBtn.setDisable(true);
        }
    }

    private void setMainEvents() {
        this.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                TitleBar.this.xOffset = event.getSceneX();
                TitleBar.this.yOffset = event.getSceneY();
            }
        });
        this.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                Stage stage = (Stage)TitleBar.this.closeBtn.getScene().getWindow();
                stage.setX(event.getScreenX() - TitleBar.this.xOffset);
                stage.setY(event.getScreenY() - TitleBar.this.yOffset);
            }
        });
        this.setOnDragDetected((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                Window w = TitleBar.this.maximizeBtn.getScene().getWindow();
                TitleBar.this.lastX = w.getX();
                TitleBar.this.lastY = w.getY();
            }
        });
        this.closeBtn.setOnMouseClicked(ActionEvent2 -> {
            System.out.println("state: " + Utilities.isInEditor);
            if (!Utilities.isInEditor) {
                Stage stage = (Stage)this.closeBtn.getScene().getWindow();
                stage.close();
                this.closeBtn.setStyle("-fx-background-color: rgb(0,0,0,0)");
                System.exit(0);
                return;
            }
            this.changeSceneToMainPage();
        });
        this.minimizeBtn.setOnMouseClicked(ActionEvent2 -> this.minimize());
        this.launchBtn.setOnMouseClicked(ActionEvent2 -> {
            this.changeSceneToToolBar();
            this.launchBtn.setStyle("-fx-background-color: rgb(0,0,0,0)");
        });
        this.maximizeBtn.setOnMouseClicked(ActionEvent2 -> this.maximizeAndDemaximize());
    }

    public void minimize() {
        Stage stage = (Stage)this.closeBtn.getScene().getWindow();
        stage.setIconified(true);
        this.minimizeBtn.setStyle("-fx-background-color: rgb(0,0,0,0)");
    }

    public void maximizeAndDemaximize() {
        Button n = this.maximizeBtn;
        this.maximizeBtn.setStyle("-fx-background-color: rgb(0,0,0,0)");
        Window w = n.getScene().getWindow();
        double currentX = w.getX();
        double currentY = w.getY();
        double currentWidth = w.getWidth();
        double currentHeight = w.getHeight();
        Screen screen = Screen.getPrimary();
        Rectangle2D bounds = screen.getVisualBounds();
        if (currentX != bounds.getMinX() && currentY != bounds.getMinY() && currentWidth != bounds.getWidth() && currentHeight != bounds.getHeight()) {
            this.maximize(w, currentX, currentY, currentWidth, currentHeight, bounds);
        } else {
            w.setX(this.lastX);
            w.setY(this.lastY > 0.0 ? this.lastY : 0.0);
            System.out.println("==>" + this.lastY);
            if (page.equals("editor")) {
                w.setWidth(Math.max(this.lastWidth, 1100.0));
                w.setHeight(Math.max(this.lastHeight, 642.25));
            } else {
                w.setWidth(this.lastWidth);
                w.setHeight(this.lastHeight);
            }
            ImageView imageView = new ImageView(new Image(((Object)((Object)this)).getClass().getResourceAsStream("/icons/maximize-big.png")));
            imageView.setFitWidth(15.0);
            imageView.setFitHeight(15.0);
            this.maximizeBtn.setGraphic((Node)imageView);
        }
    }

    private void maximize(Window w, double currentX, double currentY, double currentWidth, double currentHeight, Rectangle2D bounds) {
        w.setX(bounds.getMinX());
        w.setY(bounds.getMinY());
        w.setWidth(bounds.getWidth());
        w.setHeight(bounds.getHeight());
        this.lastX = currentX;
        this.lastY = currentY;
        System.out.println("changed last Y");
        this.lastWidth = currentWidth;
        this.lastHeight = currentHeight;
        ImageView imageView = new ImageView(new Image(((Object)((Object)this)).getClass().getResourceAsStream("/icons/maximize-small.png")));
        imageView.setFitWidth(15.0);
        imageView.setFitHeight(15.0);
        this.maximizeBtn.setGraphic((Node)imageView);
        this.setEventForBackGroundColor();
    }

    private void setEventForBackGroundColor() {
        this.closeBtn.setOnMouseEntered((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                TitleBar.this.closeBtn.setStyle("-fx-background-color: red; ");
            }
        });
        this.closeBtn.setOnMouseExited((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                TitleBar.this.closeBtn.setStyle("-fx-background-color: rgb(0,0,0,0)");
            }
        });
        this.maximizeBtn.setOnMouseEntered((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                TitleBar.this.maximizeBtn.setStyle("-fx-background-color: rgb(86, 86, 79,0.2); ");
            }
        });
        this.maximizeBtn.setOnMouseExited((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                TitleBar.this.maximizeBtn.setStyle("-fx-background-color: rgb(0,0,0,0)");
            }
        });
        this.minimizeBtn.setOnMouseEntered((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                TitleBar.this.minimizeBtn.setStyle("-fx-background-color: rgb(86, 86, 79,0.2); ");
            }
        });
        this.minimizeBtn.setOnMouseExited((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                TitleBar.this.minimizeBtn.setStyle("-fx-background-color: rgb(0,0,0,0)");
            }
        });
        this.launchBtn.setOnMouseEntered((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                TitleBar.this.launchBtn.setStyle("-fx-background-color: rgb(86, 86, 79,0.2); ");
            }
        });
        this.launchBtn.setOnMouseExited((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                TitleBar.this.launchBtn.setStyle("-fx-background-color: rgb(0,0,0,0)");
            }
        });
    }

    private void changeSceneToMainPage() {
        System.setProperty("prism.lcdtext", "false");
        Stage stage = (Stage)this.closeBtn.getScene().getWindow();
        FXMLLoader fxmlLoader = new FXMLLoader();
        fxmlLoader.setLocation(Main.class.getResource("/fxml/main-page.fxml"));
        try {
            fxmlLoader.load();
        }
        catch (IOException e) {
            Sentry.captureException((Throwable)e);
            e.printStackTrace();
        }
        Parent root = (Parent)fxmlLoader.getRoot();
        Scene scene = stage.getHeight() <= 642.5 || stage.getWidth() <= 1100.0 ? new Scene(root) : new Scene(root, stage.getWidth(), stage.getHeight());
        stage.sizeToScene();
        stage.setScene(scene);
        stage.setResizable(true);
        ResizeHelper.addResizeListener(stage, 960.0, 564.0, Double.MAX_VALUE, Double.MAX_VALUE);
        stage.show();
    }

    public Button getLaunchBtn() {
        return this.launchBtn;
    }

    private void changeSceneToToolBar() {
        SwingUtilities.invokeLater(() -> {
            new JFXPanel();
            Platform.runLater(() -> {
                frame = null;
                URL fxmlUrl = ((Object)((Object)this)).getClass().getResource("/fxml/toolbarWithSetting.fxml");
                if (fxmlUrl == null) {
                    System.out.println("File not found.");
                    Platform.exit();
                    return;
                }
                Parent root = null;
                try {
                    root = (Parent)FXMLLoader.load((URL)fxmlUrl);
                }
                catch (IOException e) {
                    Sentry.captureException((Throwable)e);
                    e.printStackTrace();
                }
                Scene scene = new Scene(root);
                scene.setFill((Paint)javafx.scene.paint.Color.TRANSPARENT);
                frame = new MainFrame(scene);
                Stage stage = (Stage)this.closeBtn.getScene().getWindow();
                stage.close();
                frame.setVisible(true);
            });
        });
    }

    public static class MainFrame
    extends JFrame {
        private JFXPanel fxContainer = new JFXPanel();

        public MainFrame(Scene scene) {
            this.fxContainer.setScene(scene);
            this.getContentPane().add((Component)this.fxContainer);
            this.setAlwaysOnTop(true);
            this.setType(Window.Type.UTILITY);
            this.setDefaultCloseOperation(3);
            this.setSize(260, 100);
            this.setUndecorated(true);
            this.setFocusable(false);
            this.setFocusableWindowState(false);
            SwingUtilities.invokeLater(this::addAppToTray);
            Rectangle2D bounds = Screen.getPrimary().getVisualBounds();
            int x = (int)((bounds.getWidth() - scene.getWidth()) * 0.5);
            this.setLocation(x, 0);
            this.setBackground(new Color(1.0f, 1.0f, 1.0f, 0.0f));
        }

        private void addAppToTray() {
            try {
                Toolkit.getDefaultToolkit();
                if (!SystemTray.isSupported()) {
                    System.out.println("No system tray support, application exiting.");
                    this.setVisible(false);
                    this.dispose();
                    System.exit(0);
                }
                SystemTray tray = SystemTray.getSystemTray();
                BufferedImage image = ImageIO.read(this.getClass().getResource("/icons/mic-small.png"));
                TrayIcon trayIcon = new TrayIcon(image);
                trayIcon.addActionListener(event -> Platform.runLater(this::showStage));
                MenuItem openItem = new MenuItem("Show");
                openItem.addActionListener(event -> Platform.runLater(this::showStage));
                Font defaultFont = Font.decode(null);
                Font boldFont = defaultFont.deriveFont(1);
                openItem.setFont(boldFont);
                MenuItem find = new MenuItem("Recover");
                find.addActionListener(event -> Platform.runLater(this::findToolbar));
                find.setFont(boldFont);
                MenuItem exitItem = new MenuItem("Exit");
                exitItem.addActionListener(event -> {
                    this.setVisible(false);
                    this.dispose();
                    System.exit(0);
                    tray.remove(trayIcon);
                });
                PopupMenu popup = new PopupMenu();
                popup.add(openItem);
                popup.addSeparator();
                popup.add(find);
                popup.addSeparator();
                popup.add(exitItem);
                trayIcon.setPopupMenu(popup);
                tray.add(trayIcon);
            }
            catch (AWTException | IOException e) {
                Sentry.captureException((Throwable)e);
                System.out.println("Unable to init system tray");
                e.printStackTrace();
            }
        }

        private void showStage() {
            if (ToolbarWithSettingController.isInToolBar) {
                this.setVisible(true);
                this.toFront();
            }
        }

        private void findToolbar() {
            frame.setLocation(new Point((int)((Screen.getPrimary().getVisualBounds().getWidth() - 100.0) / 2.0) - 100, 0));
        }
    }
}

