/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.ui;

import ir.deepmine.dictation.Main;
import java.awt.Component;
import java.awt.Window;
import java.io.IOException;
import java.net.URL;
import javafx.embed.swing.JFXPanel;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Rectangle2D;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Screen;
import javax.swing.JFrame;

public class HelpForm
extends JFrame {
    private static HelpForm instance = null;

    private HelpForm() {
        Scene scene = this.loadScene();
        if (scene == null) {
            return;
        }
        JFXPanel fxContainer = new JFXPanel();
        fxContainer.setScene(scene);
        this.getContentPane().add((Component)fxContainer);
        this.setType(Window.Type.UTILITY);
        this.setAlwaysOnTop(true);
        this.setSize((int)scene.getWidth(), (int)scene.getHeight());
        this.setUndecorated(true);
        Rectangle2D bounds = Screen.getPrimary().getVisualBounds();
        int x = (int)((bounds.getWidth() - scene.getWidth()) * 0.5);
        int y = (int)((bounds.getHeight() - scene.getHeight()) * 0.5);
        this.setLocation(x, y);
    }

    private Scene loadScene() {
        Parent root;
        System.setProperty("prism.lcdtext", "false");
        URL fxmlUrl = Main.class.getResource("/fxml/help.fxml");
        if (fxmlUrl == null) {
            return null;
        }
        try {
            root = (Parent)FXMLLoader.load((URL)fxmlUrl);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        Scene scene = new Scene(root);
        scene.setFill((Paint)Color.TRANSPARENT);
        try {
            this.setUndecorated(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.getContentPane().setBackground(new java.awt.Color(1.0f, 1.0f, 1.0f, 0.0f));
        this.setBackground(new java.awt.Color(1.0f, 1.0f, 1.0f, 0.0f));
        return scene;
    }

    public static synchronized HelpForm getInstance() {
        if (instance == null) {
            instance = new HelpForm();
        }
        return instance;
    }
}

