/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.ui.HTMLEditor;

import com.sun.javafx.application.PlatformImpl;
import com.sun.javafx.scene.ParentHelper;
import com.sun.javafx.scene.control.skin.FXVK;
import com.sun.javafx.scene.traversal.ParentTraversalEngine;
import com.sun.javafx.webkit.Accessor;
import com.sun.webkit.WebPage;
import com.sun.webkit.event.WCFocusEvent;
import ir.deepmine.dictation.ui.HTMLEditor.HTMLEditor;
import ir.deepmine.dictation.ui.HTMLEditor.HTMLEditorBehavior;
import java.security.AccessController;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.application.ConditionalFeature;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.css.StyleableProperty;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Orientation;
import javafx.print.PrinterJob;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Separator;
import javafx.scene.control.SkinBase;
import javafx.scene.control.TextInputControl;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.util.Callback;
import javafx.util.Duration;
import org.w3c.dom.html.HTMLDocument;
import org.w3c.dom.html.HTMLElement;

public class HTMLEditorSkin
extends SkinBase<HTMLEditor> {
    private GridPane gridPane;
    private ToolBar toolbar1;
    private ToolBar toolbar2;
    private HBox toolbarBox;
    private Button recordButton;
    private Button undoButton;
    private Button redoButton;
    private Button reduceSizeButton;
    private Button increaseSizeButton;
    private Button insertHorizontalRuleButton;
    private ToggleButton bulletsButton;
    private ToggleButton numbersButton;
    private ToggleButton heading1Button;
    private ToggleButton heading2Button;
    private ComboBox<String> formatComboBox;
    private Map<String, String> formatStyleMap;
    private Map<String, String> styleFormatMap;
    private ComboBox<String> fontFamilyComboBox;
    private ComboBox<String> fontSizeComboBox;
    private Map<String, String> fontSizeMap;
    private Map<String, String> sizeFontMap;
    private ToggleButton boldButton;
    private ToggleButton italicButton;
    private ToggleButton underlineButton;
    private ToggleButton strikethroughButton;
    private ColorPicker fgColorButton;
    private ColorPicker bgColorButton;
    private WebView webView;
    private WebPage webPage;
    private ParentTraversalEngine engine;
    private boolean resetToolbarState = false;
    private String cachedHTMLText = "<html><head></head><body contenteditable=\"true\"></body></html>";
    private ResourceBundle resources;
    private FontSize currentSize;
    private AtomicBoolean isRecording;
    private boolean enableAtomicityCheck = false;
    private int atomicityCount = 0;
    private boolean isFirstRun = true;
    private static final int FONT_FAMILY_MENUBUTTON_WIDTH = 150;
    private static final int FONT_FAMILY_MENU_WIDTH = 100;
    private static final int FONT_SIZE_MENUBUTTON_WIDTH = 80;
    private static final Color DEFAULT_BG_COLOR = Color.WHITE;
    private static final Color DEFAULT_FG_COLOR = Color.BLACK;
    private static final String FORMAT_PARAGRAPH = "<p>";
    private static final String FORMAT_HEADING_1 = "<h1>";
    private static final String FORMAT_HEADING_2 = "<h2>";
    private static final String FORMAT_HEADING_3 = "<h3>";
    private static final String FORMAT_HEADING_4 = "<h4>";
    private static final String FORMAT_HEADING_5 = "<h5>";
    private static final String FORMAT_HEADING_6 = "<h6>";
    private static final String SIZE_XX_SMALL = "1";
    private static final String SIZE_X_SMALL = "2";
    private static final String SIZE_SMALL = "3";
    private static final String SIZE_MEDIUM = "4";
    private static final String SIZE_LARGE = "5";
    private static final String SIZE_X_LARGE = "6";
    private static final String SIZE_XX_LARGE = "7";
    private static final String[][] DEFAULT_FORMAT_MAPPINGS = new String[][]{{"<p>", "", "3"}, {"<h1>", Command.BOLD.getCommand(), "6"}, {"<h2>", Command.BOLD.getCommand(), "5"}, {"<h3>", Command.BOLD.getCommand(), "4"}, {"<h4>", Command.BOLD.getCommand(), "3"}, {"<h5>", Command.BOLD.getCommand(), "2"}, {"<h6>", Command.BOLD.getCommand(), "1"}};
    private static PseudoClass CONTAINS_FOCUS_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"contains-focus");
    private ListChangeListener<Node> itemsListener = c -> {
        while (c.next()) {
            if (c.getRemovedSize() <= 0) continue;
            for (Node n : c.getList()) {
                if (!(n instanceof WebView)) continue;
                this.webPage.dispose();
            }
        }
    };

    public HTMLEditorSkin(HTMLEditor control, HBox toolbarBox, Button recordButton, AtomicBoolean isRecording, boolean isEditable) {
        super((Control)control);
        this.toolbarBox = toolbarBox;
        this.recordButton = recordButton;
        this.isRecording = isRecording;
        this.currentSize = FontSize.MEDIUM;
        this.undoButton = (Button)toolbarBox.getChildren().get(0);
        this.redoButton = (Button)toolbarBox.getChildren().get(1);
        this.reduceSizeButton = (Button)toolbarBox.getChildren().get(2);
        this.increaseSizeButton = (Button)toolbarBox.getChildren().get(4);
        this.heading1Button = (ToggleButton)toolbarBox.getChildren().get(5);
        this.heading2Button = (ToggleButton)toolbarBox.getChildren().get(6);
        this.bulletsButton = (ToggleButton)toolbarBox.getChildren().get(7);
        this.numbersButton = (ToggleButton)toolbarBox.getChildren().get(8);
        this.insertHorizontalRuleButton = (Button)toolbarBox.getChildren().get(9);
        this.strikethroughButton = (ToggleButton)toolbarBox.getChildren().get(10);
        this.underlineButton = (ToggleButton)toolbarBox.getChildren().get(11);
        this.italicButton = (ToggleButton)toolbarBox.getChildren().get(12);
        this.boldButton = (ToggleButton)toolbarBox.getChildren().get(13);
        ((Node)toolbarBox.getChildren().get(2)).setVisible(false);
        ((Node)toolbarBox.getChildren().get(3)).setVisible(false);
        ((Node)toolbarBox.getChildren().get(4)).setVisible(false);
        ((Node)toolbarBox.getChildren().get(2)).setManaged(false);
        ((Node)toolbarBox.getChildren().get(3)).setManaged(false);
        ((Node)toolbarBox.getChildren().get(4)).setManaged(false);
        HTMLEditorBehavior behavior = new HTMLEditorBehavior(control);
        this.getChildren().clear();
        this.gridPane = new GridPane();
        this.gridPane.getStyleClass().add((Object)"grid");
        this.getChildren().addAll((Object[])new Node[]{this.gridPane});
        this.toolbar1 = new ToolBar();
        this.toolbar1.getStyleClass().add((Object)"top-toolbar");
        this.gridPane.add((Node)this.toolbar1, 0, 0);
        this.toolbar2 = new ToolBar();
        this.toolbar2.getStyleClass().add((Object)"bottom-toolbar");
        this.gridPane.add((Node)this.toolbar2, 0, 1);
        this.webView = new WebView();
        this.gridPane.add((Node)this.webView, 0, 2);
        ColumnConstraints column = new ColumnConstraints();
        column.setHgrow(Priority.ALWAYS);
        this.gridPane.getColumnConstraints().add((Object)column);
        this.webPage = Accessor.getPageFor((WebEngine)this.webView.getEngine());
        this.webView.setStyle("-fx-background-color: transparent");
        this.toolbar2.setVisible(false);
        this.toolbar1.setVisible(false);
        this.toolbar1.setManaged(false);
        this.toolbar2.setManaged(false);
        this.webView.setPrefHeight(2.147483647E9);
        this.webView.addEventHandler(MouseEvent.MOUSE_RELEASED, event2 -> Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                HTMLEditorSkin.this.enableAtomicityCheck = true;
                HTMLEditorSkin.this.updateToolbarState(true);
                HTMLEditorSkin.this.enableAtomicityCheck = false;
            }
        }));
        this.webView.addEventHandler(KeyEvent.KEY_PRESSED, event -> {
            this.applyTextFormatting();
            if (event.getCode() == KeyCode.CONTROL || event.getCode() == KeyCode.META) {
                return;
            }
            if (event.getCode() == KeyCode.TAB && !event.isControlDown()) {
                if (!event.isShiftDown()) {
                    if (this.getCommandState(Command.BULLETS.getCommand()) || this.getCommandState(Command.NUMBERS.getCommand())) {
                        this.executeCommand(Command.INDENT.getCommand(), null);
                    } else {
                        this.executeCommand(Command.INSERT_TAB.getCommand(), null);
                    }
                } else if (this.getCommandState(Command.BULLETS.getCommand()) || this.getCommandState(Command.NUMBERS.getCommand())) {
                    this.executeCommand(Command.OUTDENT.getCommand(), null);
                }
                return;
            }
            if (this.fgColorButton != null && this.fgColorButton.isShowing() || this.bgColorButton != null && this.bgColorButton.isShowing()) {
                return;
            }
            Platform.runLater(() -> {
                if (this.webPage.getClientSelectedText().isEmpty()) {
                    if (event.getCode() == KeyCode.UP || event.getCode() == KeyCode.DOWN || event.getCode() == KeyCode.LEFT || event.getCode() == KeyCode.RIGHT || event.getCode() == KeyCode.HOME || event.getCode() == KeyCode.END) {
                        this.updateToolbarState(true);
                    } else if (event.isControlDown() || event.isMetaDown()) {
                        if (event.getCode() == KeyCode.B) {
                            this.performCommand(Command.BOLD);
                        } else if (event.getCode() == KeyCode.I) {
                            this.performCommand(Command.ITALIC);
                        } else if (event.getCode() == KeyCode.U) {
                            this.performCommand(Command.UNDERLINE);
                        }
                        this.updateToolbarState(true);
                    } else {
                        boolean bl = this.resetToolbarState = event.getCode() == KeyCode.ENTER;
                        if (this.resetToolbarState && this.getCommandState(Command.BOLD.getCommand()) != this.boldButton.selectedProperty().getValue().booleanValue()) {
                            this.executeCommand(Command.BOLD.getCommand(), this.boldButton.selectedProperty().getValue().toString());
                        }
                        this.updateToolbarState(false);
                    }
                    this.resetToolbarState = false;
                } else if (event.isShiftDown() && (event.getCode() == KeyCode.UP || event.getCode() == KeyCode.DOWN || event.getCode() == KeyCode.LEFT || event.getCode() == KeyCode.RIGHT || event.getCode() == KeyCode.HOME || event.getCode() == KeyCode.END)) {
                    this.enableAtomicityCheck = true;
                    this.updateToolbarState(true);
                    this.enableAtomicityCheck = false;
                } else if ((event.isControlDown() || event.isMetaDown()) && event.getCode() == KeyCode.A) {
                    this.enableAtomicityCheck = true;
                    this.updateToolbarState(true);
                    this.enableAtomicityCheck = false;
                }
            });
        });
        this.webView.addEventHandler(KeyEvent.KEY_RELEASED, event -> {
            if (event.getCode() == KeyCode.CONTROL || event.getCode() == KeyCode.META) {
                return;
            }
            if (this.fgColorButton != null && this.fgColorButton.isShowing() || this.bgColorButton != null && this.bgColorButton.isShowing()) {
                return;
            }
            Platform.runLater(() -> {
                if (this.webPage.getClientSelectedText().isEmpty()) {
                    if (event.getCode() == KeyCode.UP || event.getCode() == KeyCode.DOWN || event.getCode() == KeyCode.LEFT || event.getCode() == KeyCode.RIGHT || event.getCode() == KeyCode.HOME || event.getCode() == KeyCode.END) {
                        this.updateToolbarState(true);
                    } else if (event.isControlDown() || event.isMetaDown()) {
                        if (event.getCode() == KeyCode.B) {
                            this.performCommand(Command.BOLD);
                        } else if (event.getCode() == KeyCode.I) {
                            this.performCommand(Command.ITALIC);
                        } else if (event.getCode() == KeyCode.U) {
                            this.performCommand(Command.UNDERLINE);
                        }
                        this.updateToolbarState(true);
                    } else {
                        boolean bl = this.resetToolbarState = event.getCode() == KeyCode.ENTER;
                        if (!this.resetToolbarState) {
                            this.updateToolbarState(false);
                        }
                    }
                    this.resetToolbarState = false;
                }
            });
        });
        ((HTMLEditor)this.getSkinnable()).focusedProperty().addListener((observable, oldValue, newValue) -> Platform.runLater((Runnable)new Runnable((Boolean)newValue){
            final /* synthetic */ Boolean val$newValue;
            {
                this.val$newValue = bl;
            }

            @Override
            public void run() {
                if (this.val$newValue.booleanValue()) {
                    HTMLEditorSkin.this.webView.requestFocus();
                }
            }
        }));
        this.webView.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.webPage.dispatchFocusEvent(new WCFocusEvent(2, 0));
                this.enableToolbar(true);
            } else {
                this.webPage.dispatchFocusEvent(new WCFocusEvent(3, 0));
                this.enableToolbar(false);
                if (isRecording.get()) {
                    // empty if block
                }
            }
            this.pseudoClassStateChanged(CONTAINS_FOCUS_PSEUDOCLASS_STATE, (boolean)newValue);
            Platform.runLater((Runnable)new Runnable((Boolean)newValue){
                final /* synthetic */ Boolean val$newValue;
                {
                    this.val$newValue = bl;
                }

                @Override
                public void run() {
                    HTMLEditorSkin.this.updateToolbarState(true);
                    if (PlatformImpl.isSupported((ConditionalFeature)ConditionalFeature.VIRTUAL_KEYBOARD)) {
                        Scene scene = ((HTMLEditor)HTMLEditorSkin.this.getSkinnable()).getScene();
                        if (this.val$newValue.booleanValue()) {
                            FXVK.attach((Node)HTMLEditorSkin.this.webView);
                        } else if (scene == null || scene.getWindow() == null || !scene.getWindow().isFocused() || !(scene.getFocusOwner() instanceof TextInputControl)) {
                            FXVK.detach();
                        }
                    }
                }
            });
        });
        this.webView.getEngine().getLoadWorker().workDoneProperty().addListener((observable, oldValue, newValue) -> {
            Platform.runLater(() -> this.webView.requestLayout());
            double totalWork = this.webView.getEngine().getLoadWorker().getTotalWork();
            if (newValue.doubleValue() == totalWork) {
                this.cachedHTMLText = null;
                Platform.runLater(() -> {
                    this.setContentEditable(isEditable);
                    this.updateToolbarState(true);
                    this.updateNodeOrientation();
                    this.executeCommand(Command.STYLEWITHCSS.getCommand(), "true");
                });
            }
        });
        this.enableToolbar(true);
        this.setHTMLText(this.cachedHTMLText);
        ParentHelper.setTraversalEngine((Parent)this.getSkinnable(), (ParentTraversalEngine)this.engine);
        this.webView.setFocusTraversable(true);
        this.gridPane.getChildren().addListener(this.itemsListener);
    }

    public void performCommand(Command command) {
        switch (command) {
            case BOLD: {
                this.boldButton.fire();
                break;
            }
            case ITALIC: {
                this.italicButton.setSelected(!this.italicButton.isSelected());
                break;
            }
            case UNDERLINE: {
                this.underlineButton.setSelected(!this.underlineButton.isSelected());
            }
        }
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        if (this.isFirstRun) {
            this.populateToolbars();
            this.isFirstRun = false;
            String init = "<html>\n<head>\n    <meta charset=\"utf-8\">\n    <style type=\"text/css\">\n        .farsi {\n            font-family: Sahel,serif;\n            font-size: medium;\n            direction: rtl;\n            text-align: right;\n            padding-right: 18px;\n        }\n        .english {\n            font-family: Calibri,serif;\n            font-size: 12px;\n            direction: ltr;\n            text-align: left;\n        }\n\n    </style>\n</head>\n<body class=\"farsi\"><div></div></body>";
            this.webPage.load(this.webPage.getMainFrame(), init, "text/html");
        }
        super.layoutChildren(x, y, w, h);
        double toolbarWidth = Math.max(this.toolbar1.prefWidth(-1.0), this.toolbar2.prefWidth(-1.0));
        this.toolbar1.setMinWidth(toolbarWidth);
        this.toolbar1.setPrefWidth(toolbarWidth);
        this.toolbar2.setMinWidth(toolbarWidth);
        this.toolbar2.setPrefWidth(toolbarWidth);
    }

    final String getHTMLText() {
        return this.cachedHTMLText != null ? this.cachedHTMLText : this.webPage.getHtml(this.webPage.getMainFrame());
    }

    final void setHTMLText(String htmlText) {
        this.cachedHTMLText = htmlText;
        this.webPage.load(this.webPage.getMainFrame(), htmlText, "text/html");
        Platform.runLater(() -> this.updateToolbarState(true));
    }

    private void populateToolbars() {
        this.resources = ResourceBundle.getBundle(HTMLEditorSkin.class.getName());
        this.toolbar1.getItems().add((Object)new Separator(Orientation.VERTICAL));
        this.setActionOnButton(this.redoButton, "\u062f\u0648\u0628\u0627\u0631\u0647 \u0627\u0646\u062c\u0627\u0645 \u062f\u0627\u062f\u0646", Command.REDO.getCommand());
        this.setActionOnButton(this.undoButton, "\u0628\u0631\u06af\u0631\u062f\u0627\u0646\u062f\u0646 \u0639\u0645\u0644 \u0627\u0646\u062c\u0627\u0645 \u0634\u062f\u0647", Command.UNDO.getCommand());
        this.toolbar1.getItems().add((Object)new Separator());
        ToggleGroup listStyleToggleGroup = new ToggleGroup();
        this.setActionOnToggleButton(this.bulletsButton, listStyleToggleGroup, "\u06af\u0644\u0648\u0644\u0647\u200c\u0647\u0627", Command.BULLETS.getCommand());
        this.setActionOnToggleButton(this.numbersButton, listStyleToggleGroup, "\u0627\u0639\u062f\u0627\u062f", Command.NUMBERS.getCommand());
        this.toolbar1.getItems().add((Object)new Separator(Orientation.VERTICAL));
        this.formatComboBox = new ComboBox();
        this.formatComboBox.getStyleClass().add((Object)"font-menu-button");
        this.formatComboBox.setFocusTraversable(false);
        this.formatComboBox.setMinWidth(Double.NEGATIVE_INFINITY);
        this.toolbar2.getItems().add(this.formatComboBox);
        this.formatStyleMap = new HashMap<String, String>();
        this.styleFormatMap = new HashMap<String, String>();
        this.createFormatMenuItem(FORMAT_PARAGRAPH, this.resources.getString("paragraph"));
        Platform.runLater(() -> this.formatComboBox.setValue((Object)this.resources.getString("paragraph")));
        this.createFormatMenuItem(FORMAT_HEADING_1, this.resources.getString("heading1"));
        this.createFormatMenuItem(FORMAT_HEADING_2, this.resources.getString("heading2"));
        this.createFormatMenuItem(FORMAT_HEADING_3, this.resources.getString("heading3"));
        this.createFormatMenuItem(FORMAT_HEADING_4, this.resources.getString("heading4"));
        this.createFormatMenuItem(FORMAT_HEADING_5, this.resources.getString("heading5"));
        this.createFormatMenuItem(FORMAT_HEADING_6, this.resources.getString("heading6"));
        Tooltip heading1Tooltip = new Tooltip("\u0647\u062f\u06cc\u0646\u06af 1");
        Tooltip heading2Tooltip = new Tooltip("\u0647\u062f\u06cc\u0646\u06af 2");
        heading1Tooltip.setShowDelay(Duration.millis((double)350.0));
        heading1Tooltip.setFont(Font.font((String)"Vazir", (FontWeight)FontWeight.NORMAL, (double)12.0));
        heading2Tooltip.setShowDelay(Duration.millis((double)350.0));
        heading2Tooltip.setFont(Font.font((String)"Vazir", (FontWeight)FontWeight.NORMAL, (double)12.0));
        this.heading1Button.setTooltip(heading1Tooltip);
        this.heading2Button.setTooltip(heading2Tooltip);
        this.heading1Button.setOnAction(event -> {
            String formatValue = this.getCommandValue(Command.FORMAT.getCommand());
            if (formatValue.equals("h1")) {
                this.executeCommand(Command.FORMAT.getCommand(), FORMAT_PARAGRAPH);
                this.formatComboBox.setValue((Object)"paragraph");
            } else {
                this.executeCommand(Command.FORMAT.getCommand(), FORMAT_HEADING_1);
                this.formatComboBox.setValue((Object)"heading1");
            }
            this.updateToolbarState(false);
        });
        this.heading2Button.setOnAction(event -> {
            String formatValue = this.getCommandValue(Command.FORMAT.getCommand());
            if (formatValue.equals("h2")) {
                this.executeCommand(Command.FORMAT.getCommand(), FORMAT_PARAGRAPH);
                this.formatComboBox.setValue((Object)"paragraph");
            } else {
                this.executeCommand(Command.FORMAT.getCommand(), FORMAT_HEADING_2);
                this.formatComboBox.setValue((Object)"heading2");
            }
            this.updateToolbarState(false);
        });
        Tooltip tooltip = new Tooltip(this.resources.getString("format"));
        tooltip.setShowDelay(Duration.millis((double)350.0));
        tooltip.setFont(Font.font((String)"Vazir", (FontWeight)FontWeight.NORMAL, (double)12.0));
        this.formatComboBox.setTooltip(tooltip);
        this.formatComboBox.valueProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue == null) {
                this.formatComboBox.setValue(null);
            } else {
                String formatValue = this.formatStyleMap.get(newValue);
                this.executeCommand(Command.FORMAT.getCommand(), formatValue);
                this.updateToolbarState(false);
                for (int i = 0; i < DEFAULT_FORMAT_MAPPINGS.length; ++i) {
                    String[] mapping = DEFAULT_FORMAT_MAPPINGS[i];
                    if (!mapping[0].equalsIgnoreCase(formatValue)) continue;
                    this.updateToolbarState(false);
                    break;
                }
            }
        });
        this.fontFamilyComboBox = new ComboBox();
        this.fontFamilyComboBox.getStyleClass().add((Object)"font-menu-button");
        this.fontFamilyComboBox.setMinWidth(150.0);
        this.fontFamilyComboBox.setPrefWidth(150.0);
        this.fontFamilyComboBox.setMaxWidth(150.0);
        this.fontFamilyComboBox.setFocusTraversable(false);
        this.fontFamilyComboBox.setTooltip(new Tooltip(this.resources.getString("fontFamily")));
        this.toolbar2.getItems().add(this.fontFamilyComboBox);
        this.fontFamilyComboBox.getProperties().put((Object)"comboBoxRowsToMeasureWidth", (Object)0);
        this.fontFamilyComboBox.setCellFactory((Callback)new Callback<ListView<String>, ListCell<String>>(){

            public ListCell<String> call(ListView<String> param) {
                ListCell<String> cell = new ListCell<String>(){

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null) {
                            this.setText(item);
                            this.setFont(new Font(item, 12.0));
                        }
                    }
                };
                cell.setMinWidth(100.0);
                cell.setPrefWidth(100.0);
                cell.setMaxWidth(100.0);
                return cell;
            }
        });
        Platform.runLater(() -> {
            ObservableList fonts = FXCollections.observableArrayList((Collection)Font.getFamilies());
            fonts.add(0, (Object)"");
            for (String fontFamily : fonts) {
                this.fontFamilyComboBox.setValue((Object)"");
                this.fontFamilyComboBox.setItems(fonts);
            }
        });
        this.fontFamilyComboBox.valueProperty().addListener((observable, oldValue, newValue) -> {});
        this.fontSizeComboBox = new ComboBox();
        this.fontSizeComboBox.getStyleClass().add((Object)"font-menu-button");
        this.fontSizeComboBox.setFocusTraversable(false);
        this.toolbar2.getItems().add(this.fontSizeComboBox);
        this.fontSizeMap = new HashMap<String, String>();
        this.sizeFontMap = new HashMap<String, String>();
        this.createFontSizeMenuItem(SIZE_XX_SMALL, this.resources.getString("extraExtraSmall"));
        this.createFontSizeMenuItem(SIZE_X_SMALL, this.resources.getString("extraSmall"));
        this.createFontSizeMenuItem(SIZE_SMALL, this.resources.getString("small"));
        Platform.runLater(() -> this.fontSizeComboBox.setValue((Object)this.resources.getString("small")));
        this.createFontSizeMenuItem(SIZE_MEDIUM, this.resources.getString("medium"));
        this.createFontSizeMenuItem(SIZE_LARGE, this.resources.getString("large"));
        this.createFontSizeMenuItem(SIZE_X_LARGE, this.resources.getString("extraLarge"));
        this.createFontSizeMenuItem(SIZE_XX_LARGE, this.resources.getString("extraExtraLarge"));
        this.fontSizeComboBox.setTooltip(new Tooltip(this.resources.getString("fontSize")));
        this.fontSizeComboBox.setCellFactory((Callback)new Callback<ListView<String>, ListCell<String>>(){

            public ListCell<String> call(ListView<String> param) {
                ListCell<String> cell = new ListCell<String>(){

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null) {
                            this.setText(item);
                            String size = item.replaceFirst("[^0-9.].*$", "");
                            this.setFont(new Font((String)HTMLEditorSkin.this.fontFamilyComboBox.getValue(), Double.valueOf(size).doubleValue()));
                        }
                    }
                };
                return cell;
            }
        });
        this.fontSizeComboBox.valueProperty().addListener((observable, oldValue, newValue) -> {});
        this.toolbar2.getItems().add((Object)new Separator(Orientation.VERTICAL));
        this.setActionOnToggleButton(this.boldButton, null, "\u067e\u0631\u0631\u0646\u06af \u06a9\u0631\u062f\u0646", Command.BOLD.getCommand());
        this.boldButton.setOnAction(event1 -> {
            if (FORMAT_PARAGRAPH.equals(this.formatStyleMap.get(this.formatComboBox.getValue()))) {
                this.executeCommand(Command.BOLD.getCommand(), this.boldButton.selectedProperty().getValue().toString());
            }
        });
        this.setActionOnToggleButton(this.italicButton, null, "\u0627\u06cc\u062a\u0627\u0644\u06cc\u0627\u06cc\u06cc", Command.ITALIC.getCommand());
        this.setActionOnToggleButton(this.underlineButton, null, "\u0632\u06cc\u0631\u062e\u0637", Command.UNDERLINE.getCommand());
        this.setActionOnToggleButton(this.strikethroughButton, null, "\u0645\u06cc\u0627\u0646 \u062e\u0637", Command.STRIKETHROUGH.getCommand());
        this.reduceSizeButton.setOnAction(event -> {
            String html = this.getHTMLText();
            this.setHTMLText(html.replaceFirst(this.currentSize.getFontSize(), this.currentSize.getprevious().fontSize));
            this.currentSize = this.currentSize.getprevious();
        });
        this.increaseSizeButton.setOnAction(event -> {
            String html = this.getHTMLText();
            this.setHTMLText(html.replaceFirst(this.currentSize.getFontSize(), this.currentSize.getNext().fontSize));
            this.currentSize = this.currentSize.getNext();
        });
        this.reduceSizeButton.setFocusTraversable(false);
        this.increaseSizeButton.setFocusTraversable(false);
        Tooltip reduce = new Tooltip("\u06a9\u0627\u0647\u0634 \u0627\u0646\u062f\u0627\u0632\u0647 \u0646\u0648\u0634\u062a\u0627\u0631");
        Tooltip increase = new Tooltip("\u0627\u0641\u0632\u0627\u06cc\u0634 \u0627\u0646\u062f\u0627\u0632\u0647 \u0646\u0648\u0634\u062a\u0627\u0631");
        reduce.setShowDelay(Duration.millis((double)350.0));
        reduce.setFont(Font.font((String)"Vazir", (FontWeight)FontWeight.NORMAL, (double)12.0));
        increase.setShowDelay(Duration.millis((double)350.0));
        increase.setFont(Font.font((String)"Vazir", (FontWeight)FontWeight.NORMAL, (double)12.0));
        this.reduceSizeButton.setTooltip(reduce);
        this.increaseSizeButton.setTooltip(increase);
        this.toolbar2.getItems().add((Object)new Separator(Orientation.VERTICAL));
        this.setActionOnButton(this.insertHorizontalRuleButton, "\u0627\u0636\u0627\u0641\u0647 \u06a9\u0631\u062f\u0646 \u062e\u0637 \u0627\u0641\u0642\u06cc", Command.INSERT_HORIZONTAL_RULE.getCommand());
        this.insertHorizontalRuleButton.setOnAction(event -> {
            this.executeCommand(Command.INSERT_NEW_LINE.getCommand(), null);
            this.executeCommand(Command.INSERT_HORIZONTAL_RULE.getCommand(), null);
        });
        this.fgColorButton = new ColorPicker();
        this.fgColorButton.getStyleClass().add((Object)"html-editor-foreground");
        this.fgColorButton.setFocusTraversable(false);
        this.toolbar1.getItems().add((Object)this.fgColorButton);
        this.fgColorButton.setValue((Object)DEFAULT_FG_COLOR);
        this.fgColorButton.setTooltip(new Tooltip(this.resources.getString("foregroundColor")));
        this.fgColorButton.setOnAction(ev1 -> {
            Color newValue = (Color)this.fgColorButton.getValue();
            if (newValue != null) {
                this.executeCommand(Command.FOREGROUND_COLOR.getCommand(), this.colorValueToRGBA(newValue));
                this.fgColorButton.hide();
            }
        });
        this.bgColorButton = new ColorPicker();
        this.bgColorButton.getStyleClass().add((Object)"html-editor-background");
        this.bgColorButton.setFocusTraversable(false);
        this.toolbar1.getItems().add((Object)this.bgColorButton);
        this.bgColorButton.setValue((Object)DEFAULT_BG_COLOR);
        this.bgColorButton.setTooltip(new Tooltip(this.resources.getString("backgroundColor")));
        this.bgColorButton.setOnAction(ev -> {
            Color newValue = (Color)this.bgColorButton.getValue();
            if (newValue != null) {
                this.executeCommand(Command.BACKGROUND_COLOR.getCommand(), this.colorValueToRGBA(newValue));
                this.bgColorButton.hide();
            }
        });
    }

    private String colorValueToRGBA(Color c) {
        return String.format((Locale)null, "rgba(%d, %d, %d, %.5f)", Math.round(c.getRed() * 255.0), Math.round(c.getGreen() * 255.0), Math.round(c.getBlue() * 255.0), c.getOpacity());
    }

    private Button addButton(ToolBar toolbar, String iconName, String tooltipText, String command, String styleClass) {
        Button button = new Button();
        button.setFocusTraversable(false);
        button.getStyleClass().add((Object)styleClass);
        toolbar.getItems().add((Object)button);
        Image icon = AccessController.doPrivileged(() -> new Image(HTMLEditorSkin.class.getResource(iconName).toString()));
        ((StyleableProperty)button.graphicProperty()).applyStyle(null, (Object)new ImageView(icon));
        button.setTooltip(new Tooltip(tooltipText));
        button.setOnAction(event -> {
            this.executeCommand(command, null);
            this.updateToolbarState(false);
        });
        return button;
    }

    private void setActionOnButton(Button button, String tooltipText, String command) {
        button.setFocusTraversable(false);
        Tooltip tooltip = new Tooltip(tooltipText);
        tooltip.setShowDelay(Duration.millis((double)350.0));
        tooltip.setFont(Font.font((String)"Vazir", (FontWeight)FontWeight.NORMAL, (double)12.0));
        button.setTooltip(tooltip);
        button.setOnAction(event -> {
            this.executeCommand(command, null);
            this.updateToolbarState(false);
        });
    }

    private ToggleButton addToggleButton(ToolBar toolbar, ToggleGroup toggleGroup, String iconName, String tooltipText, String command, String styleClass) {
        ToggleButton toggleButton = new ToggleButton();
        toggleButton.setUserData((Object)command);
        toggleButton.setFocusTraversable(false);
        toggleButton.getStyleClass().add((Object)styleClass);
        toolbar.getItems().add((Object)toggleButton);
        if (toggleGroup != null) {
            toggleButton.setToggleGroup(toggleGroup);
        }
        Image icon = AccessController.doPrivileged(() -> new Image(HTMLEditorSkin.class.getResource(iconName).toString()));
        ((StyleableProperty)toggleButton.graphicProperty()).applyStyle(null, (Object)new ImageView(icon));
        toggleButton.setTooltip(new Tooltip(tooltipText));
        if (!Command.BOLD.getCommand().equals(command)) {
            toggleButton.selectedProperty().addListener((observable, oldValue, newValue) -> {
                if (this.getCommandState(command) != newValue.booleanValue()) {
                    this.executeCommand(command, null);
                }
            });
        }
        return toggleButton;
    }

    private void setActionOnToggleButton(ToggleButton toggleButton, ToggleGroup toggleGroup, String tooltipText, String command) {
        toggleButton.setUserData((Object)command);
        toggleButton.setFocusTraversable(false);
        if (toggleGroup != null) {
            toggleButton.setToggleGroup(toggleGroup);
        }
        Tooltip tooltip = new Tooltip(tooltipText);
        tooltip.setShowDelay(Duration.millis((double)350.0));
        tooltip.setFont(Font.font((String)"Vazir", (FontWeight)FontWeight.NORMAL, (double)12.0));
        toggleButton.setTooltip(tooltip);
        if (!Command.BOLD.getCommand().equals(command)) {
            toggleButton.selectedProperty().addListener((observable, oldValue, newValue) -> {
                if (this.getCommandState(command) != newValue.booleanValue()) {
                    this.executeCommand(command, null);
                }
            });
        }
    }

    private void createFormatMenuItem(String formatValue, String label) {
        this.formatComboBox.getItems().add((Object)label);
        this.formatStyleMap.put(label, formatValue);
        this.styleFormatMap.put(formatValue, label);
    }

    private void createFontSizeMenuItem(String fontSizeValue, String label) {
        this.fontSizeComboBox.getItems().add((Object)label);
        this.fontSizeMap.put(label, fontSizeValue);
        this.sizeFontMap.put(fontSizeValue, label);
    }

    private void updateNodeOrientation() {
        NodeOrientation orientation = ((HTMLEditor)this.getSkinnable()).getEffectiveNodeOrientation();
        HTMLDocument htmlDocument = (HTMLDocument)this.webPage.getDocument(this.webPage.getMainFrame());
        HTMLElement htmlDocumentElement = (HTMLElement)htmlDocument.getDocumentElement();
        if (htmlDocumentElement.getAttribute("dir") == null) {
            htmlDocumentElement.setAttribute("dir", orientation == NodeOrientation.RIGHT_TO_LEFT ? "rtl" : "ltr");
        }
    }

    private void updateToolbarState(boolean updateAlignment) {
        if (!this.webView.isFocused()) {
            return;
        }
        ++this.atomicityCount;
        this.undoButton.setDisable(!this.isCommandEnabled(Command.UNDO.getCommand()));
        this.redoButton.setDisable(!this.isCommandEnabled(Command.REDO.getCommand()));
        this.undoButton.setDisable(!this.isCommandEnabled(Command.FORMAT.getCommand()));
        this.redoButton.setDisable(!this.isCommandEnabled(Command.FORMAT.getCommand()));
        this.insertHorizontalRuleButton.setDisable(!this.isCommandEnabled(Command.INSERT_HORIZONTAL_RULE.getCommand()));
        this.bulletsButton.setDisable(!this.isCommandEnabled(Command.BULLETS.getCommand()));
        this.bulletsButton.setSelected(this.getCommandState(Command.BULLETS.getCommand()));
        this.numbersButton.setDisable(!this.isCommandEnabled(Command.NUMBERS.getCommand()));
        this.numbersButton.setSelected(this.getCommandState(Command.NUMBERS.getCommand()));
        this.formatComboBox.setDisable(!this.isCommandEnabled(Command.FORMAT.getCommand()));
        String formatValue = this.getCommandValue(Command.FORMAT.getCommand());
        if (formatValue != null) {
            String htmlTag = "<" + formatValue + ">";
            String comboFormatValue = this.styleFormatMap.get(htmlTag);
            String format = (String)this.formatComboBox.getValue();
            if (this.resetToolbarState || htmlTag.equals("<>") || htmlTag.equalsIgnoreCase("<div>") || htmlTag.equalsIgnoreCase("<blockquote>")) {
                this.formatComboBox.setValue((Object)this.resources.getString("paragraph"));
            } else if (format != null && !format.equalsIgnoreCase(comboFormatValue)) {
                this.formatComboBox.setValue((Object)comboFormatValue);
            }
        }
        this.heading1Button.setDisable(!this.isCommandEnabled(Command.FORMAT.getCommand()));
        this.heading2Button.setDisable(!this.isCommandEnabled(Command.FORMAT.getCommand()));
        this.heading1Button.setSelected(formatValue.equals("h1"));
        this.heading2Button.setSelected(formatValue.equals("h2"));
        this.boldButton.setDisable(!this.isCommandEnabled(Command.BOLD.getCommand()));
        this.boldButton.setSelected(this.getCommandState(Command.BOLD.getCommand()));
        this.italicButton.setDisable(!this.isCommandEnabled(Command.ITALIC.getCommand()));
        this.italicButton.setSelected(this.getCommandState(Command.ITALIC.getCommand()));
        this.underlineButton.setDisable(!this.isCommandEnabled(Command.UNDERLINE.getCommand()));
        this.underlineButton.setSelected(this.getCommandState(Command.UNDERLINE.getCommand()));
        this.strikethroughButton.setDisable(!this.isCommandEnabled(Command.STRIKETHROUGH.getCommand()));
        this.strikethroughButton.setSelected(this.getCommandState(Command.STRIKETHROUGH.getCommand()));
        this.fgColorButton.setDisable(!this.isCommandEnabled(Command.FOREGROUND_COLOR.getCommand()));
        String foregroundColorValue = this.getCommandValue(Command.FOREGROUND_COLOR.getCommand());
        if (foregroundColorValue != null) {
            this.fgColorButton.setValue((Object)this.getColor(foregroundColorValue));
        }
        this.bgColorButton.setDisable(!this.isCommandEnabled(Command.BACKGROUND_COLOR.getCommand()));
        String backgroundColorValue = this.getCommandValue(Command.BACKGROUND_COLOR.getCommand());
        if (backgroundColorValue != null) {
            this.bgColorButton.setValue((Object)this.getColor(backgroundColorValue));
        }
        this.atomicityCount = this.atomicityCount == 0 ? 0 : (this.atomicityCount = this.atomicityCount - 1);
    }

    private void enableToolbar(boolean enable) {
        Platform.runLater(() -> {
            if (enable) {
                // empty if block
            }
            this.undoButton.setDisable(!enable);
            this.redoButton.setDisable(!enable);
            this.insertHorizontalRuleButton.setDisable(!enable);
            this.bulletsButton.setDisable(!enable);
            this.numbersButton.setDisable(!enable);
            this.formatComboBox.setDisable(!enable);
            this.fontFamilyComboBox.setDisable(!enable);
            this.fontSizeComboBox.setDisable(!enable);
            this.boldButton.setDisable(!enable);
            this.italicButton.setDisable(!enable);
            this.underlineButton.setDisable(!enable);
            this.strikethroughButton.setDisable(!enable);
            this.fgColorButton.setDisable(!enable);
            this.bgColorButton.setDisable(!enable);
            this.heading1Button.setDisable(!enable);
            this.heading2Button.setDisable(!enable);
        });
    }

    private boolean executeCommand(String command, String value) {
        if (!this.enableAtomicityCheck || this.enableAtomicityCheck && this.atomicityCount == 0) {
            return this.webPage.executeCommand(command, value);
        }
        return false;
    }

    private boolean isCommandEnabled(String command) {
        return this.webPage.queryCommandEnabled(command);
    }

    public void setContentEditable(boolean b) {
        HTMLDocument htmlDocument = (HTMLDocument)this.webPage.getDocument(this.webPage.getMainFrame());
        HTMLElement htmlDocumentElement = (HTMLElement)htmlDocument.getDocumentElement();
        HTMLElement htmlBodyElement = (HTMLElement)htmlDocumentElement.getElementsByTagName("body").item(0);
        htmlBodyElement.setAttribute("contenteditable", Boolean.toString(b));
    }

    private boolean getCommandState(String command) {
        return this.webPage.queryCommandState(command);
    }

    private String getCommandValue(String command) {
        return this.webPage.queryCommandValue(command);
    }

    private Color getColor(String value) {
        Color color = Color.web((String)value);
        if (color.equals((Object)Color.TRANSPARENT)) {
            color = Color.WHITE;
        }
        return color;
    }

    private void applyTextFormatting() {
        if (this.getCommandState(Command.BULLETS.getCommand()) || this.getCommandState(Command.NUMBERS.getCommand())) {
            return;
        }
        if (this.webPage.getClientCommittedTextLength() == 0) {
            String format = this.formatStyleMap.get(this.formatComboBox.getValue());
            String font = ((String)this.fontFamilyComboBox.getValue()).toString();
            this.executeCommand(Command.FORMAT.getCommand(), format);
        }
    }

    void print(PrinterJob job) {
        this.webView.getEngine().print(job);
    }

    public WebView getWebView() {
        return this.webView;
    }

    public static enum FontSize {
        XX_SMALL("xx-small", 0),
        X_SMALL("x-small", 1),
        SMALL("small", 2),
        MEDIUM("medium", 3),
        LARGE("large", 4),
        X_LARGE("x-large", 5),
        XX_LARGE("xx-large", 6);

        private final String fontSize;
        private final int index;

        private FontSize(String fontSize, int index) {
            this.fontSize = fontSize;
            this.index = index;
        }

        public String getFontSize() {
            return this.fontSize;
        }

        public FontSize getprevious() {
            FontSize[] fontSizes = new FontSize[]{XX_SMALL, X_SMALL, SMALL, MEDIUM, LARGE, X_LARGE, XX_LARGE};
            if (this.index - 1 >= 0) {
                return fontSizes[this.index - 1];
            }
            return this;
        }

        public FontSize getNext() {
            FontSize[] fontSizes = new FontSize[]{XX_SMALL, X_SMALL, SMALL, MEDIUM, LARGE, X_LARGE, XX_LARGE};
            if (this.index + 1 < 7) {
                return fontSizes[this.index + 1];
            }
            return this;
        }
    }

    public static enum Command {
        CUT("cut"),
        COPY("copy"),
        PASTE("paste"),
        UNDO("undo"),
        REDO("redo"),
        INSERT_HORIZONTAL_RULE("inserthorizontalrule"),
        ALIGN_LEFT("justifyleft"),
        ALIGN_CENTER("justifycenter"),
        ALIGN_RIGHT("justifyright"),
        ALIGN_JUSTIFY("justifyfull"),
        BULLETS("insertUnorderedList"),
        NUMBERS("insertOrderedList"),
        INDENT("indent"),
        OUTDENT("outdent"),
        FORMAT("formatblock"),
        BOLD("bold"),
        ITALIC("italic"),
        UNDERLINE("underline"),
        STRIKETHROUGH("strikethrough"),
        FOREGROUND_COLOR("forecolor"),
        BACKGROUND_COLOR("backcolor"),
        STYLEWITHCSS("styleWithCSS"),
        INSERT_NEW_LINE("insertnewline"),
        INSERT_TAB("inserttab");

        private final String command;

        private Command(String command) {
            this.command = command;
        }

        public String getCommand() {
            return this.command;
        }
    }
}

