/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.ui;

import com.jfoenix.controls.JFXComboBox;
import ir.deepmine.dictation.Main;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Paint;

public class FilterComboBox
extends JFXComboBox<String> {
    private ObservableList<String> initialList;
    private ObservableList<String> bufferList = FXCollections.observableArrayList();
    private String previousValue = "";

    public FilterComboBox(ObservableList<String> items) {
        super(items);
        super.setEditable(true);
        this.getEditor().setEditable(true);
        this.setUnFocusColor(Paint.valueOf((String)"#56564f"));
        this.setFocusColor(Paint.valueOf((String)"#fff69d"));
        this.setVisibleRowCount(6);
        this.initialList = items;
        this.getEditor().getStyleClass().add((Object)"labelAdderComboBox");
        this.getEditor().setAlignment(Pos.TOP_RIGHT);
        final FilterComboBox currentInstance = this;
        this.getStylesheets().add((Object)String.valueOf(Main.class.getResource("/style/scroll.css")));
        this.getEditor().setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                currentInstance.getEditor().setText("");
                currentInstance.show();
            }
        });
        this.configAutoFilterListener();
    }

    private void configAutoFilterListener() {
        final FilterComboBox currentInstance = this;
        this.getEditor().textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                FilterComboBox.this.previousValue = oldValue;
                TextField editor = currentInstance.getEditor();
                String selected = (String)currentInstance.getSelectionModel().getSelectedItem();
                System.out.println((String)currentInstance.getSelectionModel().getSelectedItem());
                if (selected == null || !selected.equals(editor.getText())) {
                    FilterComboBox.this.filterItems(newValue, (JFXComboBox<String>)currentInstance);
                    currentInstance.hide();
                    currentInstance.show();
                }
            }
        });
    }

    private void filterItems(String filter, JFXComboBox<String> comboBox) {
        this.bufferList = this.readFromList(filter, this.initialList);
        comboBox.setItems(this.bufferList);
    }

    private ObservableList<String> readFromList(String filter, ObservableList<String> originalList) {
        ObservableList filteredList = FXCollections.observableArrayList();
        for (String item : originalList) {
            if (!item.toLowerCase().contains(filter.toLowerCase())) continue;
            filteredList.add((Object)item);
        }
        return filteredList;
    }

    private void setUserInputToOnlyOption(ComboBox<String> currentInstance, final TextField editor) {
        final String onlyOption = (String)currentInstance.getItems().get(0);
        final String currentText = editor.getText();
        if (onlyOption.length() > currentText.length()) {
            editor.setText(onlyOption);
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    editor.selectRange(currentText.length(), onlyOption.length());
                }
            });
        }
    }
}

