/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.ui;

import com.jfoenix.controls.JFXButton;
import io.sentry.Sentry;
import ir.deepmine.dictation.exceptions.ConnectionException;
import ir.deepmine.dictation.exceptions.ExceptionHandling;
import ir.deepmine.dictation.exceptions.GeneralException;
import ir.deepmine.dictation.exceptions.InvalidTokenException;
import ir.deepmine.dictation.exceptions.NotExistException;
import ir.deepmine.dictation.exceptions.ServerException;
import ir.deepmine.dictation.utils.DoActions;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class ClosableTag
extends HBox {
    private ir.deepmine.dictation.database.Label label;
    private EditableLabel editableLabel;
    private ImageView close = new ImageView(new Image(((Object)((Object)this)).getClass().getResourceAsStream("/icons/close.png")));
    private JFXButton closeBtn = new JFXButton();
    TextField tf = new TextField();
    private String mode = "normal";
    private boolean inDoc = false;
    private boolean edited = false;

    public ClosableTag(ir.deepmine.dictation.database.Label label) {
        this(label, false);
    }

    public ClosableTag(ir.deepmine.dictation.database.Label label, final boolean editable) {
        this.editableLabel = new EditableLabel(editable, label);
        this.label = label;
        this.setMinHeight(24.0);
        this.setPrefHeight(24.0);
        this.setMaxHeight(24.0);
        this.setFillHeight(true);
        this.setStyle("-fx-background-color: #2f2f2f;-fx-background-radius: 100;");
        this.setAlignment(Pos.BASELINE_CENTER);
        this.setNodeOrientation(NodeOrientation.LEFT_TO_RIGHT);
        this.close.setFitWidth(14.0);
        this.close.setFitHeight(14.0);
        this.closeBtn.setGraphic((Node)this.close);
        this.closeBtn.setPrefHeight(14.0);
        this.closeBtn.setPrefWidth(14.0);
        this.closeBtn.setMaxHeight(14.0);
        this.closeBtn.setMaxWidth(14.0);
        this.close.setLayoutY(5.0);
        this.editableLabel.setText(label.getLabel());
        this.editableLabel.setStyle("-fx-font-family: Vazir;\n  -fx-font-size: 12px;\n  -fx-font-weight: normal;\n  -fx-font-stretch: normal;\n  -fx-font-style: normal;\n  -fx-line-height: 1.5;\n  -fx-letter-spacing: 0.22px;\n  -fx-text-align: right;");
        this.editableLabel.setTextFill((Paint)Color.rgb((int)228, (int)228, (int)228));
        this.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (ClosableTag.this.mode.equals("normal") && editable && !ClosableTag.this.inDoc) {
                    ClosableTag.this.editableLabel.setTextFill((Paint)Color.rgb((int)255, (int)245, (int)157));
                    ClosableTag.this.setStyle("-fx-background-color: #56564f;-fx-background-radius: 100;");
                    ClosableTag.this.mode = "selected";
                } else if (ClosableTag.this.mode.equals("selected")) {
                    ClosableTag.this.editableLabel.setTextFill((Paint)Color.rgb((int)228, (int)228, (int)228));
                    ClosableTag.this.setStyle("-fx-background-color: #2f2f2f;-fx-background-radius: 100;");
                    ClosableTag.this.mode = "normal";
                }
            }
        });
        this.addEventHandler(MouseEvent.MOUSE_ENTERED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (!ClosableTag.this.mode.equals("selected") && !ClosableTag.this.inDoc) {
                    ClosableTag.this.setStyle("-fx-background-color: rgb(255, 245, 157,0.35);-fx-background-radius: 100;");
                }
            }
        });
        this.addEventHandler(MouseEvent.MOUSE_EXITED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (!ClosableTag.this.mode.equals("selected") && !ClosableTag.this.inDoc) {
                    ClosableTag.this.setStyle("-fx-background-color: #2f2f2f;-fx-background-radius: 100;");
                }
            }
        });
        this.setAlignment(Pos.TOP_CENTER);
        this.getChildren().add((Object)this.editableLabel);
        this.normalMode();
    }

    public void editMode() {
        this.setMaxWidth(140.0);
        this.close.setLayoutY(5.0);
        this.getChildren().add((Object)this.closeBtn);
        this.editableLabel.setPadding(new Insets(0.0, -3.0, 0.0, 5.0));
        this.setStyle("-fx-background-color: #2f2f2f;-fx-background-radius: 100;");
        this.editableLabel.setTextFill((Paint)Color.rgb((int)255, (int)245, (int)157));
        this.mode = "edit";
    }

    public void normalMode() {
        this.setMaxWidth(120.0);
        this.getChildren().remove((Object)this.closeBtn);
        this.editableLabel.setTextFill((Paint)Color.rgb((int)228, (int)228, (int)228));
        this.editableLabel.setPadding(new Insets(0.0, 4.0, 0.0, 4.0));
        this.mode = "normal";
    }

    public boolean isEdited() {
        return this.edited;
    }

    public void setEdited(boolean edited) {
        this.edited = edited;
    }

    public TextField getTf() {
        return this.tf;
    }

    public JFXButton getCloseBtn() {
        return this.closeBtn;
    }

    public EditableLabel getEditableLabel() {
        return this.editableLabel;
    }

    public String getMode() {
        return this.mode;
    }

    public boolean isInDoc() {
        return this.inDoc;
    }

    public void setInDoc(boolean inDoc) {
        this.inDoc = inDoc;
    }

    public ir.deepmine.dictation.database.Label getLabel() {
        return this.label;
    }

    class EditableLabel
    extends Label {
        ir.deepmine.dictation.database.Label label;
        boolean editable;
        String backup;

        public EditableLabel(boolean editable, ir.deepmine.dictation.database.Label label) {
            this("", editable, label);
        }

        public EditableLabel(String str, ir.deepmine.dictation.database.Label label) {
            this(str, false, label);
        }

        public EditableLabel(String str, boolean editable, ir.deepmine.dictation.database.Label label) {
            super(str);
            this.backup = "";
            this.label = label;
            this.editable = editable;
            if (editable) {
                ClosableTag.this.tf.setStyle("-fx-background-color:rgb(0,0,0,0);-fx-text-fill:rgb(228, 228, 228);-fx-font-family: Vazir;-fx-font-size: 12px;-fx-font-weight: normal;-fx-font-stretch: normal;-fx-font-style: normal;-fx-line-height: 1.5;-fx-letter-spacing: 0.22px;-fx-text-align: right;");
                ClosableTag.this.tf.setAlignment(Pos.TOP_CENTER);
                ClosableTag.this.tf.setPadding(new Insets(0.0, 0.0, 5.0, 0.0));
                this.setOnMouseClicked(e -> {
                    if (e.getClickCount() == 2 && ClosableTag.this.mode.equals("edit")) {
                        this.backup = this.getText();
                        ClosableTag.this.tf.setText(this.backup);
                        ClosableTag.this.tf.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

                            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                                ClosableTag.this.edited = true;
                                System.out.println("edited == true");
                            }
                        });
                        this.setGraphic((Node)ClosableTag.this.tf);
                        this.setText("");
                        ClosableTag.this.tf.requestFocus();
                    }
                });
                ClosableTag.this.tf.focusedProperty().addListener((prop, o, n) -> {
                    if (!n.booleanValue()) {
                        this.toLabel();
                    }
                });
                ClosableTag.this.tf.setOnKeyReleased(e -> {
                    if (e.getCode().equals((Object)KeyCode.ENTER)) {
                        this.toLabel();
                        try {
                            DoActions.getInstance().updateLabel(label.getId(), ClosableTag.this.tf.getText());
                        }
                        catch (InvalidTokenException invalidTokenException) {
                            ExceptionHandling.getInstance().invalidTokenExceptionHandling(invalidTokenException);
                        }
                        catch (NotExistException notExistException) {
                            Sentry.captureException((Throwable)notExistException);
                            notExistException.printStackTrace();
                        }
                        catch (GeneralException generalException) {
                            ExceptionHandling.getInstance().generalExceptionHandling(generalException);
                        }
                        catch (ConnectionException connectionException) {
                            ExceptionHandling.getInstance().connectionExceptionHandling(connectionException);
                        }
                        catch (ServerException serverException) {
                            ExceptionHandling.getInstance().serverExceptionHandling(serverException);
                        }
                    } else if (e.getCode().equals((Object)KeyCode.ESCAPE)) {
                        ClosableTag.this.tf.setText(this.backup);
                        this.toLabel();
                    }
                });
            }
        }

        void toLabel() {
            this.setGraphic(null);
            this.setText(ClosableTag.this.tf.getText());
        }

        public TextField getTf() {
            return ClosableTag.this.tf;
        }
    }
}

