/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.database;

import io.objectbox.annotation.Entity;
import io.objectbox.annotation.Id;
import io.objectbox.annotation.Index;
import io.objectbox.query.Query;
import ir.deepmine.dictation.database.Boxes;
import ir.deepmine.dictation.database.Notification_;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

@Entity
public class Notification {
    @Id(assignable=true)
    private long id;
    @Index
    private long userId;
    private String text;
    private Date date;
    private boolean seen;

    public Notification() {
    }

    public Notification(long id, long userId, String text, Date date, boolean seen) {
        this.id = id;
        this.userId = userId;
        this.text = text;
        this.date = date;
        this.seen = seen;
    }

    public static Notification get(long id) {
        return (Notification)Boxes.notificationBox.get(id);
    }

    public static void put(Notification notification) {
        Boxes.notificationBox.put((Object)notification);
    }

    public static void put(ArrayList<Notification> notifications) {
        Boxes.notificationBox.put(notifications);
    }

    public static void remove(long id) {
        Boxes.notificationBox.remove(id);
    }

    public static List<Notification> getAll(long userId) {
        Query query = Boxes.notificationBox.query().equal(Notification_.userId, userId).build();
        List notifications = query.find();
        query.close();
        return notifications;
    }

    public static void removeAll(long userId) {
        Query query = Boxes.notificationBox.query().equal(Notification_.userId, userId).build();
        List notifications = query.find();
        query.close();
        Boxes.notificationBox.remove((Collection)notifications);
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getUserId() {
        return this.userId;
    }

    public void setUserId(long userId) {
        this.userId = userId;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public boolean getSeen() {
        return this.seen;
    }

    public void setSeen(boolean seen) {
        this.seen = seen;
    }
}

