/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.database;

import io.objectbox.annotation.Convert;
import io.objectbox.annotation.Entity;
import io.objectbox.annotation.Id;
import io.objectbox.annotation.Index;
import io.objectbox.exception.UniqueViolationException;
import io.objectbox.query.Query;
import io.objectbox.query.QueryFilter;
import ir.deepmine.dictation.controller.enums.Page;
import ir.deepmine.dictation.database.Boxes;
import ir.deepmine.dictation.database.Document_;
import ir.deepmine.dictation.database.Label;
import ir.deepmine.dictation.database.LabelConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

@Entity
public class Document {
    @Id(assignable=true)
    private long id;
    @Index
    private String uuid;
    @Index
    private long userId;
    @Index
    private String title;
    private String content;
    private String summary;
    private String content_url;
    private String pureContent;
    @Index
    private Date creation_date;
    @Index
    private Date updated_at;
    @Index
    private Date trashed_date;
    @Index
    private Date content_modified_at;
    private int word_count;
    @Index
    private int deletion_status;
    private boolean modify_status;
    private boolean showFirstTimeInEditor;
    @Convert(converter=LabelConverter.class, dbType=String.class)
    private ArrayList<Label> labels;

    public Document() {
    }

    public Document(String title, String content) {
        this.labels = new ArrayList();
        this.creation_date = new Date();
        this.updated_at = new Date();
        this.title = title;
        this.content = content;
        this.deletion_status = 0;
        this.modify_status = false;
    }

    public Document(long id, String uuid, long userId, String title, String content, String summary, String content_url, String pureContent, Date creation_date, Date updated_at, Date trashed_date, Date content_modified_at, int word_count, int deletion_status, boolean modify_status, boolean showFirstTimeInEditor, ArrayList<Label> labels) {
        this.id = id;
        this.uuid = uuid;
        this.userId = userId;
        this.title = title;
        this.content = content;
        this.summary = summary;
        this.content_url = content_url;
        this.pureContent = pureContent;
        this.creation_date = creation_date;
        this.updated_at = updated_at;
        this.trashed_date = trashed_date;
        this.content_modified_at = content_modified_at;
        this.word_count = word_count;
        this.deletion_status = deletion_status;
        this.modify_status = modify_status;
        this.showFirstTimeInEditor = showFirstTimeInEditor;
        this.labels = labels;
    }

    public static void put(Document document) {
        try {
            Boxes.documentBox.put((Object)document);
        }
        catch (UniqueViolationException e) {
            e.printStackTrace();
        }
    }

    public static void put(List<Document> documents) {
        Boxes.documentBox.put(documents);
    }

    public static List<Document> getAll(long user_id) {
        Query query = Boxes.documentBox.query().equal(Document_.userId, user_id).equal(Document_.deletion_status, 0L).build();
        List documents = query.find();
        query.close();
        return documents;
    }

    public static List<Document> getAll(final Label label) {
        Query query = null;
        query = Boxes.documentBox.query().filter((QueryFilter)new QueryFilter<Document>(){

            public boolean keep(Document entity) {
                return Document.checkLabelId(label.getId(), entity);
            }
        }).build();
        List documents = query.find();
        query.close();
        return documents;
    }

    public static List<Document> getAll(Page type, final ArrayList<Label> labels, String sortOn, String order) {
        Query query = null;
        query = type == Page.ARCHIVE ? (sortOn.equalsIgnoreCase("title") ? (order.equalsIgnoreCase("ascending") ? Boxes.documentBox.query().equal(Document_.deletion_status, 1L).filter((QueryFilter)new QueryFilter<Document>(){

            public boolean keep(Document entity) {
                int count = 0;
                for (Label label : labels) {
                    if (!Document.checkLabelId(label.getId(), entity)) continue;
                    ++count;
                }
                return count == labels.size();
            }
        }).order(Document_.title).build() : Boxes.documentBox.query().equal(Document_.deletion_status, 1L).filter((QueryFilter)new QueryFilter<Document>(){

            public boolean keep(Document entity) {
                int count = 0;
                for (Label label : labels) {
                    if (!Document.checkLabelId(label.getId(), entity)) continue;
                    ++count;
                }
                return count == labels.size();
            }
        }).orderDesc(Document_.title).build()) : (sortOn.equalsIgnoreCase("creation_date") ? (order.equalsIgnoreCase("ascending") ? Boxes.documentBox.query().equal(Document_.deletion_status, 1L).filter((QueryFilter)new QueryFilter<Document>(){

            public boolean keep(Document entity) {
                int count = 0;
                for (Label label : labels) {
                    if (!Document.checkLabelId(label.getId(), entity)) continue;
                    ++count;
                }
                return count == labels.size();
            }
        }).order(Document_.creation_date).build() : Boxes.documentBox.query().equal(Document_.deletion_status, 1L).filter((QueryFilter)new QueryFilter<Document>(){

            public boolean keep(Document entity) {
                int count = 0;
                for (Label label : labels) {
                    if (!Document.checkLabelId(label.getId(), entity)) continue;
                    ++count;
                }
                return count == labels.size();
            }
        }).orderDesc(Document_.creation_date).build()) : (order.equalsIgnoreCase("ascending") ? Boxes.documentBox.query().equal(Document_.deletion_status, 1L).filter((QueryFilter)new QueryFilter<Document>(){

            public boolean keep(Document entity) {
                int count = 0;
                for (Label label : labels) {
                    if (!Document.checkLabelId(label.getId(), entity)) continue;
                    ++count;
                }
                return count == labels.size();
            }
        }).order(Document_.updated_at).build() : Boxes.documentBox.query().equal(Document_.deletion_status, 1L).filter((QueryFilter)new QueryFilter<Document>(){

            public boolean keep(Document entity) {
                int count = 0;
                for (Label label : labels) {
                    if (!Document.checkLabelId(label.getId(), entity)) continue;
                    ++count;
                }
                return count == labels.size();
            }
        }).orderDesc(Document_.updated_at).build()))) : (type == Page.TRASH ? (sortOn.equalsIgnoreCase("title") ? (order.equalsIgnoreCase("ascending") ? Boxes.documentBox.query().equal(Document_.deletion_status, 2L).filter((QueryFilter)new QueryFilter<Document>(){

            public boolean keep(Document entity) {
                int count = 0;
                for (Label label : labels) {
                    if (!Document.checkLabelId(label.getId(), entity)) continue;
                    ++count;
                }
                return count == labels.size();
            }
        }).order(Document_.title).build() : Boxes.documentBox.query().equal(Document_.deletion_status, 2L).filter((QueryFilter)new QueryFilter<Document>(){

            public boolean keep(Document entity) {
                int count = 0;
                for (Label label : labels) {
                    if (!Document.checkLabelId(label.getId(), entity)) continue;
                    ++count;
                }
                return count == labels.size();
            }
        }).orderDesc(Document_.title).build()) : (sortOn.equalsIgnoreCase("creation_date") ? (order.equalsIgnoreCase("ascending") ? Boxes.documentBox.query().equal(Document_.deletion_status, 2L).filter((QueryFilter)new QueryFilter<Document>(){

            public boolean keep(Document entity) {
                int count = 0;
                for (Label label : labels) {
                    if (!Document.checkLabelId(label.getId(), entity)) continue;
                    ++count;
                }
                return count == labels.size();
            }
        }).order(Document_.creation_date).build() : Boxes.documentBox.query().equal(Document_.deletion_status, 2L).filter((QueryFilter)new QueryFilter<Document>(){

            public boolean keep(Document entity) {
                int count = 0;
                for (Label label : labels) {
                    if (!Document.checkLabelId(label.getId(), entity)) continue;
                    ++count;
                }
                return count == labels.size();
            }
        }).orderDesc(Document_.creation_date).build()) : (order.equalsIgnoreCase("ascending") ? Boxes.documentBox.query().equal(Document_.deletion_status, 2L).filter((QueryFilter)new QueryFilter<Document>(){

            public boolean keep(Document entity) {
                int count = 0;
                for (Label label : labels) {
                    if (!Document.checkLabelId(label.getId(), entity)) continue;
                    ++count;
                }
                return count == labels.size();
            }
        }).order(Document_.updated_at).build() : Boxes.documentBox.query().equal(Document_.deletion_status, 2L).filter((QueryFilter)new QueryFilter<Document>(){

            public boolean keep(Document entity) {
                int count = 0;
                for (Label label : labels) {
                    if (!Document.checkLabelId(label.getId(), entity)) continue;
                    ++count;
                }
                return count == labels.size();
            }
        }).orderDesc(Document_.updated_at).build()))) : (sortOn.equalsIgnoreCase("title") ? (order.equalsIgnoreCase("ascending") ? Boxes.documentBox.query().equal(Document_.deletion_status, 0L).filter((QueryFilter)new QueryFilter<Document>(){

            public boolean keep(Document entity) {
                int count = 0;
                for (Label label : labels) {
                    if (!Document.checkLabelId(label.getId(), entity)) continue;
                    ++count;
                }
                return count == labels.size();
            }
        }).order(Document_.title).build() : Boxes.documentBox.query().equal(Document_.deletion_status, 0L).filter((QueryFilter)new QueryFilter<Document>(){

            public boolean keep(Document entity) {
                int count = 0;
                for (Label label : labels) {
                    if (!Document.checkLabelId(label.getId(), entity)) continue;
                    ++count;
                }
                return count == labels.size();
            }
        }).orderDesc(Document_.title).build()) : (sortOn.equalsIgnoreCase("creation_date") ? (order.equalsIgnoreCase("ascending") ? Boxes.documentBox.query().equal(Document_.deletion_status, 0L).filter((QueryFilter)new QueryFilter<Document>(){

            public boolean keep(Document entity) {
                int count = 0;
                for (Label label : labels) {
                    if (!Document.checkLabelId(label.getId(), entity)) continue;
                    ++count;
                }
                return count == labels.size();
            }
        }).order(Document_.creation_date).build() : Boxes.documentBox.query().equal(Document_.deletion_status, 0L).filter((QueryFilter)new QueryFilter<Document>(){

            public boolean keep(Document entity) {
                int count = 0;
                for (Label label : labels) {
                    if (!Document.checkLabelId(label.getId(), entity)) continue;
                    ++count;
                }
                return count == labels.size();
            }
        }).orderDesc(Document_.creation_date).build()) : (order.equalsIgnoreCase("ascending") ? Boxes.documentBox.query().equal(Document_.deletion_status, 0L).filter((QueryFilter)new QueryFilter<Document>(){

            public boolean keep(Document entity) {
                int count = 0;
                for (Label label : labels) {
                    if (!Document.checkLabelId(label.getId(), entity)) continue;
                    ++count;
                }
                return count == labels.size();
            }
        }).order(Document_.updated_at).build() : Boxes.documentBox.query().equal(Document_.deletion_status, 0L).filter((QueryFilter)new QueryFilter<Document>(){

            public boolean keep(Document entity) {
                int count = 0;
                for (Label label : labels) {
                    if (!Document.checkLabelId(label.getId(), entity)) continue;
                    ++count;
                }
                return count == labels.size();
            }
        }).orderDesc(Document_.updated_at).build()))));
        List documents = query.find();
        query.close();
        return documents;
    }

    public static List<Document> getAll(Page type, final ArrayList<Label> labels, String sortOn, String order, String text) {
        Query query = null;
        query = type == Page.ARCHIVE ? (sortOn.equalsIgnoreCase("title") ? (order.equalsIgnoreCase("ascending") ? Boxes.documentBox.query().equal(Document_.deletion_status, 1L).contains(Document_.pureContent, text).or().contains(Document_.title, text).filter((QueryFilter)new QueryFilter<Document>(){

            public boolean keep(Document entity) {
                int count = 0;
                for (Label label : labels) {
                    if (!Document.checkLabelId(label.getId(), entity)) continue;
                    ++count;
                }
                return count == labels.size();
            }
        }).order(Document_.title).build() : Boxes.documentBox.query().equal(Document_.deletion_status, 1L).contains(Document_.pureContent, text).or().contains(Document_.title, text).filter((QueryFilter)new QueryFilter<Document>(){

            public boolean keep(Document entity) {
                int count = 0;
                for (Label label : labels) {
                    if (!Document.checkLabelId(label.getId(), entity)) continue;
                    ++count;
                }
                return count == labels.size();
            }
        }).orderDesc(Document_.title).build()) : (sortOn.equalsIgnoreCase("creation_date") ? (order.equalsIgnoreCase("ascending") ? Boxes.documentBox.query().equal(Document_.deletion_status, 1L).contains(Document_.pureContent, text).or().contains(Document_.title, text).filter((QueryFilter)new QueryFilter<Document>(){

            public boolean keep(Document entity) {
                int count = 0;
                for (Label label : labels) {
                    if (!Document.checkLabelId(label.getId(), entity)) continue;
                    ++count;
                }
                return count == labels.size();
            }
        }).order(Document_.creation_date).build() : Boxes.documentBox.query().equal(Document_.deletion_status, 1L).contains(Document_.pureContent, text).or().contains(Document_.title, text).filter((QueryFilter)new QueryFilter<Document>(){

            public boolean keep(Document entity) {
                int count = 0;
                for (Label label : labels) {
                    if (!Document.checkLabelId(label.getId(), entity)) continue;
                    ++count;
                }
                return count == labels.size();
            }
        }).orderDesc(Document_.creation_date).build()) : (order.equalsIgnoreCase("ascending") ? Boxes.documentBox.query().equal(Document_.deletion_status, 1L).contains(Document_.pureContent, text).or().contains(Document_.title, text).filter((QueryFilter)new QueryFilter<Document>(){

            public boolean keep(Document entity) {
                int count = 0;
                for (Label label : labels) {
                    if (!Document.checkLabelId(label.getId(), entity)) continue;
                    ++count;
                }
                return count == labels.size();
            }
        }).order(Document_.updated_at).build() : Boxes.documentBox.query().equal(Document_.deletion_status, 1L).contains(Document_.pureContent, text).or().contains(Document_.title, text).filter((QueryFilter)new QueryFilter<Document>(){

            public boolean keep(Document entity) {
                int count = 0;
                for (Label label : labels) {
                    if (!Document.checkLabelId(label.getId(), entity)) continue;
                    ++count;
                }
                return count == labels.size();
            }
        }).orderDesc(Document_.updated_at).build()))) : (type == Page.TRASH ? (sortOn.equalsIgnoreCase("title") ? (order.equalsIgnoreCase("ascending") ? Boxes.documentBox.query().equal(Document_.deletion_status, 2L).contains(Document_.pureContent, text).or().contains(Document_.title, text).filter((QueryFilter)new QueryFilter<Document>(){

            public boolean keep(Document entity) {
                int count = 0;
                for (Label label : labels) {
                    if (!Document.checkLabelId(label.getId(), entity)) continue;
                    ++count;
                }
                return count == labels.size();
            }
        }).order(Document_.title).build() : Boxes.documentBox.query().equal(Document_.deletion_status, 2L).contains(Document_.pureContent, text).or().contains(Document_.title, text).filter((QueryFilter)new QueryFilter<Document>(){

            public boolean keep(Document entity) {
                int count = 0;
                for (Label label : labels) {
                    if (!Document.checkLabelId(label.getId(), entity)) continue;
                    ++count;
                }
                return count == labels.size();
            }
        }).orderDesc(Document_.title).build()) : (sortOn.equalsIgnoreCase("creation_date") ? (order.equalsIgnoreCase("ascending") ? Boxes.documentBox.query().equal(Document_.deletion_status, 2L).contains(Document_.pureContent, text).or().contains(Document_.title, text).filter((QueryFilter)new QueryFilter<Document>(){

            public boolean keep(Document entity) {
                int count = 0;
                for (Label label : labels) {
                    if (!Document.checkLabelId(label.getId(), entity)) continue;
                    ++count;
                }
                return count == labels.size();
            }
        }).order(Document_.creation_date).build() : Boxes.documentBox.query().equal(Document_.deletion_status, 2L).contains(Document_.pureContent, text).or().contains(Document_.title, text).filter((QueryFilter)new QueryFilter<Document>(){

            public boolean keep(Document entity) {
                int count = 0;
                for (Label label : labels) {
                    if (!Document.checkLabelId(label.getId(), entity)) continue;
                    ++count;
                }
                return count == labels.size();
            }
        }).orderDesc(Document_.creation_date).build()) : (order.equalsIgnoreCase("ascending") ? Boxes.documentBox.query().equal(Document_.deletion_status, 2L).contains(Document_.pureContent, text).or().contains(Document_.title, text).filter((QueryFilter)new QueryFilter<Document>(){

            public boolean keep(Document entity) {
                int count = 0;
                for (Label label : labels) {
                    if (!Document.checkLabelId(label.getId(), entity)) continue;
                    ++count;
                }
                return count == labels.size();
            }
        }).order(Document_.updated_at).build() : Boxes.documentBox.query().equal(Document_.deletion_status, 2L).contains(Document_.pureContent, text).or().contains(Document_.title, text).filter((QueryFilter)new QueryFilter<Document>(){

            public boolean keep(Document entity) {
                int count = 0;
                for (Label label : labels) {
                    if (!Document.checkLabelId(label.getId(), entity)) continue;
                    ++count;
                }
                return count == labels.size();
            }
        }).orderDesc(Document_.updated_at).build()))) : (sortOn.equalsIgnoreCase("title") ? (order.equalsIgnoreCase("ascending") ? Boxes.documentBox.query().equal(Document_.deletion_status, 0L).contains(Document_.pureContent, text).or().contains(Document_.title, text).filter((QueryFilter)new QueryFilter<Document>(){

            public boolean keep(Document entity) {
                int count = 0;
                for (Label label : labels) {
                    if (!Document.checkLabelId(label.getId(), entity)) continue;
                    ++count;
                }
                return count == labels.size();
            }
        }).order(Document_.title).build() : Boxes.documentBox.query().equal(Document_.deletion_status, 0L).contains(Document_.pureContent, text).or().contains(Document_.title, text).filter((QueryFilter)new QueryFilter<Document>(){

            public boolean keep(Document entity) {
                int count = 0;
                for (Label label : labels) {
                    if (!Document.checkLabelId(label.getId(), entity)) continue;
                    ++count;
                }
                return count == labels.size();
            }
        }).orderDesc(Document_.title).build()) : (sortOn.equalsIgnoreCase("creation_date") ? (order.equalsIgnoreCase("ascending") ? Boxes.documentBox.query().equal(Document_.deletion_status, 0L).contains(Document_.pureContent, text).or().contains(Document_.title, text).filter((QueryFilter)new QueryFilter<Document>(){

            public boolean keep(Document entity) {
                int count = 0;
                for (Label label : labels) {
                    if (!Document.checkLabelId(label.getId(), entity)) continue;
                    ++count;
                }
                return count == labels.size();
            }
        }).order(Document_.creation_date).build() : Boxes.documentBox.query().equal(Document_.deletion_status, 0L).contains(Document_.pureContent, text).or().contains(Document_.title, text).filter((QueryFilter)new QueryFilter<Document>(){

            public boolean keep(Document entity) {
                int count = 0;
                for (Label label : labels) {
                    if (!Document.checkLabelId(label.getId(), entity)) continue;
                    ++count;
                }
                return count == labels.size();
            }
        }).orderDesc(Document_.creation_date).build()) : (order.equalsIgnoreCase("ascending") ? Boxes.documentBox.query().equal(Document_.deletion_status, 0L).contains(Document_.pureContent, text).or().contains(Document_.title, text).filter((QueryFilter)new QueryFilter<Document>(){

            public boolean keep(Document entity) {
                int count = 0;
                for (Label label : labels) {
                    if (!Document.checkLabelId(label.getId(), entity)) continue;
                    ++count;
                }
                return count == labels.size();
            }
        }).order(Document_.updated_at).build() : Boxes.documentBox.query().equal(Document_.deletion_status, 0L).contains(Document_.pureContent, text).or().contains(Document_.title, text).filter((QueryFilter)new QueryFilter<Document>(){

            public boolean keep(Document entity) {
                int count = 0;
                for (Label label : labels) {
                    if (!Document.checkLabelId(label.getId(), entity)) continue;
                    ++count;
                }
                return count == labels.size();
            }
        }).orderDesc(Document_.updated_at).build()))));
        List documents = query.find();
        query.close();
        return documents;
    }

    public static List<Document> search(long userId, String text, String sortOn, String order, Page type) {
        Query query = null;
        List documents = null;
        if (type == Page.ARCHIVE) {
            if (sortOn.equalsIgnoreCase("title")) {
                if (order.equalsIgnoreCase("ascending")) {
                    query = Boxes.documentBox.query().equal(Document_.userId, userId).equal(Document_.deletion_status, 1L).contains(Document_.pureContent, text).or().contains(Document_.title, text).order(Document_.title).build();
                    documents = query.find();
                } else {
                    query = Boxes.documentBox.query().equal(Document_.userId, userId).equal(Document_.deletion_status, 1L).contains(Document_.pureContent, text).or().contains(Document_.title, text).orderDesc(Document_.title).build();
                    documents = query.find();
                }
            } else if (sortOn.equalsIgnoreCase("creation_date")) {
                if (order.equalsIgnoreCase("ascending")) {
                    query = Boxes.documentBox.query().equal(Document_.userId, userId).equal(Document_.deletion_status, 1L).contains(Document_.pureContent, text).or().contains(Document_.title, text).order(Document_.creation_date).build();
                    documents = query.find();
                } else {
                    query = Boxes.documentBox.query().equal(Document_.userId, userId).equal(Document_.deletion_status, 1L).contains(Document_.pureContent, text).or().contains(Document_.title, text).orderDesc(Document_.creation_date).build();
                    documents = query.find();
                }
            } else if (order.equalsIgnoreCase("ascending")) {
                query = Boxes.documentBox.query().equal(Document_.userId, userId).equal(Document_.deletion_status, 1L).contains(Document_.pureContent, text).or().contains(Document_.title, text).order(Document_.updated_at).build();
                documents = query.find();
            } else {
                query = Boxes.documentBox.query().equal(Document_.userId, userId).equal(Document_.deletion_status, 1L).contains(Document_.pureContent, text).or().contains(Document_.title, text).orderDesc(Document_.updated_at).build();
                documents = query.find();
            }
        } else if (type == Page.TRASH) {
            if (sortOn.equalsIgnoreCase("title")) {
                if (order.equalsIgnoreCase("ascending")) {
                    query = Boxes.documentBox.query().equal(Document_.userId, userId).equal(Document_.deletion_status, 2L).contains(Document_.pureContent, text).or().contains(Document_.title, text).order(Document_.title).build();
                    documents = query.find();
                } else {
                    query = Boxes.documentBox.query().equal(Document_.userId, userId).equal(Document_.deletion_status, 2L).contains(Document_.pureContent, text).or().contains(Document_.title, text).orderDesc(Document_.title).build();
                    documents = query.find();
                }
            } else if (sortOn.equalsIgnoreCase("creation_date")) {
                if (order.equalsIgnoreCase("ascending")) {
                    query = Boxes.documentBox.query().equal(Document_.userId, userId).equal(Document_.deletion_status, 2L).contains(Document_.pureContent, text).or().contains(Document_.title, text).order(Document_.creation_date).build();
                    documents = query.find();
                } else {
                    query = Boxes.documentBox.query().equal(Document_.userId, userId).equal(Document_.deletion_status, 2L).contains(Document_.pureContent, text).or().contains(Document_.title, text).orderDesc(Document_.creation_date).build();
                    documents = query.find();
                }
            } else if (order.equalsIgnoreCase("ascending")) {
                query = Boxes.documentBox.query().equal(Document_.userId, userId).equal(Document_.deletion_status, 2L).contains(Document_.pureContent, text).or().contains(Document_.title, text).order(Document_.updated_at).build();
                documents = query.find();
            } else {
                query = Boxes.documentBox.query().equal(Document_.userId, userId).equal(Document_.deletion_status, 2L).contains(Document_.pureContent, text).or().contains(Document_.title, text).orderDesc(Document_.updated_at).build();
                documents = query.find();
            }
        } else if (sortOn.equalsIgnoreCase("title")) {
            if (order.equalsIgnoreCase("ascending")) {
                query = Boxes.documentBox.query().equal(Document_.userId, userId).equal(Document_.deletion_status, 0L).contains(Document_.pureContent, text).or().contains(Document_.title, text).order(Document_.title).build();
                documents = query.find();
            } else {
                query = Boxes.documentBox.query().equal(Document_.userId, userId).equal(Document_.deletion_status, 0L).contains(Document_.pureContent, text).or().contains(Document_.title, text).orderDesc(Document_.title).build();
                documents = query.find();
            }
        } else if (sortOn.equalsIgnoreCase("creation_date")) {
            if (order.equalsIgnoreCase("ascending")) {
                query = Boxes.documentBox.query().equal(Document_.userId, userId).equal(Document_.deletion_status, 0L).contains(Document_.pureContent, text).or().contains(Document_.title, text).order(Document_.creation_date).build();
                documents = query.find();
            } else {
                query = Boxes.documentBox.query().equal(Document_.userId, userId).equal(Document_.deletion_status, 0L).contains(Document_.pureContent, text).or().contains(Document_.title, text).orderDesc(Document_.creation_date).build();
                documents = query.find();
            }
        } else if (order.equalsIgnoreCase("ascending")) {
            query = Boxes.documentBox.query().equal(Document_.userId, userId).equal(Document_.deletion_status, 0L).contains(Document_.pureContent, text).or().contains(Document_.title, text).order(Document_.updated_at).build();
            documents = query.find();
        } else {
            query = Boxes.documentBox.query().equal(Document_.userId, userId).equal(Document_.deletion_status, 0L).contains(Document_.pureContent, text).or().contains(Document_.title, text).orderDesc(Document_.updated_at).build();
            documents = query.find();
        }
        query.close();
        return documents;
    }

    public static long[] getIds(long userId) {
        Query query = Boxes.documentBox.query().equal(Document_.userId, userId).build();
        long[] ids = query.findIds();
        query.close();
        return ids;
    }

    public static List<Document> getAll(long user_id, String sortOn, String order, Page type) {
        List documents = null;
        Query query = null;
        query = type == Page.ARCHIVE ? (sortOn.equals("title") ? (order.equalsIgnoreCase("ascending") ? Boxes.documentBox.query().equal(Document_.userId, user_id).equal(Document_.deletion_status, 1L).orderDesc(Document_.title).build() : Boxes.documentBox.query().equal(Document_.userId, user_id).equal(Document_.deletion_status, 1L).order(Document_.title).build()) : (sortOn.equalsIgnoreCase("creation_date") ? (order.equalsIgnoreCase("ascending") ? Boxes.documentBox.query().equal(Document_.userId, user_id).equal(Document_.deletion_status, 1L).orderDesc(Document_.creation_date).build() : Boxes.documentBox.query().equal(Document_.userId, user_id).equal(Document_.deletion_status, 1L).order(Document_.creation_date).build()) : (order.equalsIgnoreCase("ascending") ? Boxes.documentBox.query().equal(Document_.userId, user_id).equal(Document_.deletion_status, 1L).orderDesc(Document_.updated_at).build() : Boxes.documentBox.query().equal(Document_.userId, user_id).equal(Document_.deletion_status, 1L).order(Document_.updated_at).build()))) : (type == Page.TRASH ? (sortOn.equals("title") ? (order.equalsIgnoreCase("ascending") ? Boxes.documentBox.query().equal(Document_.userId, user_id).equal(Document_.deletion_status, 2L).orderDesc(Document_.title).build() : Boxes.documentBox.query().equal(Document_.userId, user_id).equal(Document_.deletion_status, 2L).order(Document_.title).build()) : (sortOn.equalsIgnoreCase("creation_date") ? (order.equalsIgnoreCase("ascending") ? Boxes.documentBox.query().equal(Document_.userId, user_id).equal(Document_.deletion_status, 2L).orderDesc(Document_.creation_date).build() : Boxes.documentBox.query().equal(Document_.userId, user_id).equal(Document_.deletion_status, 2L).order(Document_.creation_date).build()) : (order.equalsIgnoreCase("ascending") ? Boxes.documentBox.query().equal(Document_.userId, user_id).equal(Document_.deletion_status, 2L).orderDesc(Document_.updated_at).build() : Boxes.documentBox.query().equal(Document_.userId, user_id).equal(Document_.deletion_status, 2L).order(Document_.updated_at).build()))) : (sortOn.equals("title") ? (order.equalsIgnoreCase("ascending") ? Boxes.documentBox.query().equal(Document_.userId, user_id).equal(Document_.deletion_status, 0L).orderDesc(Document_.title).build() : Boxes.documentBox.query().equal(Document_.userId, user_id).equal(Document_.deletion_status, 0L).order(Document_.title).build()) : (sortOn.equalsIgnoreCase("creation_date") ? (order.equalsIgnoreCase("ascending") ? Boxes.documentBox.query().equal(Document_.userId, user_id).equal(Document_.deletion_status, 0L).orderDesc(Document_.creation_date).build() : Boxes.documentBox.query().equal(Document_.userId, user_id).equal(Document_.deletion_status, 0L).order(Document_.creation_date).build()) : (order.equalsIgnoreCase("ascending") ? Boxes.documentBox.query().equal(Document_.userId, user_id).equal(Document_.deletion_status, 0L).orderDesc(Document_.updated_at).build() : Boxes.documentBox.query().equal(Document_.userId, user_id).equal(Document_.deletion_status, 0L).order(Document_.updated_at).build()))));
        documents = query.find();
        query.close();
        return documents;
    }

    public static List<Document> getAllRemoved(long userId) {
        Query query = Boxes.documentBox.query().equal(Document_.userId, userId).equal(Document_.deletion_status, 2L).build();
        List documents = query.find();
        query.close();
        return documents;
    }

    public static List<Document> getAllArchived(long userId) {
        Query query = Boxes.documentBox.query().equal(Document_.userId, userId).equal(Document_.deletion_status, 1L).build();
        List documents = query.find();
        query.close();
        return documents;
    }

    public static void removeAll(long userId) {
        Query query = Boxes.documentBox.query().equal(Document_.userId, userId).build();
        List documents = query.find();
        query.close();
        Boxes.documentBox.remove((Collection)documents);
    }

    public static void remove(long id) {
        Boxes.documentBox.remove(id);
    }

    public static Document get(long id) {
        return (Document)Boxes.documentBox.get(id);
    }

    public static Document get(String uuid, long userId) {
        Query query = Boxes.documentBox.query().equal(Document_.uuid, uuid).equal(Document_.userId, userId).build();
        Document document = (Document)query.findUnique();
        query.close();
        return document;
    }

    public static void removeMoveToTrash(String uuid) {
        Query query = Boxes.documentBox.query().equal(Document_.uuid, uuid).build();
        Document document = (Document)query.findUnique();
        query.close();
        assert (document != null);
        document.setDeletion_status(2);
        Boxes.documentBox.put((Object)document);
    }

    public static void remove(String uuid) {
        Query query = Boxes.documentBox.query().equal(Document_.uuid, uuid).build();
        Document document = (Document)query.findUnique();
        query.close();
        assert (document != null);
        Boxes.documentBox.remove((Object)document);
    }

    public static Document get(String uuid) {
        Query query = Boxes.documentBox.query().equal(Document_.uuid, uuid).build();
        Document document = (Document)query.findUnique();
        query.close();
        return document;
    }

    private static boolean checkLabelId(long id, Document entity) {
        for (int i = 0; i < entity.getLabels().size(); ++i) {
            if (entity.getLabels().get(i).getId() != id) continue;
            return true;
        }
        return false;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getUserId() {
        return this.userId;
    }

    public void setUserId(long userId) {
        this.userId = userId;
    }

    public int isDeletion_status() {
        return this.deletion_status;
    }

    public boolean isModify_status() {
        return this.modify_status;
    }

    public void setModify_status(boolean modifyStatus) {
        this.modify_status = modifyStatus;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Date getCreation_date() {
        return this.creation_date;
    }

    public void setCreation_date(Date creationDate) {
        this.creation_date = creationDate;
    }

    public Date getUpdated_at() {
        return this.updated_at;
    }

    public void setUpdated_at(Date updateDate) {
        this.updated_at = updateDate;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getContent_url() {
        return this.content_url;
    }

    public void setContent_url(String content_url) {
        this.content_url = content_url;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getPureContent() {
        return this.pureContent;
    }

    public void setPureContent(String pureContent) {
        this.pureContent = pureContent;
    }

    public int getWord_count() {
        return this.word_count;
    }

    public void setWord_count(int wordCount) {
        this.word_count = wordCount;
    }

    public ArrayList<Label> getLabels() {
        return this.labels;
    }

    public void setLabels(ArrayList<Label> labels) {
        this.labels = labels;
    }

    public int getDeletion_status() {
        return this.deletion_status;
    }

    public void setDeletion_status(int deletion_status) {
        this.deletion_status = deletion_status;
    }

    public Date getTrashed_date() {
        return this.trashed_date;
    }

    public void setTrashed_date(Date trashed_date) {
        this.trashed_date = trashed_date;
    }

    public boolean isShowFirstTimeInEditor() {
        return this.showFirstTimeInEditor;
    }

    public void setShowFirstTimeInEditor(boolean showFirstTimeInEditor) {
        this.showFirstTimeInEditor = showFirstTimeInEditor;
    }

    public Date getContent_modified_at() {
        return this.content_modified_at;
    }

    public void setContent_modified_at(Date content_modified_at) {
        this.content_modified_at = content_modified_at;
    }
}

