/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.controller.edit;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXTextField;
import ir.deepmine.dictation.controller.enums.ForgetRegisterState;
import ir.deepmine.dictation.exceptions.ConnectionException;
import ir.deepmine.dictation.exceptions.ExceptionHandling;
import ir.deepmine.dictation.exceptions.ExpiredCodeVerificationException;
import ir.deepmine.dictation.exceptions.GeneralException;
import ir.deepmine.dictation.exceptions.InvalidCodeVerificationException;
import ir.deepmine.dictation.exceptions.InvalidFormatException;
import ir.deepmine.dictation.exceptions.ServerException;
import ir.deepmine.dictation.exceptions.SuccessException;
import ir.deepmine.dictation.exceptions.TooManyRequestException;
import ir.deepmine.dictation.exceptions.UserNotFoundException;
import ir.deepmine.dictation.ui.notification.Notifications;
import ir.deepmine.dictation.ui.notification.TrayNotification;
import ir.deepmine.dictation.utils.DoActions;
import ir.deepmine.dictation.utils.Utilities;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javafx.animation.FadeTransition;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.util.Duration;
import javax.swing.Timer;

public class EditPasswordController {
    private DoActions doActions;
    private ExceptionHandling exceptionHandling;
    private boolean isMobile;
    private String phoneNumber;
    private String email;
    private ForgetRegisterState state;
    private Timer timer;
    private int duration;
    private AnchorPane rootPane;
    @FXML
    private JFXButton next;
    @FXML
    private JFXTextField phone_code_name;
    @FXML
    private Label invalidFormatLabel;
    @FXML
    private Label timerLabel;
    @FXML
    private ImageView timerImage;
    @FXML
    private JFXButton previous;
    private FadeTransition fadeTransition;

    public EditPasswordController(AnchorPane rootPane, boolean isMobile, String mobile, String email) {
        this.rootPane = rootPane;
        this.isMobile = isMobile;
        this.phoneNumber = mobile;
        this.email = email;
    }

    public void initialize() {
        this.duration = 120;
        this.state = ForgetRegisterState.STATE1;
        this.doActions = DoActions.getInstance();
        this.exceptionHandling = ExceptionHandling.getInstance();
        this.fadeTransition = new FadeTransition(Duration.millis((double)7000.0), (Node)this.invalidFormatLabel);
        this.fadeTransition.setFromValue(1.0);
        this.fadeTransition.setToValue(0.0);
        if (this.isMobile) {
            this.phone_code_name.setPromptText("\u0634\u0645\u0627\u0631\u0647 \u0647\u0645\u0631\u0627\u0647");
            this.phone_code_name.setText(this.phoneNumber);
        } else {
            this.phone_code_name.setPromptText("\u0627\u06cc\u0645\u06cc\u0644");
            this.phone_code_name.setText(this.email);
        }
        this.phone_code_name.setDisable(true);
    }

    @FXML
    void nextClick(javafx.event.ActionEvent event) {
        if (this.state == ForgetRegisterState.STATE1) {
            if (this.isMobile) {
                try {
                    this.doActions.phoneForget(this.phoneNumber);
                }
                catch (InvalidFormatException e) {
                    this.showFadeLabel();
                }
                catch (SuccessException e) {
                    this.goToState2();
                }
                catch (ServerException e) {
                    this.exceptionHandling.serverExceptionHandling(e);
                }
                catch (ConnectionException e) {
                    this.exceptionHandling.connectionExceptionHandling(e);
                }
                catch (TooManyRequestException e) {
                    TrayNotification tray = new TrayNotification("\u06a9\u062f \u062a\u0627\u06cc\u06cc\u062f \u0627\u0631\u0633\u0627\u0644 \u0634\u062f\u0647 \u0627\u0633\u062a.", "", Notifications.NOTICE);
                    tray.showAndDismiss();
                    this.goToState2();
                }
                catch (UserNotFoundException e) {
                    TrayNotification tray = new TrayNotification("\u0639\u062f\u0645 \u062d\u0633\u0627\u0628 \u06a9\u0627\u0631\u0628\u0631\u06cc", e.getMessage(), Notifications.NOTICE);
                    tray.showAndDismiss();
                }
                catch (GeneralException e) {
                    this.exceptionHandling.generalExceptionHandling(e);
                }
            } else {
                try {
                    this.doActions.emailForget(this.email);
                }
                catch (InvalidFormatException e) {
                    this.showFadeLabel();
                }
                catch (SuccessException e) {
                    this.goToState2();
                }
                catch (ServerException e) {
                    this.exceptionHandling.serverExceptionHandling(e);
                }
                catch (ConnectionException e) {
                    this.exceptionHandling.connectionExceptionHandling(e);
                }
                catch (TooManyRequestException e) {
                    TrayNotification tray = new TrayNotification("\u06a9\u062f \u062a\u0627\u06cc\u06cc\u062f \u0627\u0631\u0633\u0627\u0644 \u0634\u062f\u0647 \u0627\u0633\u062a.", "", Notifications.NOTICE);
                    tray.showAndDismiss();
                    this.goToState2();
                }
                catch (UserNotFoundException e) {
                    TrayNotification tray = new TrayNotification("\u0639\u062f\u0645 \u062d\u0633\u0627\u0628 \u06a9\u0627\u0631\u0628\u0631\u06cc", e.getMessage(), Notifications.NOTICE);
                    tray.showAndDismiss();
                }
                catch (GeneralException e) {
                    this.exceptionHandling.generalExceptionHandling(e);
                }
            }
        } else if (this.state == ForgetRegisterState.STATE2) {
            String code = this.phone_code_name.getText();
            System.out.println("code: " + code);
            if (this.isMobile) {
                try {
                    this.doActions.phoneCodeVerification(this.phoneNumber, code);
                }
                catch (ServerException e) {
                    this.exceptionHandling.serverExceptionHandling(e);
                }
                catch (ConnectionException e) {
                    this.exceptionHandling.connectionExceptionHandling(e);
                }
                catch (InvalidFormatException e) {
                    System.out.println("format error");
                }
                catch (ExpiredCodeVerificationException e) {
                    TrayNotification tray = new TrayNotification("\u06a9\u062f \u0645\u0646\u0642\u0636\u06cc", e.getMessage(), Notifications.INFORMATION);
                    tray.showAndDismiss();
                }
                catch (SuccessException e) {
                    this.goToState3();
                }
                catch (InvalidCodeVerificationException e) {
                    TrayNotification tray = new TrayNotification("\u06a9\u062f \u0646\u0627\u0645\u0639\u062a\u0628\u0631", e.getMessage(), Notifications.WARNING);
                    tray.showAndDismiss();
                }
                catch (GeneralException e) {
                    this.exceptionHandling.generalExceptionHandling(e);
                }
            } else {
                try {
                    this.doActions.emailCodeVerification(this.email, code);
                }
                catch (ServerException e) {
                    this.exceptionHandling.serverExceptionHandling(e);
                }
                catch (ConnectionException e) {
                    this.exceptionHandling.connectionExceptionHandling(e);
                }
                catch (InvalidFormatException e) {
                    System.out.println("format error");
                }
                catch (ExpiredCodeVerificationException e) {
                    TrayNotification tray = new TrayNotification("\u06a9\u062f \u0645\u0646\u0642\u0636\u06cc", e.getMessage(), Notifications.INFORMATION);
                    tray.showAndDismiss();
                }
                catch (SuccessException e) {
                    this.goToState3();
                }
                catch (InvalidCodeVerificationException e) {
                    TrayNotification tray = new TrayNotification("\u06a9\u062f \u0646\u0627\u0645\u0639\u062a\u0628\u0631", e.getMessage(), Notifications.WARNING);
                    tray.showAndDismiss();
                }
                catch (GeneralException e) {
                    this.exceptionHandling.generalExceptionHandling(e);
                }
            }
        } else if (this.state == ForgetRegisterState.STATE3) {
            String password = this.phone_code_name.getText();
            if (this.isMobile) {
                if (Utilities.validatePassword(password)) {
                    try {
                        HashMap<String, String> info = this.doActions.phoneForgetSetPassword(this.phoneNumber, password);
                        TrayNotification tray = new TrayNotification("\u0645\u0648\u0641\u0642\u06cc\u062a", "\u0631\u0645\u0632 \u0639\u0628\u0648\u0631 \u0628\u0627 \u0645\u0648\u0641\u0642\u06cc\u062a \u062a\u063a\u06cc\u06cc\u0631 \u06a9\u0631\u062f.", Notifications.SUCCESS);
                        tray.showAndDismiss();
                        this.close();
                    }
                    catch (ServerException e) {
                        this.exceptionHandling.serverExceptionHandling(e);
                    }
                    catch (ConnectionException e) {
                        this.exceptionHandling.connectionExceptionHandling(e);
                    }
                    catch (ExpiredCodeVerificationException e) {
                        TrayNotification tray = new TrayNotification("\u06a9\u062f \u0645\u0646\u0642\u0636\u06cc", e.getMessage(), Notifications.INFORMATION);
                        tray.showAndDismiss();
                    }
                    catch (UserNotFoundException e) {
                        TrayNotification tray = new TrayNotification("\u0639\u062f\u0645 \u062d\u0633\u0627\u0628 \u06a9\u0627\u0631\u0628\u0631\u06cc", e.getMessage(), Notifications.NOTICE);
                        tray.showAndDismiss();
                    }
                    catch (GeneralException e) {
                        this.exceptionHandling.generalExceptionHandling(e);
                    }
                } else {
                    System.out.println("not valid password");
                    TrayNotification tray = new TrayNotification("", "\u0631\u0645\u0632 \u0639\u0628\u0648\u0631 \u0628\u0627\u06cc\u062f \u0628\u06cc\u0646 8 \u0648 20 \u06a9\u0627\u0631\u0627\u06a9\u062a\u0631 \u0648 \u0634\u0627\u0645\u0644 \u062d\u0631\u0648\u0641 \u06a9\u0648\u0686\u06a9 \u0648 \u0628\u0632\u0631\u06af \u0644\u0627\u062a\u06cc\u0646 \u0648 \u0647\u0645\u0686\u0646\u06cc\u0646 \u062d\u062f\u0627\u0642\u0644 \u06cc\u06a9 \u0639\u062f\u062f \u0628\u0627\u0634\u062f.", 4000, Notifications.INFORMATION);
                    tray.showAndDismiss();
                }
            } else if (Utilities.validatePassword(password)) {
                try {
                    HashMap<String, String> info = this.doActions.emailForgetSetPassword(this.email, password);
                    TrayNotification tray = new TrayNotification("\u0645\u0648\u0641\u0642\u06cc\u062a", "\u0631\u0645\u0632 \u0639\u0628\u0648\u0631 \u0628\u0627 \u0645\u0648\u0641\u0642\u06cc\u062a \u062a\u063a\u06cc\u06cc\u0631 \u06a9\u0631\u062f.", Notifications.SUCCESS);
                    tray.showAndDismiss();
                    this.close();
                }
                catch (ServerException e) {
                    this.exceptionHandling.serverExceptionHandling(e);
                }
                catch (ConnectionException e) {
                    this.exceptionHandling.connectionExceptionHandling(e);
                }
                catch (ExpiredCodeVerificationException e) {
                    TrayNotification tray = new TrayNotification("\u06a9\u062f \u0645\u0646\u0642\u0636\u06cc", e.getMessage(), Notifications.INFORMATION);
                    tray.showAndDismiss();
                }
                catch (UserNotFoundException e) {
                    TrayNotification tray = new TrayNotification("\u0639\u062f\u0645 \u062d\u0633\u0627\u0628 \u06a9\u0627\u0631\u0628\u0631\u06cc", e.getMessage(), Notifications.NOTICE);
                    tray.showAndDismiss();
                }
                catch (GeneralException e) {
                    this.exceptionHandling.generalExceptionHandling(e);
                }
            } else {
                System.out.println("not valid password");
                TrayNotification tray = new TrayNotification("", "\u0631\u0645\u0632 \u0639\u0628\u0648\u0631 \u0628\u0627\u06cc\u062f \u0628\u06cc\u0646 8 \u0648 20 \u06a9\u0627\u0631\u0627\u06a9\u062a\u0631 \u0648 \u0634\u0627\u0645\u0644 \u062d\u0631\u0648\u0641 \u06a9\u0648\u0686\u06a9 \u0648 \u0628\u0632\u0631\u06af \u0644\u0627\u062a\u06cc\u0646 \u0648 \u0647\u0645\u0686\u0646\u06cc\u0646 \u062d\u062f\u0627\u0642\u0644 \u06cc\u06a9 \u0639\u062f\u062f \u0628\u0627\u0634\u062f.", 4000, Notifications.INFORMATION);
                tray.showAndDismiss();
            }
        }
    }

    @FXML
    void previousClick(javafx.event.ActionEvent event) {
        if (this.state == ForgetRegisterState.STATE1) {
            this.close();
        }
        if (this.state == ForgetRegisterState.STATE2) {
            this.close();
        }
        if (this.state == ForgetRegisterState.STATE3) {
            this.close();
        }
    }

    private void goToState1() {
        this.next.setText("\u062f\u0631\u06cc\u0627\u0641\u062a \u06a9\u062f");
        this.timerImage.setVisible(false);
        this.timerLabel.setVisible(false);
        this.state = ForgetRegisterState.STATE1;
        if (this.isMobile) {
            this.phone_code_name.setText(this.phoneNumber);
        } else {
            this.phone_code_name.setText(this.email);
        }
        this.phone_code_name.setDisable(true);
        this.previous.setText("\u0627\u0646\u0635\u0631\u0627\u0641");
        this.invalidFormatLabel.setText("\u0641\u0631\u0645\u062a \u0627\u06cc\u0645\u06cc\u0644 \u06cc\u0627 \u0634\u0645\u0627\u0631\u0647 \u062a\u0644\u0641\u0646 \u0648\u0627\u0631\u062f \u0634\u062f\u0647 \u0635\u062d\u06cc\u062d \u0646\u0645\u06cc\u200c\u0628\u0627\u0634\u062f.");
        this.phone_code_name.setPromptText("\u0627\u06cc\u0645\u06cc\u0644/\u0634\u0645\u0627\u0631\u0647 \u062a\u0644\u0641\u0646");
    }

    private void goToState2() {
        this.startTimer();
        this.next.setText("\u0645\u0631\u062d\u0644\u0647 \u0628\u0639\u062f");
        this.timerImage.setVisible(true);
        this.timerLabel.setVisible(true);
        this.phone_code_name.setDisable(false);
        this.phone_code_name.clear();
        this.state = ForgetRegisterState.STATE2;
        this.previous.setText("\u0627\u0646\u0635\u0631\u0627\u0641");
        this.invalidFormatLabel.setText("\u06a9\u062f \u062a\u0627\u06cc\u06cc\u062f \u0627\u0631\u0633\u0627\u0644 \u0634\u062f\u0647 \u0631\u0627 \u0648\u0627\u0631\u062f \u0646\u0645\u0627\u06cc\u06cc\u062f.");
        this.showFadeLabel();
        this.phone_code_name.setPromptText("\u06a9\u062f \u062a\u0627\u06cc\u06cc\u062f");
    }

    private void goToState3() {
        this.next.setText("\u062a\u063a\u06cc\u06cc\u0631 \u0631\u0645\u0632");
        this.state = ForgetRegisterState.STATE3;
        this.phone_code_name.clear();
        this.phone_code_name.setPromptText("\u0631\u0645\u0632 \u0639\u0628\u0648\u0631");
        this.invalidFormatLabel.setText("");
    }

    private void close() {
        this.rootPane.getChildren().remove(this.rootPane.getChildren().size() - 1);
        this.rootPane.getChildren().remove(this.rootPane.getChildren().size() - 1);
    }

    private void showFadeLabel() {
        this.invalidFormatLabel.setVisible(true);
        this.fadeTransition.playFromStart();
    }

    private void startTimer() {
        this.timer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EditPasswordController.this.duration > 0) {
                    EditPasswordController.this.duration = EditPasswordController.this.duration - 1;
                    String time = EditPasswordController.this.getTime(EditPasswordController.this.duration);
                    EditPasswordController.this.setTime(time);
                }
            }
        });
        this.timer.start();
    }

    private String getTime(float time) {
        Object res = "";
        int min = 0;
        int second = 0;
        min = (int)(time / 60.0f);
        second = (int)(time %= 60.0f) % 60;
        res = (String)res + min;
        res = second < 10 ? (String)res + ":0" + second : (String)res + ":" + second;
        return res;
    }

    private void setTime(final String time) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                EditPasswordController.this.timerLabel.setText(time);
            }
        });
    }
}

