/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.controller;

import io.sentry.Sentry;
import ir.deepmine.dictation.Main;
import ir.deepmine.dictation.controller.RecordButtonController;
import ir.deepmine.dictation.controller.ResizeHelper;
import ir.deepmine.dictation.controller.SettingFormController;
import ir.deepmine.dictation.database.SpeechModel;
import ir.deepmine.dictation.exceptions.ConnectionException;
import ir.deepmine.dictation.exceptions.ExceptionHandling;
import ir.deepmine.dictation.exceptions.GeneralException;
import ir.deepmine.dictation.exceptions.InvalidTokenException;
import ir.deepmine.dictation.exceptions.NotExistException;
import ir.deepmine.dictation.exceptions.ServerException;
import ir.deepmine.dictation.ui.HelpForm;
import ir.deepmine.dictation.ui.TitleBar;
import ir.deepmine.dictation.ui.notification.Notifications;
import ir.deepmine.dictation.ui.notification.TrayNotification;
import ir.deepmine.dictation.utils.Settings;
import ir.deepmine.dictation.utils.UserInfo;
import ir.deepmine.dictation.utils.Utilities;
import java.awt.Point;
import java.io.IOException;
import java.util.List;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javax.swing.JFrame;

public class ToolbarWithSettingController {
    public static boolean isInToolBar;
    private final Settings settings = Settings.getInstance();
    @FXML
    private Button settingButton;
    @FXML
    private Button toolsButton;
    @FXML
    private AnchorPane root;
    @FXML
    private AnchorPane mainAnchorPane;
    @FXML
    private AnchorPane settingPane;
    @FXML
    private AnchorPane toolsPane;
    @FXML
    private AnchorPane recordPane;
    private VBox settingForm;
    private double anchorX;
    private double anchorY;
    private Stage stage;

    public void initialize() {
        this.root.getChildren().remove((Object)this.settingPane);
        this.root.getChildren().remove((Object)this.toolsPane);
        this.root.setStyle("-fx-background-radius: 20 100 100 76;-fx-background-color:#424242");
        this.settings.setProperty("app_mode.mode", "toolbar");
        this.settingPane.setVisible(false);
        this.toolsPane.setVisible(false);
        List<SpeechModel> speechModelList = SpeechModel.getAll();
        System.out.println("toolbar form");
        FXMLLoader fxmlLoader = new FXMLLoader();
        fxmlLoader.setLocation(Main.class.getResource("/fxml/recordButton.fxml"));
        RecordButtonController controller = new RecordButtonController();
        fxmlLoader.setController((Object)controller);
        try {
            fxmlLoader.load();
        }
        catch (IOException e) {
            Sentry.captureException((Throwable)e);
            e.printStackTrace();
        }
        Parent recordBtn = (Parent)fxmlLoader.getRoot();
        this.recordPane.getChildren().add((Object)recordBtn);
        FXMLLoader settingLoader = new FXMLLoader();
        settingLoader.setLocation(Main.class.getResource("/fxml/setting-form.fxml"));
        SettingFormController settingsController = new SettingFormController(this.root, "toolbar");
        settingLoader.setController((Object)settingsController);
        try {
            settingLoader.load();
        }
        catch (IOException e) {
            Sentry.captureException((Throwable)e);
            e.printStackTrace();
        }
        this.settingForm = (VBox)settingLoader.getRoot();
        this.settingPane.getChildren().add((Object)this.settingForm);
        this.settingForm.setPrefWidth(260.0);
        isInToolBar = true;
        this.stage = new Stage();
        this.stage.initStyle(StageStyle.TRANSPARENT);
        this.stage.getIcons().add((Object)Utilities.icon);
    }

    @FXML
    void helpImageViewClicked() {
        HelpForm.getInstance().setVisible(true);
    }

    @FXML
    void maximizeImageViewClicked() {
        if (Utilities.startWithToolbar) {
            Utilities.startWithToolbar = false;
            System.out.println("start with toolbar");
            try {
                UserInfo.getInstance().initializeBasic();
            }
            catch (ConnectionException | GeneralException | InvalidTokenException | NotExistException e) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        TrayNotification tray = new TrayNotification("\u062e\u0637\u0627 \u062f\u0631 \u0639\u0645\u0644\u06cc\u0627\u062a", "\u0628\u0627\u0632\u0646\u0634\u0627\u0646\u06cc \u0627\u0637\u0644\u0627\u0639\u0627\u062a \u0627\u0646\u062c\u0627\u0645 \u0646\u0634\u062f.", Notifications.NOTICE);
                        tray.showAndDismiss();
                        Sentry.captureException((Throwable)e);
                    }
                });
            }
            catch (ServerException e) {
                ExceptionHandling.getInstance().serverExceptionHandling(e);
            }
        }
        if (this.stage.isShowing()) {
            this.stage.close();
        }
        TitleBar.frame.setVisible(false);
        Platform.runLater(() -> {
            System.setProperty("prism.lcdtext", "false");
            Stage stage = new Stage();
            stage.getIcons().add((Object)Utilities.icon);
            stage.initStyle(StageStyle.UNDECORATED);
            FXMLLoader fxmlLoader = new FXMLLoader();
            fxmlLoader.setLocation(Main.class.getResource("/fxml/main-page.fxml"));
            try {
                fxmlLoader.load();
            }
            catch (IOException e) {
                Sentry.captureException((Throwable)e);
                e.printStackTrace();
            }
            Parent root = (Parent)fxmlLoader.getRoot();
            Scene scene = new Scene(root);
            stage.setScene(scene);
            stage.setResizable(true);
            ResizeHelper.addResizeListener(stage, 960.0, 564.0, Double.MAX_VALUE, Double.MAX_VALUE);
            stage.show();
        });
    }

    @FXML
    void minimizeImageViewClicked() {
        TitleBar.frame.setVisible(false);
    }

    @FXML
    void mainAnchorPaneMousePressed(MouseEvent event) {
        if (event.isPrimaryButtonDown()) {
            this.anchorX = event.getSceneX();
            this.anchorY = event.getSceneY();
        }
    }

    @FXML
    void mainAnchorPaneMouseDragged(MouseEvent event) {
        if (event.isPrimaryButtonDown()) {
            JFrame frame = TitleBar.frame;
            Point point = frame.getLocation();
            frame.setLocation(point.x + (int)(event.getSceneX() - this.anchorX), point.y + (int)(event.getSceneY() - this.anchorY));
        }
    }

    @FXML
    void profileButtonPressed() {
        System.setProperty("prism.lcdtext", "false");
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                FXMLLoader fxmlLoader = new FXMLLoader();
                fxmlLoader.setLocation(Main.class.getResource("/fxml/profile.fxml"));
                try {
                    fxmlLoader.load();
                }
                catch (IOException e) {
                    Sentry.captureException((Throwable)e);
                    e.printStackTrace();
                }
                Parent root = (Parent)fxmlLoader.getRoot();
                Scene scene = new Scene(root);
                scene.setFill((Paint)Color.TRANSPARENT);
                ToolbarWithSettingController.this.stage.setScene(scene);
                ToolbarWithSettingController.this.stage.setResizable(true);
                ResizeHelper.addResizeListener(ToolbarWithSettingController.this.stage, 600.0, 492.0, Double.MAX_VALUE, Double.MAX_VALUE);
                ToolbarWithSettingController.this.stage.show();
            }
        });
    }

    @FXML
    void settingsButtonPressed() {
        if (this.settingPane.isVisible()) {
            TitleBar.frame.setSize(260, 100);
            this.root.getChildren().remove((Object)this.settingPane);
            this.root.getChildren().remove((Object)this.toolsPane);
            this.mainAnchorPane.setStyle("-fx-background-radius: 20 100 100 76;-fx-background-color: #424242;");
            this.root.setStyle("-fx-background-radius: 20 100 100 76;-fx-background-color:#424242");
            this.settingButton.setStyle(null);
            this.toolsButton.setStyle(null);
            this.settingPane.setVisible(false);
            this.toolsPane.setVisible(false);
        } else {
            this.settingForm.setStyle("-fx-background-radius: 0 0 10 10;-fx-font-family : IranSans;-fx-font-size: 14px");
            TitleBar.frame.setSize(260, (int)(this.mainAnchorPane.getHeight() + 424.0));
            this.root.getChildren().remove((Object)this.toolsPane);
            this.root.getChildren().add((Object)this.settingPane);
            this.mainAnchorPane.setStyle("-fx-background-radius: 10 50 0 0;-fx-background-color: #424242;");
            this.root.setStyle("-fx-background-radius: 10 50 8 8;-fx-background-color:#424242");
            this.settingButton.setStyle("-fx-background-color:#2f2f2f");
            this.toolsButton.setStyle(null);
            this.toolsPane.setVisible(false);
            this.settingPane.setVisible(true);
        }
    }

    @FXML
    void toolsButtonPressed() {
        if (this.toolsPane.isVisible()) {
            TitleBar.frame.setSize(260, 100);
            this.root.getChildren().remove((Object)this.settingPane);
            this.root.getChildren().remove((Object)this.toolsPane);
            this.mainAnchorPane.setStyle("-fx-background-radius: 20 100 100 76;-fx-background-color: #424242;");
            this.root.setStyle("-fx-background-radius: 20 100 100 76;-fx-background-color:#424242");
            this.settingButton.setStyle(null);
            this.toolsButton.setStyle(null);
            this.settingPane.setVisible(false);
            this.toolsPane.setVisible(false);
        } else {
            TitleBar.frame.setSize(260, 158);
            this.root.getChildren().add((Object)this.toolsPane);
            this.root.getChildren().remove((Object)this.settingPane);
            this.mainAnchorPane.setStyle("-fx-background-radius: 10 50 0 0;-fx-background-color: #424242;");
            this.root.setStyle("-fx-background-radius: 10 50 8 8;-fx-background-color:#424242");
            this.toolsButton.setStyle("-fx-background-color:#2f2f2f");
            this.settingButton.setStyle(null);
            this.toolsPane.setVisible(true);
            this.settingPane.setVisible(false);
        }
    }

    @FXML
    void punctuationShow(ActionEvent event) {
        System.setProperty("prism.lcdtext", "false");
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                FXMLLoader fxmlLoader = new FXMLLoader();
                fxmlLoader.setLocation(Main.class.getResource("/fxml/punctuations.fxml"));
                try {
                    fxmlLoader.load();
                }
                catch (IOException e) {
                    Sentry.captureException((Throwable)e);
                    e.printStackTrace();
                }
                Parent root = (Parent)fxmlLoader.getRoot();
                Scene scene = new Scene(root);
                ToolbarWithSettingController.this.stage.getIcons().add((Object)Utilities.icon);
                ToolbarWithSettingController.this.stage.setScene(scene);
                ToolbarWithSettingController.this.stage.setResizable(true);
                scene.setFill((Paint)Color.TRANSPARENT);
                ResizeHelper.addResizeListener(ToolbarWithSettingController.this.stage, 600.0, 492.0, Double.MAX_VALUE, Double.MAX_VALUE);
                ToolbarWithSettingController.this.stage.show();
            }
        });
    }
}

