/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.controller;

import io.sentry.Sentry;
import ir.deepmine.dictation.Main;
import ir.deepmine.dictation.controller.SettingFormController;
import ir.deepmine.dictation.ui.SettingsForm;
import java.awt.Point;
import java.io.IOException;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.VBox;

public class SettingsController {
    @FXML
    public AnchorPane mainAnchorPane;
    @FXML
    private AnchorPane settingPane;
    private double anchorX;
    private double anchorY;
    public static boolean inSettingForm;

    @FXML
    void close(ActionEvent event) {
        inSettingForm = false;
        SettingsForm.getInstance().setVisible(false);
    }

    @FXML
    void mainAnchorPaneMousePressed(MouseEvent event) {
        if (event.isPrimaryButtonDown()) {
            this.anchorX = event.getSceneX();
            this.anchorY = event.getSceneY();
        }
    }

    @FXML
    void mainAnchorPaneMouseDragged(MouseEvent event) {
        if (event.isPrimaryButtonDown()) {
            Point point = SettingsForm.getInstance().getLocation();
            SettingsForm.getInstance().setLocation(point.x + (int)(event.getSceneX() - this.anchorX), point.y + (int)(event.getSceneY() - this.anchorY));
        }
    }

    @FXML
    public void initialize() {
        FXMLLoader fxmlLoader = new FXMLLoader();
        fxmlLoader.setLocation(Main.class.getResource("/fxml/setting-form.fxml"));
        SettingFormController controller = new SettingFormController(this.mainAnchorPane, "normal");
        fxmlLoader.setController((Object)controller);
        try {
            fxmlLoader.load();
        }
        catch (IOException e) {
            Sentry.captureException((Throwable)e);
            e.printStackTrace();
        }
        VBox settingForm = (VBox)fxmlLoader.getRoot();
        this.settingPane.getChildren().add((Object)settingForm);
        inSettingForm = true;
        settingForm.setPrefWidth(472.0);
    }
}

