/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.controller;

import com.jfoenix.controls.JFXCheckBox;
import io.sentry.Sentry;
import ir.deepmine.dictation.Main;
import ir.deepmine.dictation.controller.DateSeparatorController;
import ir.deepmine.dictation.controller.LanguageModelController;
import ir.deepmine.dictation.controller.LanguageSpeechController;
import ir.deepmine.dictation.database.SpeechModel;
import ir.deepmine.dictation.utils.Settings;
import java.io.IOException;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.layout.AnchorPane;

public class SettingFormController {
    @FXML
    private JFXCheckBox punctuationCheckBox;
    @FXML
    private JFXCheckBox numbersCheckBox;
    @FXML
    private JFXCheckBox dateTimeCheckBox;
    @FXML
    private JFXCheckBox phoneNumbersCheckBox;
    @FXML
    private Label langLabel;
    @FXML
    private Label modelLabel;
    @FXML
    private Label dateSeparatorLabel;
    @FXML
    private Spinner<Integer> idleTimeSpinner;
    @FXML
    private JFXCheckBox typeInWordApp;
    public static Label langLabelStatic;
    public static Label modelLabelStatic;
    public static Label dateSeparatorStatic;
    String mode;
    Settings settings = Settings.getInstance();
    AnchorPane mainAnchorPane;

    public SettingFormController(AnchorPane mainAnchorPane, String mode) {
        this.mainAnchorPane = mainAnchorPane;
        this.mode = mode;
    }

    public void initialize() {
        langLabelStatic = new Label();
        modelLabelStatic = new Label();
        dateSeparatorStatic = new Label();
        this.punctuationCheckBox.selectedProperty().addListener((observable, oldValue, newValue) -> this.settings.setProperty("process.apply_punctuation", newValue.toString()));
        this.numbersCheckBox.selectedProperty().addListener((observable, oldValue, newValue) -> this.settings.setProperty("process.apply_numbers", newValue.toString()));
        this.dateTimeCheckBox.selectedProperty().addListener((observable, oldValue, newValue) -> this.settings.setProperty("process.apply_datetime", newValue.toString()));
        this.phoneNumbersCheckBox.selectedProperty().addListener((observable, oldValue, newValue) -> this.settings.setProperty("process.apply_phone_numbers", newValue.toString()));
        this.idleTimeSpinner.valueProperty().addListener((observable, oldValue, newValue) -> this.settings.setProperty("recorder.idle_time", newValue.toString()));
        this.typeInWordApp.selectedProperty().addListener((observable, oldValue, newValue) -> this.settings.setProperty("process.type_to_word", newValue.toString()));
        this.punctuationCheckBox.setSelected(this.settings.getBooleanProperty("process.apply_punctuation"));
        this.numbersCheckBox.setSelected(this.settings.getBooleanProperty("process.apply_numbers"));
        this.dateTimeCheckBox.setSelected(this.settings.getBooleanProperty("process.apply_datetime"));
        this.phoneNumbersCheckBox.setSelected(this.settings.getBooleanProperty("process.apply_phone_numbers"));
        this.idleTimeSpinner.getValueFactory().setValue((Object)this.settings.getIntegerProperty("recorder.idle_time"));
        this.typeInWordApp.setSelected(this.settings.getBooleanProperty("process.type_to_word"));
        if (!this.mode.equals("normal")) {
            this.idleTimeSpinner.setEditable(false);
        }
        String lang = this.settings.getStringProperty("grpc.language_code");
        String model = this.settings.getStringProperty("grpc.model_name");
        this.modelLabel.textProperty().bind((ObservableValue)modelLabelStatic.textProperty());
        this.langLabel.textProperty().bind((ObservableValue)langLabelStatic.textProperty());
        this.dateSeparatorLabel.textProperty().bind((ObservableValue)dateSeparatorStatic.textProperty());
        List<SpeechModel> speechModelList = SpeechModel.getAll();
        for (SpeechModel speechModel : speechModelList) {
            if (speechModel.getLanguage().equals(lang)) {
                langLabelStatic.setText(speechModel.getLanguage_fa());
            }
            if (!speechModel.getName().equals(model)) continue;
            modelLabelStatic.setText(speechModel.getLabel());
        }
        dateSeparatorStatic.setText(this.settings.getStringProperty("process.date_separator"));
    }

    @FXML
    void langClick(ActionEvent event) {
        FXMLLoader fxmlLoader = new FXMLLoader();
        fxmlLoader.setLocation(Main.class.getResource("/fxml/language-speech.fxml"));
        LanguageSpeechController languageSpeechController = new LanguageSpeechController(this.mainAnchorPane);
        fxmlLoader.setController((Object)languageSpeechController);
        try {
            fxmlLoader.load();
        }
        catch (IOException e) {
            Sentry.captureException((Throwable)e);
            e.printStackTrace();
        }
        AnchorPane anchorPane = (AnchorPane)fxmlLoader.getRoot();
        AnchorPane blackAnchor = new AnchorPane();
        System.out.println("height and width: " + this.mainAnchorPane.getHeight() + " , " + this.mainAnchorPane.getWidth());
        blackAnchor.setPrefSize(this.mainAnchorPane.getWidth(), this.mainAnchorPane.getHeight());
        blackAnchor.setStyle("-fx-background-color: rgb(0,0,0,0.8);-fx-background-radius: 10px;");
        this.mainAnchorPane.getChildren().add((Object)blackAnchor);
        if (this.mode.equals("normal")) {
            anchorPane.setLayoutX(172.0);
        } else {
            anchorPane.setLayoutX(3.0);
        }
        anchorPane.setLayoutY(200.0);
        this.mainAnchorPane.getChildren().add((Object)anchorPane);
    }

    @FXML
    void modelClick(ActionEvent event) {
        FXMLLoader fxmlLoader = new FXMLLoader();
        fxmlLoader.setLocation(Main.class.getResource("/fxml/language-model.fxml"));
        LanguageModelController languageModelController = new LanguageModelController(this.mainAnchorPane);
        fxmlLoader.setController((Object)languageModelController);
        try {
            fxmlLoader.load();
        }
        catch (IOException e) {
            Sentry.captureException((Throwable)e);
            e.printStackTrace();
        }
        AnchorPane anchorPane = (AnchorPane)fxmlLoader.getRoot();
        AnchorPane blackAnchor = new AnchorPane();
        blackAnchor.setPrefSize(this.mainAnchorPane.getWidth(), this.mainAnchorPane.getHeight());
        blackAnchor.setStyle("-fx-background-color: rgb(0,0,0,0.8);-fx-background-radius: 10px;");
        this.mainAnchorPane.getChildren().add((Object)blackAnchor);
        if (this.mode.equals("normal")) {
            anchorPane.setLayoutX(172.0);
        } else {
            anchorPane.setLayoutX(3.0);
        }
        anchorPane.setLayoutY(200.0);
        this.mainAnchorPane.getChildren().add((Object)anchorPane);
    }

    @FXML
    void dateSeparatorClick(ActionEvent event) {
        FXMLLoader fxmlLoader = new FXMLLoader();
        fxmlLoader.setLocation(Main.class.getResource("/fxml/date-separator.fxml"));
        DateSeparatorController dateSeparatorController = new DateSeparatorController(this.mainAnchorPane);
        fxmlLoader.setController((Object)dateSeparatorController);
        try {
            fxmlLoader.load();
        }
        catch (IOException e) {
            Sentry.captureException((Throwable)e);
            e.printStackTrace();
        }
        AnchorPane anchorPane = (AnchorPane)fxmlLoader.getRoot();
        AnchorPane blackAnchor = new AnchorPane();
        blackAnchor.setPrefSize(this.mainAnchorPane.getWidth(), this.mainAnchorPane.getHeight());
        blackAnchor.setStyle("-fx-background-color: rgb(0,0,0,0.8);-fx-background-radius: 10px;");
        this.mainAnchorPane.getChildren().add((Object)blackAnchor);
        if (this.mode.equals("normal")) {
            anchorPane.setLayoutX(172.0);
        } else {
            anchorPane.setLayoutX(3.0);
        }
        anchorPane.setLayoutY(200.0);
        this.mainAnchorPane.getChildren().add((Object)anchorPane);
    }
}

