/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.controller;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXCheckBox;
import com.jfoenix.controls.JFXTextField;
import io.sentry.Sentry;
import ir.deepmine.dictation.Main;
import ir.deepmine.dictation.controller.PrivacyAndConditionController;
import ir.deepmine.dictation.controller.ResizeHelper;
import ir.deepmine.dictation.controller.enums.RegisterState;
import ir.deepmine.dictation.controller.enums.WebViewState;
import ir.deepmine.dictation.database.UserData;
import ir.deepmine.dictation.exceptions.AlreadyExistException;
import ir.deepmine.dictation.exceptions.ConnectionException;
import ir.deepmine.dictation.exceptions.ExceptionHandling;
import ir.deepmine.dictation.exceptions.ExpiredCodeVerificationException;
import ir.deepmine.dictation.exceptions.GeneralException;
import ir.deepmine.dictation.exceptions.InvalidCodeVerificationException;
import ir.deepmine.dictation.exceptions.InvalidFormatException;
import ir.deepmine.dictation.exceptions.ServerException;
import ir.deepmine.dictation.exceptions.SuccessException;
import ir.deepmine.dictation.exceptions.TooManyRequestException;
import ir.deepmine.dictation.ui.TitleBar;
import ir.deepmine.dictation.ui.notification.Notifications;
import ir.deepmine.dictation.ui.notification.TrayNotification;
import ir.deepmine.dictation.utils.DoActions;
import ir.deepmine.dictation.utils.Utilities;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.animation.FadeTransition;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.util.Duration;
import javax.swing.Timer;

public class RegisterController {
    private DoActions doActions;
    private ExceptionHandling exceptionHandling;
    private boolean isMobile;
    private String phoneNumber;
    private String email;
    private String password;
    private RegisterState registerState;
    private Timer timer;
    private int duration;
    private WebViewState webViewState;
    @FXML
    private BorderPane pane;
    @FXML
    private AnchorPane rootAnchor;
    @FXML
    private JFXButton next;
    @FXML
    private JFXCheckBox confirmPrivacy;
    @FXML
    private JFXTextField phone_code_name;
    @FXML
    private Label invalidFormatLabel;
    @FXML
    private JFXTextField familyNameField;
    @FXML
    private JFXTextField passwordField;
    @FXML
    private Label timerLabel;
    @FXML
    private JFXButton previous;
    @FXML
    private ImageView timerImage;
    @FXML
    private Label label1;
    @FXML
    private Label label2;
    @FXML
    private Label label3;
    @FXML
    private Label label4;
    @FXML
    private Label passwordInfo;
    private FadeTransition fadeTransition;

    public void initialize() {
        this.email = "";
        this.phoneNumber = "";
        this.duration = 120;
        this.registerState = RegisterState.STATE1;
        this.doActions = DoActions.getInstance();
        this.exceptionHandling = ExceptionHandling.getInstance();
        TitleBar titleBar = TitleBar.getInstance("normal");
        titleBar.visibleLaunch(false);
        this.pane.setTop((Node)titleBar);
        this.fadeTransition = new FadeTransition(Duration.millis((double)7000.0), (Node)this.invalidFormatLabel);
        this.fadeTransition.setFromValue(1.0);
        this.fadeTransition.setToValue(0.0);
    }

    @FXML
    void enterPane(MouseEvent event) {
    }

    @FXML
    void nextClick(javafx.event.ActionEvent event) {
        System.out.println("state: " + this.registerState);
        if (this.registerState == RegisterState.STATE1) {
            String phoneOrEmail = this.phone_code_name.getText();
            this.isMobile = this.isPhoneNumber(phoneOrEmail);
            System.out.println("isMobile: " + this.isMobile);
            if (this.isMobile) {
                if (!this.phoneNumber.equals(phoneOrEmail)) {
                    this.duration = 120;
                    if (this.timer != null && this.timer.isRunning()) {
                        this.timer.stop();
                    }
                }
                this.phoneNumber = phoneOrEmail;
                if (Utilities.validatePhoneNumber(this.phoneNumber)) {
                    try {
                        this.doActions.phoneRegister(this.phoneNumber);
                    }
                    catch (InvalidFormatException e) {
                        this.showFadeLabel();
                    }
                    catch (AlreadyExistException e) {
                        TrayNotification tray = new TrayNotification("\u0648\u062c\u0648\u062f \u062d\u0633\u0627\u0628 \u06a9\u0627\u0631\u0628\u0631\u06cc", e.getMessage(), Notifications.INFORMATION);
                        tray.showAndDismiss();
                    }
                    catch (ServerException e) {
                        this.exceptionHandling.serverExceptionHandling(e);
                    }
                    catch (ConnectionException e) {
                        this.exceptionHandling.connectionExceptionHandling(e);
                    }
                    catch (SuccessException e) {
                        this.goToState2();
                    }
                    catch (TooManyRequestException e) {
                        TrayNotification tray = new TrayNotification("\u06a9\u062f \u062a\u0627\u06cc\u06cc\u062f \u0627\u0631\u0633\u0627\u0644 \u0634\u062f\u0647 \u0627\u0633\u062a.", "", Notifications.NOTICE);
                        tray.showAndDismiss();
                        this.goToState2();
                    }
                    catch (GeneralException e) {
                        this.exceptionHandling.generalExceptionHandling(e);
                    }
                } else {
                    this.showFadeLabel();
                }
            } else {
                if (!this.email.equals(phoneOrEmail)) {
                    this.duration = 120;
                    if (this.timer != null && this.timer.isRunning()) {
                        this.timer.stop();
                    }
                }
                this.email = phoneOrEmail;
                System.out.println("email valid: " + Utilities.validateEmail(this.email));
                if (Utilities.validateEmail(this.email)) {
                    try {
                        this.doActions.emailRegister(this.email);
                    }
                    catch (InvalidFormatException e) {
                        this.showFadeLabel();
                    }
                    catch (AlreadyExistException e) {
                        TrayNotification tray = new TrayNotification("\u0648\u062c\u0648\u062f \u062d\u0633\u0627\u0628 \u06a9\u0627\u0631\u0628\u0631\u06cc", e.getMessage(), Notifications.INFORMATION);
                        tray.showAndDismiss();
                    }
                    catch (ServerException e) {
                        this.exceptionHandling.serverExceptionHandling(e);
                    }
                    catch (ConnectionException e) {
                        this.exceptionHandling.connectionExceptionHandling(e);
                    }
                    catch (SuccessException e) {
                        this.goToState2();
                    }
                    catch (TooManyRequestException e) {
                        TrayNotification tray = new TrayNotification("\u06a9\u062f \u062a\u0627\u06cc\u06cc\u062f \u0627\u0631\u0633\u0627\u0644 \u0634\u062f\u0647 \u0627\u0633\u062a.", "", Notifications.NOTICE);
                        tray.showAndDismiss();
                        this.goToState2();
                    }
                } else {
                    this.showFadeLabel();
                }
            }
        } else if (this.registerState == RegisterState.STATE2) {
            String code = this.phone_code_name.getText();
            System.out.println("code: " + code);
            if (this.isMobile) {
                try {
                    this.doActions.phoneCodeVerification(this.phoneNumber, code);
                }
                catch (ServerException e) {
                    this.exceptionHandling.serverExceptionHandling(e);
                }
                catch (ConnectionException e) {
                    this.exceptionHandling.connectionExceptionHandling(e);
                }
                catch (InvalidFormatException e) {
                    System.out.println("format error");
                }
                catch (ExpiredCodeVerificationException e) {
                    TrayNotification tray = new TrayNotification("\u06a9\u062f \u0645\u0646\u0642\u0636\u06cc", e.getMessage(), Notifications.INFORMATION);
                    tray.showAndDismiss();
                }
                catch (SuccessException e) {
                    this.goToState3();
                }
                catch (InvalidCodeVerificationException e) {
                    TrayNotification tray = new TrayNotification("\u06a9\u062f \u0646\u0627\u0645\u0639\u062a\u0628\u0631", e.getMessage(), Notifications.WARNING);
                    tray.showAndDismiss();
                }
                catch (GeneralException e) {
                    this.exceptionHandling.generalExceptionHandling(e);
                }
            } else {
                try {
                    this.doActions.emailCodeVerification(this.email, code);
                }
                catch (ServerException e) {
                    this.exceptionHandling.serverExceptionHandling(e);
                }
                catch (ConnectionException e) {
                    this.exceptionHandling.connectionExceptionHandling(e);
                }
                catch (InvalidFormatException e) {
                    System.out.println("format error");
                }
                catch (ExpiredCodeVerificationException e) {
                    TrayNotification tray = new TrayNotification("\u06a9\u062f \u0645\u0646\u0642\u0636\u06cc", e.getMessage(), Notifications.INFORMATION);
                    tray.showAndDismiss();
                }
                catch (SuccessException e) {
                    this.goToState3();
                }
                catch (InvalidCodeVerificationException e) {
                    TrayNotification tray = new TrayNotification("\u06a9\u062f \u0646\u0627\u0645\u0639\u062a\u0628\u0631", e.getMessage(), Notifications.WARNING);
                    tray.showAndDismiss();
                }
                catch (GeneralException e) {
                    this.exceptionHandling.generalExceptionHandling(e);
                }
            }
        } else if (this.registerState == RegisterState.STATE3) {
            if (this.confirmPrivacy.isSelected()) {
                String name = this.phone_code_name.getText();
                String family = this.familyNameField.getText();
                String password = this.passwordField.getText();
                System.out.println("name: " + name);
                System.out.println("family: " + family);
                System.out.println("password: " + password);
                if (Utilities.validatePassword(password)) {
                    System.out.println("valid password");
                    HashMap<Object, Object> info = new HashMap();
                    if (this.isMobile) {
                        try {
                            info = this.doActions.phoneRegistrationSetPassword(name, family, password, this.phoneNumber);
                            TrayNotification tray = new TrayNotification("\u0627\u06cc\u062c\u0627\u062f \u062d\u0633\u0627\u0628 \u06a9\u0627\u0631\u0628\u0631\u06cc", "\u0628\u0647 \u0632\u06cc\u200c\u062a\u0627\u06cc\u067e \u062e\u0648\u0634 \u0622\u0645\u062f\u06cc\u062f.", Notifications.SUCCESS);
                            tray.showAndDismiss();
                            this.goToMainPage();
                        }
                        catch (ServerException e) {
                            this.exceptionHandling.serverExceptionHandling(e);
                        }
                        catch (ConnectionException e) {
                            this.exceptionHandling.connectionExceptionHandling(e);
                        }
                        catch (AlreadyExistException e) {
                            TrayNotification tray = new TrayNotification("\u0648\u062c\u0648\u062f \u062d\u0633\u0627\u0628 \u06a9\u0627\u0631\u0628\u0631\u06cc", e.getMessage(), 3000, Notifications.INFORMATION);
                            tray.showAndDismiss();
                        }
                        catch (ExpiredCodeVerificationException e) {
                            TrayNotification tray = new TrayNotification("\u06a9\u062f \u0645\u0646\u0642\u0636\u06cc", e.getMessage(), Notifications.INFORMATION);
                            tray.showAndDismiss();
                        }
                        catch (GeneralException e) {
                            this.exceptionHandling.generalExceptionHandling(e);
                        }
                    } else {
                        try {
                            info = this.doActions.emailRegistrationSetPassword(name, family, password, this.email);
                            TrayNotification tray = new TrayNotification("\u0627\u06cc\u062c\u0627\u062f \u062d\u0633\u0627\u0628 \u06a9\u0627\u0631\u0628\u0631\u06cc", "\u0628\u0647 \u0632\u06cc\u200c\u062a\u0627\u06cc\u067e \u062e\u0648\u0634 \u0622\u0645\u062f\u06cc\u062f.", Notifications.SUCCESS);
                            tray.showAndDismiss();
                            this.goToMainPage();
                        }
                        catch (ServerException e) {
                            this.exceptionHandling.serverExceptionHandling(e);
                        }
                        catch (ConnectionException e) {
                            this.exceptionHandling.connectionExceptionHandling(e);
                        }
                        catch (AlreadyExistException e) {
                            TrayNotification tray = new TrayNotification("\u0648\u062c\u0648\u062f \u062d\u0633\u0627\u0628 \u06a9\u0627\u0631\u0628\u0631\u06cc", e.getMessage(), 3000, Notifications.INFORMATION);
                            tray.showAndDismiss();
                        }
                        catch (ExpiredCodeVerificationException e) {
                            TrayNotification tray = new TrayNotification("\u0632\u0645\u0627\u0646 \u0645\u0646\u0642\u0636\u06cc", e.getMessage(), Notifications.INFORMATION);
                            tray.showAndDismiss();
                        }
                        catch (GeneralException e) {
                            this.exceptionHandling.generalExceptionHandling(e);
                        }
                    }
                } else {
                    System.out.println("not valid password");
                    TrayNotification tray = new TrayNotification("", "\u0631\u0645\u0632 \u0639\u0628\u0648\u0631 \u0628\u0627\u06cc\u062f \u0628\u06cc\u0646 8 \u0648 20 \u06a9\u0627\u0631\u0627\u06a9\u062a\u0631 \u0648 \u0634\u0627\u0645\u0644 \u062d\u0631\u0648\u0641 \u06a9\u0648\u0686\u06a9 \u0648 \u0628\u0632\u0631\u06af \u0644\u0627\u062a\u06cc\u0646 \u0648 \u0647\u0645\u0686\u0646\u06cc\u0646 \u062d\u062f\u0627\u0642\u0644 \u06cc\u06a9 \u0639\u062f\u062f \u0628\u0627\u0634\u062f.", 4000, Notifications.INFORMATION);
                    tray.showAndDismiss();
                }
            } else {
                TrayNotification tray = new TrayNotification("\u062a\u0648\u0627\u0641\u0642 \u0646\u0627\u0645\u0647 \u0631\u0627 \u0628\u0632\u0646\u06cc\u062f.", "", Notifications.NOTICE);
                tray.showAndDismiss();
            }
        }
    }

    @FXML
    void previousClick(javafx.event.ActionEvent event) {
        if (this.registerState == RegisterState.STATE1) {
            this.goToLogin();
        } else if (this.registerState == RegisterState.STATE2) {
            this.goToState1();
        } else if (this.registerState == RegisterState.STATE3) {
            this.goToState2();
        }
    }

    @FXML
    void ConditionsAndTermsClick(MouseEvent event) {
        this.webViewState = WebViewState.CONDITION_AND_TERM;
        this.openPrivacyConditionPopup();
    }

    @FXML
    void PrivacyAndPolicyClick(MouseEvent event) {
        this.webViewState = WebViewState.PRIVACY_AND_POLICY;
        this.openPrivacyConditionPopup();
    }

    private void openPrivacyConditionPopup() {
        FXMLLoader fxmlLoader = new FXMLLoader();
        fxmlLoader.setLocation(Main.class.getResource("/fxml/privacy-condition.fxml"));
        PrivacyAndConditionController controller = new PrivacyAndConditionController(this.rootAnchor, this.webViewState);
        fxmlLoader.setController((Object)controller);
        try {
            fxmlLoader.load();
        }
        catch (IOException e) {
            Sentry.captureException((Throwable)e);
            e.printStackTrace();
        }
        AnchorPane anchorPane = (AnchorPane)fxmlLoader.getRoot();
        AnchorPane blackAnchor = new AnchorPane();
        blackAnchor.setPrefSize(this.rootAnchor.getWidth(), this.rootAnchor.getHeight());
        blackAnchor.setStyle("-fx-background-color: rgb(0,0,0,0.8)");
        this.rootAnchor.getChildren().add((Object)blackAnchor);
        anchorPane.setLayoutX(this.rootAnchor.getWidth() / 2.0 - 200.0);
        anchorPane.setLayoutY(this.rootAnchor.getHeight() / 2.0 - 240.0);
        this.rootAnchor.getChildren().add((Object)anchorPane);
    }

    private void goToState1() {
        this.next.setText("\u062f\u0631\u06cc\u0627\u0641\u062a \u06a9\u062f");
        this.familyNameField.setVisible(false);
        this.passwordField.setVisible(false);
        this.timerImage.setVisible(false);
        this.timerLabel.setVisible(false);
        this.familyNameField.clear();
        this.passwordField.clear();
        this.registerState = RegisterState.STATE1;
        if (this.isMobile) {
            this.phone_code_name.setText(this.phoneNumber);
        } else {
            this.phone_code_name.setText(this.email);
        }
        this.previous.setText("\u0648\u0627\u0631\u062f \u0634\u0648\u06cc\u062f");
        this.invalidFormatLabel.setText("\u0641\u0631\u0645\u062a \u0627\u06cc\u0645\u06cc\u0644 \u06cc\u0627 \u0634\u0645\u0627\u0631\u0647 \u062a\u0644\u0641\u0646 \u0648\u0627\u0631\u062f \u0634\u062f\u0647 \u0635\u062d\u06cc\u062d \u0646\u0645\u06cc\u200c\u0628\u0627\u0634\u062f.");
        this.phone_code_name.setPromptText("\u0627\u06cc\u0645\u06cc\u0644/\u0634\u0645\u0627\u0631\u0647 \u062a\u0644\u0641\u0646");
    }

    private void goToState2() {
        this.startTimer();
        this.next.setText("\u0645\u0631\u062d\u0644\u0647 \u0628\u0639\u062f");
        this.familyNameField.setVisible(false);
        this.passwordField.setVisible(false);
        this.timerImage.setVisible(true);
        this.timerLabel.setVisible(true);
        this.confirmPrivacy.setVisible(false);
        this.familyNameField.clear();
        this.passwordField.clear();
        this.phone_code_name.clear();
        this.registerState = RegisterState.STATE2;
        this.previous.setText("\u062a\u0635\u062d\u06cc\u062d \u0646\u0627\u0645 \u06a9\u0627\u0631\u0628\u0631\u06cc");
        this.invalidFormatLabel.setText("\u06a9\u062f \u062a\u0627\u06cc\u06cc\u062f \u0627\u0631\u0633\u0627\u0644 \u0634\u062f\u0647 \u0631\u0627 \u0648\u0627\u0631\u062f \u0646\u0645\u0627\u06cc\u06cc\u062f.");
        this.showFadeLabel();
        this.phone_code_name.setPromptText("\u06a9\u062f \u062a\u0627\u06cc\u06cc\u062f");
    }

    private void goToState3() {
        this.duration = 300 - this.duration;
        this.next.setText("\u062b\u0628\u062a \u0646\u0627\u0645");
        this.familyNameField.setVisible(true);
        this.passwordField.setVisible(true);
        this.previous.setVisible(false);
        this.confirmPrivacy.setVisible(true);
        this.label1.setVisible(true);
        this.label2.setVisible(true);
        this.label3.setVisible(true);
        this.label4.setVisible(true);
        this.passwordInfo.setVisible(true);
        AnchorPane.setTopAnchor((Node)this.next, (Double)380.0);
        AnchorPane.setTopAnchor((Node)this.timerLabel, (Double)395.0);
        AnchorPane.setTopAnchor((Node)this.timerImage, (Double)395.0);
        AnchorPane.setTopAnchor((Node)this.phone_code_name, (Double)125.0);
        AnchorPane.setTopAnchor((Node)this.familyNameField, (Double)195.0);
        this.registerState = RegisterState.STATE3;
        this.familyNameField.clear();
        this.passwordField.clear();
        this.phone_code_name.clear();
        this.phone_code_name.setPromptText("\u0646\u0627\u0645");
        this.invalidFormatLabel.setText("");
    }

    private void goToMainPage() {
        UserData userData = UserData.get();
        if (userData == null) {
            userData = new UserData();
        }
        userData.setRefresh(null);
        userData.setAccess(null);
        userData.setUserId(0L);
        if (this.isMobile) {
            userData.setUserName(this.phoneNumber);
        } else {
            userData.setUserName(this.email);
        }
        UserData.put(userData);
        System.setProperty("prism.lcdtext", "false");
        Stage stage = (Stage)this.phone_code_name.getScene().getWindow();
        stage.getIcons().add((Object)Utilities.icon);
        FXMLLoader fxmlLoader = new FXMLLoader();
        fxmlLoader.setLocation(Main.class.getResource("/fxml/main-page.fxml"));
        try {
            fxmlLoader.load();
        }
        catch (IOException e) {
            Sentry.captureException((Throwable)e);
            e.printStackTrace();
        }
        Parent root = (Parent)fxmlLoader.getRoot();
        Scene scene = new Scene(root);
        stage.setScene(scene);
        stage.setResizable(true);
        ResizeHelper.addResizeListener(stage, 960.0, 564.0, Double.MAX_VALUE, Double.MAX_VALUE);
        stage.show();
    }

    private void goToLogin() {
        System.setProperty("prism.lcdtext", "false");
        Stage stage = (Stage)this.phone_code_name.getScene().getWindow();
        stage.getIcons().add((Object)Utilities.icon);
        FXMLLoader fxmlLoader = new FXMLLoader();
        fxmlLoader.setLocation(Main.class.getResource("/fxml/login.fxml"));
        try {
            fxmlLoader.load();
        }
        catch (IOException e) {
            Sentry.captureException((Throwable)e);
            e.printStackTrace();
        }
        Parent root = (Parent)fxmlLoader.getRoot();
        Scene scene = new Scene(root);
        stage.setScene(scene);
        stage.setResizable(true);
        ResizeHelper.addResizeListener(stage, 960.0, 564.0, Double.MAX_VALUE, Double.MAX_VALUE);
        stage.show();
    }

    private void startTimer() {
        this.timer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RegisterController.this.duration > 0) {
                    RegisterController.this.duration = RegisterController.this.duration - 1;
                    String time = RegisterController.this.getTime(RegisterController.this.duration);
                    RegisterController.this.setTime(time);
                }
            }
        });
        this.timer.start();
    }

    private void setTime(final String time) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                RegisterController.this.timerLabel.setText(time);
            }
        });
    }

    private String getTime(float time) {
        Object res = "";
        int min = 0;
        int second = 0;
        min = (int)(time / 60.0f);
        second = (int)(time %= 60.0f) % 60;
        res = (String)res + min;
        res = second < 10 ? (String)res + ":0" + second : (String)res + ":" + second;
        return res;
    }

    private void showFadeLabel() {
        this.invalidFormatLabel.setVisible(true);
        this.fadeTransition.playFromStart();
    }

    private boolean isPhoneNumber(String phone) {
        String regex = "[0-9]+";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(phone);
        return matcher.matches();
    }
}

