/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.controller;

import com.jfoenix.controls.JFXButton;
import io.sentry.Sentry;
import ir.deepmine.dictation.exceptions.ExceptionHandling;
import ir.deepmine.dictation.ui.HTMLEditor.HTMLEditor;
import ir.deepmine.dictation.ui.HTMLEditor.HTMLEditorSkin;
import ir.deepmine.dictation.ui.PartialResultsForm;
import ir.deepmine.dictation.ui.gauge.RingProgressIndicator;
import ir.deepmine.dictation.ui.notification.Notifications;
import ir.deepmine.dictation.ui.notification.TrayNotification;
import ir.deepmine.dictation.utils.AudioRecorder;
import ir.deepmine.dictation.utils.Formatter;
import ir.deepmine.dictation.utils.GrpcClient;
import ir.deepmine.dictation.utils.PunctuationsProcessing;
import ir.deepmine.dictation.utils.Settings;
import ir.deepmine.dictation.utils.UserInfo;
import ir.deepmine.dictation.utils.Utilities;
import java.awt.AWTException;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.util.Duration;
import javax.net.ssl.SSLException;
import javax.sound.sampled.LineUnavailableException;
import javax.swing.Timer;

public class RecordButtonController {
    private static final Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
    private static final PunctuationsProcessing punctuationsProcessing = PunctuationsProcessing.getInstance();
    private static final Settings settings = Settings.getInstance();
    @FXML
    private AnchorPane recordPane;
    @FXML
    private JFXButton recordButton;
    @FXML
    private ImageView recordImg;
    @FXML
    private Label timerLabel;
    private boolean timerWorking = false;
    private long lastRecognizedWordTime = 0L;
    private AudioRecorder recorder;
    private GrpcClient client;
    private AtomicBoolean isRecording = new AtomicBoolean(false);
    private RingProgressIndicator indicator;
    private Robot robot;
    private boolean lastCharacterWasSpace = true;
    private ResultObserver resultObserver;
    private HTMLEditor htmlEditor;
    private long previousTime = UserInfo.previousTime;
    private Timer timer;
    private FileWriter fileWriter;
    private BufferedWriter writer;
    private FileReader fileReader;
    private BufferedReader reader;
    private ExecutorService executorService = Executors.newSingleThreadExecutor();
    private String languageCode = settings.getStringProperty("grpc.language_code");
    private String modelName = settings.getStringProperty("grpc.model_name");
    private boolean editorPage;

    public RecordButtonController(HTMLEditor htmlEditor, AtomicBoolean isRecording) {
        this.isRecording = isRecording;
        this.editorPage = true;
        this.htmlEditor = htmlEditor;
        this.samePartOfConstructors();
    }

    public RecordButtonController() {
        this.editorPage = false;
        this.samePartOfConstructors();
    }

    public void initialize() {
        UserInfo.getInstance().initializePunctuation();
        Task task = new Task(){

            protected Object call() throws Exception {
                UserInfo.getInstance().syncPlans();
                return null;
            }
        };
        Utilities.runATask((Task<Void>)task);
        if (this.editorPage) {
            this.recordButton.setPadding(new Insets(0.0, 0.0, 5.0, 0.0));
        } else {
            this.recordButton.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
        }
        Tooltip tooltip = this.recordButton.getTooltip();
        tooltip.setFont(Font.font((String)"IranSans", (FontWeight)FontWeight.BOLD, (double)12.0));
        tooltip.setShowDelay(Duration.millis((double)400.0));
        this.recordButton.setTooltip(tooltip);
    }

    private void createClient() {
        this.client = new GrpcClient(UserInfo.getInstance().getAccess(), settings.getIntegerProperty("recorder.sample_rate"), settings.getStringProperty("grpc.language_code"), settings.getStringProperty("grpc.model_name"), this.resultObserver);
    }

    private void samePartOfConstructors() {
        this.resultObserver = new ResultObserver();
        this.createClient();
        this.lastRecognizedWordTime = System.currentTimeMillis();
        this.recorder = new AudioRecorder(settings.getIntegerProperty("recorder.sample_rate"), settings.getIntegerProperty("recorder.buffer_size"), (speechBuffer, length) -> {
            this.client.processNextBuffer(speechBuffer, 0, length);
            int idleTime = settings.getIntegerProperty("recorder.idle_time") * 1000;
            if (System.currentTimeMillis() - this.lastRecognizedWordTime > (long)idleTime) {
                this.recordButtonPressed(new ActionEvent());
            }
        });
        try {
            this.robot = new Robot();
        }
        catch (AWTException e) {
            Platform.runLater(() -> {
                TrayNotification tray = new TrayNotification("\u0639\u062f\u0645 \u062f\u0633\u062a\u0631\u0633\u06cc", "\u0627\u0645\u06a9\u0627\u0646 \u062f\u0633\u062a\u0631\u0633\u06cc \u0628\u0647 \u0639\u0645\u0644\u06cc\u0627\u062a \u06a9\u06cc\u0628\u0648\u0631\u062f \u0648\u062c\u0648\u062f \u0646\u062f\u0627\u0631\u062f.", Notifications.INFORMATION);
                tray.showAndDismiss();
            });
            Sentry.captureException((Throwable)e);
            e.printStackTrace();
        }
    }

    private void stopRecording() {
        if (this.isRecording.get()) {
            System.out.println(this.previousTime);
            this.recordButton.setStyle("-fx-background-color: #ff8a80; -fx-background-radius: 100;");
            this.recorder.stopRecording();
            this.client.finish();
            this.isRecording.set(false);
            PartialResultsForm.getInstance().setVisible(false);
            this.timerLabel.setVisible(false);
            this.timerWorking = false;
            this.timer.stop();
            Platform.runLater(() -> {
                this.recordImg.setVisible(true);
                this.recordButton.setGraphic((Node)this.recordImg);
                this.recordPane.getChildren().remove((Object)this.indicator);
            });
        }
    }

    @FXML
    void recordButtonPressed(ActionEvent event) {
        if (UserInfo.getInstance().isHaveGoldenPlan()) {
            if (this.isRecording.get()) {
                this.stopRecording();
            } else {
                HTMLEditorSkin skin;
                try {
                    if (!this.languageCode.equals(settings.getStringProperty("grpc.language_code")) || !this.modelName.equals(settings.getStringProperty("grpc.model_name"))) {
                        this.createClient();
                        this.languageCode = settings.getStringProperty("grpc.language_code");
                        this.modelName = settings.getStringProperty("grpc.model_name");
                    }
                    this.client.start();
                    this.handleViewOfStartRecording();
                    Thread.sleep(500L);
                    this.recorder.startRecording();
                    this.lastRecognizedWordTime = System.currentTimeMillis();
                    this.setTimer();
                }
                catch (InterruptedException | SSLException | LineUnavailableException exp) {
                    Sentry.captureException((Throwable)exp);
                    if (exp instanceof LineUnavailableException) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                TrayNotification tray = new TrayNotification("\u0645\u06cc\u06a9\u0631\u0648\u0641\u0648\u0646 \u0646\u0627\u0633\u0627\u0632\u06af\u0627\u0631", "\u0645\u06cc\u06a9\u0631\u0648\u0641\u0648\u0646 \u062f\u0633\u062a\u06af\u0627\u0647 \u0634\u0645\u0627 \u0645\u0646\u0627\u0633\u0628 \u062a\u0627\u06cc\u067e \u0635\u0648\u062a\u06cc \u0646\u0645\u06cc\u200c\u0628\u0627\u0634\u062f.", Notifications.INFORMATION);
                                tray.showAndDismiss();
                            }
                        });
                        ExceptionHandling.getInstance().lineUnAvailableExceptionHandling((LineUnavailableException)exp);
                    }
                    if (exp instanceof SSLException) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                TrayNotification tray = new TrayNotification("\u0645\u062c\u0648\u0632 \u0646\u0627\u0645\u062a\u0639\u0628\u0631", "\u0645\u062c\u0648\u0632 \u0627\u0646\u062c\u0627\u0645 \u062a\u0627\u06cc\u067e \u0635\u0648\u062a\u06cc \u0648\u062c\u0648\u062f \u0646\u062f\u0627\u0631\u062f.", Notifications.INFORMATION);
                                tray.showAndDismiss();
                            }
                        });
                    }
                    exp.printStackTrace();
                    return;
                }
                this.isRecording.set(true);
                PartialResultsForm.getInstance().setVisible(true);
                if (this.editorPage && !(skin = (HTMLEditorSkin)this.htmlEditor.getSkin()).getWebView().isFocused()) {
                    skin.getWebView().requestFocus();
                }
                this.recordButton.setStyle("-fx-background-color: #81d4fa; -fx-background-radius: 100;");
            }
        } else {
            TrayNotification tray = new TrayNotification("\u0639\u062f\u0645 \u0627\u0634\u062a\u0631\u0627\u06a9 \u0637\u0644\u0627\u06cc\u06cc", "\u0628\u0631\u0627\u06cc \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0627\u0632 \u0627\u06cc\u0646 \u0642\u0627\u0628\u0644\u06cc\u062a \u0628\u0627\u06cc\u062f \u0627\u0634\u062a\u0631\u0627\u06a9 \u0637\u0644\u0627\u06cc\u06cc \u062e\u0631\u06cc\u062f\u0627\u0631\u06cc \u0646\u0645\u0627\u06cc\u06cc\u062f.", Notifications.INFORMATION);
            tray.showAndDismiss();
        }
    }

    private void handleViewOfStartRecording() {
        this.addVolumeIndicator();
        this.recordImg.setVisible(false);
        this.recordButton.setGraphic((Node)this.timerLabel);
        this.timerWorking = true;
        this.timerLabel.setVisible(true);
        this.recorder.addObserver(this.indicator);
    }

    private void setTimer() {
        this.timer = new Timer(1000, e -> {
            long millis = this.previousTime;
            String time = String.format("%02d:%02d:%02d", TimeUnit.MILLISECONDS.toHours(millis), TimeUnit.MILLISECONDS.toMinutes(millis) - TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(millis)), TimeUnit.MILLISECONDS.toSeconds(millis) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(millis)));
            Platform.runLater(() -> this.timerLabel.setText(Utilities.normalizeDigits(time)));
            this.previousTime += 1000L;
            UserInfo.previousTime += 1000L;
        });
        this.timer.start();
    }

    private void addVolumeIndicator() {
        this.indicator = new RingProgressIndicator(100, 120, 47, "volume_indicator");
        this.indicator.setPrefSize(105.0, 105.0);
        this.indicator.setMaxSize(105.0, 105.0);
        this.indicator.setMinSize(105.0, 105.0);
        this.indicator.setLayoutX(17.0);
        this.indicator.setLayoutY(-2.5);
        this.recordPane.getChildren().add(0, (Object)this.indicator);
    }

    public void writeToFile(String text) {
        PartialResultsForm.getInstance().setVisible(true);
        PartialResultsForm.getInstance().setPartialResult(text);
        StringSelection stringSelection = new StringSelection(text);
        try {
            this.writer.write(text);
            this.writer.flush();
            this.writer.close();
        }
        catch (IOException e) {
            Sentry.captureException((Throwable)e);
            this.handleFileException();
        }
    }

    public void readFromFile() throws IOException {
        Object result = "";
        String line = "";
        while ((line = this.reader.readLine()) != null && !line.isEmpty()) {
            result = (String)result + "\n" + line;
        }
        PartialResultsForm.getInstance().setVisible(true);
        PartialResultsForm.getInstance().setPartialResult((String)result);
        StringSelection stringSelection = new StringSelection((String)result);
        this.htmlEditor.requestFocus();
        clipboard.setContents(stringSelection, null);
        this.robot.keyPress(17);
        this.robot.keyPress(86);
        this.robot.keyRelease(86);
        this.robot.keyRelease(17);
    }

    private void handleFileException() {
        this.stopRecording();
        TrayNotification tray = new TrayNotification("\u062e\u0637\u0627\u06cc\u06cc \u0631\u062e \u062f\u0627\u062f\u0647 \u0627\u0633\u062a", "\u0645\u0634\u06a9\u0644\u06cc \u0631\u062e \u062f\u0627\u062f\u0647 \u0627\u0633\u062a.", Notifications.INFORMATION);
        tray.showAndDismiss();
    }

    public void disable() {
        this.recordButton.setDisable(true);
    }

    private class ResultObserver
    implements GrpcClient.ResultObserver {
        private String partialStableResult = "";

        private ResultObserver() {
        }

        @Override
        public void onNext(String stableResult, String nonStableResult, boolean isFinal, float lastWordEndTime) {
            RecordButtonController.this.lastRecognizedWordTime = System.currentTimeMillis();
            if (isFinal) {
                if (((String)stableResult).isEmpty()) {
                    return;
                }
                if (Formatter.isSafeToFinalize((String)stableResult)) {
                    if (!this.partialStableResult.isEmpty()) {
                        stableResult = ((String)stableResult).charAt(0) == ' ' || this.partialStableResult.endsWith(" ") ? this.partialStableResult + (String)stableResult : this.partialStableResult + " " + (String)stableResult;
                        this.partialStableResult = "";
                    }
                    stableResult = Formatter.apply((String)stableResult, settings.getBooleanProperty("process.apply_punctuation"), settings.getBooleanProperty("process.apply_numbers"), settings.getBooleanProperty("process.apply_datetime"), settings.getBooleanProperty("process.apply_phone_numbers"), settings.getBooleanProperty("process.type_to_word"), settings.getStringProperty("process.date_separator").charAt(0));
                    String extraSpace = "";
                    if (!RecordButtonController.this.lastCharacterWasSpace && ((String)stableResult).charAt(0) != ' ' && punctuationsProcessing.isSpaceNeededBeforeCharacter(Character.valueOf(((String)stableResult).charAt(0)))) {
                        extraSpace = " ";
                    }
                    RecordButtonController.this.lastCharacterWasSpace = ((String)stableResult).endsWith(" ") || ((String)stableResult).endsWith("\n") || !punctuationsProcessing.isSpaceNeededAfterCharacter(Character.valueOf(((String)stableResult).charAt(((String)stableResult).length() - 1)));
                    boolean removeLastChar = false;
                    if (settings.getBooleanProperty("process.type_to_word") && ((String)stableResult).endsWith("\n")) {
                        stableResult = (String)stableResult + "\u200c";
                        removeLastChar = true;
                    }
                    StringSelection stringSelection = new StringSelection(extraSpace + (String)stableResult);
                    clipboard.setContents(stringSelection, null);
                    RecordButtonController.this.robot.keyPress(17);
                    RecordButtonController.this.robot.keyPress(86);
                    RecordButtonController.this.robot.keyRelease(86);
                    RecordButtonController.this.robot.keyRelease(17);
                    if (removeLastChar) {
                        RecordButtonController.this.robot.keyPress(8);
                        RecordButtonController.this.robot.keyRelease(8);
                    }
                    PartialResultsForm.getInstance().setPartialResult("");
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    this.partialStableResult = !this.partialStableResult.isEmpty() ? (((String)stableResult).charAt(0) == ' ' || this.partialStableResult.endsWith(" ") ? this.partialStableResult + (String)stableResult : this.partialStableResult + " " + (String)stableResult) : stableResult;
                }
            } else {
                if (!this.partialStableResult.isEmpty()) {
                    stableResult = ((String)stableResult).isEmpty() || ((String)stableResult).charAt(0) == ' ' || this.partialStableResult.endsWith(" ") ? this.partialStableResult + (String)stableResult : this.partialStableResult + " " + (String)stableResult;
                }
                stableResult = ((String)stableResult).endsWith(" ") || nonStableResult.charAt(0) == ' ' ? (String)stableResult + nonStableResult : (String)stableResult + " " + nonStableResult;
                PartialResultsForm.getInstance().setPartialResult((String)stableResult);
            }
        }

        @Override
        public void onError(Throwable t) {
            RecordButtonController.this.stopRecording();
            Sentry.captureException((Throwable)t);
        }

        @Override
        public void onCompleted() {
            RecordButtonController.this.stopRecording();
        }
    }
}

