/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.controller.Punctuations;

import io.sentry.Sentry;
import ir.deepmine.dictation.Main;
import ir.deepmine.dictation.controller.PopupController;
import ir.deepmine.dictation.controller.Punctuations.EditPunctuationController;
import ir.deepmine.dictation.controller.Punctuations.NewPunctuationController;
import ir.deepmine.dictation.controller.Punctuations.PunctuationRowController;
import ir.deepmine.dictation.controller.ToolbarWithSettingController;
import ir.deepmine.dictation.database.DefaultPunctuationMark;
import ir.deepmine.dictation.database.PunctuationMark;
import ir.deepmine.dictation.database.PunctuationParent;
import ir.deepmine.dictation.exceptions.AlreadyExistException;
import ir.deepmine.dictation.exceptions.ConnectionException;
import ir.deepmine.dictation.exceptions.ExceptionHandling;
import ir.deepmine.dictation.exceptions.GeneralException;
import ir.deepmine.dictation.exceptions.InvalidTokenException;
import ir.deepmine.dictation.exceptions.NotExistException;
import ir.deepmine.dictation.exceptions.ServerException;
import ir.deepmine.dictation.exceptions.SuccessException;
import ir.deepmine.dictation.ui.notification.Notifications;
import ir.deepmine.dictation.ui.notification.TrayNotification;
import ir.deepmine.dictation.utils.DoActions;
import ir.deepmine.dictation.utils.Settings;
import ir.deepmine.dictation.utils.UserInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;

public class PunctuationController {
    @FXML
    private AnchorPane root;
    @FXML
    private GridPane systemPunctuationGrid;
    @FXML
    private GridPane userPunctuationGrid;
    @FXML
    private ScrollPane scrollPaneSystem;
    @FXML
    private ScrollPane scrollPaneUser;
    @FXML
    private ScrollBar vScrollBarUser;
    @FXML
    private ScrollBar vScrollBarSystem;
    private DoActions doActions = DoActions.getInstance();
    private ExceptionHandling exceptionHandling = ExceptionHandling.getInstance();
    private double anchorX;
    private double anchorY;

    public void initialize() {
        this.loadUserPunctuations();
        this.loadSystemPunctuations();
        System.out.println("row count user: " + this.userPunctuationGrid.getRowCount());
        System.out.println("row count sys: " + this.systemPunctuationGrid.getRowCount());
        if (this.userPunctuationGrid.getRowCount() < 4) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    System.out.println("sys: " + PunctuationController.this.vScrollBarSystem.getHeight());
                    System.out.println("user: " + PunctuationController.this.vScrollBarUser.getHeight());
                    System.out.println("after");
                    PunctuationController.this.vScrollBarUser.setPrefHeight(100.0);
                    System.out.println("sys: " + PunctuationController.this.vScrollBarSystem.getHeight());
                    System.out.println("user: " + PunctuationController.this.vScrollBarUser.getHeight());
                }
            });
        }
        this.vScrollBarUser.minProperty().bind((ObservableValue)this.scrollPaneUser.vminProperty());
        this.vScrollBarUser.maxProperty().bind((ObservableValue)this.scrollPaneUser.vmaxProperty());
        this.vScrollBarUser.visibleAmountProperty().bind((ObservableValue)this.scrollPaneUser.heightProperty().divide((ObservableNumberValue)this.userPunctuationGrid.heightProperty()));
        this.vScrollBarUser.visibleProperty().bind((ObservableValue)this.scrollPaneUser.heightProperty().lessThan((ObservableNumberValue)this.userPunctuationGrid.heightProperty()));
        this.scrollPaneUser.vvalueProperty().bindBidirectional((Property)this.vScrollBarUser.valueProperty());
        this.vScrollBarSystem.minProperty().bind((ObservableValue)this.scrollPaneSystem.vminProperty());
        this.vScrollBarSystem.maxProperty().bind((ObservableValue)this.scrollPaneSystem.vmaxProperty());
        this.vScrollBarSystem.visibleAmountProperty().bind((ObservableValue)this.scrollPaneSystem.heightProperty().divide((ObservableNumberValue)this.systemPunctuationGrid.heightProperty()));
        this.vScrollBarSystem.visibleProperty().bind((ObservableValue)this.scrollPaneSystem.heightProperty().lessThan((ObservableNumberValue)this.systemPunctuationGrid.heightProperty()));
        this.scrollPaneSystem.vvalueProperty().bindBidirectional((Property)this.vScrollBarSystem.valueProperty());
        if (ToolbarWithSettingController.isInToolBar) {
            this.root.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    PunctuationController.this.anchorX = event.getSceneX();
                    PunctuationController.this.anchorY = event.getSceneY();
                }
            });
            this.root.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    Stage stage = (Stage)PunctuationController.this.root.getScene().getWindow();
                    stage.setX(event.getScreenX() - PunctuationController.this.anchorX);
                    stage.setY(event.getScreenY() - PunctuationController.this.anchorY);
                }
            });
        }
    }

    private void loadSystemPunctuations() {
        this.systemPunctuationGrid.getChildren().clear();
        List<DefaultPunctuationMark> punctuations = DefaultPunctuationMark.getAll();
        ArrayList<DefaultPunctuationMark> punctuationParents = new ArrayList<DefaultPunctuationMark>(punctuations);
        int i = 0;
        boolean isPersian = false;
        if (Settings.getInstance().getStringProperty("grpc.language_code").equals("fa-IR")) {
            isPersian = true;
        }
        for (PunctuationParent punctuationParent : punctuationParents) {
            if (isPersian) {
                switch (punctuationParent.getWord()) {
                    case "\u06a9\u0631\u0648\u0634\u0647 \u0628\u0627\u0632": {
                        punctuationParent.setMark(" ]");
                        break;
                    }
                    case "\u06a9\u0631\u0648\u0634\u0647 \u0628\u0633\u062a\u0647": {
                        punctuationParent.setMark("[ ");
                        break;
                    }
                    case "\u067e\u0631\u0627\u0646\u062a\u0632 \u0628\u0627\u0632": {
                        punctuationParent.setMark(" )");
                        break;
                    }
                    case "\u067e\u0631\u0627\u0646\u062a\u0632 \u0628\u0633\u062a\u0647": {
                        punctuationParent.setMark("( ");
                        break;
                    }
                    case "\u06af\u06cc\u0648\u0645\u0647 \u0628\u0627\u0632": {
                        punctuationParent.setMark(" \u00bb");
                        break;
                    }
                    case "\u06af\u06cc\u0648\u0645\u0647 \u0628\u0633\u062a\u0647": {
                        punctuationParent.setMark("\u00ab ");
                        break;
                    }
                    case "\u0622\u06a9\u0648\u0644\u0627\u062f \u0628\u0627\u0632": {
                        punctuationParent.setMark(" }");
                        break;
                    }
                    case "\u0622\u06a9\u0648\u0644\u0627\u062f \u0628\u0633\u062a\u0647": {
                        punctuationParent.setMark("{ ");
                    }
                }
            }
            Parent row = this.addAPunctuation(punctuationParent, false);
            this.systemPunctuationGrid.add((Node)row, 0, i, 5, 1);
            ++i;
        }
    }

    private void loadUserPunctuations() {
        this.userPunctuationGrid.getChildren().clear();
        ArrayList punctuations = (ArrayList)PunctuationMark.getAll(UserInfo.getInstance().getUser_id());
        int i = 0;
        for (PunctuationMark punctuationMark : punctuations) {
            Parent row = this.addAPunctuation(punctuationMark, true);
            this.userPunctuationGrid.add((Node)row, 0, i, 5, 1);
            ++i;
        }
    }

    private Parent addAPunctuation(PunctuationParent punctuationMark, boolean isUserPunctuation) {
        FXMLLoader fxmlLoader = new FXMLLoader();
        fxmlLoader.setLocation(Main.class.getResource("/fxml/punctuationRow.fxml"));
        PunctuationRowController controller = new PunctuationRowController(punctuationMark, isUserPunctuation);
        fxmlLoader.setController((Object)controller);
        try {
            fxmlLoader.load();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Parent row = (Parent)fxmlLoader.getRoot();
        this.addDeleteEventHandler(punctuationMark, controller, row);
        this.addEditEventHandler(punctuationMark, controller);
        return row;
    }

    private void addEditEventHandler(PunctuationParent punctuationMark, PunctuationRowController controller) {
        PunctuationMark[] result = new PunctuationMark[1];
        controller.getEdit().setOnMouseClicked(event -> {
            EditPunctuationController editPunctuationController = this.addEditScene(punctuationMark, this.root);
            editPunctuationController.getCancel().setOnAction(event1 -> this.closeExtraScene());
            editPunctuationController.getSubmit().setOnAction(event1 -> {
                try {
                    result[0] = this.doActions.editPunctuationMark(editPunctuationController.getStatementField().getText(), editPunctuationController.getSignField().getText(), punctuationMark.getId());
                }
                catch (GeneralException e) {
                    this.exceptionHandling.generalExceptionHandling(e);
                }
                catch (InvalidTokenException e) {
                    this.exceptionHandling.invalidTokenExceptionHandling(e);
                }
                catch (AlreadyExistException e) {
                    Sentry.captureException((Throwable)e);
                    TrayNotification tray = new TrayNotification("\u0639\u0644\u0627\u0645\u062a \u0646\u06af\u0627\u0631\u0634\u06cc \u0645\u0648\u0631\u062f \u0646\u0638\u0631 \u0645\u0648\u062c\u0648\u062f \u0627\u0633\u062a.", e.getMessage(), Notifications.WARNING);
                    tray.showAndDismiss();
                }
                catch (NotExistException e) {
                    Sentry.captureException((Throwable)e);
                    TrayNotification tray = new TrayNotification("\u0639\u0644\u0627\u0645\u062a \u0646\u06af\u0627\u0631\u0634\u06cc \u0645\u0648\u0631\u062f \u0646\u0638\u0631 \u0645\u0648\u062c\u0648\u062f \u0646\u06cc\u0633\u062a.", e.getMessage(), Notifications.WARNING);
                    tray.showAndDismiss();
                }
                catch (ConnectionException e) {
                    this.exceptionHandling.connectionExceptionHandling(e);
                }
                catch (ServerException e) {
                    this.exceptionHandling.serverExceptionHandling(e);
                }
                if (result[0] != null) {
                    this.loadUserPunctuations();
                    this.closeExtraScene();
                }
            });
        });
    }

    private EditPunctuationController addEditScene(PunctuationParent punctuationMark, AnchorPane rootAnchor) {
        FXMLLoader fxmlLoader = new FXMLLoader();
        fxmlLoader.setLocation(Main.class.getResource("/fxml/editPunctuation.fxml"));
        EditPunctuationController controller = new EditPunctuationController(punctuationMark.getWord(), punctuationMark.getMark());
        fxmlLoader.setController((Object)controller);
        try {
            fxmlLoader.load();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        AnchorPane anchorPane = (AnchorPane)fxmlLoader.getRoot();
        this.addExtraAnchor(anchorPane, 188, 141);
        return controller;
    }

    private void addDeleteEventHandler(PunctuationParent punctuationMark, PunctuationRowController controller, Parent row) {
        controller.getDelete().setOnMouseClicked(event -> {
            PopupController popupController = this.addDeleteScene(punctuationMark.getMark(), this.root);
            popupController.getCancelBtn().addEventHandler(MouseEvent.MOUSE_CLICKED, event1 -> this.closeExtraScene());
            popupController.getSubmitBtn().addEventHandler(MouseEvent.MOUSE_CLICKED, event1 -> Platform.runLater(() -> {
                try {
                    this.doActions.deletePunctuationMark(punctuationMark.getId());
                }
                catch (NotExistException e) {
                    Sentry.captureException((Throwable)e);
                    TrayNotification tray = new TrayNotification("\u0639\u0644\u0627\u0645\u062a \u0646\u06af\u0627\u0631\u0634\u06cc \u0645\u0648\u0631\u062f \u0646\u0638\u0631 \u0645\u0648\u062c\u0648\u062f \u0646\u06cc\u0633\u062a.", e.getMessage(), Notifications.WARNING);
                    tray.showAndDismiss();
                }
                catch (InvalidTokenException e) {
                    this.exceptionHandling.invalidTokenExceptionHandling(e);
                }
                catch (GeneralException e) {
                    this.exceptionHandling.generalExceptionHandling(e);
                }
                catch (SuccessException e) {
                    Platform.runLater(() -> {
                        this.exceptionHandling.successExceptionHandling(e);
                        this.userPunctuationGrid.getChildren().remove((Object)row);
                        this.closeExtraScene();
                    });
                }
                catch (ConnectionException e) {
                    this.exceptionHandling.connectionExceptionHandling(e);
                }
                catch (ServerException e) {
                    this.exceptionHandling.serverExceptionHandling(e);
                }
            }));
        });
    }

    private PopupController addDeleteScene(String description, AnchorPane rootAnchor) {
        FXMLLoader fxmlLoader = new FXMLLoader();
        fxmlLoader.setLocation(Main.class.getResource("/fxml/popup.fxml"));
        PopupController controller = new PopupController("\u0639\u0644\u0627\u0645\u062a \u0646\u06af\u0627\u0631\u0634\u06cc:", description);
        fxmlLoader.setController((Object)controller);
        try {
            fxmlLoader.load();
        }
        catch (IOException e) {
            Sentry.captureException((Throwable)e);
            e.printStackTrace();
        }
        AnchorPane anchorPane = (AnchorPane)fxmlLoader.getRoot();
        this.addExtraAnchor(anchorPane, 140, 77);
        return controller;
    }

    private void closeExtraScene() {
        this.root.getChildren().remove(this.root.getChildren().size() - 1);
        this.root.getChildren().remove(this.root.getChildren().size() - 1);
    }

    private void addExtraAnchor(AnchorPane anchorPane, int widthOffset, int heightOffset) {
        AnchorPane blackAnchor = new AnchorPane();
        blackAnchor.setPrefSize(this.root.getWidth(), this.root.getHeight());
        blackAnchor.setStyle("-fx-background-color: rgb(0,0,0,0.8)");
        this.root.getChildren().add((Object)blackAnchor);
        anchorPane.setLayoutX(this.root.getWidth() / 2.0 - (double)widthOffset);
        anchorPane.setLayoutY(this.root.getHeight() / 2.0 - (double)heightOffset);
        this.root.getChildren().add((Object)anchorPane);
    }

    @FXML
    void close(ActionEvent event) {
        if (!ToolbarWithSettingController.isInToolBar) {
            Thread thread = new Thread(() -> Platform.runLater(() -> {
                AnchorPane MainRoot = (AnchorPane)this.userPunctuationGrid.getScene().getRoot();
                MainRoot.getChildren().remove((Object)this.root);
                MainRoot.getChildren().remove(MainRoot.getChildren().size() - 1);
            }));
            thread.setDaemon(true);
            thread.start();
        } else {
            Stage stage = (Stage)this.root.getScene().getWindow();
            stage.close();
        }
    }

    @FXML
    void addNewPunc(ActionEvent event) {
        FXMLLoader fxmlLoader = new FXMLLoader();
        fxmlLoader.setLocation(Main.class.getResource("/fxml/newPunctuation.fxml"));
        NewPunctuationController controller = new NewPunctuationController();
        fxmlLoader.setController((Object)controller);
        PunctuationMark[] result = new PunctuationMark[1];
        try {
            fxmlLoader.load();
        }
        catch (IOException e) {
            Sentry.captureException((Throwable)e);
            e.printStackTrace();
        }
        AnchorPane anchorPane = (AnchorPane)fxmlLoader.getRoot();
        this.addExtraAnchor(anchorPane, 188, 141);
        controller.getCancel().setOnAction(event1 -> this.closeExtraScene());
        controller.getSubmit().setOnAction(event12 -> {
            try {
                result[0] = this.doActions.createPunctuationMark(controller.getStatementField().getText(), controller.getSignField().getText());
            }
            catch (AlreadyExistException e) {
                TrayNotification tray = new TrayNotification("\u0639\u0644\u0627\u0645\u062a \u0646\u06af\u0627\u0631\u0634\u06cc \u0645\u0648\u0631\u062f \u0646\u0638\u0631 \u0645\u0648\u062c\u0648\u062f \u0627\u0633\u062a.", e.getMessage(), Notifications.WARNING);
                tray.showAndDismiss();
            }
            catch (InvalidTokenException e) {
                this.exceptionHandling.invalidTokenExceptionHandling(e);
            }
            catch (GeneralException e) {
                this.exceptionHandling.generalExceptionHandling(e);
            }
            catch (ConnectionException e) {
                this.exceptionHandling.connectionExceptionHandling(e);
            }
            catch (ServerException e) {
                this.exceptionHandling.serverExceptionHandling(e);
            }
            if (result[0] != null) {
                this.loadUserPunctuations();
                this.closeExtraScene();
            }
        });
    }
}

