/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.controller;

import com.jfoenix.controls.JFXButton;
import io.sentry.Sentry;
import ir.deepmine.dictation.controller.BuyPlanController;
import ir.deepmine.dictation.database.Boxes;
import ir.deepmine.dictation.database.DefaultPlan;
import ir.deepmine.dictation.database.Plan;
import ir.deepmine.dictation.exceptions.ConnectionException;
import ir.deepmine.dictation.exceptions.ExceptionHandling;
import ir.deepmine.dictation.exceptions.GeneralException;
import ir.deepmine.dictation.exceptions.InvalidTokenException;
import ir.deepmine.dictation.exceptions.NotExistException;
import ir.deepmine.dictation.exceptions.ServerException;
import ir.deepmine.dictation.ui.planpackage.Package;
import ir.deepmine.dictation.ui.planpackage.PackageWithOneGauge;
import ir.deepmine.dictation.ui.planpackage.PackageWithTwoGauge;
import ir.deepmine.dictation.utils.DoActions;
import ir.deepmine.dictation.utils.UserInfo;
import ir.deepmine.dictation.utils.Utilities;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.Label;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.VBox;

public class PlanController {
    private AnchorPane mainRoot;
    @FXML
    private AnchorPane root;
    @FXML
    private VBox VBox;
    @FXML
    private VBox descriptionVBox;
    @FXML
    private JFXButton buyGoldenPlanButton;
    @FXML
    private Label emptyPlanLabel;
    private ExceptionHandling exceptionHandling;
    private ArrayList<Package> packages = new ArrayList();

    public PlanController(AnchorPane mainRoot) {
        this.mainRoot = mainRoot;
    }

    public void initialize() {
        System.out.println("Size: " + this.mainRoot.getChildren().size());
        this.exceptionHandling = ExceptionHandling.getInstance();
        try {
            UserInfo.getInstance().syncPlans();
        }
        catch (ConnectionException e) {
            this.exceptionHandling.connectionExceptionHandling(e);
        }
        catch (GeneralException e) {
            this.exceptionHandling.generalExceptionHandling(e);
        }
        catch (InvalidTokenException e) {
            this.exceptionHandling.invalidTokenExceptionHandling(e);
        }
        catch (ServerException e) {
            this.exceptionHandling.serverExceptionHandling(e);
        }
        if (Boxes.defaultPlanBox.isEmpty()) {
            try {
                DoActions.getInstance().getDefaultPlans();
            }
            catch (ConnectionException e) {
                this.exceptionHandling.connectionExceptionHandling(e);
            }
            catch (GeneralException e) {
                this.exceptionHandling.generalExceptionHandling(e);
            }
            catch (InvalidTokenException e) {
                this.exceptionHandling.invalidTokenExceptionHandling(e);
            }
            catch (ServerException e) {
                this.exceptionHandling.serverExceptionHandling(e);
            }
            catch (NotExistException e) {
                Sentry.captureException((Throwable)e);
                e.printStackTrace();
            }
        }
        this.VBox.getChildren().clear();
        this.VBox.getChildren().add((Object)this.emptyPlanLabel);
        this.VBox.getChildren().add((Object)this.descriptionVBox);
        List<Plan> allPlans = Plan.getAll(UserInfo.getInstance().getUser_id(), false, true);
        allPlans = this.sortPlans(allPlans);
        for (Plan plan : allPlans) {
            Package newPackage;
            DefaultPlan defaultPlan = DefaultPlan.get(plan.getPlan());
            if (defaultPlan == null) continue;
            if (defaultPlan.getSpeciality() != null && defaultPlan.getSpeciality().equals("basic")) {
                newPackage = new PackageWithOneGauge(defaultPlan);
                ((PackageWithOneGauge)newPackage).getGaugeMinute().getGauge().setProgress((double)plan.getRemaining_quota_sec() / 60.0);
                this.packages.add(newPackage);
                continue;
            }
            newPackage = new PackageWithTwoGauge(defaultPlan);
            ((PackageWithTwoGauge)newPackage).getGaugeMinute().getGauge().progressProperty().set(((PackageWithTwoGauge)newPackage).getGaugeMinute().getGauge().defaultToMax((double)plan.getRemaining_quota_sec() / 60.0));
            float remainingDay = (float)((double)(plan.getEnd_date().getTime() - new Date().getTime()) / 8.64E7);
            ((PackageWithTwoGauge)newPackage).getGaugeDay().getGauge().progressProperty().set(((PackageWithTwoGauge)newPackage).getGaugeDay().getGauge().defaultToMax(Math.round(remainingDay)));
            if (remainingDay < 1.0f) {
                if (remainingDay * 24.0f < 1.0f) {
                    ((PackageWithTwoGauge)newPackage).getGaugeDay().setNumberLabel(Utilities.normalizeDigits(String.valueOf((int)((PackageWithTwoGauge)newPackage).getGaugeDay().getGauge().defaultToMax(remainingDay * 24.0f * 60.0f))));
                    ((PackageWithTwoGauge)newPackage).getGaugeDay().setFromUnitText("\u062f\u0642\u06cc\u0642\u0647");
                    ((PackageWithTwoGauge)newPackage).getGaugeDay().setFromLabelText("\u0627\u0632 " + Utilities.normalizeDigits(String.valueOf(defaultPlan.getExpire_at_hours() * 60)));
                } else {
                    ((PackageWithTwoGauge)newPackage).getGaugeDay().setNumberLabel(Utilities.normalizeDigits(String.valueOf((int)((PackageWithTwoGauge)newPackage).getGaugeDay().getGauge().defaultToMax(remainingDay * 24.0f))));
                    ((PackageWithTwoGauge)newPackage).getGaugeDay().setFromUnitText("\u0633\u0627\u0639\u062a");
                    ((PackageWithTwoGauge)newPackage).getGaugeDay().setFromLabelText("\u0627\u0632 " + Utilities.normalizeDigits(String.valueOf(defaultPlan.getExpire_at_hours())));
                }
            }
            this.packages.add(newPackage);
        }
        if (this.packages.size() > 0) {
            this.packages.get(0).setUsingStatusTwo();
            this.emptyPlanLabel.setVisible(false);
        }
        Collections.reverse(this.packages);
        for (Package package1 : this.packages) {
            this.VBox.getChildren().add(0, (Object)package1);
        }
    }

    @FXML
    void close(ActionEvent event) {
        this.mainRoot.getChildren().remove((Object)this.root);
        this.mainRoot.getChildren().remove(this.mainRoot.getChildren().size() - 1);
    }

    private void closePageGoToBuy() {
        Platform.runLater(() -> {
            this.mainRoot.getChildren().remove((Object)this.root);
            this.mainRoot.getChildren().remove(this.mainRoot.getChildren().size() - 3);
        });
    }

    @FXML
    void buyGoldenPlan(ActionEvent event) {
        AnchorPane anchorPane = null;
        try {
            FXMLLoader fxmlLoader = new FXMLLoader();
            fxmlLoader.setLocation(this.getClass().getResource("/fxml/buy-plan.fxml"));
            BuyPlanController buyPlanController = new BuyPlanController(this.mainRoot);
            fxmlLoader.setController((Object)buyPlanController);
            fxmlLoader.load();
            anchorPane = (AnchorPane)fxmlLoader.getRoot();
            if (anchorPane != null) {
                System.out.println("here1");
                AnchorPane blackAnchor = new AnchorPane();
                blackAnchor.setPrefSize(this.mainRoot.getWidth(), this.mainRoot.getHeight());
                System.out.println("here2");
                blackAnchor.setStyle("-fx-background-color: rgb(0,0,0,0.8)");
                this.mainRoot.getChildren().add((Object)blackAnchor);
                anchorPane.setLayoutX(this.mainRoot.getWidth() / 2.0 - 300.0);
                anchorPane.setLayoutY(this.mainRoot.getHeight() / 2.0 - 250.0);
                System.out.println("here3 " + anchorPane.getChildren());
                this.mainRoot.getChildren().add((Object)anchorPane);
                System.out.println("here4");
                System.out.println(this.mainRoot.getChildren());
                this.closePageGoToBuy();
            } else {
                Sentry.captureException((Throwable)new NullPointerException("anchor pane of buy plan is null"));
            }
        }
        catch (IOException e) {
            Sentry.captureException((Throwable)e);
            e.printStackTrace();
        }
    }

    private List<Plan> sortPlans(List<Plan> plans) {
        plans.sort(new Comparator<Plan>(){

            @Override
            public int compare(Plan o1, Plan o2) {
                float remaining12;
                float remaining1 = o1.getEnd_date().getTime();
                float diff = remaining1 - (remaining12 = (float)o2.getEnd_date().getTime());
                if (diff > 0.0f) {
                    return 1;
                }
                if (diff < 0.0f) {
                    return -1;
                }
                return 0;
            }
        });
        return plans;
    }
}

