/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.controller;

import com.jfoenix.controls.JFXRadioButton;
import ir.deepmine.dictation.controller.SettingFormController;
import ir.deepmine.dictation.database.SpeechModel;
import ir.deepmine.dictation.utils.Settings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.geometry.NodeOrientation;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;

public class LanguageSpeechController {
    private HashMap<Toggle, String> toggleStringHashMap;
    private HashMap<String, Toggle> stringToggleHashMap;
    private HashMap<String, String> lanLanFaHashMap;
    private HashMap<String, String> lanFaLanHashMap;
    @FXML
    private AnchorPane rootAnchor;
    @FXML
    private ScrollPane langScrollPane;
    private VBox vbox;
    private AnchorPane root;
    private List<SpeechModel> speechModels;
    private ArrayList<String> languages;
    private ArrayList<String> descriptions;
    private ToggleGroup toggleGroup;
    private Settings settings = Settings.getInstance();

    public LanguageSpeechController(AnchorPane root) {
        this.root = root;
    }

    public void initialize() {
        int i;
        this.speechModels = SpeechModel.getAll();
        this.languages = new ArrayList();
        this.descriptions = new ArrayList();
        this.toggleStringHashMap = new HashMap();
        this.stringToggleHashMap = new HashMap();
        this.lanFaLanHashMap = new HashMap();
        this.lanLanFaHashMap = new HashMap();
        for (i = 0; i < this.speechModels.size(); ++i) {
            if (this.contain(this.languages, this.speechModels.get(i).getLanguage_fa())) continue;
            this.languages.add(this.speechModels.get(i).getLanguage_fa());
            this.descriptions.add(this.speechModels.get(i).getDescription());
            this.lanLanFaHashMap.put(this.speechModels.get(i).getLanguage(), this.speechModels.get(i).getLanguage_fa());
            this.lanFaLanHashMap.put(this.speechModels.get(i).getLanguage_fa(), this.speechModels.get(i).getLanguage());
        }
        this.toggleGroup = new ToggleGroup();
        this.vbox = new VBox();
        for (i = 0; i < this.languages.size(); ++i) {
            String language = this.languages.get(i);
            System.out.println(language);
            JFXRadioButton radioButton = new JFXRadioButton();
            radioButton.setText(language);
            radioButton.setToggleGroup(this.toggleGroup);
            this.setRadioButtonStyle(radioButton);
            this.vbox.getChildren().add((Object)radioButton);
        }
        for (Toggle toggle : this.toggleGroup.getToggles()) {
            this.toggleStringHashMap.put(toggle, ((JFXRadioButton)toggle).getText());
            this.stringToggleHashMap.put(((JFXRadioButton)toggle).getText(), toggle);
        }
        this.setStyle();
        this.vbox.setNodeOrientation(NodeOrientation.RIGHT_TO_LEFT);
        this.langScrollPane.setContent((Node)this.vbox);
        this.toggleGroup.selectedToggleProperty().addListener(this::changed);
        this.setCorrectToggle();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                LanguageSpeechController.this.rootAnchor.setPrefHeight(LanguageSpeechController.this.vbox.getHeight() + 35.0);
            }
        });
    }

    private void enableCorrectToggle() {
        List<SpeechModel> speechModels = SpeechModel.getAllWithModel(this.settings.getStringProperty("grpc.model_name"));
        for (SpeechModel speechModel : speechModels) {
            if (this.lanLanFaHashMap.get(speechModel.getLanguage()) == null) continue;
            ((JFXRadioButton)this.stringToggleHashMap.get(this.lanLanFaHashMap.get(speechModel.getLanguage()))).setDisable(false);
        }
    }

    private void setCorrectToggle() {
        this.toggleGroup.selectToggle(this.stringToggleHashMap.get(this.lanLanFaHashMap.get(this.settings.getStringProperty("grpc.language_code"))));
    }

    private boolean contain(ArrayList<String> languages, String language) {
        for (int i = 0; i < languages.size(); ++i) {
            if (!languages.get(i).equals(language)) continue;
            return true;
        }
        return false;
    }

    @FXML
    void exit(ActionEvent event) {
        this.root.getChildren().remove(this.root.getChildren().size() - 1);
        this.root.getChildren().remove(this.root.getChildren().size() - 1);
    }

    private void setRadioButtonStyle(JFXRadioButton radioButton) {
        radioButton.setStyle("-fx-padding: 0");
        radioButton.setTextFill(Paint.valueOf((String)"#fafafa"));
        radioButton.setFont(Font.font((String)"IranSans", (FontWeight)FontWeight.BOLD, (double)14.0));
        radioButton.setSelectedColor(Color.valueOf((String)"#ffffff"));
        radioButton.setUnSelectedColor(Color.valueOf((String)"#ffffff"));
    }

    private void changed(ObservableValue<? extends Toggle> observable, Toggle oldValue, Toggle newValue) {
        this.settings.setProperty("grpc.language_code", this.lanFaLanHashMap.get(((JFXRadioButton)newValue).getText()));
        boolean flag = false;
        SpeechModel selectedSpeech = null;
        for (SpeechModel speechModel : this.speechModels) {
            if (!speechModel.getLanguage_fa().equals(((JFXRadioButton)newValue).getText())) continue;
            selectedSpeech = speechModel;
            if (!this.settings.getStringProperty("grpc.model_name").equals(speechModel.getName())) continue;
            flag = true;
        }
        if (!flag && selectedSpeech != null) {
            this.settings.setProperty("grpc.model_name", selectedSpeech.getName());
            SettingFormController.modelLabelStatic.setText(selectedSpeech.getLabel());
        }
        SettingFormController.langLabelStatic.setText(((JFXRadioButton)newValue).getText());
        System.out.println(newValue.toString());
    }

    private void setStyle() {
        this.vbox.setStyle("-fx-background-color: #292929;-fx-padding: 12");
        this.vbox.setSpacing(6.0);
        this.vbox.setPrefWidth(-1.0);
        this.vbox.setPrefHeight(-1.0);
    }
}

