/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.controller;

import com.jfoenix.controls.JFXRadioButton;
import ir.deepmine.dictation.controller.SettingFormController;
import ir.deepmine.dictation.database.SpeechModel;
import ir.deepmine.dictation.utils.Settings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.geometry.NodeOrientation;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.util.Duration;

public class LanguageModelController {
    private HashMap<Toggle, String> toggleStringHashMap;
    private HashMap<String, Toggle> stringToggleHashMap;
    private HashMap<String, String> nameLabelHashMap;
    private HashMap<String, String> labelNameHashMap;
    @FXML
    private AnchorPane rootAnchor;
    @FXML
    private ScrollPane modelScrollPane;
    private VBox vbox;
    private AnchorPane root;
    private List<SpeechModel> speechModels;
    private ArrayList<String> models;
    private ArrayList<String> descriptions;
    private ToggleGroup toggleGroup;
    private Settings settings = Settings.getInstance();

    public LanguageModelController(AnchorPane root) {
        this.root = root;
    }

    public void initialize() {
        int i;
        this.speechModels = SpeechModel.getAllWithLang(this.settings.getStringProperty("grpc.language_code"));
        this.models = new ArrayList();
        this.descriptions = new ArrayList();
        this.toggleStringHashMap = new HashMap();
        this.stringToggleHashMap = new HashMap();
        this.nameLabelHashMap = new HashMap();
        this.labelNameHashMap = new HashMap();
        for (i = 0; i < this.speechModels.size(); ++i) {
            if (this.contain(this.models, this.speechModels.get(i).getLabel())) continue;
            this.models.add(this.speechModels.get(i).getLabel());
            this.descriptions.add(this.speechModels.get(i).getDescription());
            this.nameLabelHashMap.put(this.speechModels.get(i).getName(), this.speechModels.get(i).getLabel());
            this.labelNameHashMap.put(this.speechModels.get(i).getLabel(), this.speechModels.get(i).getName());
        }
        this.toggleGroup = new ToggleGroup();
        this.vbox = new VBox();
        for (i = 0; i < this.models.size(); ++i) {
            String model = this.models.get(i);
            System.out.println(model);
            JFXRadioButton radioButton = new JFXRadioButton();
            radioButton.setText(model);
            radioButton.setToggleGroup(this.toggleGroup);
            this.setRadioButtonStyle(radioButton);
            this.vbox.getChildren().add((Object)radioButton);
            Tooltip tooltip = new Tooltip(this.descriptions.get(i));
            tooltip.setShowDelay(Duration.millis((double)500.0));
            tooltip.setFont(Font.font((String)"Vazir", (FontWeight)FontWeight.BOLD, (double)12.0));
            tooltip.setHideDelay(Duration.millis((double)5000.0));
            tooltip.setPrefHeight(90.0);
            tooltip.setWrapText(true);
            tooltip.setPrefWidth(600.0);
            radioButton.setTooltip(tooltip);
        }
        for (Toggle toggle : this.toggleGroup.getToggles()) {
            this.toggleStringHashMap.put(toggle, ((JFXRadioButton)toggle).getText());
            this.stringToggleHashMap.put(((JFXRadioButton)toggle).getText(), toggle);
        }
        this.setStyle();
        this.vbox.setNodeOrientation(NodeOrientation.RIGHT_TO_LEFT);
        this.modelScrollPane.setContent((Node)this.vbox);
        this.toggleGroup.selectedToggleProperty().addListener(this::changed);
        this.setCorrectToggle();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                LanguageModelController.this.rootAnchor.setPrefHeight(LanguageModelController.this.vbox.getHeight() + 35.0);
            }
        });
    }

    private void enableCorrectToggle() {
        List<SpeechModel> speechModels = SpeechModel.getAllWithLang(this.settings.getStringProperty("grpc.language_code"));
        for (SpeechModel speechModel : speechModels) {
            if (this.nameLabelHashMap.get(speechModel.getName()) == null) continue;
            ((JFXRadioButton)this.stringToggleHashMap.get(this.nameLabelHashMap.get(speechModel.getName()))).setDisable(false);
        }
    }

    private void setCorrectToggle() {
        this.toggleGroup.selectToggle(this.stringToggleHashMap.get(this.nameLabelHashMap.get(this.settings.getStringProperty("grpc.model_name"))));
    }

    private boolean contain(ArrayList<String> models, String model) {
        for (int i = 0; i < models.size(); ++i) {
            if (!models.get(i).equals(model)) continue;
            return true;
        }
        return false;
    }

    private void config() {
    }

    @FXML
    void exit(ActionEvent event) {
        this.root.getChildren().remove(this.root.getChildren().size() - 1);
        this.root.getChildren().remove(this.root.getChildren().size() - 1);
    }

    private void setRadioButtonStyle(JFXRadioButton radioButton) {
        radioButton.setStyle("-fx-padding: 0");
        radioButton.setTextFill(Paint.valueOf((String)"#fafafa"));
        radioButton.setFont(Font.font((String)"IranSans", (FontWeight)FontWeight.BOLD, (double)14.0));
        radioButton.setSelectedColor(Color.valueOf((String)"#ffffff"));
        radioButton.setUnSelectedColor(Color.valueOf((String)"#ffffff"));
    }

    private void changed(ObservableValue<? extends Toggle> observable, Toggle oldValue, Toggle newValue) {
        this.settings.setProperty("grpc.model_name", this.labelNameHashMap.get(((JFXRadioButton)newValue).getText()));
        SettingFormController.modelLabelStatic.setText(((JFXRadioButton)newValue).getText());
    }

    private void setStyle() {
        this.vbox.setStyle("-fx-background-color: #292929;-fx-padding: 12");
        this.vbox.setSpacing(6.0);
        this.vbox.setPrefWidth(-1.0);
        this.vbox.setPrefHeight(-1.0);
    }
}

