/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.controller.EditorPageControllers;

import com.jfoenix.controls.JFXButton;
import io.sentry.Sentry;
import ir.deepmine.dictation.Main;
import ir.deepmine.dictation.controller.EditorPageControllers.DownloadController;
import ir.deepmine.dictation.controller.EditorPageControllers.FileToTextPopupController;
import ir.deepmine.dictation.controller.MainPageController;
import ir.deepmine.dictation.controller.PopupController;
import ir.deepmine.dictation.controller.RecordButtonController;
import ir.deepmine.dictation.controller.ResizeHelper;
import ir.deepmine.dictation.database.Document;
import ir.deepmine.dictation.database.DocumentLabel;
import ir.deepmine.dictation.database.Label;
import ir.deepmine.dictation.exceptions.ConnectionException;
import ir.deepmine.dictation.exceptions.ExceptionHandling;
import ir.deepmine.dictation.exceptions.GeneralException;
import ir.deepmine.dictation.exceptions.InvalidTokenException;
import ir.deepmine.dictation.exceptions.NotExistException;
import ir.deepmine.dictation.exceptions.ServerException;
import ir.deepmine.dictation.exceptions.SuccessException;
import ir.deepmine.dictation.ui.ClosableTag;
import ir.deepmine.dictation.ui.FilterComboBox;
import ir.deepmine.dictation.ui.HTMLEditor.HTMLEditor;
import ir.deepmine.dictation.ui.HTMLEditor.HTMLEditorSkin;
import ir.deepmine.dictation.ui.SettingsForm;
import ir.deepmine.dictation.ui.TitleBar;
import ir.deepmine.dictation.ui.notification.Notification;
import ir.deepmine.dictation.ui.notification.Notifications;
import ir.deepmine.dictation.ui.notification.TrayNotification;
import ir.deepmine.dictation.utils.DoActions;
import ir.deepmine.dictation.utils.UserInfo;
import ir.deepmine.dictation.utils.Utilities;
import ir.huri.jcal.JalaliCalendar;
import java.awt.AWTException;
import java.awt.Robot;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.effect.ColorAdjust;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Duration;
import org.jsoup.Jsoup;

public class EditorPageController {
    private static final UserInfo userInfo = UserInfo.getInstance();
    private static final ExceptionHandling exceptionHandling = ExceptionHandling.getInstance();
    public static File selectedFile;
    private final DoActions doActions = DoActions.getInstance();
    private final AtomicBoolean isRecording = new AtomicBoolean(false);
    private final ArrayList<ClosableTag> tags;
    private Tooltip deleteTooltip;
    private Tooltip archiveTooltip;
    private Tooltip copyTooltip;
    @FXML
    private AnchorPane rootAnchor;
    @FXML
    private BorderPane mainPane;
    @FXML
    private Button recordButton;
    @FXML
    private JFXButton copy;
    @FXML
    private JFXButton delete;
    @FXML
    private JFXButton archive;
    @FXML
    private ImageView labelAddButton;
    @FXML
    private ImageView editLabelsButton;
    @FXML
    private ScrollPane labelPane;
    @FXML
    private VBox editorBox;
    @FXML
    private TextField docTitle;
    @FXML
    private Text dateLabel;
    @FXML
    private Pane recordPane;
    @FXML
    private HBox labelAdderTextBox;
    @FXML
    private JFXButton audioFileAdder;
    @FXML
    private HBox titleBar;
    @FXML
    private JFXButton saveButton;
    @FXML
    private JFXButton cancelButton;
    @FXML
    private JFXButton backButton;
    @FXML
    private HBox toolBarBox;
    @FXML
    private JFXButton setting;
    private Robot robot;
    private ArrayList<Label> labels;
    private ArrayList<Label> initialLabel = new ArrayList();
    private ArrayList<DocumentLabel> documentLabels;
    private boolean isTagsInEditState = false;
    private HTMLEditor htmlEditor;
    private Document document;
    private FilterComboBox labelAdderText;
    private boolean isEditable;
    private RecordButtonController recordButtonController;

    public EditorPageController() {
        this.labels = new ArrayList();
        this.tags = new ArrayList();
    }

    public void initialize() {
        RecordButtonController controller;
        TitleBar tb = TitleBar.getInstance("editor");
        this.titleBar.getChildren().add((Object)tb);
        tb.visibleLaunch(false);
        Utilities.isInEditor = true;
        this.labelAddButton.setVisible(false);
        this.editLabelsButton.setVisible(false);
        this.htmlEditor = new HTMLEditor(this.toolBarBox, this.recordButton, this.isRecording, MainPageController.isEditable);
        try {
            this.robot = new Robot();
        }
        catch (AWTException e2) {
            e2.printStackTrace();
        }
        System.out.println("editor: " + this.htmlEditor);
        this.htmlEditor.setPrefHeight(2.147483647E9);
        this.editorBox.getChildren().setAll((Object[])new Node[]{this.htmlEditor});
        this.updateLabelAdderComboBox((ObservableList<String>)FXCollections.observableArrayList());
        this.updateLabelAdderComboBoxItems(Label.getAll(UserInfo.getInstance().getUser_id()));
        this.updateDate();
        ColorAdjust colorAdjust = new ColorAdjust();
        colorAdjust.setBrightness(-0.5);
        this.labelAddButton.addEventFilter(MouseEvent.MOUSE_ENTERED, e -> this.labelAddButton.setEffect((Effect)colorAdjust));
        this.labelAddButton.addEventFilter(MouseEvent.MOUSE_EXITED, e -> this.labelAddButton.setEffect(null));
        this.editLabelsButton.addEventFilter(MouseEvent.MOUSE_ENTERED, e -> this.editLabelsButton.setEffect((Effect)colorAdjust));
        this.editLabelsButton.addEventFilter(MouseEvent.MOUSE_EXITED, e -> this.editLabelsButton.setEffect(null));
        this.htmlEditor.requestFocus();
        this.createToolTip();
        FXMLLoader fxmlLoader = new FXMLLoader();
        fxmlLoader.setLocation(Main.class.getResource("/fxml/recordButton.fxml"));
        this.recordButtonController = controller = new RecordButtonController(this.htmlEditor, this.isRecording);
        fxmlLoader.setController((Object)controller);
        try {
            fxmlLoader.load();
        }
        catch (IOException e3) {
            Sentry.captureException((Throwable)e3);
            e3.printStackTrace();
        }
        Parent recordBtn = (Parent)fxmlLoader.getRoot();
        recordBtn.setLayoutY(10.0);
        this.recordPane.getChildren().add((Object)recordBtn);
        this.docTitle.setFont(Font.font((String)"IranSans", (FontWeight)FontWeight.BOLD, (double)14.0));
    }

    private void createToolTip() {
        this.archiveTooltip = new Tooltip("\u0628\u0627\u06cc\u06af\u0627\u0646\u06cc");
        this.deleteTooltip = new Tooltip("\u062d\u0630\u0641");
        this.copyTooltip = new Tooltip("\u06a9\u067e\u06cc \u0645\u062a\u0646");
        this.archiveTooltip.setFont(Font.font((String)"Vazir", (FontWeight)FontWeight.BLACK, (double)10.0));
        this.deleteTooltip.setFont(Font.font((String)"Vazir", (FontWeight)FontWeight.BLACK, (double)10.0));
        this.copyTooltip.setFont(Font.font((String)"Vazir", (FontWeight)FontWeight.BLACK, (double)10.0));
        this.archiveTooltip.setShowDelay(Duration.millis((double)500.0));
        this.deleteTooltip.setShowDelay(Duration.millis((double)500.0));
        this.copyTooltip.setShowDelay(Duration.millis((double)500.0));
        this.archive.setTooltip(this.archiveTooltip);
        this.delete.setTooltip(this.deleteTooltip);
        this.copy.setTooltip(this.copyTooltip);
    }

    private void updateDate() {
        this.dateLabel.setText(new JalaliCalendar().toString().replace('-', '/'));
    }

    @FXML
    void AddLabelButtonPressed(MouseEvent event) {
    }

    void updateLabelAdderComboBox(ObservableList<String> items) {
        this.labelAdderTextBox.getChildren().clear();
        FilterComboBox filterComboBox = new FilterComboBox(items);
        filterComboBox.setPromptText("\u0627\u0641\u0632\u0648\u062f\u0646 \u062f\u0633\u062a\u0647        ");
        filterComboBox.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                System.out.println("add label");
                EditorPageController.this.addLabel();
            }
        });
        this.labelAdderText = filterComboBox;
        this.labelAdderTextBox.getChildren().add((Object)filterComboBox);
    }

    public void updateLabelAdderComboBoxItems(List<Label> items) {
        ObservableList stringItems = FXCollections.observableArrayList();
        for (Label label : items) {
            stringItems.add((Object)label.getLabel());
        }
        this.updateLabelAdderComboBox((ObservableList<String>)stringItems);
    }

    void addLabel() {
        if (!this.labelAdderText.getEditor().getText().isEmpty()) {
            String labelText = this.labelAdderText.getEditor().getText();
            this.labelAdderText.getEditor().setText("");
            this.labelAddButton.setVisible(false);
            Label label = Label.get(labelText);
            if (label != null && !this.checkExistLabel(label, this.labels)) {
                this.labels.add(label);
                int index = -1;
                ClosableTag newTag = new ClosableTag(new Label(0L, 0L, labelText));
                newTag.getCloseBtn().setOnAction(event1 -> this.removeTag(labelText, newTag));
                newTag.setMinHeight(Double.NEGATIVE_INFINITY);
                newTag.setMaxHeight(Double.NEGATIVE_INFINITY);
                newTag.setMinWidth(Double.NEGATIVE_INFINITY);
                newTag.setMaxWidth(Double.NEGATIVE_INFINITY);
                newTag.setPrefHeight(24.0);
                if (this.isEditable) {
                    newTag.editMode();
                }
                this.tags.add(newTag);
                this.updateLabelPane();
            }
        }
        this.updateLabelAdderComboBox((ObservableList<String>)this.labelAdderText.getItems());
    }

    void updateLabelPane() {
        FlowPane flowPane = new FlowPane();
        flowPane.setPrefWidth(this.labelPane.getWidth() - 25.0);
        flowPane.setMaxWidth(Double.NEGATIVE_INFINITY);
        flowPane.setAlignment(Pos.TOP_RIGHT);
        flowPane.setHgap(4.0);
        flowPane.setVgap(4.0);
        for (Node node : this.tags) {
            flowPane.getChildren().add((Object)node);
        }
        this.labelPane.setContent((Node)flowPane);
    }

    void removeTag(String labelText, ClosableTag tag) {
        int index = -1;
        for (int i = 0; i < this.labels.size(); ++i) {
            if (!this.labels.get(i).getLabel().equals(tag.getLabel().getLabel())) continue;
            index = i;
        }
        if (index != -1) {
            this.labels.remove(index);
        }
        this.tags.remove((Object)tag);
        this.updateLabelPane();
        System.out.println("size init remove: " + this.initialLabel.size());
    }

    @FXML
    void PDFExp(ActionEvent event) {
        Thread thread = new Thread(() -> Platform.runLater(() -> this.getExp("pdf")));
        thread.start();
    }

    @FXML
    void wordExp(ActionEvent event) {
        Thread thread = new Thread(() -> Platform.runLater(() -> this.getExp("docx")));
        thread.start();
    }

    void getExp(String expType) {
        if (this.saveDoc()) {
            FileChooser fileChooser = new FileChooser();
            fileChooser.setTitle("Save As");
            Stage stage = new Stage();
            stage.setResizable(false);
            stage.setAlwaysOnTop(true);
            fileChooser.setInitialFileName(this.docTitle.getText());
            FileChooser.ExtensionFilter filter = new FileChooser.ExtensionFilter((String)(expType.equals("pdf") ? "PDF File" : "Microsoft Office Word File  (*." + expType + ")"), new String[]{"*." + expType});
            fileChooser.getExtensionFilters().add((Object)filter);
            fileChooser.setSelectedExtensionFilter(filter);
            File file = fileChooser.showSaveDialog((Window)stage);
            if (file != null) {
                this.openDownloadPopup(file.getName(), file.getAbsolutePath(), this.document.getUuid(), expType);
            }
        }
    }

    @FXML
    void editLabelsButtonPressed(MouseEvent event) {
        if (!this.isTagsInEditState) {
            for (ClosableTag tag : this.tags) {
                tag.editMode();
            }
            this.isTagsInEditState = true;
            this.editLabelsButton.setImage(new Image("/icons/close_yellow_64.png"));
            this.labelAdderText.setDisable(true);
        } else {
            for (ClosableTag tag : this.tags) {
                tag.normalMode();
            }
            this.editLabelsButton.setImage(new Image("icons/edit.png"));
            this.isTagsInEditState = false;
            this.labelAdderText.setDisable(false);
        }
        this.updateLabelPane();
    }

    public void load(String docUuid, boolean isEditable) {
        this.isEditable = isEditable;
        String init = "<html>\n<head>\n    <meta charset=\"utf-8\">\n    <style type=\"text/css\">\n        .farsi {\n            font-family: Vazir;\n            font-size: medium;\n            direction: rtl;\n            text-align: right;\n            padding-right: 18px;\n        }\n        .english {\n            font-family: Calibri,serif;\n            font-size: 12px;\n            direction: ltr;\n            text-align: left;\n        }\n\n    </style>\n</head>\n";
        if (docUuid != null) {
            this.document = Document.get(docUuid);
            this.docTitle.setText(this.document.getTitle());
            this.htmlEditor.setHtmlText(init + this.document.getContent().trim());
            this.labels = this.document.getLabels();
            for (Label label : this.labels) {
                this.initialLabel.add(new Label(label.getId(), label.getUserId(), label.getLabel()));
            }
            System.out.println("size init: " + this.initialLabel.size());
            if (!isEditable) {
                System.out.println("here1");
                this.saveButton.setVisible(false);
                System.out.println("here2");
                this.cancelButton.setVisible(false);
                System.out.println("here3");
                this.backButton.setVisible(true);
                System.out.println("here4");
                this.recordButtonController.disable();
                System.out.println("here5");
                this.docTitle.setDisable(true);
                System.out.println("here6");
                this.archive.setDisable(true);
                System.out.println("here7");
                this.delete.setDisable(true);
                System.out.println("here8");
                System.out.println("here9");
                this.labelAdderText.setDisable(true);
                System.out.println("here10");
                this.audioFileAdder.setDisable(true);
            }
        } else {
            this.docTitle.setText("");
            this.htmlEditor.setHtmlText(init + "<body class=\"farsi\"><div></div></body>");
            this.labels = new ArrayList();
            this.initialLabel = new ArrayList();
        }
        this.loadTags();
        this.updateLabelPane();
        this.updateDate();
    }

    void setFontSize(HTMLEditorSkin.FontSize fontSize) {
        String html = this.htmlEditor.getHtmlText();
        this.htmlEditor.setHtmlText(html.replaceFirst(HTMLEditorSkin.FontSize.MEDIUM.getFontSize(), fontSize.getFontSize()));
    }

    void removeDocumentLabelFromServer(Label label) {
        if (this.document != null) {
            int size = this.documentLabels.size();
            System.out.println("size doc label: " + size);
            for (int i = 0; i < size; ++i) {
                if (this.documentLabels.get(i).getLabel() != label.getId()) continue;
                try {
                    this.doActions.removeDocumentLabel(this.documentLabels.get(i).getId());
                    this.documentLabels.remove(i);
                    --size;
                    continue;
                }
                catch (NotExistException e) {
                    Sentry.captureException((Throwable)e);
                    e.printStackTrace();
                    continue;
                }
                catch (SuccessException e) {
                    System.out.println("success");
                    continue;
                }
                catch (ConnectionException e) {
                    exceptionHandling.connectionExceptionHandling(e);
                    continue;
                }
                catch (InvalidTokenException e) {
                    exceptionHandling.invalidTokenExceptionHandling(e);
                    continue;
                }
                catch (ServerException e) {
                    exceptionHandling.serverExceptionHandling(e);
                    continue;
                }
                catch (GeneralException e) {
                    exceptionHandling.generalExceptionHandling(e);
                }
            }
        }
    }

    void loadTags() {
        if (this.document != null) {
            this.documentLabels = (ArrayList)DocumentLabel.getAll(UserInfo.getInstance().getUser_id(), this.document.getUuid());
        }
        for (Label label : this.labels) {
            ClosableTag tag = new ClosableTag(label);
            tag.getCloseBtn().setOnAction(event1 -> this.removeTag(label.getLabel(), tag));
            tag.setMinHeight(Double.NEGATIVE_INFINITY);
            tag.setMaxHeight(Double.NEGATIVE_INFINITY);
            tag.setMinWidth(Double.NEGATIVE_INFINITY);
            tag.setMaxWidth(Double.NEGATIVE_INFINITY);
            tag.setPrefHeight(24.0);
            if (this.isEditable) {
                tag.editMode();
            }
            this.tags.add(tag);
        }
    }

    @FXML
    void deleteMoveToTrash(ActionEvent event) {
        boolean saved = this.saveDoc();
        try {
            this.doActions.deleteDocumentMoveToTrash(this.document.getUuid());
        }
        catch (InvalidTokenException e) {
            exceptionHandling.invalidTokenExceptionHandling(e);
        }
        catch (GeneralException e) {
            this.showPopup("\u062e\u0637\u0640\u0640\u0640\u0640\u0640\u0640\u0627 \u062f\u0631 \u0639\u0645\u0644\u06cc\u0640\u0640\u0640\u0640\u0627\u062a.", e.getMessage(), Notifications.ERROR);
        }
        catch (SuccessException e) {
            this.showPopup("\u0639\u0645\u0644\u06cc\u0640\u0640\u0627\u062a \u0628\u0627 \u0645\u0648\u0641\u0642\u06cc\u0640\u0640\u062a \u0627\u0646\u062c\u0640\u0627\u0645 \u0634\u0640\u062f.", e.getMessage(), Notifications.SUCCESS);
            if (saved) {
                this.showMainPage();
            }
        }
        catch (NotExistException e) {
            this.showPopup("\u062e\u0637\u0640\u0640\u0640\u0640\u0640\u0640\u0627 \u062f\u0631 \u0639\u0645\u0644\u06cc\u0640\u0640\u0640\u0640\u0627\u062a.", e.getMessage(), Notifications.ERROR);
        }
        catch (ConnectionException e) {
            this.showPopup("\u062e\u0637\u0640\u0640\u0640\u0640\u0640\u0640\u0627 \u062f\u0631 \u0639\u0645\u0644\u06cc\u0640\u0640\u0640\u0640\u0627\u062a.", e.getMessage(), Notifications.ERROR);
        }
        catch (ServerException e) {
            e.printStackTrace();
        }
    }

    @FXML
    void moveToArchive(ActionEvent event) {
        boolean saved = this.saveDoc();
        try {
            this.doActions.documentMoveToArchive(this.document.getUuid());
        }
        catch (InvalidTokenException e) {
            exceptionHandling.invalidTokenExceptionHandling(e);
        }
        catch (GeneralException e) {
            exceptionHandling.generalExceptionHandling(e);
        }
        catch (SuccessException e) {
            exceptionHandling.successExceptionHandling(e);
            if (saved) {
                this.showMainPage();
            }
        }
        catch (NotExistException e) {
            Sentry.captureException((Throwable)e);
            this.showPopup("\u062e\u0637\u0640\u0640\u0640\u0640\u0640\u0640\u0627 \u062f\u0631 \u0639\u0645\u0644\u06cc\u0640\u0640\u0640\u0640\u0627\u062a.", e.getMessage(), Notifications.ERROR);
        }
        catch (ConnectionException e) {
            exceptionHandling.connectionExceptionHandling(e);
        }
        catch (ServerException e) {
            exceptionHandling.serverExceptionHandling(e);
        }
    }

    @FXML
    void addAudioFile(ActionEvent event) {
        if (userInfo.isHaveGoldenPlan()) {
            FileChooser fileChooser = new FileChooser();
            fileChooser.setTitle("Save As");
            Stage stage = new Stage();
            stage.setResizable(false);
            stage.setAlwaysOnTop(true);
            fileChooser.setInitialFileName(this.docTitle.getText());
            selectedFile = fileChooser.showOpenDialog((Window)stage);
            this.openFileToTextPopup();
        } else {
            TrayNotification tray = new TrayNotification("\u0639\u062f\u0645 \u0627\u0634\u062a\u0631\u0627\u06a9 \u0637\u0644\u0627\u06cc\u06cc", "\u0628\u0631\u0627\u06cc \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0627\u0632 \u0627\u06cc\u0646 \u0642\u0627\u0628\u0644\u06cc\u062a \u0628\u0627\u06cc\u062f \u0627\u0634\u062a\u0631\u0627\u06a9 \u0637\u0644\u0627\u06cc\u06cc \u062e\u0631\u06cc\u062f\u0627\u0631\u06cc \u0646\u0645\u0627\u06cc\u06cc\u062f.", Notifications.NOTICE);
            tray.showAndDismiss();
        }
    }

    void openDownloadPopup(String name, String filePath, String uuid, String format) {
        FXMLLoader fxmlLoader = new FXMLLoader();
        fxmlLoader.setLocation(Main.class.getResource("/fxml/download.fxml"));
        DownloadController downloadController = new DownloadController(name, filePath, uuid, format, this.rootAnchor);
        fxmlLoader.setController((Object)downloadController);
        try {
            fxmlLoader.load();
        }
        catch (IOException e) {
            Sentry.captureException((Throwable)e);
            e.printStackTrace();
        }
        AnchorPane anchorPane = (AnchorPane)fxmlLoader.getRoot();
        AnchorPane blackAnchor = new AnchorPane();
        blackAnchor.setPrefSize(this.rootAnchor.getWidth(), this.rootAnchor.getHeight());
        blackAnchor.setStyle("-fx-background-color: rgb(0,0,0,0.8)");
        this.rootAnchor.getChildren().add((Object)blackAnchor);
        anchorPane.setLayoutX(this.rootAnchor.getWidth() / 2.0 - 140.0);
        anchorPane.setLayoutY(this.rootAnchor.getHeight() / 2.0 - 77.0);
        this.rootAnchor.getChildren().add((Object)anchorPane);
    }

    void openFileToTextPopup() {
        FXMLLoader fxmlLoader = new FXMLLoader();
        fxmlLoader.setLocation(Main.class.getResource("/fxml/file-to-text-popup.fxml"));
        FileToTextPopupController fileToTextPopupController = new FileToTextPopupController(this.htmlEditor, this.rootAnchor, selectedFile.getName());
        fxmlLoader.setController((Object)fileToTextPopupController);
        try {
            fxmlLoader.load();
        }
        catch (IOException e) {
            Sentry.captureException((Throwable)e);
            e.printStackTrace();
        }
        AnchorPane anchorPane = (AnchorPane)fxmlLoader.getRoot();
        AnchorPane blackAnchor = new AnchorPane();
        blackAnchor.setPrefSize(this.rootAnchor.getWidth(), this.rootAnchor.getHeight());
        blackAnchor.setStyle("-fx-background-color: rgb(0,0,0,0.8)");
        this.rootAnchor.getChildren().add((Object)blackAnchor);
        anchorPane.setLayoutX(this.rootAnchor.getWidth() / 2.0 - 140.0);
        anchorPane.setLayoutY(this.rootAnchor.getHeight() / 2.0 - 77.0);
        this.rootAnchor.getChildren().add((Object)anchorPane);
    }

    @FXML
    void cancel(ActionEvent event) {
        if (this.checkChanged()) {
            this.addConfirmPopUp();
        } else {
            this.showMainPage();
        }
    }

    @FXML
    void newFileAdder(ActionEvent event) {
        this.saveDoc();
        this.load(null, true);
    }

    @FXML
    private void save(ActionEvent event) {
        if (this.isEditable && this.saveDoc()) {
            this.showMainPage();
            this.showPopup("\u0639\u0645\u0644\u06cc\u0640\u0640\u0627\u062a \u0628\u0627 \u0645\u0648\u0641\u0642\u06cc\u0640\u0640\u062a \u0627\u0646\u062c\u0640\u0627\u0645 \u0634\u0640\u062f.", "\u0633\u0646\u062f \u0628\u0627 \u0646\u0627\u0645 " + this.docTitle.getText() + " \u0630\u062e\u06cc\u0631\u0647 \u0634\u062f. ", Notifications.SUCCESS);
        }
    }

    @FXML
    void copyText(ActionEvent event) {
        ClipboardContent clipboardContent = new ClipboardContent();
        clipboardContent.putHtml(this.htmlEditor.getHtmlText());
        clipboardContent.putString(Jsoup.parse((String)this.htmlEditor.getHtmlText()).text());
        Clipboard clipboard = Clipboard.getSystemClipboard();
        clipboard.setContent((Map)clipboardContent);
        TrayNotification tray = new TrayNotification("\u062a\u0645\u0627\u0645 \u0645\u062a\u0646 \u0628\u0627 \u0645\u0648\u0641\u0642\u06cc\u062a \u06a9\u067e\u06cc \u0634\u062f.", "", Notifications.SUCCESS);
        tray.showAndDismiss();
    }

    @FXML
    void openSetting(ActionEvent event) {
        SettingsForm.getInstance().setVisible(true);
    }

    @FXML
    void back(ActionEvent event) {
        this.showMainPage();
    }

    private String getNewHtmlText() {
        return Jsoup.parse((String)this.htmlEditor.getHtmlText()).body().html();
    }

    private boolean saveDoc() {
        boolean saveFlag = true;
        if (this.isEditable) {
            if (this.docTitle.getText().isEmpty()) {
                this.showPopup("\u062e\u0640\u0640\u0640\u0640\u0637\u0640\u0640\u0627", "\u0646\u0627\u0645 \u0633\u0646\u062f \u0646\u0645\u06cc \u062a\u0648\u0627\u0646\u062f \u062e\u0627\u0644\u06cc \u0628\u0627\u0634\u062f.", Notifications.ERROR);
                return false;
            }
            String[] htmlTexts = this.htmlEditor.getHtmlText().split("</head>");
            String newHTMLText = htmlTexts[htmlTexts.length - 1];
            if (newHTMLText.contains("</html>")) {
                newHTMLText = newHTMLText.replace("</html>", "");
            }
            if (this.document != null) {
                if (this.checkChanged()) {
                    try {
                        this.document = this.doActions.updateDocument(this.document.getUuid(), this.docTitle.getText(), newHTMLText);
                    }
                    catch (InvalidTokenException e) {
                        saveFlag = false;
                        exceptionHandling.invalidTokenExceptionHandling(e);
                    }
                    catch (GeneralException e) {
                        saveFlag = false;
                        exceptionHandling.generalExceptionHandling(e);
                    }
                    catch (NotExistException e) {
                        saveFlag = false;
                        this.showPopup("\u062e\u0637\u0640\u0640\u0640\u0640\u0640\u0640\u0627 \u062f\u0631 \u0639\u0645\u0644\u06cc\u0640\u0640\u0640\u0640\u0627\u062a.", e.getMessage(), Notifications.ERROR);
                    }
                    catch (ConnectionException e) {
                        saveFlag = false;
                        exceptionHandling.connectionExceptionHandling(e);
                    }
                    catch (ServerException e) {
                        saveFlag = false;
                        exceptionHandling.serverExceptionHandling(e);
                    }
                    ArrayList<Label> initial = this.document.getLabels();
                    for (int i = 0; i < initial.size(); ++i) {
                        System.out.println(initial.get(i).getLabel());
                        boolean flag = false;
                        for (int j = 0; j < this.labels.size(); ++j) {
                            if (!initial.get(i).getLabel().equals(this.labels.get(j).getLabel())) continue;
                            flag = true;
                        }
                        if (flag) continue;
                        this.removeDocumentLabelFromServer(this.document.getLabels().get(i));
                    }
                } else {
                    System.out.println("not changed");
                }
            } else {
                try {
                    System.out.println(this.htmlEditor.getHtmlText());
                    this.document = this.doActions.createDocument(this.docTitle.getText(), newHTMLText);
                    System.out.println("create");
                }
                catch (InvalidTokenException e) {
                    saveFlag = false;
                    exceptionHandling.invalidTokenExceptionHandling(e);
                }
                catch (GeneralException e) {
                    saveFlag = false;
                    exceptionHandling.generalExceptionHandling(e);
                }
                catch (ConnectionException e) {
                    saveFlag = false;
                    exceptionHandling.connectionExceptionHandling(e);
                }
                catch (ServerException e) {
                    saveFlag = false;
                    exceptionHandling.serverExceptionHandling(e);
                }
            }
            for (Label label : this.labels) {
                if (this.checkExistLabel(label, this.document.getLabels())) continue;
                System.out.println("add label");
                try {
                    this.doActions.addLabelToDocument(this.document.getUuid(), label.getId());
                    System.out.println("add label3fvc");
                }
                catch (InvalidTokenException e) {
                    saveFlag = false;
                    exceptionHandling.invalidTokenExceptionHandling(e);
                }
                catch (GeneralException e) {
                    saveFlag = false;
                    exceptionHandling.generalExceptionHandling(e);
                }
                catch (NotExistException e) {
                    saveFlag = false;
                    this.showPopup("\u062e\u0637\u0640\u0640\u0640\u0640\u0640\u0640\u0627 \u062f\u0631 \u0639\u0645\u0644\u06cc\u0640\u0640\u0640\u0640\u0627\u062a.", e.getMessage(), Notifications.ERROR);
                }
                catch (ConnectionException e) {
                    saveFlag = false;
                    exceptionHandling.connectionExceptionHandling(e);
                }
                catch (ServerException e) {
                    saveFlag = false;
                    exceptionHandling.serverExceptionHandling(e);
                }
            }
        }
        return saveFlag;
    }

    private boolean checkExistLabel(Label label, ArrayList<Label> labels) {
        for (int i = 0; i < labels.size(); ++i) {
            if (label.getId() != labels.get(i).getId()) continue;
            return true;
        }
        return false;
    }

    private void showMainPage() {
        System.setProperty("prism.lcdtext", "false");
        Stage stage = (Stage)this.editorBox.getScene().getWindow();
        FXMLLoader fxmlLoader = new FXMLLoader();
        fxmlLoader.setLocation(Main.class.getResource("/fxml/main-page.fxml"));
        try {
            fxmlLoader.load();
        }
        catch (IOException e) {
            Sentry.captureException((Throwable)e);
            e.printStackTrace();
        }
        Parent root = (Parent)fxmlLoader.getRoot();
        Scene scene = stage.getHeight() <= 642.5 || stage.getWidth() <= 1100.0 ? new Scene(root) : new Scene(root, stage.getWidth(), stage.getHeight());
        stage.sizeToScene();
        stage.setScene(scene);
        stage.setResizable(true);
        ResizeHelper.addResizeListener(stage, 960.0, 564.0, Double.MAX_VALUE, Double.MAX_VALUE);
        stage.show();
    }

    private void showPopup(String title, String text, Notification type) {
        TrayNotification tray = new TrayNotification(title, text, type);
        tray.showAndDismiss();
    }

    private void addConfirmPopUp() {
        FXMLLoader fxmlLoader = new FXMLLoader();
        fxmlLoader.setLocation(Main.class.getResource("/fxml/popup.fxml"));
        PopupController popUpController = new PopupController("\u062a\u063a\u06cc\u06cc\u0631\u0627\u062a \u0630\u062e\u06cc\u0631\u0647 \u0646\u062e\u0648\u0627\u0647\u062f \u0634\u062f", "", "\u062a\u0627\u06cc\u06cc\u062f \u0627\u0646\u0635\u0631\u0627\u0641");
        fxmlLoader.setController((Object)popUpController);
        try {
            fxmlLoader.load();
        }
        catch (IOException e) {
            Sentry.captureException((Throwable)e);
            e.printStackTrace();
        }
        AnchorPane anchorPane = (AnchorPane)fxmlLoader.getRoot();
        AnchorPane blackAnchor = new AnchorPane();
        blackAnchor.setPrefSize(this.rootAnchor.getWidth(), this.rootAnchor.getHeight());
        blackAnchor.setStyle("-fx-background-color: rgb(0,0,0,0.8)");
        this.rootAnchor.getChildren().add((Object)blackAnchor);
        anchorPane.setLayoutX(this.rootAnchor.getWidth() / 2.0 - 140.0);
        anchorPane.setLayoutY(this.rootAnchor.getHeight() / 2.0 - 77.0);
        this.rootAnchor.getChildren().add((Object)anchorPane);
        popUpController.getCancelBtn().setOnAction(event -> {
            this.mainPane.setEffect(null);
            this.mainPane.setDisable(false);
            this.closeConfirmPopUp();
        });
        popUpController.getSubmitBtn().setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                EditorPageController.this.mainPane.setEffect(null);
                EditorPageController.this.mainPane.setDisable(false);
                EditorPageController.this.closeConfirmPopUp();
                EditorPageController.this.showMainPage();
            }
        });
    }

    private boolean checkChanged() {
        if (this.document != null) {
            if (!this.docTitle.getText().equals(this.document.getTitle())) {
                System.out.println("here1");
                return true;
            }
            System.out.println(this.getNewHtmlText());
            System.out.println("ali");
            System.out.println(Jsoup.parse((String)this.document.getContent()).body().html());
            if (!this.getNewHtmlText().equals(Jsoup.parse((String)this.document.getContent()).body().html())) {
                System.out.println("here2");
                return true;
            }
            if (this.checkChangeLabel()) {
                System.out.println("here3");
                return true;
            }
            System.out.println("here4");
        } else {
            if (!this.docTitle.getText().isEmpty()) {
                return true;
            }
            System.out.println("html : " + this.getNewHtmlText());
            if (!this.getNewHtmlText().replace("<div></div>", "").isEmpty()) {
                return true;
            }
            if (this.labels.size() > 0) {
                return true;
            }
        }
        return false;
    }

    private boolean checkChangeLabel() {
        System.out.println(this.initialLabel.size());
        System.out.println(this.labels.size());
        if (this.labels.size() != this.initialLabel.size()) {
            System.out.println("here10");
            return true;
        }
        for (int i = 0; i < this.initialLabel.size(); ++i) {
            if (this.checkExistLabel(this.initialLabel.get(i), this.labels)) continue;
            System.out.println("here11");
            return true;
        }
        System.out.println("here12");
        return false;
    }

    private void closeConfirmPopUp() {
        this.rootAnchor.getChildren().remove(this.rootAnchor.getChildren().size() - 1);
        this.rootAnchor.getChildren().remove(this.rootAnchor.getChildren().size() - 1);
    }
}

