/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.controller.EditorPageControllers;

import com.jfoenix.controls.JFXButton;
import ir.deepmine.dictation.Main;
import ir.deepmine.dictation.utils.DoActions;
import java.io.IOException;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.paint.Paint;

public class DownloadController {
    private static Image loadingGif = new Image(Main.class.getResourceAsStream("/icons/loading.gif"));
    private static Image successImage = new Image(Main.class.getResourceAsStream("/icons/ok.png"));
    private static final int tryMaxCount = 4;
    @FXML
    private JFXButton confirm;
    @FXML
    private Label fileName;
    @FXML
    private ImageView loadingOrSuccess;
    @FXML
    private JFXButton showLocation;
    @FXML
    private Label notifLabel;
    @FXML
    private JFXButton cancel;
    @FXML
    private JFXButton reStart;
    private String filePath;
    private String name;
    private AnchorPane rootAnchor;
    private String uuid;
    private String format;
    private String state;
    private Task task;
    int tryCount;

    public DownloadController(String fileName, String filePath, String uuid, String format, AnchorPane rootAnchor) {
        this.name = fileName;
        this.filePath = filePath;
        this.uuid = uuid;
        this.format = format;
        this.rootAnchor = rootAnchor;
    }

    public void initialize() {
        this.fileName.setText(this.name);
        this.notifLabel.setVisible(false);
        this.loadingOrSuccess.setVisible(false);
        this.showLocation.setVisible(false);
        this.confirm.setText("\u0634\u0631\u0648\u0639");
        this.state = "pre_down";
    }

    @FXML
    void confirmClick(ActionEvent event) {
        if (this.state.equals("pre_down")) {
            this.startDownload();
        } else {
            this.exit();
        }
    }

    @FXML
    void cancelClick(ActionEvent event) {
        if (this.task != null) {
            this.task.cancel();
            System.out.println("message: " + this.task.getState());
        }
        this.exit();
    }

    @FXML
    void showLocationClick(ActionEvent event) {
        try {
            Runtime.getRuntime().exec("explorer.exe /select," + this.filePath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @FXML
    void reStartClick(ActionEvent event) {
        this.notifLabel.setVisible(false);
        this.startDownload();
    }

    private void startDownload() {
        this.loadingOrSuccess.setVisible(true);
        this.loadingOrSuccess.setImage(loadingGif);
        this.task = new Task(){

            protected Object call() throws Exception {
                DoActions.getInstance().exportDocument(DownloadController.this.uuid, DownloadController.this.format, DownloadController.this.filePath);
                System.out.println("try: " + DownloadController.this.tryCount);
                return null;
            }
        };
        this.runATask(this.task);
        ++this.tryCount;
    }

    private void runATask(Task task) {
        task.setOnFailed((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent event) {
                if (DownloadController.this.tryCount <= 4) {
                    System.out.println("ry: " + DownloadController.this.tryCount);
                    DownloadController.this.startDownload();
                } else {
                    DownloadController.this.notifLabel.setVisible(true);
                    DownloadController.this.cancel.setVisible(false);
                    DownloadController.this.confirm.setText("\u0627\u0646\u0635\u0631\u0627\u0641");
                    DownloadController.this.confirm.setTextFill(Paint.valueOf((String)"#ef9a9a"));
                    DownloadController.this.confirm.setRipplerFill(Paint.valueOf((String)"#ef9a9a"));
                    DownloadController.this.confirm.setStyle("-fx-background-radius:8;-fx-border-radius:8;-fx-border-color:#ef9a9a;");
                    DownloadController.this.reStart.setVisible(true);
                    DownloadController.this.loadingOrSuccess.setVisible(false);
                    DownloadController.this.state = "fail";
                    DownloadController.this.tryCount = 0;
                }
            }
        });
        task.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent event) {
                DownloadController.this.showLocation.setVisible(true);
                DownloadController.this.loadingOrSuccess.setImage(successImage);
                DownloadController.this.reStart.setVisible(false);
                DownloadController.this.cancel.setVisible(false);
                DownloadController.this.confirm.setText("\u062a\u0627\u06cc\u06cc\u062f");
                DownloadController.this.confirm.setStyle("-fx-background-radius:8;-fx-border-radius:8;-fx-border-color:#ccff90;-fx-text-fill:#ccff90;");
                DownloadController.this.state = "success";
            }
        });
        Thread thread = new Thread((Runnable)task);
        thread.setDaemon(true);
        thread.start();
    }

    private void exit() {
        this.rootAnchor.getChildren().remove(this.rootAnchor.getChildren().size() - 1);
        this.rootAnchor.getChildren().remove(this.rootAnchor.getChildren().size() - 1);
    }
}

