/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.controller;

import com.jfoenix.controls.JFXRadioButton;
import ir.deepmine.dictation.controller.SettingFormController;
import ir.deepmine.dictation.utils.Settings;
import ir.deepmine.dictation.utils.Utilities;
import java.util.HashMap;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.geometry.NodeOrientation;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;

public class DateSeparatorController {
    @FXML
    private AnchorPane rootAnchor;
    @FXML
    private ScrollPane dateSeparatorsScroll;
    private ToggleGroup toggleGroup;
    private HashMap<String, Toggle> stringToggleHashMap;
    private HashMap<String, String> dateSeparatorsHashmap;
    private AnchorPane root;
    private VBox vbox;
    private Settings settings;

    public DateSeparatorController(AnchorPane root) {
        this.root = root;
    }

    public void initialize() {
        this.settings = Settings.getInstance();
        this.stringToggleHashMap = new HashMap();
        this.dateSeparatorsHashmap = Utilities.getDateSeparatorsHashMap();
        this.toggleGroup = new ToggleGroup();
        this.vbox = new VBox();
        ObservableList<String> dateSeparators = Utilities.getDateSeparators();
        for (int i = 0; i < dateSeparators.size(); ++i) {
            System.out.println((String)dateSeparators.get(i));
            JFXRadioButton radioButton = new JFXRadioButton();
            radioButton.setText((String)dateSeparators.get(i) + "   " + this.dateSeparatorsHashmap.get(dateSeparators.get(i)));
            radioButton.setToggleGroup(this.toggleGroup);
            this.setRadioButtonStyle(radioButton);
            this.stringToggleHashMap.put((String)dateSeparators.get(i) + "   " + this.dateSeparatorsHashmap.get(dateSeparators.get(i)), (Toggle)radioButton);
            this.vbox.getChildren().add((Object)radioButton);
        }
        this.setStyle();
        this.vbox.setNodeOrientation(NodeOrientation.RIGHT_TO_LEFT);
        this.dateSeparatorsScroll.setContent((Node)this.vbox);
        this.toggleGroup.selectedToggleProperty().addListener(this::changed);
        this.setCorrectToggle();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                System.out.println("max and pref height: " + DateSeparatorController.this.rootAnchor.getMaxHeight() + " , " + DateSeparatorController.this.rootAnchor.getPrefHeight());
                DateSeparatorController.this.rootAnchor.setPrefHeight(DateSeparatorController.this.vbox.getHeight() + 35.0);
            }
        });
    }

    @FXML
    void exit(ActionEvent event) {
        this.root.getChildren().remove(this.root.getChildren().size() - 1);
        this.root.getChildren().remove(this.root.getChildren().size() - 1);
    }

    private void setStyle() {
        this.vbox.setStyle("-fx-background-color: #292929;-fx-padding: 12");
        this.vbox.setSpacing(6.0);
        this.vbox.setPrefWidth(-1.0);
        this.vbox.setPrefHeight(-1.0);
    }

    private void setRadioButtonStyle(JFXRadioButton radioButton) {
        radioButton.setStyle("-fx-padding: 0");
        radioButton.setTextFill(Paint.valueOf((String)"#fafafa"));
        radioButton.setFont(Font.font((String)"IranSans", (FontWeight)FontWeight.BOLD, (double)14.0));
        radioButton.setSelectedColor(Color.valueOf((String)"#ffffff"));
        radioButton.setUnSelectedColor(Color.valueOf((String)"#ffffff"));
    }

    private void changed(ObservableValue<? extends Toggle> observable, Toggle oldValue, Toggle newValue) {
        this.settings.setProperty("process.date_separator", String.valueOf(((JFXRadioButton)newValue).getText().charAt(0)));
        SettingFormController.dateSeparatorStatic.setText(String.valueOf(((JFXRadioButton)newValue).getText().charAt(0)));
    }

    private void setCorrectToggle() {
        String separator = this.settings.getStringProperty("process.date_separator");
        this.toggleGroup.selectToggle(this.stringToggleHashMap.get(separator + "   " + this.dateSeparatorsHashmap.get(separator)));
    }
}

