/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.controller;

import ir.deepmine.dictation.controller.PlanController;
import ir.deepmine.dictation.database.DefaultPlan;
import ir.deepmine.dictation.exceptions.ConnectionException;
import ir.deepmine.dictation.exceptions.ExceptionHandling;
import ir.deepmine.dictation.exceptions.GeneralException;
import ir.deepmine.dictation.exceptions.InvalidTokenException;
import ir.deepmine.dictation.exceptions.NotExistException;
import ir.deepmine.dictation.exceptions.ServerException;
import ir.deepmine.dictation.ui.CustomGoldenPlan;
import ir.deepmine.dictation.utils.DoActions;
import ir.deepmine.dictation.utils.Utilities;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.FlowPane;

public class BuyPlanController {
    private AnchorPane mainRoot;
    @FXML
    private AnchorPane root;
    @FXML
    private ScrollPane scrollPane;
    private DoActions doActions = DoActions.getInstance();
    private ExceptionHandling exceptionHandling = ExceptionHandling.getInstance();

    public BuyPlanController(AnchorPane mainRoot) {
        this.mainRoot = mainRoot;
    }

    public void initialize() {
        System.out.println("Size: " + this.mainRoot.getChildren().size());
        System.out.println("init1");
        FlowPane planPane = new FlowPane();
        try {
            this.doActions.getDefaultPlans();
        }
        catch (ConnectionException e) {
            this.exceptionHandling.connectionExceptionHandling(e);
        }
        catch (GeneralException e) {
            this.exceptionHandling.generalExceptionHandling(e);
        }
        catch (InvalidTokenException e) {
            this.exceptionHandling.invalidTokenExceptionHandling(e);
        }
        catch (ServerException e) {
            this.exceptionHandling.serverExceptionHandling(e);
        }
        catch (NotExistException e) {
            e.printStackTrace();
        }
        List<DefaultPlan> defaultPlans = DefaultPlan.getAll();
        ArrayList<CustomGoldenPlan> customGoldenPlans = new ArrayList<CustomGoldenPlan>();
        System.out.println("size: " + defaultPlans.size());
        for (DefaultPlan defaultPlan : defaultPlans) {
            if (!defaultPlan.isIs_active() || !defaultPlan.isIs_buyable()) continue;
            final CustomGoldenPlan customGoldenPlan = new CustomGoldenPlan(defaultPlan);
            customGoldenPlan.getBuyButton().addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
                Task task = new Task(){

                    protected Object call() {
                        try {
                            String url = BuyPlanController.this.doActions.buyPaidPlan(customGoldenPlan.getDefaultPlan().getId());
                            if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                                Desktop.getDesktop().browse(new URI(url));
                            }
                        }
                        catch (GeneralException e) {
                            BuyPlanController.this.exceptionHandling.generalExceptionHandling(e);
                        }
                        catch (ServerException e) {
                            BuyPlanController.this.exceptionHandling.serverExceptionHandling(e);
                        }
                        catch (ConnectionException e) {
                            BuyPlanController.this.exceptionHandling.connectionExceptionHandling(e);
                        }
                        catch (URISyntaxException e) {
                            e.printStackTrace();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        return null;
                    }
                };
                Utilities.runATask((Task<Void>)task);
            });
            customGoldenPlans.add(customGoldenPlan);
        }
        System.out.println("init2");
        System.out.println("init3");
        planPane.setVgap(8.0);
        planPane.getChildren().setAll(customGoldenPlans);
        this.scrollPane.setContent((Node)planPane);
    }

    @FXML
    void close(ActionEvent event) {
        this.mainRoot.getChildren().remove(this.mainRoot.getChildren().size() - 1);
        this.mainRoot.getChildren().remove(this.mainRoot.getChildren().size() - 1);
        FXMLLoader fxmlLoader = new FXMLLoader();
        fxmlLoader.setLocation(this.getClass().getResource("/fxml/plan.fxml"));
        PlanController planController = new PlanController(this.mainRoot);
        fxmlLoader.setController((Object)planController);
        try {
            fxmlLoader.load();
            AnchorPane anchorPane = (AnchorPane)fxmlLoader.getRoot();
            AnchorPane blackAnchor = new AnchorPane();
            blackAnchor.setPrefSize(this.mainRoot.getWidth(), this.mainRoot.getHeight());
            blackAnchor.setStyle("-fx-background-color: rgb(0,0,0,0.8)");
            this.mainRoot.getChildren().add((Object)blackAnchor);
            anchorPane.setLayoutX(this.mainRoot.getWidth() / 2.0 - 300.0);
            anchorPane.setLayoutY(this.mainRoot.getHeight() / 2.0 - 250.0);
            this.mainRoot.getChildren().add((Object)anchorPane);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

