/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import ir.deepmine.dictation.api.ContentFromUrl;
import ir.deepmine.dictation.api.DictationService;
import ir.deepmine.dictation.exceptions.TooManyRequestException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.OkHttpClient;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;
import retrofit2.converter.scalars.ScalarsConverterFactory;

public class ServerSingleton {
    private static ServerSingleton instance;
    private final int tryCount;
    private DictationService dictationService;
    private ContentFromUrl contentUrlService;
    private String baseUrl = "https://api.deepmine.ir";
    private String baseContent = "https://file-access.deepmine.ir";
    private int currentTry = 0;

    private ServerSingleton() {
        this.tryCount = 3;
        Gson gson = new GsonBuilder().setLenient().create();
        OkHttpClient okHttpClient = ServerSingleton.getUnsafeOkHttpClient();
        Retrofit retrofit = new Retrofit.Builder().baseUrl(this.baseUrl).client(okHttpClient).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)gson)).build();
        Retrofit retrofitContent = new Retrofit.Builder().baseUrl(this.baseContent).client(okHttpClient).addConverterFactory((Converter.Factory)ScalarsConverterFactory.create()).build();
        this.contentUrlService = (ContentFromUrl)retrofitContent.create(ContentFromUrl.class);
        this.dictationService = (DictationService)retrofit.create(DictationService.class);
    }

    private static OkHttpClient getUnsafeOkHttpClient() {
        try {
            X509TrustManager x509TrustManager = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            };
            TrustManager[] trustAllCerts = new TrustManager[]{x509TrustManager};
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            int serverTimeOut = 20;
            OkHttpClient okHttpClient = new OkHttpClient.Builder().connectTimeout(4L, TimeUnit.SECONDS).readTimeout((long)serverTimeOut, TimeUnit.SECONDS).writeTimeout((long)serverTimeOut, TimeUnit.SECONDS).sslSocketFactory(sslSocketFactory, x509TrustManager).hostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String s, SSLSession sslSession) {
                    return true;
                }
            }).build();
            return okHttpClient;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static synchronized ServerSingleton getInstance() {
        if (instance == null) {
            instance = new ServerSingleton();
        }
        return instance;
    }

    private void createNewService() throws TooManyRequestException {
        ++this.currentTry;
        if (this.currentTry >= 3) {
            throw new TooManyRequestException("");
        }
        this.baseUrl = "https://api.deepmine.ir";
        this.baseContent = "https://file-access.deepmine.ir";
        Gson gson = new GsonBuilder().setLenient().create();
        int serverTimeOut = 20;
        OkHttpClient okHttpClient = new OkHttpClient.Builder().connectTimeout(4L, TimeUnit.SECONDS).readTimeout((long)serverTimeOut, TimeUnit.SECONDS).writeTimeout((long)serverTimeOut, TimeUnit.SECONDS).hostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String s, SSLSession sslSession) {
                return true;
            }
        }).build();
        Retrofit retrofit = new Retrofit.Builder().baseUrl(this.baseUrl).client(okHttpClient).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)gson)).build();
        Retrofit retrofitContent = new Retrofit.Builder().baseUrl(this.baseContent).client(okHttpClient).addConverterFactory((Converter.Factory)ScalarsConverterFactory.create()).build();
        this.contentUrlService = (ContentFromUrl)retrofitContent.create(ContentFromUrl.class);
        this.dictationService = (DictationService)retrofit.create(DictationService.class);
    }

    public HashMap<String, String> getHashMap(JsonObject jsonObject) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Set key = jsonObject.keySet();
        for (int i = 0; i < key.size(); ++i) {
            hashMap.put(String.valueOf(key.toArray()[i]), String.valueOf(jsonObject.get(String.valueOf(key.toArray()[i]))));
        }
        return hashMap;
    }

    public String getMessage(JsonObject jsonObject) {
        return String.valueOf(jsonObject.get("message")).split("\"")[1];
    }

    public String getListString(ArrayList<String> uuids) {
        Object res = "[";
        for (int i = 0; i < uuids.size(); ++i) {
            res = (String)res + "\"" + uuids.get(i) + "\",";
        }
        res = (String)res + "]";
        return res;
    }

    public DictationService getDictationService() {
        return this.dictationService;
    }

    public ContentFromUrl getContentUrlService() {
        return this.contentUrlService;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getBaseContent() {
        return this.baseContent;
    }
}

