/*
 * Decompiled with CFR 0.152.
 */
package com.company;

import com.company.DeviceUUIDCreator;
import com.company.SystemInfoAssisstant;
import java.util.Date;
import java.util.Map;

public class User {
    private long id = 0L;
    private Date creationDate;
    private Date updatedAt;
    private String operationSystem = System.getProperty("os.name");
    private String osRelease;
    private String javaVersion;
    private String display;
    private String manufacturer;
    private String model;
    private String versionName;
    private String deviceId;

    public User(String versionName) {
        Map productInfo = null;
        if (this.operationSystem.contains("Windows")) {
            SystemInfoAssisstant.getWinComputerSystemProductInfo();
        }
        this.javaVersion = System.getProperty("java.version");
        this.creationDate = new Date(System.currentTimeMillis());
        this.osRelease = this.operationSystem.contains("Windows") ? SystemInfoAssisstant.getWinVersion() : SystemInfoAssisstant.getLinuxVersion();
        this.display = SystemInfoAssisstant.getPrimaryResolution();
        this.manufacturer = (String)productInfo.get("Vendor");
        this.model = (String)productInfo.get("Version");
        this.versionName = versionName;
        this.deviceId = new DeviceUUIDCreator(this.operationSystem).getUuid();
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setOperationSystem(String operationSystem) {
        this.operationSystem = operationSystem;
    }

    public void setOsRelease(String osRelease) {
        this.osRelease = osRelease;
    }

    public void setJavaVersion(String javaVersion) {
        this.javaVersion = javaVersion;
    }

    public void setDisplay(String display) {
        this.display = display;
    }

    public void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setVersionName(String versionName) {
        this.versionName = versionName;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public long getId() {
        return this.id;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public String getOperationSystem() {
        return this.operationSystem;
    }

    public String getOsRelease() {
        return this.osRelease;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public String getDisplay() {
        return this.display;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public String getModel() {
        return this.model;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public String getDeviceId() {
        return this.deviceId;
    }
}

