/*
 * Decompiled with CFR 0.152.
 */
package com.company;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;

public class SystemInfoAssisstant {
    public static String getPrimaryResolution() {
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        int width = (int)size.getWidth();
        int height = (int)size.getHeight();
        return width + "x" + height;
    }

    public static String getWindowsMotherBoardSerialNumber() {
        String command = "wmic baseboard get serialnumber";
        Object serialNumber = null;
        try {
            String line;
            Process SerialNumberProcess = Runtime.getRuntime().exec(command);
            InputStreamReader ISR = new InputStreamReader(SerialNumberProcess.getInputStream());
            BufferedReader br = new BufferedReader(ISR);
            while ((line = br.readLine()) != null) {
                serialNumber = (String)serialNumber + line;
            }
            SerialNumberProcess.waitFor();
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            serialNumber = null;
        }
        String[] strings = ((String)serialNumber).split("SerialNumber");
        serialNumber = strings[strings.length - 1].trim();
        return serialNumber;
    }

    public static String getLinuxMotherBoardSerialNumber() {
        String command = "sudo dmidecode -s baseboard-serial-number";
        String serialNumber = null;
        try {
            Process SerialNumberProcess = Runtime.getRuntime().exec(command);
            InputStreamReader ISR = new InputStreamReader(SerialNumberProcess.getInputStream());
            BufferedReader br = new BufferedReader(ISR);
            serialNumber = br.readLine().trim();
            SerialNumberProcess.waitFor();
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            serialNumber = null;
        }
        return serialNumber;
    }

    public static Map<String, String> getLnxComputerSystemProductInfo() {
        String[] propNames = new String[]{"UUID", "Vendor", "Version"};
        HashMap<String, String> map = new HashMap<String, String>();
        String vendorCommand = "less /sys/devices/virtual/dmi/id/board_vendor";
        String versionCommand = "less /sys/devices/virtual/dmi/id/product_version";
        String vendor = null;
        try {
            Process SerialNumberProcess = Runtime.getRuntime().exec(vendorCommand);
            InputStreamReader ISR = new InputStreamReader(SerialNumberProcess.getInputStream());
            BufferedReader br = new BufferedReader(ISR);
            vendor = br.readLine().trim();
            SerialNumberProcess.waitFor();
            br.close();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String version = null;
        try {
            Process SerialNumberProcess = Runtime.getRuntime().exec(versionCommand);
            InputStreamReader ISR = new InputStreamReader(SerialNumberProcess.getInputStream());
            BufferedReader br = new BufferedReader(ISR);
            version = br.readLine().trim();
            SerialNumberProcess.waitFor();
            br.close();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        map.put(propNames[1], vendor);
        map.put(propNames[2], version);
        return map;
    }

    public static String getWindowsCPU_SerialNumber() {
        Object result = "";
        try {
            String line;
            File file = File.createTempFile("realhowto", ".vbs");
            file.deleteOnExit();
            FileWriter fw = new FileWriter(file);
            String vbs1 = "Set objWMIService = GetObject(\"winmgmts:\\\\.\\root\\cimv2\")\nSet colItems = objWMIService.ExecQuery _ \n   (\"Select * from Win32_Processor\") \nFor Each objItem in colItems \n    Wscript.Echo objItem.ProcessorId \n    exit for  ' do the first cpu only! \nNext \n";
            fw.write(vbs1);
            fw.close();
            Process p = Runtime.getRuntime().exec("cscript //NoLogo " + file.getPath());
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = input.readLine()) != null) {
                result = (String)result + line;
            }
            input.close();
        }
        catch (Exception E) {
            System.err.println("Windows CPU Exp : " + E.getMessage());
        }
        return ((String)result).trim();
    }

    public static String getWinVersion() {
        Runtime runtime = Runtime.getRuntime();
        StringBuilder stringBuilder = new StringBuilder();
        String stdOutLine = null;
        String windowsVersion = null;
        try {
            Process process = runtime.exec("cmd.exe /c ver");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((stdOutLine = bufferedReader.readLine()) != null) {
                stringBuilder.append(stdOutLine);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Error while getting Windows version");
        }
        try {
            String[] strings = stringBuilder.toString().split("Version ");
            windowsVersion = strings[strings.length - 1].substring(0, strings[strings.length - 1].length() - 2);
        }
        catch (NoSuchElementException e) {
            windowsVersion = null;
        }
        return windowsVersion;
    }

    public static String getLinuxVersion() {
        String[] cmd = new String[]{"/bin/sh", "-c", "cat /etc/*-release"};
        StringBuilder linuxVersion = new StringBuilder();
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            BufferedReader bri = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = "";
            while ((line = bri.readLine()) != null) {
                if (!line.contains("VERSION_ID")) continue;
                linuxVersion.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return linuxVersion.toString().substring(linuxVersion.indexOf("\"") + 1, linuxVersion.lastIndexOf("\""));
    }

    public static Map<String, String> getWinComputerSystemProductInfo() {
        String vbClassName = "Win32_ComputerSystemProduct";
        String[] propNames = new String[]{"UUID", "Vendor", "Version"};
        HashMap<String, String> map = new HashMap<String, String>();
        String vbScript = SystemInfoAssisstant.makeProductInfoVbScript(vbClassName, propNames);
        try {
            String line;
            File file = File.createTempFile("vbsfile", ".vbs");
            FileWriter fw = new FileWriter(file);
            fw.write(vbScript);
            fw.close();
            Process p = Runtime.getRuntime().exec("cscript //NoLogo " + file.getPath());
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            for (int i = 0; (line = input.readLine()) != null && i < propNames.length; ++i) {
                String key = propNames[i];
                map.put(key, line);
            }
            input.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    private static String makeProductInfoVbScript(String vbClassName, String[] propNames) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < propNames.length; ++i) {
            if (i < propNames.length - 1) {
                sb.append(propNames[i]).append(",");
                continue;
            }
            sb.append(propNames[i]);
        }
        String colNameString = sb.toString();
        sb.setLength(0);
        sb.append("Set objWMIService = GetObject(\"winmgmts:\\\\.\\root\\cimv2\")").append("\n");
        sb.append("Set colItems = objWMIService.ExecQuery _ ").append("\n");
        sb.append("(\"Select ").append(colNameString).append(" from ").append(vbClassName).append("\") ").append("\n");
        sb.append("For Each objItem in colItems ").append("\n");
        for (String propName : propNames) {
            sb.append("    Wscript.Echo objItem.").append(propName).append("\n");
        }
        sb.append("Next ").append("\n");
        return sb.toString();
    }

    public static class GetNetworkAddress {
        public static String GetAddress(String addressType) {
            String address;
            block9: {
                address = "";
                InetAddress lanIp = null;
                try {
                    String ipAddress = null;
                    Enumeration<NetworkInterface> net = null;
                    net = NetworkInterface.getNetworkInterfaces();
                    while (net.hasMoreElements()) {
                        NetworkInterface element = net.nextElement();
                        Enumeration<InetAddress> addresses = element.getInetAddresses();
                        while (element.getHardwareAddress() != null && addresses.hasMoreElements() && element.getHardwareAddress().length > 0 && !GetNetworkAddress.isVMMac(element.getHardwareAddress())) {
                            InetAddress ip = addresses.nextElement();
                            if (!(ip instanceof Inet4Address) || !ip.isSiteLocalAddress()) continue;
                            ipAddress = ip.getHostAddress();
                            lanIp = InetAddress.getByName(ipAddress);
                        }
                    }
                    if (lanIp == null) {
                        return null;
                    }
                    if (addressType.equals("ip")) {
                        address = lanIp.toString().replaceAll("^/+", "");
                        break block9;
                    }
                    if (addressType.equals("mac")) {
                        address = GetNetworkAddress.getMacAddress(lanIp);
                        break block9;
                    }
                    throw new Exception("Specify \"ip\" or \"mac\"");
                }
                catch (UnknownHostException ex) {
                    ex.printStackTrace();
                }
                catch (SocketException ex) {
                    ex.printStackTrace();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            return address;
        }

        private static String getMacAddress(InetAddress ip) {
            String address = null;
            try {
                NetworkInterface network = NetworkInterface.getByInetAddress(ip);
                byte[] mac = network.getHardwareAddress();
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < mac.length; ++i) {
                    sb.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? "-" : ""));
                }
                address = sb.toString();
            }
            catch (SocketException ex) {
                ex.printStackTrace();
            }
            return address;
        }

        private static boolean isVMMac(byte[] mac) {
            byte[][] invalidMacs;
            if (null == mac) {
                return false;
            }
            for (byte[] invalid : invalidMacs = new byte[][]{{0, 5, 105}, {0, 28, 20}, {0, 12, 41}, {0, 80, 86}, {8, 0, 39}, {10, 0, 39}, {0, 3, -1}, {0, 21, 93}}) {
                if (invalid[0] != mac[0] || invalid[1] != mac[1] || invalid[2] != mac[2]) continue;
                return true;
            }
            return false;
        }
    }
}

