/*
 * Decompiled with CFR 0.152.
 */
package com.company;

import com.company.SystemInfoAssisstant;
import java.io.UnsupportedEncodingException;
import java.util.UUID;

public class DeviceUUIDCreator {
    private String uuid;
    private final String WINDOWS_PREFIX = "WIN_";
    private final String LINUX_PREFIX = "LNX_";
    private final String MAC_PREFIX = "MAC_";
    private final String UNKNOWN_OS_PREFIX = "UKN_";
    private final String OSUUID_PREFIX = "OSI_";
    private final String CPU_SERIAL_PREFIX = "CPU_";
    private final String MOTHERBOARD_SERIAL_PREFIX = "MBS_";
    private final String MAC_ADDRESS_PREFIX = "MCA_";
    private final String RANDOM_UUID_PREFIX = "RNM_";

    public DeviceUUIDCreator(String os) {
        String seed = null;
        String RANDOM_ID_PREFIX = null;
        String osPrefix = "";
        osPrefix = os.contains("Windows") ? "WIN_" : (os.contains("Linux") ? "LNX_" : (os.contains("Mac") ? "MAC_" : "UKN_"));
        if (os.contains("Windows")) {
            seed = SystemInfoAssisstant.getWinComputerSystemProductInfo().get("UUID");
            if (seed != null && !seed.isEmpty()) {
                RANDOM_ID_PREFIX = "WIN_OSI_";
            } else {
                seed = SystemInfoAssisstant.getWindowsCPU_SerialNumber();
                if (seed != null && !seed.isEmpty()) {
                    RANDOM_ID_PREFIX = "WIN_OSI_";
                }
            }
        } else if (os.contains("Linux") || os.contains("Mac")) {
            // empty if block
        }
        if (seed != null && !seed.isEmpty()) {
            String string = seed = os.contains("Windows") ? SystemInfoAssisstant.getWindowsMotherBoardSerialNumber() : SystemInfoAssisstant.getLinuxMotherBoardSerialNumber();
            RANDOM_ID_PREFIX = seed != null && !seed.isEmpty() ? (os.contains("Windows") ? "WIN_" : "LNX_MBS_") : ((seed = SystemInfoAssisstant.GetNetworkAddress.GetAddress("mac")) != null && !seed.isEmpty() ? "MCA_" : osPrefix);
        }
        try {
            if (seed != null && !seed.isEmpty()) {
                byte[] arr = seed.getBytes("utf8");
                this.uuid = RANDOM_ID_PREFIX + UUID.nameUUIDFromBytes(arr);
            } else {
                this.uuid = RANDOM_ID_PREFIX + UUID.randomUUID();
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public String getUuid() {
        return this.uuid;
    }
}

