/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.web;

import com.sun.glass.ui.Application;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.scene.web.Debugger;
import com.sun.javafx.scene.web.Printable;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.webkit.Accessor;
import com.sun.javafx.webkit.CursorManagerImpl;
import com.sun.javafx.webkit.EventLoopImpl;
import com.sun.javafx.webkit.ThemeClientImpl;
import com.sun.javafx.webkit.UIClientImpl;
import com.sun.javafx.webkit.UtilitiesImpl;
import com.sun.javafx.webkit.WebPageClientImpl;
import com.sun.javafx.webkit.prism.PrismGraphicsManager;
import com.sun.javafx.webkit.prism.PrismInvoker;
import com.sun.javafx.webkit.prism.theme.PrismRenderer;
import com.sun.javafx.webkit.theme.RenderThemeImpl;
import com.sun.javafx.webkit.theme.Renderer;
import com.sun.webkit.CursorManager;
import com.sun.webkit.Disposer;
import com.sun.webkit.DisposerRecord;
import com.sun.webkit.EventLoop;
import com.sun.webkit.InspectorClient;
import com.sun.webkit.Invoker;
import com.sun.webkit.LoadListenerClient;
import com.sun.webkit.ThemeClient;
import com.sun.webkit.Timer;
import com.sun.webkit.UIClient;
import com.sun.webkit.Utilities;
import com.sun.webkit.WebPage;
import com.sun.webkit.WebPageClient;
import com.sun.webkit.graphics.RenderTheme;
import com.sun.webkit.graphics.WCGraphicsManager;
import com.sun.webkit.network.Util;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Objects;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.concurrent.Worker;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Rectangle2D;
import javafx.print.JobSettings;
import javafx.print.PageLayout;
import javafx.print.PageRange;
import javafx.print.PrinterJob;
import javafx.scene.Node;
import javafx.scene.web.DirectoryLock;
import javafx.scene.web.PopupFeatures;
import javafx.scene.web.PromptData;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebErrorEvent;
import javafx.scene.web.WebEvent;
import javafx.scene.web.WebHistory;
import javafx.scene.web.WebView;
import javafx.util.Callback;
import org.w3c.dom.Document;

/*
 * Exception performing whole class analysis ignored.
 */
public final class WebEngine {
    private static final PlatformLogger logger;
    private static int instanceCount;
    private final ObjectProperty<WebView> view = new SimpleObjectProperty((Object)this, "view");
    private final LoadWorker loadWorker = new LoadWorker(this);
    private final WebPage page;
    private final SelfDisposer disposer;
    private final DebuggerImpl debugger = new DebuggerImpl(this);
    private boolean userDataDirectoryApplied = false;
    private final DocumentProperty document = new DocumentProperty(this);
    private final ReadOnlyStringWrapper location = new ReadOnlyStringWrapper((Object)this, "location");
    private final ReadOnlyStringWrapper title = new ReadOnlyStringWrapper((Object)this, "title");
    private BooleanProperty javaScriptEnabled;
    private StringProperty userStyleSheetLocation;
    private final ObjectProperty<File> userDataDirectory = new SimpleObjectProperty((Object)this, "userDataDirectory");
    private StringProperty userAgent;
    private final ObjectProperty<EventHandler<WebEvent<String>>> onAlert = new SimpleObjectProperty((Object)this, "onAlert");
    private final ObjectProperty<EventHandler<WebEvent<String>>> onStatusChanged = new SimpleObjectProperty((Object)this, "onStatusChanged");
    private final ObjectProperty<EventHandler<WebEvent<Rectangle2D>>> onResized = new SimpleObjectProperty((Object)this, "onResized");
    private final ObjectProperty<EventHandler<WebEvent<Boolean>>> onVisibilityChanged = new SimpleObjectProperty((Object)this, "onVisibilityChanged");
    private final ObjectProperty<Callback<PopupFeatures, WebEngine>> createPopupHandler = new SimpleObjectProperty((Object)this, "createPopupHandler", popupFeatures -> this);
    private final ObjectProperty<Callback<String, Boolean>> confirmHandler = new SimpleObjectProperty((Object)this, "confirmHandler");
    private final ObjectProperty<Callback<PromptData, String>> promptHandler = new SimpleObjectProperty((Object)this, "promptHandler");
    private final ObjectProperty<EventHandler<WebErrorEvent>> onError = new SimpleObjectProperty((Object)this, "onError");
    private final WebHistory history;

    public final Worker<Void> getLoadWorker() {
        return this.loadWorker;
    }

    public final Document getDocument() {
        return (Document)this.document.getValue();
    }

    public final ReadOnlyObjectProperty<Document> documentProperty() {
        return this.document;
    }

    public final String getLocation() {
        return this.location.getValue();
    }

    public final ReadOnlyStringProperty locationProperty() {
        return this.location.getReadOnlyProperty();
    }

    private void updateLocation(String string) {
        this.location.set(string);
        this.document.invalidate(false);
        this.title.set(null);
    }

    public final String getTitle() {
        return this.title.getValue();
    }

    public final ReadOnlyStringProperty titleProperty() {
        return this.title.getReadOnlyProperty();
    }

    private void updateTitle() {
        this.title.set(this.page.getTitle(this.page.getMainFrame()));
    }

    public final void setJavaScriptEnabled(boolean bl) {
        this.javaScriptEnabledProperty().set(bl);
    }

    public final boolean isJavaScriptEnabled() {
        return this.javaScriptEnabled == null ? true : this.javaScriptEnabled.get();
    }

    public final BooleanProperty javaScriptEnabledProperty() {
        if (this.javaScriptEnabled == null) {
            this.javaScriptEnabled = new /* Unavailable Anonymous Inner Class!! */;
        }
        return this.javaScriptEnabled;
    }

    public final void setUserStyleSheetLocation(String string) {
        this.userStyleSheetLocationProperty().set((Object)string);
    }

    public final String getUserStyleSheetLocation() {
        return this.userStyleSheetLocation == null ? null : (String)this.userStyleSheetLocation.get();
    }

    private byte[] readFully(BufferedInputStream bufferedInputStream) throws IOException {
        int n;
        int n2 = 0;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        byte[] byArray = new byte[4096];
        while ((n = bufferedInputStream.read(byArray)) >= 0) {
            byte[] byArray2;
            if (n == byArray.length) {
                byArray2 = byArray;
                byArray = new byte[4096];
            } else {
                byArray2 = new byte[n];
                System.arraycopy(byArray, 0, byArray2, 0, n);
            }
            arrayList.add(byArray2);
            n2 += n;
        }
        byte[] byArray3 = new byte[n2];
        int n3 = 0;
        for (byte[] byArray4 : arrayList) {
            System.arraycopy(byArray4, 0, byArray3, n3, byArray4.length);
            n3 += byArray4.length;
        }
        return byArray3;
    }

    public final StringProperty userStyleSheetLocationProperty() {
        if (this.userStyleSheetLocation == null) {
            this.userStyleSheetLocation = new /* Unavailable Anonymous Inner Class!! */;
        }
        return this.userStyleSheetLocation;
    }

    public final File getUserDataDirectory() {
        return (File)this.userDataDirectory.get();
    }

    public final void setUserDataDirectory(File file) {
        this.userDataDirectory.set((Object)file);
    }

    public final ObjectProperty<File> userDataDirectoryProperty() {
        return this.userDataDirectory;
    }

    public final void setUserAgent(String string) {
        this.userAgentProperty().set((Object)string);
    }

    public final String getUserAgent() {
        return this.userAgent == null ? this.page.getUserAgent() : (String)this.userAgent.get();
    }

    public final StringProperty userAgentProperty() {
        if (this.userAgent == null) {
            this.userAgent = new /* Unavailable Anonymous Inner Class!! */;
        }
        return this.userAgent;
    }

    public final EventHandler<WebEvent<String>> getOnAlert() {
        return (EventHandler)this.onAlert.get();
    }

    public final void setOnAlert(EventHandler<WebEvent<String>> eventHandler) {
        this.onAlert.set(eventHandler);
    }

    public final ObjectProperty<EventHandler<WebEvent<String>>> onAlertProperty() {
        return this.onAlert;
    }

    public final EventHandler<WebEvent<String>> getOnStatusChanged() {
        return (EventHandler)this.onStatusChanged.get();
    }

    public final void setOnStatusChanged(EventHandler<WebEvent<String>> eventHandler) {
        this.onStatusChanged.set(eventHandler);
    }

    public final ObjectProperty<EventHandler<WebEvent<String>>> onStatusChangedProperty() {
        return this.onStatusChanged;
    }

    public final EventHandler<WebEvent<Rectangle2D>> getOnResized() {
        return (EventHandler)this.onResized.get();
    }

    public final void setOnResized(EventHandler<WebEvent<Rectangle2D>> eventHandler) {
        this.onResized.set(eventHandler);
    }

    public final ObjectProperty<EventHandler<WebEvent<Rectangle2D>>> onResizedProperty() {
        return this.onResized;
    }

    public final EventHandler<WebEvent<Boolean>> getOnVisibilityChanged() {
        return (EventHandler)this.onVisibilityChanged.get();
    }

    public final void setOnVisibilityChanged(EventHandler<WebEvent<Boolean>> eventHandler) {
        this.onVisibilityChanged.set(eventHandler);
    }

    public final ObjectProperty<EventHandler<WebEvent<Boolean>>> onVisibilityChangedProperty() {
        return this.onVisibilityChanged;
    }

    public final Callback<PopupFeatures, WebEngine> getCreatePopupHandler() {
        return (Callback)this.createPopupHandler.get();
    }

    public final void setCreatePopupHandler(Callback<PopupFeatures, WebEngine> callback) {
        this.createPopupHandler.set(callback);
    }

    public final ObjectProperty<Callback<PopupFeatures, WebEngine>> createPopupHandlerProperty() {
        return this.createPopupHandler;
    }

    public final Callback<String, Boolean> getConfirmHandler() {
        return (Callback)this.confirmHandler.get();
    }

    public final void setConfirmHandler(Callback<String, Boolean> callback) {
        this.confirmHandler.set(callback);
    }

    public final ObjectProperty<Callback<String, Boolean>> confirmHandlerProperty() {
        return this.confirmHandler;
    }

    public final Callback<PromptData, String> getPromptHandler() {
        return (Callback)this.promptHandler.get();
    }

    public final void setPromptHandler(Callback<PromptData, String> callback) {
        this.promptHandler.set(callback);
    }

    public final ObjectProperty<Callback<PromptData, String>> promptHandlerProperty() {
        return this.promptHandler;
    }

    public final EventHandler<WebErrorEvent> getOnError() {
        return (EventHandler)this.onError.get();
    }

    public final void setOnError(EventHandler<WebErrorEvent> eventHandler) {
        this.onError.set(eventHandler);
    }

    public final ObjectProperty<EventHandler<WebErrorEvent>> onErrorProperty() {
        return this.onError;
    }

    public WebEngine() {
        this(null, false);
    }

    public WebEngine(String string) {
        this(string, true);
    }

    private WebEngine(String string, boolean bl) {
        WebEngine.checkThread();
        AccessorImpl accessorImpl = new AccessorImpl(this);
        this.page = new WebPage((WebPageClient)new WebPageClientImpl((Accessor)accessorImpl), (UIClient)new UIClientImpl((Accessor)accessorImpl), null, (InspectorClient)new InspectorClientImpl(this), (ThemeClient)new ThemeClientImpl((Accessor)accessorImpl), false);
        this.page.addLoadListenerClient((LoadListenerClient)new PageLoadListener(this));
        this.history = new WebHistory(this.page);
        this.disposer = new SelfDisposer(this.page);
        Disposer.addRecord((Object)this, (DisposerRecord)this.disposer);
        if (bl) {
            this.load(string);
        }
        if (instanceCount == 0 && Timer.getMode() == Timer.Mode.PLATFORM_TICKS) {
            PulseTimer.start();
        }
        ++instanceCount;
    }

    public void load(String string) {
        WebEngine.checkThread();
        this.loadWorker.cancelAndReset();
        if (string == null || string.equals("") || string.equals("about:blank")) {
            string = "";
        } else {
            try {
                string = Util.adjustUrlForWebKit((String)string);
            }
            catch (MalformedURLException malformedURLException) {
                this.loadWorker.dispatchLoadEvent(this.getMainFrame(), 0, string, null, 0.0, 0);
                this.loadWorker.dispatchLoadEvent(this.getMainFrame(), 5, string, null, 0.0, 2);
                return;
            }
        }
        this.applyUserDataDirectory();
        this.page.open(this.page.getMainFrame(), string);
    }

    public void loadContent(String string) {
        this.loadContent(string, "text/html");
    }

    public void loadContent(String string, String string2) {
        WebEngine.checkThread();
        this.loadWorker.cancelAndReset();
        this.applyUserDataDirectory();
        this.page.load(this.page.getMainFrame(), string, string2);
    }

    public void reload() {
        WebEngine.checkThread();
        this.page.refresh(this.page.getMainFrame());
    }

    public WebHistory getHistory() {
        return this.history;
    }

    public Object executeScript(String string) {
        WebEngine.checkThread();
        this.applyUserDataDirectory();
        return this.page.executeScript(this.page.getMainFrame(), string);
    }

    private long getMainFrame() {
        return this.page.getMainFrame();
    }

    WebPage getPage() {
        return this.page;
    }

    void setView(WebView webView) {
        this.view.setValue((Object)webView);
    }

    private void stop() {
        WebEngine.checkThread();
        this.page.stop(this.page.getMainFrame());
    }

    private void applyUserDataDirectory() {
        if (this.userDataDirectoryApplied) {
            return;
        }
        this.userDataDirectoryApplied = true;
        File file = this.getUserDataDirectory();
        while (true) {
            Throwable throwable;
            EventType eventType;
            String string;
            File file2;
            String string2;
            File file3;
            if (file == null) {
                file3 = WebEngine.defaultUserDataDirectory();
                string2 = String.format("null (%s)", file3);
            } else {
                file3 = file;
                string2 = file3.toString();
            }
            logger.fine("Trying to apply user data directory [{0}]", new Object[]{string2});
            try {
                File[] fileArray;
                file3 = DirectoryLock.canonicalize((File)file3);
                file2 = new File(file3, "localstorage");
                for (File file4 : fileArray = new File[]{file3, file2}) {
                    WebEngine.createDirectories((File)file4);
                    File file5 = new File(file4, ".test");
                    if (!file5.createNewFile()) continue;
                    file5.delete();
                }
                this.disposer.userDataDirectoryLock = new DirectoryLock(file3);
                this.page.setLocalStorageDatabasePath(file2.getPath());
                this.page.setLocalStorageEnabled(true);
                logger.fine("User data directory [{0}] has been applied successfully", new Object[]{string2});
                return;
            }
            catch (DirectoryLock.DirectoryAlreadyInUseException directoryAlreadyInUseException) {
                string = "User data directory [%s] is already in use";
                eventType = WebErrorEvent.USER_DATA_DIRECTORY_ALREADY_IN_USE;
                throwable = directoryAlreadyInUseException;
            }
            catch (IOException iOException) {
                string = "An I/O error occurred while setting up user data directory [%s]";
                eventType = WebErrorEvent.USER_DATA_DIRECTORY_IO_ERROR;
                throwable = iOException;
            }
            catch (SecurityException securityException) {
                string = "A security error occurred while setting up user data directory [%s]";
                eventType = WebErrorEvent.USER_DATA_DIRECTORY_SECURITY_ERROR;
                throwable = securityException;
            }
            string = String.format(string, string2);
            logger.fine("{0}, calling error handler", new Object[]{string});
            file2 = file;
            this.fireError(eventType, string, throwable);
            file = this.getUserDataDirectory();
            if (Objects.equals(file, file2)) {
                logger.fine("Error handler did not modify user data directory, continuing without user data directory");
                return;
            }
            logger.fine("Error handler has set user data directory to [{0}], retrying", new Object[]{file});
        }
    }

    private static File defaultUserDataDirectory() {
        return new File(Application.GetApplication().getDataDirectory(), "webview");
    }

    private static void createDirectories(File file) throws IOException {
        Path path = file.toPath();
        try {
            Files.createDirectories(path, PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwx------")));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            Files.createDirectories(path, new FileAttribute[0]);
        }
    }

    private void fireError(EventType<WebErrorEvent> eventType, String string, Throwable throwable) {
        EventHandler eventHandler = this.getOnError();
        if (eventHandler != null) {
            eventHandler.handle((Event)new WebErrorEvent((Object)this, eventType, string, throwable));
        }
    }

    void dispose() {
        this.disposer.dispose();
    }

    static void checkThread() {
        Toolkit.getToolkit().checkFxUserThread();
    }

    Debugger getDebugger() {
        return this.debugger;
    }

    private static final boolean printStatusOK(PrinterJob printerJob) {
        switch (4.$SwitchMap$javafx$print$PrinterJob$JobStatus[printerJob.getJobStatus().ordinal()]) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    public void print(PrinterJob printerJob) {
        if (!WebEngine.printStatusOK((PrinterJob)printerJob)) {
            return;
        }
        PageLayout pageLayout = printerJob.getJobSettings().getPageLayout();
        float f = (float)pageLayout.getPrintableWidth();
        float f2 = (float)pageLayout.getPrintableHeight();
        int n = this.page.beginPrinting(f, f2);
        JobSettings jobSettings = printerJob.getJobSettings();
        if (jobSettings.getPageRanges() != null) {
            PageRange[] pageRangeArray;
            for (PageRange pageRange : pageRangeArray = jobSettings.getPageRanges()) {
                for (int i = pageRange.getStartPage(); i <= pageRange.getEndPage() && i <= n; ++i) {
                    if (!WebEngine.printStatusOK((PrinterJob)printerJob)) continue;
                    Printable printable = new Printable(this.page, i - 1, f);
                    printerJob.printPage((Node)printable);
                }
            }
        } else {
            for (int i = 0; i < n; ++i) {
                if (!WebEngine.printStatusOK((PrinterJob)printerJob)) continue;
                Printable printable = new Printable(this.page, i, f);
                printerJob.printPage((Node)printable);
            }
        }
        this.page.endPrinting();
    }

    static {
        Accessor.setPageAccessor(webEngine -> webEngine == null ? null : webEngine.getPage());
        Invoker.setInvoker((Invoker)new PrismInvoker());
        Renderer.setRenderer((Renderer)new PrismRenderer());
        WCGraphicsManager.setGraphicsManager((WCGraphicsManager)new PrismGraphicsManager());
        CursorManager.setCursorManager((CursorManager)new CursorManagerImpl());
        EventLoop.setEventLoop((EventLoop)new EventLoopImpl());
        ThemeClient.setDefaultRenderTheme((RenderTheme)new RenderThemeImpl());
        Utilities.setUtilities((Utilities)new UtilitiesImpl());
        logger = PlatformLogger.getLogger((String)WebEngine.class.getName());
        instanceCount = 0;
    }
}

