/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.grpc;

import com.google.protobuf.ByteString;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.stub.StreamObserver;
import ir.deepmine.speech.v1.RecognitionConfig;
import ir.deepmine.speech.v1.SpeechGrpc;
import ir.deepmine.speech.v1.SpeechRecognitionAlternative;
import ir.deepmine.speech.v1.StreamingRecognitionConfig;
import ir.deepmine.speech.v1.StreamingRecognitionResult;
import ir.deepmine.speech.v1.StreamingRecognizeRequest;
import ir.deepmine.speech.v1.StreamingRecognizeResponse;
import ir.deepmine.speech.v1.WordInfo;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.concurrent.atomic.AtomicBoolean;

public class GrpcTest {
    RecognitionConfig config = RecognitionConfig.newBuilder().setEncoding(RecognitionConfig.AudioEncoding.LINEAR16).setLanguageCode("fa-IR").setSampleRateHertz(16000).setModel("default").setEnableWordConfidence(true).build();
    StreamingRecognitionConfig streamingConfig = StreamingRecognitionConfig.newBuilder().setConfig(this.config).setAccessToken("not_used_yet").setInterimResults(true).setInterimResultsIntervalMilliseconds(500).build();
    final AtomicBoolean finished = new AtomicBoolean(false);

    public static void main(String[] argv) {
        GrpcTest client = new GrpcTest();
        client.runBidiTest();
    }

    private void runBidiTest() {
        byte[] wavArray = this.readWavFile("test_fa.wav");
        ManagedChannel channel = ManagedChannelBuilder.forAddress((String)"deepmine.ir", (int)8443).usePlaintext().build();
        SpeechGrpc.SpeechStub asyncSpeechStub = SpeechGrpc.newStub((Channel)channel);
        ResponseApiStreamingObserver responseObserver = new ResponseApiStreamingObserver();
        StreamObserver<StreamingRecognizeRequest> requestObserver = asyncSpeechStub.bidiStreamingRecognize(responseObserver);
        this.finished.set(false);
        System.out.println("Start sending the data ...");
        requestObserver.onNext((Object)StreamingRecognizeRequest.newBuilder().setStreamingConfig(this.streamingConfig).build());
        int chunkSize = 65536;
        int offset = 0;
        int dataLength = wavArray.length;
        while (true) {
            int size;
            if (offset + (size = chunkSize) > dataLength) {
                size = dataLength - offset;
            }
            requestObserver.onNext((Object)StreamingRecognizeRequest.newBuilder().setAudioContent(ByteString.copyFrom((byte[])wavArray, (int)offset, (int)size)).build());
            if (offset + size >= dataLength) break;
            offset += size;
        }
        requestObserver.onCompleted();
        System.out.println("All data was sent. Waiting for the results ...");
        while (!this.finished.get()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private byte[] readWavFile(String filePath) {
        File fid = new File(filePath);
        try {
            int fileSize = (int)fid.length();
            RandomAccessFile fReader = new RandomAccessFile(fid, "r");
            fReader.seek(44L);
            if (fileSize < 44) {
                return new byte[0];
            }
            byte[] data = new byte[fileSize - 44];
            fReader.readFully(data);
            return data;
        }
        catch (Exception exp) {
            exp.printStackTrace();
            return new byte[0];
        }
    }

    class ResponseApiStreamingObserver
    implements StreamObserver<StreamingRecognizeResponse> {
        ResponseApiStreamingObserver() {
        }

        public void onNext(StreamingRecognizeResponse response) {
            StreamingRecognitionResult result = response.getResultsList().get(0);
            SpeechRecognitionAlternative alternative = result.getAlternativesList().get(0);
            System.out.printf("%s\n", alternative.getTranscript());
            if (result.getIsFinal()) {
                System.out.printf("alternative_confidence: %.4f", Float.valueOf(alternative.getConfidence()));
                for (WordInfo wordInfo : alternative.getWordsList()) {
                    System.out.printf("%.4f  %.4f  %.3f  %s\n", Float.valueOf(wordInfo.getStartTime()), Float.valueOf(wordInfo.getEndTime()), Float.valueOf(wordInfo.getConfidence()), wordInfo.getWord());
                }
            }
        }

        public void onError(Throwable t) {
            t.printStackTrace();
            GrpcTest.this.finished.set(true);
        }

        public void onCompleted() {
            System.out.println("Finished");
            GrpcTest.this.finished.set(true);
        }
    }
}

