/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.utils;

import io.sentry.Sentry;
import ir.deepmine.dictation.Main;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.scene.image.Image;
import org.apache.commons.validator.routines.EmailValidator;

public class Utilities {
    public static boolean isToolBarPunctuation;
    public static boolean startWithToolbar;
    public static boolean isInEditor;
    public static Image icon;
    private static EmailValidator emailValidator;
    public static HashMap<String, String> dateSeparatorsHashMap;
    public static ObservableList<String> dateSeparators;

    public static ObservableList<String> getDateSeparators() {
        if (dateSeparators.size() == 0) {
            dateSeparators.addAll((Object[])new String[]{"/", ".", "-", "\u066b", "#", ",", ":"});
        }
        return dateSeparators;
    }

    public static HashMap<String, String> getDateSeparatorsHashMap() {
        if (dateSeparatorsHashMap.size() == 0) {
            System.out.println("size date : 0");
            dateSeparatorsHashMap.put("/", "(\u0645\u0645\u06cc\u0632 \u0627\u0646\u06af\u0644\u06cc\u0633\u06cc)");
            dateSeparatorsHashMap.put(".", "(\u0646\u0642\u0637\u0647)");
            dateSeparatorsHashMap.put("-", "(\u062e\u0637 \u0641\u0627\u0635\u0644\u0647)");
            dateSeparatorsHashMap.put("\u066b", "(\u0645\u0645\u06cc\u0632 \u0641\u0627\u0631\u0633\u06cc)");
            dateSeparatorsHashMap.put("#", "(\u0647\u0634\u062a\u06af)");
            dateSeparatorsHashMap.put(",", "(\u06a9\u0627\u0645\u0627 \u0627\u0646\u06af\u0644\u06cc\u0633\u06cc)");
            dateSeparatorsHashMap.put(":", "(\u062f\u0648 \u0646\u0642\u0637\u0647)");
        }
        System.out.println("return date");
        return dateSeparatorsHashMap;
    }

    public static String normalizeDigits(String inputString) {
        StringBuilder output = new StringBuilder(inputString);
        for (int i = 0; i < inputString.length(); ++i) {
            String ch;
            String c = ch = String.valueOf(output.charAt(i));
            switch (ch) {
                case "1": {
                    c = "\u06f1";
                    break;
                }
                case "2": {
                    c = "\u06f2";
                    break;
                }
                case "3": {
                    c = "\u06f3";
                    break;
                }
                case "4": {
                    c = "\u06f4";
                    break;
                }
                case "5": {
                    c = "\u06f5";
                    break;
                }
                case "6": {
                    c = "\u06f6";
                    break;
                }
                case "7": {
                    c = "\u06f7";
                    break;
                }
                case "8": {
                    c = "\u06f8";
                    break;
                }
                case "9": {
                    c = "\u06f9";
                    break;
                }
                case "0": {
                    c = "\u06f0";
                    break;
                }
            }
            if (c.equals(ch)) continue;
            output.setCharAt(i, c.charAt(0));
        }
        return output.toString();
    }

    public static boolean validatePhoneNumber(String mobNumber) {
        String regex = "^09\\d{9}$";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(mobNumber);
        return matcher.matches();
    }

    public static boolean validatePassword(String password) {
        String regex = "^(?=.*[a-z])(?=.*[A-Z])(?=.*\\d)[a-zA-Z\\d]{8,}$";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(password);
        System.out.println(matcher.matches());
        return matcher.matches();
    }

    public static String join(CharSequence delimiter, Iterable<? extends CharSequence> elements) {
        Iterator<? extends CharSequence> iterator = elements.iterator();
        if (!iterator.hasNext()) {
            return "";
        }
        StringBuilder builder = new StringBuilder(64);
        builder.append(iterator.next());
        while (iterator.hasNext()) {
            builder.append(delimiter);
            builder.append(iterator.next());
        }
        return builder.toString();
    }

    public static boolean validateEmail(String email) {
        return emailValidator.isValid(email);
    }

    public static String convertFile(String inputFile) {
        String command = String.format("bin/convert/ffmpeg -loglevel quiet -i \"%s\" -ar 16000 -ac 1 -f s16le bin/convert/temp.wav", inputFile);
        try {
            File temp = new File("bin/convert/temp.wav");
            if (temp.exists() && !temp.delete()) {
                return null;
            }
            Process p = Runtime.getRuntime().exec(command);
            p.waitFor();
            temp = new File("bin/convert/temp.wav");
            if (temp.exists()) {
                return "bin/convert/temp.wav";
            }
            return null;
        }
        catch (IOException | InterruptedException exp) {
            exp.printStackTrace();
            return null;
        }
    }

    public static void runATask(Task<Void> task) {
        task.setOnSucceeded(event -> System.out.println("success"));
        task.setOnCancelled(event -> System.out.println("cancel"));
        task.setOnFailed(event -> {
            task.getException().printStackTrace();
            Sentry.captureException((Throwable)task.getException());
            System.out.println("failed");
        });
        Thread th = new Thread((Runnable)task);
        th.setDaemon(true);
        th.start();
    }

    public static String getFileChecksum(MessageDigest digest, File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        byte[] byteArray = new byte[1024];
        int bytesCount = 0;
        while ((bytesCount = fis.read(byteArray)) != -1) {
            digest.update(byteArray, 0, bytesCount);
        }
        fis.close();
        byte[] bytes = digest.digest();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(Integer.toString((bytes[i] & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    static {
        icon = new Image(String.valueOf(Main.class.getResource("/icons/zi-round-transparent.png")));
        emailValidator = EmailValidator.getInstance();
        dateSeparatorsHashMap = new HashMap();
        dateSeparators = FXCollections.observableArrayList();
    }
}

