/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.utils;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class Settings {
    public static final String APP_VERSION_NAME = "\u06f1.\u06f0.\u06f1";
    public static final int APP_VERSION_CODE = 10001;
    public static final String SAMPLE_RATE = "recorder.sample_rate";
    public static final String BUFFER_SIZE = "recorder.buffer_size";
    public static final String IDLE_TIME = "recorder.idle_time";
    public static final String GRPC_ADDRESS = "grpc.address";
    public static final String GRPC_PORT = "grpc.port";
    public static final String GRPC_LANGUAGE_CODE = "grpc.language_code";
    public static final String GRPC_MODEL_NAME = "grpc.model_name";
    public static final String APPLY_PUNCTUATION = "process.apply_punctuation";
    public static final String APPLY_NUMBERS = "process.apply_numbers";
    public static final String APPLY_DATETIME = "process.apply_datetime";
    public static final String APPLY_PHONE_NUMBERS = "process.apply_phone_numbers";
    public static final String DOCUMENT_SORT_ORDER = "document_sort.order";
    public static final String DOCUMENT_SORT_ON = "document_sort.sort_on";
    public static final String APP_MODE = "app_mode.mode";
    public static final String TYPE_TO_WORD = "process.type_to_word";
    public static final String DATE_SEPARATOR = "process.date_separator";
    private static final String PROPERTIES_FILE = "resources/config.properties";
    private static Settings instance = null;
    private final Properties prop = new Properties();

    private Settings() {
        try (FileInputStream input = new FileInputStream(PROPERTIES_FILE);){
            this.prop.load(input);
            if (!this.prop.stringPropertyNames().contains(DATE_SEPARATOR)) {
                this.prop.setProperty(DATE_SEPARATOR, "/");
            }
        }
        catch (IOException ex) {
            this.initProperties();
        }
    }

    public static synchronized Settings getInstance() {
        if (instance == null) {
            instance = new Settings();
        }
        return instance;
    }

    private void initProperties() {
        this.prop.setProperty(SAMPLE_RATE, "16000");
        this.prop.setProperty(BUFFER_SIZE, "4000");
        this.prop.setProperty(IDLE_TIME, "6");
        this.prop.setProperty(GRPC_ADDRESS, "grpc.deepmine.ir");
        this.prop.setProperty(GRPC_PORT, "443");
        this.prop.setProperty(GRPC_LANGUAGE_CODE, "fa-IR");
        this.prop.setProperty(GRPC_MODEL_NAME, "dictation");
        this.prop.setProperty(APPLY_PUNCTUATION, "false");
        this.prop.setProperty(APPLY_NUMBERS, "false");
        this.prop.setProperty(APPLY_DATETIME, "false");
        this.prop.setProperty(APPLY_PHONE_NUMBERS, "false");
        this.prop.setProperty(DOCUMENT_SORT_ORDER, "ascending");
        this.prop.setProperty(DOCUMENT_SORT_ON, "title");
        this.prop.setProperty(APP_MODE, "main_page");
        this.prop.setProperty(TYPE_TO_WORD, "false");
        this.prop.setProperty(DATE_SEPARATOR, "/");
        this.saveProperties();
    }

    private void saveProperties() {
        try (FileOutputStream output = new FileOutputStream(PROPERTIES_FILE);){
            this.prop.store(output, "Deepmine Dictation Config File");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public String getStringProperty(String propertyKey) {
        return this.prop.getProperty(propertyKey);
    }

    public int getIntegerProperty(String propertyKey) {
        return Integer.parseInt(this.prop.getProperty(propertyKey));
    }

    public boolean getBooleanProperty(String propertyKey) {
        return Boolean.parseBoolean(this.prop.getProperty(propertyKey));
    }

    public void setProperty(String propertyKey, String propertyValue) {
        this.prop.setProperty(propertyKey, propertyValue);
        this.saveProperties();
    }
}

