/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.utils;

import com.google.gson.Gson;
import com.google.protobuf.ByteString;
import io.grpc.CallCredentials;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyChannelBuilder;
import io.grpc.stub.StreamObserver;
import io.netty.handler.ssl.SslContext;
import io.sentry.Sentry;
import ir.deepmine.dictation.exceptions.ConnectionException;
import ir.deepmine.dictation.exceptions.ExceptionHandling;
import ir.deepmine.dictation.exceptions.GeneralException;
import ir.deepmine.dictation.exceptions.InvalidTokenException;
import ir.deepmine.dictation.exceptions.ServerException;
import ir.deepmine.dictation.ui.notification.Notifications;
import ir.deepmine.dictation.ui.notification.TrayNotification;
import ir.deepmine.dictation.utils.GrpcExceptionsHelper;
import ir.deepmine.dictation.utils.Settings;
import ir.deepmine.dictation.utils.UserInfo;
import ir.deepmine.speech.v1.RecognitionConfig;
import ir.deepmine.speech.v1.SpeechGrpc;
import ir.deepmine.speech.v1.SpeechRecognitionAlternative;
import ir.deepmine.speech.v1.StreamingRecognitionConfig;
import ir.deepmine.speech.v1.StreamingRecognitionResult;
import ir.deepmine.speech.v1.StreamingRecognizeRequest;
import ir.deepmine.speech.v1.StreamingRecognizeResponse;
import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import javafx.application.Platform;
import javax.net.ssl.SSLException;

public class GrpcClient {
    private final Settings settings = Settings.getInstance();
    private final ExceptionHandling exceptionHandling = ExceptionHandling.getInstance();
    private final StreamingRecognitionConfig streamingConfig;
    private ManagedChannel channel;
    private StreamObserver<StreamingRecognizeRequest> requestObserver;
    private boolean isChannelStarted;
    private SslContext sslContext;
    private OAuthToken accessTokenAut;
    private final ArrayList<ResultObserver> observers = new ArrayList(2);

    public GrpcClient(String accessToken) {
        this(accessToken, 16000);
    }

    public GrpcClient(String accessToken, int sampleRate) {
        this(accessToken, sampleRate, "fa-IR");
    }

    public GrpcClient(String accessToken, int sampleRate, String languageCode) {
        this(accessToken, sampleRate, languageCode, "default");
    }

    public GrpcClient(String accessToken, int sampleRate, String languageCode, String modelName) {
        this(accessToken, sampleRate, languageCode, modelName, null);
    }

    public GrpcClient(String accessToken, int sampleRate, String languageCode, String modelName, ResultObserver observer) {
        RecognitionConfig config = RecognitionConfig.newBuilder().setEncoding(RecognitionConfig.AudioEncoding.LINEAR16).setLanguageCode(languageCode).setSampleRateHertz(sampleRate).setModel(modelName).setEnableWordConfidence(true).build();
        this.streamingConfig = StreamingRecognitionConfig.newBuilder().setConfig(config).setInterimResults(true).setInterimResultsIntervalMilliseconds(500).build();
        this.observers.add(observer);
        this.isChannelStarted = false;
    }

    public void addObserver(ResultObserver observer) {
        this.observers.add(observer);
    }

    public synchronized void start() throws SSLException {
        File trustedCertificate;
        if (this.isChannelStarted) {
            System.out.println("The channel was already started.");
            return;
        }
        if (this.channel != null && !this.channel.isShutdown()) {
            System.out.println("Channel is not null. Try to shutdown it.");
            try {
                this.channel.shutdownNow();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!(trustedCertificate = new File("resources/server.crt")).exists()) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    TrayNotification tray = new TrayNotification("\u0645\u062c\u0648\u0632 \u0646\u0627\u0645\u062a\u0639\u0628\u0631", "\u0645\u062c\u0648\u0632 \u0627\u0646\u062c\u0627\u0645 \u062a\u0627\u06cc\u067e \u0635\u0648\u062a\u06cc \u0648\u062c\u0648\u062f \u0646\u062f\u0627\u0631\u062f.", Notifications.INFORMATION);
                    tray.showAndDismiss();
                }
            });
            throw new SSLException("\u0645\u062c\u0648\u0632 \u062f\u0633\u062a\u0631\u0633\u06cc \u0627\u0631\u0627\u0626\u0647 \u0646\u0634\u062f\u0647 \u0627\u0633\u062a.");
        }
        this.sslContext = GrpcSslContexts.forClient().trustManager(trustedCertificate).build();
        this.channel = NettyChannelBuilder.forAddress((String)this.settings.getStringProperty("grpc.address"), (int)this.settings.getIntegerProperty("grpc.port")).sslContext(this.sslContext).build();
        this.accessTokenAut = new OAuthToken(UserInfo.getInstance().getAccess());
        SpeechGrpc.SpeechStub asyncSpeechStub = (SpeechGrpc.SpeechStub)SpeechGrpc.newStub((Channel)this.channel).withCallCredentials(this.accessTokenAut);
        ResponseApiStreamingObserver responseObserver = new ResponseApiStreamingObserver();
        this.requestObserver = asyncSpeechStub.bidiStreamingRecognize(responseObserver);
        System.out.println("Start sending the streamingConfig ...");
        this.requestObserver.onNext((Object)StreamingRecognizeRequest.newBuilder().setStreamingConfig(this.streamingConfig).build());
        this.isChannelStarted = true;
    }

    public void processNextBuffer(byte[] buffer) {
        this.processNextBuffer(buffer, 0, buffer.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processNextBuffer(byte[] buffer, int offset, int size) {
        if (!this.isChannelStarted) {
            throw new IllegalStateException("The channel not started yet. You should call start method first");
        }
        GrpcClient grpcClient = this;
        synchronized (grpcClient) {
            this.requestObserver.onNext((Object)StreamingRecognizeRequest.newBuilder().setAudioContent(ByteString.copyFrom((byte[])buffer, (int)offset, (int)size)).build());
        }
    }

    public void finish() {
        this.requestObserver.onCompleted();
        this.channel.shutdown();
        this.isChannelStarted = false;
    }

    public static class OAuthToken
    extends CallCredentials {
        private final String value;

        public OAuthToken(String value) {
            this.value = value;
        }

        public void applyRequestMetadata(CallCredentials.RequestInfo requestInfo, Executor executor, CallCredentials.MetadataApplier metadataApplier) {
            executor.execute(() -> {
                try {
                    Metadata headers = new Metadata();
                    Metadata.Key key = Metadata.Key.of((String)"access-token", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
                    headers.put(key, (Object)this.value);
                    metadataApplier.apply(headers);
                }
                catch (Throwable e) {
                    metadataApplier.fail(Status.UNAUTHENTICATED.withCause(e));
                }
            });
        }

        public void thisUsesUnstableApi() {
        }
    }

    private class ResponseApiStreamingObserver
    implements StreamObserver<StreamingRecognizeResponse> {
        private ResponseApiStreamingObserver() {
        }

        public void onNext(StreamingRecognizeResponse response) {
            String nonStableResult;
            String stableResult;
            StreamingRecognitionResult result = response.getResultsList().get(0);
            SpeechRecognitionAlternative alternative = result.getAlternativesList().get(0);
            float lastWordTime = 0.0f;
            if (response.getResultsList().size() > 1) {
                stableResult = alternative.getTranscript();
                nonStableResult = response.getResultsList().get(1).getAlternativesList().get(0).getTranscript();
            } else if (result.getIsFinal()) {
                stableResult = alternative.getTranscript();
                nonStableResult = "";
                lastWordTime = alternative.getWords(alternative.getWordsCount() - 1).getEndTime();
            } else {
                stableResult = "";
                nonStableResult = alternative.getTranscript();
            }
            for (ResultObserver observer : GrpcClient.this.observers) {
                observer.onNext(stableResult, nonStableResult, result.getIsFinal(), lastWordTime);
            }
        }

        public void onError(Throwable t) {
            block9: {
                Sentry.captureException((Throwable)t);
                try {
                    UserInfo.getInstance().syncPlans();
                }
                catch (ConnectionException e) {
                    GrpcClient.this.exceptionHandling.connectionExceptionHandling(e);
                }
                catch (GeneralException e) {
                    GrpcClient.this.exceptionHandling.generalExceptionHandling(e);
                }
                catch (InvalidTokenException e) {
                    GrpcClient.this.exceptionHandling.invalidTokenExceptionHandling(e);
                }
                catch (ServerException e) {
                    GrpcClient.this.exceptionHandling.serverExceptionHandling(e);
                }
                System.out.println("onError: " + t.getMessage());
                try {
                    GrpcExceptionsHelper helper = (GrpcExceptionsHelper)new Gson().fromJson("{" + t.getMessage().split(": \\{")[1], GrpcExceptionsHelper.class);
                    ExceptionHandling.getInstance().grpcExceptionHandling(helper);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    if (!t.getMessage().contains("UNAVAILABLE")) break block9;
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            TrayNotification tray = new TrayNotification("\u062e\u0637\u0627 \u062f\u0631 \u0639\u0645\u0644\u06cc\u0627\u062a", "\u0633\u0631\u0648\u0631 \u062f\u0631 \u062f\u0633\u062a\u0631\u0633 \u0646\u06cc\u0633\u062a\u060c \u0644\u0637\u0641\u0627 \u0628\u0639\u062f\u0627 \u062a\u0644\u0627\u0634 \u06a9\u0646\u06cc\u062f.", Notifications.NOTICE);
                            tray.showAndDismiss();
                        }
                    });
                }
            }
            if (!UserInfo.getInstance().isHaveGoldenPlan()) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        TrayNotification tray = new TrayNotification("\u0627\u062a\u0645\u0627\u0645 \u0627\u0634\u062a\u0631\u0627\u06a9 \u0637\u0644\u0627\u06cc\u06cc", "\u0627\u0634\u062a\u0631\u0627\u06a9 \u0637\u0644\u0627\u06cc\u06cc \u0634\u0645\u0627 \u0628\u0647 \u0627\u062a\u0645\u0627\u0645 \u0631\u0633\u06cc\u062f\u0647 \u0627\u0633\u062a.", Notifications.INFORMATION);
                        tray.showAndDismiss();
                    }
                });
            }
            for (ResultObserver observer : GrpcClient.this.observers) {
                observer.onError(t);
            }
        }

        public void onCompleted() {
            System.out.println("onCompleted: Finished");
            for (ResultObserver observer : GrpcClient.this.observers) {
                observer.onCompleted();
            }
        }
    }

    public static interface ResultObserver {
        public void onNext(String var1, String var2, boolean var3, float var4);

        public void onError(Throwable var1);

        public void onCompleted();
    }
}

