/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.utils;

import ir.deepmine.dictation.utils.Constants;
import ir.deepmine.dictation.utils.PunctuationsProcessing;
import ir.deepmine.dictation.utils.WordToNumber;
import java.util.HashSet;
import java.util.regex.Pattern;

public class Formatter {
    private static final boolean fixLineSeparator = !System.lineSeparator().equals("\n");
    private static final String lineSeparator = System.lineSeparator();
    private static final PunctuationsProcessing punctuations = PunctuationsProcessing.getInstance();
    private static final WordToNumber wordToNumber = WordToNumber.getInstance();
    private static final Pattern spacePattern = Pattern.compile("( \u0277|\u0277 |\u0277)");
    private static final HashSet<String> knownWords = new HashSet();

    public static String apply(String input, boolean convertPunctuations, boolean convertGeneralNumber, boolean convertDateAndTime, boolean convertPhoneNumber) {
        return Formatter.apply(input, convertPunctuations, convertGeneralNumber, convertDateAndTime, convertPhoneNumber, false, '/');
    }

    public static String apply(String input, boolean convertPunctuations, boolean convertGeneralNumber, boolean convertDateAndTime, boolean convertPhoneNumber, boolean typeToWord, char dateDelimiter) {
        boolean changed = false;
        if (convertPunctuations) {
            input = punctuations.apply(input);
            changed = true;
        }
        if (convertGeneralNumber || convertDateAndTime || convertPhoneNumber) {
            input = wordToNumber.convert(input, convertGeneralNumber, convertDateAndTime, convertPhoneNumber, typeToWord, dateDelimiter);
            changed = true;
        } else if (changed) {
            input = input.replace("\u0239", "");
        }
        if (changed) {
            input = spacePattern.matcher(input).replaceAll("");
            input = input.replace("\u0238", " ");
            if (fixLineSeparator) {
                input = input.replace("\n", lineSeparator);
            }
        }
        return input;
    }

    public static boolean isSafeToFinalize(String inputString) {
        String[] words = inputString.split(" ");
        if (words.length == 0) {
            return false;
        }
        if (words.length > 1 && words[words.length - 1].equals("\u0648") && knownWords.contains(words[words.length - 2])) {
            return false;
        }
        return !knownWords.contains(words[words.length - 1]);
    }

    static {
        knownWords.addAll(Constants.basicForms.keySet());
        knownWords.addAll(Constants.decimalForms.keySet());
        knownWords.addAll(Constants.scaleForms.keySet());
    }
}

