/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.utils;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;

public class EnergyCalculator {
    private int maxEnergyLevel = 0;
    private final ByteBuffer unprocessedBuffer;
    private static EnergyCalculator instance = null;

    private EnergyCalculator(int sampleRate) {
        this.unprocessedBuffer = ByteBuffer.allocate(2 * sampleRate * 2);
        this.unprocessedBuffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    public static synchronized EnergyCalculator getInstance(int sampleRate) {
        if (instance == null) {
            instance = new EnergyCalculator(sampleRate);
        }
        return instance;
    }

    public int processBuffer(byte[] buffer, int length) {
        this.unprocessedBuffer.clear();
        this.unprocessedBuffer.put(buffer, 0, length);
        this.unprocessedBuffer.position(0);
        int frameSize = length / 2;
        ShortBuffer segment = this.unprocessedBuffer.asShortBuffer();
        double energy = 0.0;
        for (int i = 0; i < frameSize; ++i) {
            float amplitudeValue = segment.get(i);
            energy += (double)(amplitudeValue * amplitudeValue);
        }
        int energyLevel = (int)(Math.sqrt(energy / (double)frameSize) / 32767.0 * 100.0);
        if (energyLevel > this.maxEnergyLevel) {
            this.maxEnergyLevel = energyLevel;
        }
        energyLevel = Math.min(300 * energyLevel / (2 * this.maxEnergyLevel + 75), 100);
        return energyLevel;
    }
}

