/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.utils;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import io.sentry.Sentry;
import ir.deepmine.dictation.api.ContentFromUrl;
import ir.deepmine.dictation.api.DictationService;
import ir.deepmine.dictation.api.ServerSingleton;
import ir.deepmine.dictation.database.Accent;
import ir.deepmine.dictation.database.DefaultPlan;
import ir.deepmine.dictation.database.DefaultPunctuationMark;
import ir.deepmine.dictation.database.Document;
import ir.deepmine.dictation.database.DocumentLabel;
import ir.deepmine.dictation.database.Education;
import ir.deepmine.dictation.database.FileNameHashCode;
import ir.deepmine.dictation.database.Label;
import ir.deepmine.dictation.database.Plan;
import ir.deepmine.dictation.database.Province;
import ir.deepmine.dictation.database.PunctuationMark;
import ir.deepmine.dictation.database.SpeechModel;
import ir.deepmine.dictation.database.UserData;
import ir.deepmine.dictation.exceptions.AlreadyExistException;
import ir.deepmine.dictation.exceptions.ConnectionException;
import ir.deepmine.dictation.exceptions.ExpiredCodeVerificationException;
import ir.deepmine.dictation.exceptions.GeneralException;
import ir.deepmine.dictation.exceptions.InvalidCodeVerificationException;
import ir.deepmine.dictation.exceptions.InvalidDataException;
import ir.deepmine.dictation.exceptions.InvalidFormatException;
import ir.deepmine.dictation.exceptions.InvalidTokenException;
import ir.deepmine.dictation.exceptions.NotExistException;
import ir.deepmine.dictation.exceptions.ServerException;
import ir.deepmine.dictation.exceptions.SuccessException;
import ir.deepmine.dictation.exceptions.TooManyRequestException;
import ir.deepmine.dictation.exceptions.UserNotFoundException;
import ir.deepmine.dictation.ui.notification.Notifications;
import ir.deepmine.dictation.ui.notification.TrayNotification;
import ir.deepmine.dictation.utils.ApiResponse;
import ir.deepmine.dictation.utils.DoActionHelper;
import ir.deepmine.dictation.utils.PunctuationsProcessing;
import ir.deepmine.dictation.utils.UserInfo;
import java.io.File;
import java.io.IOException;
import java.net.ProtocolException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javafx.application.Platform;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.jsoup.Jsoup;
import retrofit2.Response;

public class DoActions {
    private static final UserInfo userInfo = UserInfo.getInstance();
    private static final DictationService dictationService = ServerSingleton.getInstance().getDictationService();
    private static final ContentFromUrl contentUrlService = ServerSingleton.getInstance().getContentUrlService();
    private static final DoActionHelper doactionHelper = DoActionHelper.getInstance();
    private static PunctuationsProcessing punctuationsProcessing = PunctuationsProcessing.getInstance();
    private static DoActions doActions;

    public static DoActions getInstance() {
        if (doActions == null) {
            doActions = new DoActions();
        }
        return doActions;
    }

    public HashMap<String, String> getHashMap(JsonObject jsonObject) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Set key = jsonObject.keySet();
        for (int i = 0; i < key.size(); ++i) {
            String value = String.valueOf(jsonObject.get(String.valueOf(key.toArray()[i])));
            if (value.charAt(0) == '\"') {
                hashMap.put(String.valueOf(key.toArray()[i]), String.valueOf(jsonObject.get(String.valueOf(key.toArray()[i]))).split("\"")[1]);
                continue;
            }
            hashMap.put(String.valueOf(key.toArray()[i]), String.valueOf(jsonObject.get(String.valueOf(key.toArray()[i]))));
        }
        return hashMap;
    }

    public Label createLabel(String label) throws AlreadyExistException, ServerException, ConnectionException, GeneralException, InvalidTokenException, InvalidDataException {
        Label dbLabel = Label.get(label);
        if (dbLabel != null) {
            throw new AlreadyExistException();
        }
        String token = userInfo.getAccess();
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("label", label);
        try {
            Response response = dictationService.postLabelCreate("fa-ir", "Token " + token, info).execute();
            Object jsonObject = null;
            if (!response.isSuccessful()) {
                if (response.code() == 400) {
                    throw new InvalidDataException("\u0645\u062a\u0646 \u0628\u0631\u0686\u0633\u0628 \u062e\u0627\u0644\u06cc \u0627\u0633\u062a");
                }
                if (response.code() == 500) {
                    doactionHelper.captureExceptionSentryServerError();
                }
                ApiResponse apiResponse = null;
                try {
                    apiResponse = (ApiResponse)new Gson().fromJson(response.errorBody().string(), ApiResponse.class);
                }
                catch (JsonSyntaxException e) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            TrayNotification tray = new TrayNotification("\u0627\u0637\u0644\u0627\u0639\u0627\u062a \u0628\u0647 \u062f\u0631\u0633\u062a\u06cc \u062f\u06cc\u0627\u0641\u062a \u0646\u0634\u062f.\n\u0644\u0637\u0641\u0627 \u0628\u0639\u062f\u0627 \u062a\u0644\u0627\u0634 \u06a9\u0646\u06cc\u062f.", Notifications.WARNING);
                            tray.showAndDismiss();
                        }
                    });
                }
                if (apiResponse.getCode().equals("label_exists")) {
                    throw new AlreadyExistException(apiResponse.getMessage());
                }
                if (apiResponse.getCode().equals("token_not_valid")) {
                    throw new InvalidTokenException(apiResponse.getMessages().get(0).getMessage());
                }
                throw new GeneralException();
            }
            dbLabel = (Label)new Gson().fromJson((JsonElement)response.body(), Label.class);
            dbLabel.setUserId(userInfo.getUser_id());
            Label.put(dbLabel);
            return dbLabel;
        }
        catch (IOException e) {
            if (doactionHelper.checkUserConnection()) {
                Sentry.captureException((Throwable)e);
                throw new ServerException();
            }
            throw new ConnectionException();
        }
    }

    public Label updateLabel(long id, String text) throws InvalidTokenException, NotExistException, GeneralException, ConnectionException, ServerException {
        String access = userInfo.getAccess();
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("label", text);
        try {
            Response response = dictationService.putUserLabelUpdate("fa-ir", "Token " + access, id, info).execute();
            if (!response.isSuccessful()) {
                if (response.code() == 500) {
                    doactionHelper.captureExceptionSentryServerError();
                }
                ApiResponse apiResponse = null;
                try {
                    apiResponse = (ApiResponse)new Gson().fromJson(response.errorBody().string(), ApiResponse.class);
                }
                catch (JsonSyntaxException e) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            TrayNotification tray = new TrayNotification("\u0627\u0637\u0644\u0627\u0639\u0627\u062a \u0628\u0647 \u062f\u0631\u0633\u062a\u06cc \u062f\u06cc\u0627\u0641\u062a \u0646\u0634\u062f.\n\u0644\u0637\u0641\u0627 \u0628\u0639\u062f\u0627 \u062a\u0644\u0627\u0634 \u06a9\u0646\u06cc\u062f.", Notifications.WARNING);
                            tray.showAndDismiss();
                        }
                    });
                }
                if (apiResponse.getDetail() != null && apiResponse.getDetail().equals("Not found.")) {
                    throw new NotExistException("\u0628\u0631\u0686\u0633\u0628 \u0645\u0648\u0631\u062f \u0646\u0638\u0631 \u0645\u0648\u062c\u0648\u062f \u0646\u06cc\u0633\u062a");
                }
                if (apiResponse.getCode() != null && apiResponse.getCode().equals("token_not_valid")) {
                    throw new InvalidTokenException(apiResponse.getMessages().get(0).getMessage());
                }
                throw new GeneralException();
            }
            Label label = (Label)new Gson().fromJson((JsonElement)response.body(), Label.class);
            label.setUserId(userInfo.getUser_id());
            Label.put(label);
            this.updateDocumentWithEditedLabel(label);
            return label;
        }
        catch (IOException e) {
            if (doactionHelper.checkUserConnection()) {
                Sentry.captureException((Throwable)e);
                throw new ServerException();
            }
            throw new ConnectionException();
        }
    }

    public void removeLabel(long id) throws ConnectionException, NotExistException, InvalidTokenException, GeneralException, SuccessException, ServerException {
        String access = userInfo.getAccess();
        try {
            Response response = dictationService.deleteUserLabel("fa-ir", "Token " + access, id).execute();
            if (!response.isSuccessful()) {
                if (response.code() == 500) {
                    doactionHelper.captureExceptionSentryServerError();
                }
                ApiResponse apiResponse = null;
                try {
                    apiResponse = (ApiResponse)new Gson().fromJson(response.errorBody().string(), ApiResponse.class);
                }
                catch (JsonSyntaxException e) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            TrayNotification tray = new TrayNotification("\u0644\u0637\u0641\u0627 \u0628\u0639\u062f\u0627 \u062a\u0644\u0627\u0634 \u06a9\u0646\u06cc\u062f.", Notifications.ERROR);
                            tray.showAndDismiss();
                        }
                    });
                }
                if (apiResponse.getDetail() != null && apiResponse.getDetail().equalsIgnoreCase("Not found.")) {
                    throw new NotExistException("\u0628\u0631\u0686\u0633\u0628 \u0645\u0648\u0631\u062f \u0646\u0638\u0631 \u0645\u0648\u062c\u0648\u062f \u0646\u06cc\u0633\u062a");
                }
                if (apiResponse.getCode() != null && apiResponse.getCode().equals("token_not_valid")) {
                    throw new InvalidTokenException(apiResponse.getMessages().get(0).getMessage());
                }
                throw new GeneralException();
            }
            this.updateDocumentWithEditedLabel(Label.get(id));
            Label.remove(id);
            this.getDocumentLabels();
            throw new SuccessException("\u0628\u0631\u0686\u0633\u0628 \u0645\u0648\u0631\u062f \u0646\u0638\u0631 \u0628\u0627 \u0645\u0648\u0641\u0642\u06cc\u062a \u062d\u0630\u0641 \u0634\u062f");
        }
        catch (IOException e) {
            if (e instanceof ProtocolException) {
                this.updateDocumentWithEditedLabel(Label.get(id));
                Label.remove(id);
                this.getDocumentLabels();
                throw new SuccessException("\u0628\u0631\u0686\u0633\u0628 \u0645\u0648\u0631\u062f \u0646\u0638\u0631 \u0628\u0627 \u0645\u0648\u0641\u0642\u06cc\u062a \u062d\u0630\u0641 \u0634\u062f");
            }
            if (doactionHelper.checkUserConnection()) {
                Sentry.captureException((Throwable)e);
                throw new ServerException();
            }
            throw new ConnectionException();
        }
    }

    public ArrayList<Label> getLabels() throws ConnectionException, InvalidTokenException, GeneralException, ServerException {
        String access = userInfo.getAccess();
        try {
            Response response = dictationService.getUserLabelList("fa-ir", "Token " + access, 10, 0).execute();
            if (!response.isSuccessful()) {
                if (response.code() == 500) {
                    doactionHelper.captureExceptionSentryServerError();
                }
                ApiResponse apiResponse = null;
                try {
                    apiResponse = (ApiResponse)new Gson().fromJson(response.errorBody().string(), ApiResponse.class);
                }
                catch (JsonSyntaxException e) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            TrayNotification tray = new TrayNotification("\u0644\u0637\u0641\u0627 \u0628\u0639\u062f\u0627 \u062a\u0644\u0627\u0634 \u06a9\u0646\u06cc\u062f.", Notifications.ERROR);
                            tray.showAndDismiss();
                        }
                    });
                }
                if (apiResponse.getCode() != null && apiResponse.getCode().equals("token_not_valid")) {
                    throw new InvalidTokenException(apiResponse.getMessages().get(0).getMessage());
                }
                throw new GeneralException();
            }
            String cnt = String.valueOf(((JsonObject)response.body()).get("count"));
            int count = Integer.valueOf(cnt);
            ArrayList labels = new ArrayList();
            if (count > 0) {
                labels = (ArrayList)new Gson().fromJson((JsonElement)((JsonObject)response.body()).getAsJsonArray("results"), new TypeToken<ArrayList<Label>>(){}.getType());
            }
            if (count > 10) {
                response = dictationService.getUserLabelList("fa-ir", "Token " + access, count - 10, 10).execute();
                if (!response.isSuccessful()) {
                    ApiResponse apiResponse;
                    if (response.code() == 500) {
                        doactionHelper.captureExceptionSentryServerError();
                    }
                    if ((apiResponse = (ApiResponse)new Gson().fromJson(response.errorBody().string(), ApiResponse.class)).getCode() != null && apiResponse.getCode().equals("token_not_valid")) {
                        throw new InvalidTokenException(apiResponse.getMessages().get(0).getMessage());
                    }
                    throw new GeneralException();
                }
                ArrayList offsetLabel = new ArrayList();
                offsetLabel = (ArrayList)new Gson().fromJson((JsonElement)((JsonObject)response.body()).getAsJsonArray("results"), new TypeToken<ArrayList<Label>>(){}.getType());
                labels.addAll(offsetLabel);
            }
            for (int i = 0; i < labels.size(); ++i) {
                labels.get(i).setUserId(userInfo.getUser_id());
            }
            Label.put(labels);
            return labels;
        }
        catch (IOException e) {
            if (doactionHelper.checkUserConnection()) {
                Sentry.captureException((Throwable)e);
                throw new ServerException();
            }
            throw new ConnectionException();
        }
    }

    public JsonObject completeProfile(HashMap<String, String> info) throws ConnectionException, InvalidTokenException, GeneralException, InvalidFormatException, AlreadyExistException, TooManyRequestException, ServerException {
        System.out.println("complete profile");
        String access = userInfo.getAccess();
        for (String key : info.keySet()) {
            System.out.println(key + " : " + info.get(key));
        }
        try {
            Response response = dictationService.updateProfile("fa_ir", "Token " + access, info).execute();
            System.out.println("execute");
            if (!response.isSuccessful()) {
                if (response.code() == 500) {
                    doactionHelper.captureExceptionSentryServerError();
                }
                ApiResponse apiResponse = null;
                try {
                    apiResponse = (ApiResponse)new Gson().fromJson(response.errorBody().string(), ApiResponse.class);
                }
                catch (JsonSyntaxException e) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            TrayNotification tray = new TrayNotification("\u0644\u0637\u0641\u0627 \u0628\u0639\u062f\u0627 \u062a\u0644\u0627\u0634 \u06a9\u0646\u06cc\u062f.", Notifications.ERROR);
                            tray.showAndDismiss();
                        }
                    });
                }
                if (apiResponse.getCode() != null) {
                    if (apiResponse.getCode().equals("invalid_email") || apiResponse.getCode().equals("invalid_mobile")) {
                        throw new InvalidFormatException(apiResponse.getMessage());
                    }
                    if (apiResponse.getCode().equals("email_exists") || apiResponse.getCode().equals("mobile_exists")) {
                        throw new AlreadyExistException(apiResponse.getMessage());
                    }
                    if (apiResponse.getCode().equals("too_many_requests")) {
                        throw new TooManyRequestException(apiResponse.getMessage());
                    }
                    if (response.code() == 400) {
                        throw new InvalidFormatException(apiResponse.getMessage());
                    }
                    if (apiResponse.getCode().equals("token_not_valid")) {
                        throw new InvalidTokenException(apiResponse.getMessages().get(0).getMessage());
                    }
                }
                throw new GeneralException();
            }
            System.out.println("body: " + response.body());
            return (JsonObject)response.body();
        }
        catch (IOException e) {
            if (doactionHelper.checkUserConnection()) {
                Sentry.captureException((Throwable)e);
                throw new ServerException();
            }
            throw new ConnectionException();
        }
    }

    public void updateProfileAvatar(String first_name, String last_name, File image) throws SuccessException, InvalidTokenException, GeneralException, ServerException, ConnectionException {
        String access = userInfo.getAccess();
        HashMap<String, File> info = new HashMap<String, File>();
        info.put("avatar", image);
        System.out.println("file: " + image.toString());
        int index = image.getName().lastIndexOf(46);
        String extension = "";
        if (index > 0) {
            extension = image.getName().substring(index + 1);
            System.out.println("File extension is " + extension);
        }
        System.out.println("image tpye : " + extension);
        RequestBody requestFile = RequestBody.create((MediaType)MediaType.parse((String)("image/" + extension)), (File)image);
        System.out.println("here2");
        MultipartBody.Part body = MultipartBody.Part.createFormData((String)"avatar", (String)image.getName(), (RequestBody)requestFile);
        System.out.println("here3");
        RequestBody nameBody = RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)first_name);
        RequestBody familyBody = RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)last_name);
        try {
            Response response = dictationService.updateAvatar("en", "Token " + access, nameBody, familyBody, body).execute();
            System.out.println("here4");
            if (!response.isSuccessful()) {
                if (response.code() == 500) {
                    doactionHelper.captureExceptionSentryServerError();
                }
                ApiResponse apiResponse = null;
                try {
                    apiResponse = (ApiResponse)new Gson().fromJson(response.errorBody().string(), ApiResponse.class);
                }
                catch (JsonSyntaxException e) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            TrayNotification tray = new TrayNotification("\u0644\u0637\u0641\u0627 \u0628\u0639\u062f\u0627 \u062a\u0644\u0627\u0634 \u06a9\u0646\u06cc\u062f.", Notifications.ERROR);
                            tray.showAndDismiss();
                        }
                    });
                }
                if (apiResponse.getCode() != null && apiResponse.getCode().equals("token_not_valid")) {
                    throw new InvalidTokenException(apiResponse.getMessages().get(0).getMessage());
                }
                throw new GeneralException();
            }
            System.out.println("body: " + response.body());
            throw new SuccessException();
        }
        catch (IOException e) {
            if (doactionHelper.checkUserConnection()) {
                Sentry.captureException((Throwable)e);
                throw new ServerException();
            }
            throw new ConnectionException();
        }
    }

    public JsonObject getProfile() throws ConnectionException, InvalidTokenException, GeneralException, ServerException {
        String access = userInfo.getAccess();
        try {
            Response response = dictationService.getProfileList("fa-ir", "Token " + access).execute();
            if (!response.isSuccessful()) {
                if (response.code() == 500) {
                    doactionHelper.captureExceptionSentryServerError();
                }
                ApiResponse apiResponse = null;
                try {
                    apiResponse = (ApiResponse)new Gson().fromJson(response.errorBody().string(), ApiResponse.class);
                }
                catch (JsonSyntaxException e) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            TrayNotification tray = new TrayNotification("\u0644\u0637\u0641\u0627 \u0628\u0639\u062f\u0627 \u062a\u0644\u0627\u0634 \u06a9\u0646\u06cc\u062f.", Notifications.ERROR);
                            tray.showAndDismiss();
                        }
                    });
                }
                if (apiResponse.getCode() != null && apiResponse.getCode().equals("token_not_valid")) {
                    throw new InvalidTokenException(apiResponse.getMessages().get(0).getMessage());
                }
                throw new GeneralException();
            }
            return (JsonObject)response.body();
        }
        catch (IOException e) {
            boolean connection = doactionHelper.checkUserConnection();
            if (connection) {
                e.printStackTrace();
                Sentry.captureException((Throwable)e);
                throw new ServerException();
            }
            throw new ConnectionException();
        }
    }

    public Document createDocument(String title, String content) throws InvalidTokenException, GeneralException, ConnectionException, ServerException {
        String token = userInfo.getAccess();
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("title", title);
        info.put("content", content);
        try {
            Response response = dictationService.postDocumentCreate("fa-ir", "Token " + token, info).execute();
            if (!response.isSuccessful()) {
                if (response.code() == 500) {
                    doactionHelper.captureExceptionSentryServerError();
                }
                ApiResponse apiResponse = null;
                try {
                    apiResponse = (ApiResponse)new Gson().fromJson(response.errorBody().string(), ApiResponse.class);
                }
                catch (JsonSyntaxException e) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            TrayNotification tray = new TrayNotification("\u0644\u0637\u0641\u0627 \u0628\u0639\u062f\u0627 \u062a\u0644\u0627\u0634 \u06a9\u0646\u06cc\u062f.", Notifications.ERROR);
                            tray.showAndDismiss();
                        }
                    });
                }
                if (apiResponse.getCode() != null && apiResponse.getCode().equals("token_not_valid")) {
                    throw new InvalidTokenException(apiResponse.getMessages().get(0).getMessage());
                }
                throw new GeneralException();
            }
            Document document = (Document)new Gson().fromJson((JsonElement)response.body(), Document.class);
            document.setContent(content);
            document.setUserId(userInfo.getUser_id());
            document.setPureContent(Jsoup.parse((String)document.getContent()).text());
            document.setShowFirstTimeInEditor(true);
            Document.put(document);
            return document;
        }
        catch (IOException e) {
            if (doactionHelper.checkUserConnection()) {
                Sentry.captureException((Throwable)e);
                throw new ServerException();
            }
            throw new ConnectionException();
        }
    }

    public Document updateDocument(String uuid, String newTitle, String newContent) throws NotExistException, InvalidTokenException, ConnectionException, GeneralException, ServerException {
        String token = userInfo.getAccess();
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("title", newTitle);
        info.put("content", newContent);
        try {
            Response response = dictationService.putUpdateDocument("fa-ir", "Token " + token, uuid, info).execute();
            if (!response.isSuccessful()) {
                if (response.code() == 500) {
                    doactionHelper.captureExceptionSentryServerError();
                }
                ApiResponse apiResponse = null;
                try {
                    apiResponse = (ApiResponse)new Gson().fromJson(response.errorBody().string(), ApiResponse.class);
                }
                catch (JsonSyntaxException e) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            TrayNotification tray = new TrayNotification("\u0644\u0637\u0641\u0627 \u0628\u0639\u062f\u0627 \u062a\u0644\u0627\u0634 \u06a9\u0646\u06cc\u062f.", Notifications.ERROR);
                            tray.showAndDismiss();
                        }
                    });
                }
                if (apiResponse.getDetail() != null && apiResponse.getDetail().equals("Not found.")) {
                    throw new NotExistException("\u0633\u0646\u062f \u0645\u0648\u0631\u062f \u0646\u0638\u0631 \u0645\u0648\u062c\u0648\u062f \u0646\u06cc\u0633\u062a");
                }
                if (apiResponse.getCode() != null && apiResponse.getCode().equals("token_not_valid")) {
                    throw new InvalidTokenException(apiResponse.getMessages().get(0).getMessage());
                }
                throw new GeneralException();
            }
            Document document = (Document)new Gson().fromJson((JsonElement)response.body(), Document.class);
            document.setUserId(userInfo.getUser_id());
            document.setContent(newContent);
            document.setPureContent(Jsoup.parse((String)document.getContent()).text());
            Document.put(document);
            return document;
        }
        catch (IOException e) {
            if (doactionHelper.checkUserConnection()) {
                Sentry.captureException((Throwable)e);
                throw new ServerException();
            }
            throw new ConnectionException();
        }
    }

    public Document updatePartialDocument(String uuid, String title) throws ConnectionException, NotExistException, InvalidTokenException, GeneralException, ServerException {
        String access = userInfo.getAccess();
        HashMap<String, String> info = new HashMap<String, String>();
        try {
            Response response = dictationService.patchDocumentPartialUpdate("fa-ir", "Token " + access, uuid, info).execute();
            if (!response.isSuccessful()) {
                if (response.code() == 500) {
                    doactionHelper.captureExceptionSentryServerError();
                }
                ApiResponse apiResponse = null;
                try {
                    apiResponse = (ApiResponse)new Gson().fromJson(response.errorBody().string(), ApiResponse.class);
                }
                catch (JsonSyntaxException e) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            TrayNotification tray = new TrayNotification("\u0644\u0637\u0641\u0627 \u0628\u0639\u062f\u0627 \u062a\u0644\u0627\u0634 \u06a9\u0646\u06cc\u062f.", Notifications.ERROR);
                            tray.showAndDismiss();
                        }
                    });
                }
                if (apiResponse.getDetail() != null && apiResponse.getDetail().equals("Not found.")) {
                    throw new NotExistException("\u0633\u0646\u062f \u0645\u0648\u0631\u062f \u0646\u0638\u0631 \u0645\u0648\u062c\u0648\u062f \u0646\u06cc\u0633\u062a");
                }
                if (apiResponse.getCode() != null && apiResponse.getCode().equals("token_not_valid")) {
                    throw new InvalidTokenException(apiResponse.getMessages().get(0).getMessage());
                }
                throw new GeneralException();
            }
            Document document = (Document)new Gson().fromJson((JsonElement)response.body(), Document.class);
            document.setUserId(userInfo.getUser_id());
            document.setContent(Document.get(uuid).getContent());
            document.setPureContent(Jsoup.parse((String)document.getContent()).text());
            Document.put(document);
            return document;
        }
        catch (IOException e) {
            if (doactionHelper.checkUserConnection()) {
                Sentry.captureException((Throwable)e);
                throw new ServerException();
            }
            throw new ConnectionException();
        }
    }

    public ArrayList<Document> getDocuments(Date afterDate) throws ConnectionException, InvalidTokenException, GeneralException, ServerException {
        String access = userInfo.getAccess();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String date = simpleDateFormat.format(afterDate).split(" ")[0];
        String time = simpleDateFormat.format(afterDate).split(" ")[1];
        System.out.println(date + "T" + time);
        try {
            Response response = dictationService.getDocumentList("fa-ir", "Token " + access, date + "T" + time, 10, 0).execute();
            if (!response.isSuccessful()) {
                if (response.code() == 500) {
                    doactionHelper.captureExceptionSentryServerError();
                }
                ApiResponse apiResponse = null;
                try {
                    apiResponse = (ApiResponse)new Gson().fromJson(response.errorBody().string(), ApiResponse.class);
                }
                catch (JsonSyntaxException e) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            TrayNotification tray = new TrayNotification("\u0644\u0637\u0641\u0627 \u0628\u0639\u062f\u0627 \u062a\u0644\u0627\u0634 \u06a9\u0646\u06cc\u062f.", Notifications.ERROR);
                            tray.showAndDismiss();
                        }
                    });
                }
                if (apiResponse.getCode() != null && apiResponse.getCode().equals("token_not_valid")) {
                    throw new InvalidTokenException(apiResponse.getMessages().get(0).getMessage());
                }
                throw new GeneralException();
            }
            String cnt = String.valueOf(((JsonObject)response.body()).get("count"));
            int count = Integer.valueOf(cnt);
            ArrayList documents = new ArrayList();
            if (count > 0) {
                documents = (ArrayList)new Gson().fromJson((JsonElement)((JsonObject)response.body()).getAsJsonArray("results"), new TypeToken<ArrayList<Document>>(){}.getType());
            }
            if (count > 10) {
                response = dictationService.getDocumentList("fa-ir", "Token " + access, date + "T" + time, count - 10, 10).execute();
                if (!response.isSuccessful()) {
                    if (response.code() == 500) {
                        doactionHelper.captureExceptionSentryServerError();
                    }
                    ApiResponse apiResponse = null;
                    try {
                        apiResponse = (ApiResponse)new Gson().fromJson(response.errorBody().string(), ApiResponse.class);
                    }
                    catch (JsonSyntaxException e) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                TrayNotification tray = new TrayNotification("\u0644\u0637\u0641\u0627 \u0628\u0639\u062f\u0627 \u062a\u0644\u0627\u0634 \u06a9\u0646\u06cc\u062f.", Notifications.ERROR);
                                tray.showAndDismiss();
                            }
                        });
                    }
                    if (apiResponse.getCode() != null && apiResponse.getCode().equals("token_not_valid")) {
                        throw new InvalidTokenException(apiResponse.getMessages().get(0).getMessage());
                    }
                    throw new GeneralException();
                }
                documents.addAll((Collection)new Gson().fromJson((JsonElement)((JsonObject)response.body()).getAsJsonArray("results"), new TypeToken<ArrayList<Document>>(){}.getType()));
            }
            for (int i = 0; i < documents.size(); ++i) {
                String content = doactionHelper.getContentFromUrl(documents.get(i).getContent_url());
                ((Document)documents.get(i)).setContent(content);
                ((Document)documents.get(i)).setUserId(userInfo.getUser_id());
                ((Document)documents.get(i)).setPureContent(Jsoup.parse((String)content).text());
            }
            Document.put(documents);
            return documents;
        }
        catch (IOException e) {
            if (doactionHelper.checkUserConnection()) {
                Sentry.captureException((Throwable)e);
                throw new ServerException();
            }
            throw new ConnectionException();
        }
    }

    public ArrayList<Document> getAllDocumentForCoordination(Date afterDate) throws InvalidTokenException, ServerException, ConnectionException, GeneralException {
        String access = userInfo.getAccess();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String date = simpleDateFormat.format(afterDate).split(" ")[0];
        String time = simpleDateFormat.format(afterDate).split(" ")[1];
        System.out.println(date + "T" + time);
        try {
            Response response = dictationService.getDocumentList("fa-ir", "Token " + access, date + "T" + time, 10, 0, true).execute();
            if (!response.isSuccessful()) {
                if (response.code() == 500) {
                    doactionHelper.captureExceptionSentryServerError();
                }
                ApiResponse apiResponse = null;
                System.out.println("error: " + response.code());
                try {
                    apiResponse = (ApiResponse)new Gson().fromJson(response.errorBody().string(), ApiResponse.class);
                }
                catch (JsonSyntaxException e) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            TrayNotification tray = new TrayNotification("\u0644\u0637\u0641\u0627 \u0628\u0639\u062f\u0627 \u062a\u0644\u0627\u0634 \u06a9\u0646\u06cc\u062f.", Notifications.ERROR);
                            tray.showAndDismiss();
                        }
                    });
                }
                System.out.println(apiResponse);
                if (apiResponse.getCode() != null && apiResponse.getCode().equals("token_not_valid")) {
                    throw new InvalidTokenException(apiResponse.getMessages().get(0).getMessage());
                }
                throw new GeneralException();
            }
            String cnt = String.valueOf(((JsonObject)response.body()).get("count"));
            int count = Integer.valueOf(cnt);
            System.out.println("count1: " + count);
            ArrayList<Document> documents1 = new ArrayList<Document>();
            ArrayList documents = new ArrayList();
            if (count > 0) {
                documents = (ArrayList)new Gson().fromJson((JsonElement)((JsonObject)response.body()).getAsJsonArray("results"), new TypeToken<ArrayList<Document>>(){}.getType());
            }
            if (count > 10) {
                response = dictationService.getDocumentList("fa-ir", "Token " + access, date + "T" + time, count - 10, 10, true).execute();
                if (!response.isSuccessful()) {
                    if (response.code() == 500) {
                        doactionHelper.captureExceptionSentryServerError();
                    }
                    ApiResponse apiResponse = null;
                    try {
                        apiResponse = (ApiResponse)new Gson().fromJson(response.errorBody().string(), ApiResponse.class);
                    }
                    catch (JsonSyntaxException e) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                TrayNotification tray = new TrayNotification("\u0644\u0637\u0641\u0627 \u0628\u0639\u062f\u0627 \u062a\u0644\u0627\u0634 \u06a9\u0646\u06cc\u062f.", Notifications.ERROR);
                                tray.showAndDismiss();
                            }
                        });
                    }
                    if (apiResponse.getCode() != null && apiResponse.getCode().equals("token_not_valid")) {
                        throw new InvalidTokenException(apiResponse.getMessages().get(0).getMessage());
                    }
                    throw new GeneralException();
                }
                documents.addAll((Collection)new Gson().fromJson((JsonElement)((JsonObject)response.body()).getAsJsonArray("results"), new TypeToken<ArrayList<Document>>(){}.getType()));
            }
            for (int i = 0; i < documents.size(); ++i) {
                Document document = Document.get(((Document)documents.get(i)).getUuid());
                if (document != null) {
                    if (document.getUpdated_at().getTime() >= ((Document)documents.get(i)).getUpdated_at().getTime()) continue;
                    try {
                        if (document.getContent_modified_at().getTime() < ((Document)documents.get(i)).getContent_modified_at().getTime()) {
                            documents1.add(this.getDocument(((Document)documents.get(i)).getUuid(), false));
                            continue;
                        }
                        documents1.add(this.getDocument(((Document)documents.get(i)).getUuid(), false));
                        continue;
                    }
                    catch (NotExistException e) {
                        continue;
                    }
                    catch (InvalidTokenException e) {
                        throw e;
                    }
                    catch (GeneralException e) {
                        continue;
                    }
                    catch (ConnectionException e) {
                        throw e;
                    }
                }
                try {
                    documents1.add(this.getDocument(((Document)documents.get(i)).getUuid(), false));
                    continue;
                }
                catch (NotExistException e) {
                    continue;
                }
                catch (InvalidTokenException e) {
                    throw e;
                }
                catch (GeneralException e) {
                    continue;
                }
                catch (ConnectionException e) {
                    throw e;
                }
            }
            Document.put(documents1);
            return documents1;
        }
        catch (IOException e) {
            if (doactionHelper.checkUserConnection()) {
                Sentry.captureException((Throwable)e);
                throw new ServerException();
            }
            throw new ConnectionException();
        }
    }

    public ArrayList<Document> getAllDocumentForCoordination() throws GeneralException, InvalidTokenException, ServerException, ConnectionException {
        String access = userInfo.getAccess();
        try {
            int i;
            Response response = dictationService.getDocumentList("fa-ir", "Token " + access, 10, 0, true).execute();
            if (!response.isSuccessful()) {
                if (response.code() == 500) {
                    doactionHelper.captureExceptionSentryServerError();
                }
                ApiResponse apiResponse = null;
                try {
                    apiResponse = (ApiResponse)new Gson().fromJson(response.errorBody().string(), ApiResponse.class);
                }
                catch (JsonSyntaxException e) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            TrayNotification tray = new TrayNotification("\u0644\u0637\u0641\u0627 \u0628\u0639\u062f\u0627 \u062a\u0644\u0627\u0634 \u06a9\u0646\u06cc\u062f.", Notifications.ERROR);
                            tray.showAndDismiss();
                        }
                    });
                }
                if (apiResponse.getCode() != null && apiResponse.getCode().equals("token_not_valid")) {
                    throw new InvalidTokenException(apiResponse.getMessages().get(0).getMessage());
                }
                throw new GeneralException();
            }
            String cnt = String.valueOf(((JsonObject)response.body()).get("count"));
            int count = Integer.valueOf(cnt);
            ArrayList documents = new ArrayList();
            ArrayList<Document> documents1 = new ArrayList<Document>();
            if (count > 0) {
                documents = (ArrayList)new Gson().fromJson((JsonElement)((JsonObject)response.body()).getAsJsonArray("results"), new TypeToken<ArrayList<Document>>(){}.getType());
            }
            if (count > 10) {
                response = dictationService.getDocumentList("fa-ir", "Token " + access, count - 10, 10, true).execute();
                if (!response.isSuccessful()) {
                    if (response.code() == 500) {
                        doactionHelper.captureExceptionSentryServerError();
                    }
                    ApiResponse apiResponse = null;
                    try {
                        apiResponse = (ApiResponse)new Gson().fromJson(response.errorBody().string(), ApiResponse.class);
                    }
                    catch (JsonSyntaxException e) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                TrayNotification tray = new TrayNotification("\u0644\u0637\u0641\u0627 \u0628\u0639\u062f\u0627 \u062a\u0644\u0627\u0634 \u06a9\u0646\u06cc\u062f.", Notifications.ERROR);
                                tray.showAndDismiss();
                            }
                        });
                    }
                    if (apiResponse.getCode() != null && apiResponse.getCode().equals("token_not_valid")) {
                        throw new InvalidTokenException(apiResponse.getMessages().get(0).getMessage());
                    }
                    throw new GeneralException();
                }
                documents.addAll((Collection)new Gson().fromJson((JsonElement)((JsonObject)response.body()).getAsJsonArray("results"), new TypeToken<ArrayList<Document>>(){}.getType()));
            }
            ArrayList uuids = new ArrayList();
            documents1 = new ArrayList();
            for (int i2 = 0; i2 < documents.size(); ++i2) {
                try {
                    Document document = this.getDocument(((Document)documents.get(i2)).getUuid(), false);
                    documents1.add(document);
                    continue;
                }
                catch (NotExistException e) {
                    continue;
                }
                catch (InvalidTokenException e) {
                    throw e;
                }
                catch (GeneralException e) {
                    continue;
                }
                catch (ConnectionException e) {
                    throw e;
                }
            }
            long[] serverIds = new long[documents.size()];
            long[] DBIds = Document.getIds(userInfo.getUser_id());
            ArrayList<Long> removeId = new ArrayList<Long>();
            for (i = 0; i < documents.size(); ++i) {
                serverIds[i] = ((Document)documents.get(i)).getId();
            }
            for (i = 0; i < DBIds.length; ++i) {
                if (doactionHelper.checkExistId(serverIds, DBIds[i])) continue;
                removeId.add(DBIds[i]);
            }
            for (i = 0; i < removeId.size(); ++i) {
                Document.remove((Long)removeId.get(i));
            }
            return documents1;
        }
        catch (IOException e) {
            if (doactionHelper.checkUserConnection()) {
                Sentry.captureException((Throwable)e);
                throw new ServerException();
            }
            throw new ConnectionException();
        }
    }

    public void coordinationRemoveDocument() throws ConnectionException, InvalidTokenException, GeneralException, ServerException {
        String access = userInfo.getAccess();
        try {
            int i;
            Response response = dictationService.getDocumentList("fa-ir", "Token " + access, 10, 0, true).execute();
            if (!response.isSuccessful()) {
                if (response.code() == 500) {
                    doactionHelper.captureExceptionSentryServerError();
                }
                ApiResponse apiResponse = null;
                try {
                    apiResponse = (ApiResponse)new Gson().fromJson("plkorgmto", ApiResponse.class);
                }
                catch (JsonSyntaxException e) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            TrayNotification tray = new TrayNotification("\u0644\u0637\u0641\u0627 \u0628\u0639\u062f\u0627 \u062a\u0644\u0627\u0634 \u06a9\u0646\u06cc\u062f.", Notifications.ERROR);
                            tray.showAndDismiss();
                        }
                    });
                    return;
                }
                System.out.println("here2345");
                if (apiResponse.getCode().equals("token_not_valid")) {
                    throw new InvalidTokenException(apiResponse.getMessages().get(0).getMessage());
                }
                throw new GeneralException();
            }
            String cnt = String.valueOf(((JsonObject)response.body()).get("count"));
            int count = Integer.valueOf(cnt);
            ArrayList documents = new ArrayList();
            if (count > 0) {
                documents = (ArrayList)new Gson().fromJson((JsonElement)((JsonObject)response.body()).getAsJsonArray("results"), new TypeToken<ArrayList<Document>>(){}.getType());
            }
            if (count > 10) {
                response = dictationService.getDocumentList("fa-ir", "Token " + access, count - 10, 10, true).execute();
                if (!response.isSuccessful()) {
                    ApiResponse apiResponse = null;
                    try {
                        apiResponse = (ApiResponse)new Gson().fromJson(response.errorBody().string(), ApiResponse.class);
                    }
                    catch (JsonSyntaxException e) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                TrayNotification tray = new TrayNotification("\u0644\u0637\u0641\u0627 \u0628\u0639\u062f\u0627 \u062a\u0644\u0627\u0634 \u06a9\u0646\u06cc\u062f.", Notifications.ERROR);
                                tray.showAndDismiss();
                            }
                        });
                    }
                    if (apiResponse.getCode() != null && apiResponse.getCode().equals("token_not_valid")) {
                        throw new InvalidTokenException(apiResponse.getMessages().get(0).getMessage());
                    }
                    throw new GeneralException();
                }
                documents.addAll((Collection)new Gson().fromJson((JsonElement)((JsonObject)response.body()).getAsJsonArray("results"), new TypeToken<ArrayList<Document>>(){}.getType()));
            }
            long[] serverIds = new long[documents.size()];
            long[] DBIds = Document.getIds(userInfo.getUser_id());
            ArrayList<Long> removeId = new ArrayList<Long>();
            for (i = 0; i < documents.size(); ++i) {
                serverIds[i] = ((Document)documents.get(i)).getId();
            }
            for (i = 0; i < DBIds.length; ++i) {
                if (doactionHelper.checkExistId(serverIds, DBIds[i])) continue;
                removeId.add(DBIds[i]);
            }
            for (i = 0; i < removeId.size(); ++i) {
                Document.remove((Long)removeId.get(i));
            }
        }
        catch (IOException e) {
            if (doactionHelper.checkUserConnection()) {
                Sentry.captureException((Throwable)e);
                throw new ServerException();
            }
            throw new ConnectionException();
        }
    }

    public Document getDocument(String uuid, boolean isContentNeeded) throws NotExistException, InvalidTokenException, GeneralException, ConnectionException, ServerException {
        String access = userInfo.getAccess();
        try {
            Response response = dictationService.getDocument("fa-ir", "Token " + access, uuid).execute();
            if (!response.isSuccessful()) {
                if (response.code() == 500) {
                    doactionHelper.captureExceptionSentryServerError();
                }
                ApiResponse apiResponse = null;
                try {
                    apiResponse = (ApiResponse)new Gson().fromJson(response.errorBody().string(), ApiResponse.class);
                }
                catch (JsonSyntaxException e) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            TrayNotification tray = new TrayNotification("\u0644\u0637\u0641\u0627 \u0628\u0639\u062f\u0627 \u062a\u0644\u0627\u0634 \u06a9\u0646\u06cc\u062f.", Notifications.ERROR);
                            tray.showAndDismiss();
                        }
                    });
                }
                if (apiResponse.getDetail() != null && apiResponse.getDetail().equals("Not found.")) {
                    throw new NotExistException("\u0633\u0646\u062f \u0645\u0648\u0631\u062f \u0646\u0638\u0631 \u0648\u062c\u0648\u062f \u0646\u062f\u0627\u0631\u062f");
                }
                if (apiResponse.getCode() != null && apiResponse.getCode().equals("token_not_valid")) {
                    throw new InvalidTokenException(apiResponse.getMessages().get(0).getMessage());
                }
                throw new GeneralException();
            }
            Document document = (Document)new Gson().fromJson((JsonElement)response.body(), Document.class);
            String content = "";
            Document documentDb = Document.get(document.getId());
            if (isContentNeeded) {
                System.out.println("content needed");
                content = doactionHelper.getContentFromUrl(document.getContent_url());
            } else if (documentDb != null) {
                System.out.println("content not needed");
                content = Document.get(uuid).getContent();
                document.setShowFirstTimeInEditor(documentDb.isShowFirstTimeInEditor());
            } else {
                content = document.getSummary();
                document.setShowFirstTimeInEditor(false);
            }
            document.setContent(content);
            document.setUserId(userInfo.getUser_id());
            document.setPureContent(Jsoup.parse((String)content).text());
            Document.put(document);
            return document;
        }
        catch (IOException e) {
            if (doactionHelper.checkUserConnection()) {
                Sentry.captureException((Throwable)e);
                throw new ServerException();
            }
            throw new ConnectionException();
        }
    }

    public void deleteDocumentMoveToTrash(String uuid) throws NotExistException, InvalidTokenException, GeneralException, SuccessException, ConnectionException, ServerException {
        String access = userInfo.getAccess();
        System.out.println(access);
        try {
            Response response = dictationService.deleteDocumentMoveToTrash("fa-ir", "Token " + access, uuid).execute();
            if (!response.isSuccessful()) {
                if (response.code() == 500) {
                    doactionHelper.captureExceptionSentryServerError();
                }
                ApiResponse apiResponse = null;
                try {
                    apiResponse = (ApiResponse)new Gson().fromJson(response.errorBody().string(), ApiResponse.class);
                }
                catch (JsonSyntaxException e) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            TrayNotification tray = new TrayNotification("\u0644\u0637\u0641\u0627 \u0628\u0639\u062f\u0627 \u062a\u0644\u0627\u0634 \u06a9\u0646\u06cc\u062f.", Notifications.ERROR);
                            tray.showAndDismiss();
                        }
                    });
                }
                if (apiResponse.getCode() != null && apiResponse.getCode().equalsIgnoreCase("document_not_found")) {
                    throw new NotExistException("\u0633\u0646\u062f \u0645\u0648\u0631\u062f \u0646\u0638\u0631 \u0645\u0648\u062c\u0648\u062f \u0646\u06cc\u0633\u062a");
                }
                if (apiResponse.getCode() != null && apiResponse.getCode().equals("token_not_valid")) {
                    throw new InvalidTokenException(apiResponse.getMessages().get(0).getMessage());
                }
                throw new GeneralException();
            }
            Document document = doactionHelper.updateDocument(uuid, (JsonObject)response.body());
            Document.put(document);
            throw new SuccessException("\u0633\u0646\u062f \u0645\u0648\u0631\u062f \u0646\u0638\u0631 \u0628\u0627 \u0645\u0648\u0641\u0642\u06cc\u062a \u062d\u0630\u0641 \u0634\u062f.");
        }
        catch (IOException e) {
            if (doactionHelper.checkUserConnection()) {
                Sentry.captureException((Throwable)e);
                throw new ServerException();
            }
            throw new ConnectionException();
        }
    }

    public ArrayList<Document> getTrashedDocuments() throws GeneralException, InvalidTokenException, ConnectionException, ServerException {
        String access = userInfo.getAccess();
        try {
            Response response = dictationService.getTrashedDocumentList("fa-ir", "Token " + access, 10, 0).execute();
            if (!response.isSuccessful()) {
                if (response.code() == 500) {
                    doactionHelper.captureExceptionSentryServerError();
                }
                ApiResponse apiResponse = null;
                try {
                    apiResponse = (ApiResponse)new Gson().fromJson(response.errorBody().string(), ApiResponse.class);
                }
                catch (JsonSyntaxException e) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            TrayNotification tray = new TrayNotification("\u0644\u0637\u0641\u0627 \u0628\u0639\u062f\u0627 \u062a\u0644\u0627\u0634 \u06a9\u0646\u06cc\u062f.", Notifications.ERROR);
                            tray.showAndDismiss();
                        }
                    });
                }
                if (apiResponse.getCode().equals("token_not_valid")) {
                    throw new InvalidTokenException(apiResponse.getMessages().get(0).getMessage());
                }
                throw new GeneralException();
            }
            String cnt = String.valueOf(((JsonObject)response.body()).get("count"));
            int count = Integer.valueOf(cnt);
            ArrayList documents = new ArrayList();
            if (count > 0) {
                documents = (ArrayList)new Gson().fromJson((JsonElement)((JsonObject)response.body()).getAsJsonArray("results"), new TypeToken<ArrayList<Document>>(){}.getType());
            }
            if (count > 10) {
                response = dictationService.getTrashedDocumentList("fa-ir", "Token " + access, count - 10, 10).execute();
                if (!response.isSuccessful()) {
                    if (response.code() == 500) {
                        doactionHelper.captureExceptionSentryServerError();
                    }
                    ApiResponse apiResponse = null;
                    try {
                        apiResponse = (ApiResponse)new Gson().fromJson(response.errorBody().string(), ApiResponse.class);
                    }
                    catch (JsonSyntaxException e) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                TrayNotification tray = new TrayNotification("\u0644\u0637\u0641\u0627 \u0628\u0639\u062f\u0627 \u062a\u0644\u0627\u0634 \u06a9\u0646\u06cc\u062f.", Notifications.ERROR);
                                tray.showAndDismiss();
                            }
                        });
                    }
                    if (apiResponse.getCode() != null && apiResponse.getCode().equals("token_not_valid")) {
                        throw new InvalidTokenException(apiResponse.getMessages().get(0).getMessage());
                    }
                    throw new GeneralException();
                }
                documents.addAll((Collection)new Gson().fromJson((JsonElement)((JsonObject)response.body()).getAsJsonArray("results"), new TypeToken<ArrayList<Document>>(){}.getType()));
            }
            for (int i = 0; i < documents.size(); ++i) {
                String content = doactionHelper.getContentFromUrl(documents.get(i).getContent_url());
                ((Document)documents.get(i)).setContent(content);
                ((Document)documents.get(i)).setUserId(userInfo.getUser_id());
                ((Document)documents.get(i)).setPureContent(Jsoup.parse((String)content).text());
            }
            Document.put(documents);
            return documents;
        }
        catch (IOException e) {
            if (doactionHelper.checkUserConnection()) {
                Sentry.captureException((Throwable)e);
                throw new ServerException();
            }
            throw new ConnectionException();
        }
    }

    public void trashedDocumentRestore(String uuid) throws ConnectionException, InvalidTokenException, NotExistException, GeneralException, SuccessException, ServerException {
        String access = userInfo.getAccess();
        try {
            Response response = dictationService.restoreTrashedDocument("fa-ir", "Token " + access, uuid).execute();
            if (!response.isSuccessful()) {
                if (response.code() == 500) {
                    doactionHelper.captureExceptionSentryServerError();
                }
                ApiResponse apiResponse = null;
                try {
                    apiResponse = (ApiResponse)new Gson().fromJson(response.errorBody().string(), ApiResponse.class);
                }
                catch (JsonSyntaxException e) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            TrayNotification tray = new TrayNotification("\u0644\u0637\u0641\u0627 \u0628\u0639\u062f\u0627 \u062a\u0644\u0627\u0634 \u06a9\u0646\u06cc\u062f.", Notifications.ERROR);
                            tray.showAndDismiss();
                        }
                    });
                }
                if (apiResponse.getCode() != null && apiResponse.getCode().equals("token_not_valid")) {
                    throw new InvalidTokenException(apiResponse.getMessages().get(0).getMessage());
                }
                if (apiResponse.getCode() != null && apiResponse.getCode().equalsIgnoreCase("document_not_found")) {
                    throw new NotExistException("\u0633\u0646\u062f \u0645\u0648\u0631\u062f \u0646\u0638\u0631 \u0645\u0648\u062c\u0648\u062f \u0646\u06cc\u0633\u062a");
                }
                throw new GeneralException();
            }
            Document document = doactionHelper.updateDocument(uuid, (JsonObject)response.body());
            Document.put(document);
            throw new SuccessException("\u0633\u0646\u062f \u0645\u0648\u0631\u062f \u0646\u0638\u0631 \u0645\u062c\u062f\u062f\u0627 \u0630\u062e\u06cc\u0631\u0647 \u0634\u062f.");
        }
        catch (IOException e) {
            if (doactionHelper.checkUserConnection()) {
                Sentry.captureException((Throwable)e);
                throw new ServerException();
            }
            throw new ConnectionException();
        }
    }

    public void deleteTrashedDocument(String uuid) throws NotExistException, InvalidTokenException, GeneralException, SuccessException, ConnectionException, ServerException {
        String access = userInfo.getAccess();
        try {
            Response response = dictationService.deleteTrashedDocument("fa-ir", "Token " + access, uuid).execute();
            if (!response.isSuccessful()) {
                if (response.code() == 500) {
                    doactionHelper.captureExceptionSentryServerError();
                }
                ApiResponse apiResponse = null;
                try {
                    apiResponse = (ApiResponse)new Gson().fromJson(response.errorBody().string(), ApiResponse.class);
                }
                catch (JsonSyntaxException e) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            TrayNotification tray = new TrayNotification("\u0644\u0637\u0641\u0627 \u0628\u0639\u062f\u0627 \u062a\u0644\u0627\u0634 \u06a9\u0646\u06cc\u062f.", Notifications.ERROR);
                            tray.showAndDismiss();
                        }
                    });
                }
                if (apiResponse.getCode() != null && apiResponse.getCode().equalsIgnoreCase("document_not_found")) {
                    throw new NotExistException("\u0633\u0646\u062f \u0645\u0648\u0631\u062f \u0646\u0638\u0631 \u0645\u0648\u062c\u0648\u062f \u0646\u06cc\u0633\u062a");
                }
                if (apiResponse.getCode() != null && apiResponse.getCode().equals("token_not_valid")) {
                    throw new InvalidTokenException(apiResponse.getMessages().get(0).getMessage());
                }
                throw new GeneralException();
            }
            Document.remove(uuid);
            throw new SuccessException("\u0633\u0646\u062f \u0645\u0648\u0631\u062f \u0646\u0638\u0631 \u0628\u0627 \u0645\u0648\u0641\u0642\u06cc\u062a \u062d\u0630\u0641 \u0634\u062f");
        }
        catch (IOException e) {
            if (e instanceof ProtocolException) {
                Document.remove(uuid);
                throw new SuccessException("\u0633\u0646\u062f \u0645\u0648\u0631\u062f \u0646\u0638\u0631 \u0628\u0627 \u0645\u0648\u0641\u0642\u06cc\u062a \u062d\u0630\u0641 \u0634\u062f");
            }
            if (doactionHelper.checkUserConnection()) {
                Sentry.captureException((Throwable)e);
                throw new ServerException();
            }
            throw new ConnectionException();
        }
    }

    public void documentMoveToArchive(String uuid) throws ConnectionException, NotExistException, InvalidTokenException, GeneralException, SuccessException, ServerException {
        block10: {
            String access = userInfo.getAccess();
            try {
                Response response = dictationService.postDocumentMoveToArchive("fa-ir", "Token " + access, uuid).execute();
                if (!response.isSuccessful()) {
                    if (response.code() == 500) {
                        doactionHelper.captureExceptionSentryServerError();
                    }
                    ApiResponse apiResponse = null;
                    try {
                        apiResponse = (ApiResponse)new Gson().fromJson(response.errorBody().string(), ApiResponse.class);
                    }
                    catch (JsonSyntaxException e) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                TrayNotification tray = new TrayNotification("\u0644\u0637\u0641\u0627 \u0628\u0639\u062f\u0627 \u062a\u0644\u0627\u0634 \u06a9\u0646\u06cc\u062f.", Notifications.ERROR);
                                tray.showAndDismiss();
                            }
                        });
                    }
                    if (apiResponse.getCode() != null) {
                        if (apiResponse.getCode().equals("document_not_found")) {
                            throw new NotExistException(apiResponse.getMessage());
                        }
                        if (apiResponse.getCode().equals("token_not_valid")) {
                            throw new InvalidTokenException(apiResponse.getMessages().get(0).getMessage());
                        }
                        throw new GeneralException();
                    }
                    break block10;
                }
                Document document = doactionHelper.updateDocument(uuid, (JsonObject)response.body());
                Document.put(document);
                throw new SuccessException("\u0633\u0646\u062f \u0645\u0648\u0631\u062f \u0646\u0638\u0631 \u0628\u0627 \u0645\u0648\u0641\u0642\u06cc\u062a \u0627\u0631\u0634\u06cc\u0648 \u0634\u062f.");
            }
            catch (IOException e) {
                if (doactionHelper.checkUserConnection()) {
                    Sentry.captureException((Throwable)e);
                    throw new ServerException();
                }
                throw new ConnectionException();
            }
        }
    }

    public ArrayList<Document> getArchivedDocument() throws ConnectionException, InvalidTokenException, GeneralException, ServerException {
        String access = userInfo.getAccess();
        try {
            Response response = dictationService.getArchivedDocumentList("fa-ir", "Token " + access, 1, 0).execute();
            if (!response.isSuccessful()) {
                if (response.code() == 500) {
                    doactionHelper.captureExceptionSentryServerError();
                }
                ApiResponse apiResponse = null;
                try {
                    apiResponse = (ApiResponse)new Gson().fromJson(response.errorBody().string(), ApiResponse.class);
                }
                catch (JsonSyntaxException e) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            TrayNotification tray = new TrayNotification("\u0644\u0637\u0641\u0627 \u0628\u0639\u062f\u0627 \u062a\u0644\u0627\u0634 \u06a9\u0646\u06cc\u062f.", Notifications.ERROR);
                            tray.showAndDismiss();
                        }
                    });
                }
                if (apiResponse.getCode().equals("token_not_valid")) {
                    throw new InvalidTokenException(apiResponse.getMessages().get(0).getMessage());
                }
                throw new GeneralException();
            }
            ArrayList documents = new ArrayList();
            String cnt = String.valueOf(((JsonObject)response.body()).get("count"));
            int count = Integer.valueOf(cnt);
            if (count > 0) {
                documents = (ArrayList)new Gson().fromJson((JsonElement)((JsonObject)response.body()).getAsJsonArray("results"), new TypeToken<ArrayList<Document>>(){}.getType());
            }
            if (count > 10) {
                response = dictationService.getArchivedDocumentList("fa-ir", "Token " + access, count - 10, 10).execute();
                if (!response.isSuccessful()) {
                    ApiResponse apiResponse = (ApiResponse)new Gson().fromJson(response.errorBody().string(), ApiResponse.class);
                    if (apiResponse.getCode() != null && apiResponse.getCode().equals("token_not_valid")) {
                        throw new InvalidTokenException(apiResponse.getMessages().get(0).getMessage());
                    }
                    throw new GeneralException();
                }
                documents.addAll((Collection)new Gson().fromJson((JsonElement)((JsonObject)response.body()).getAsJsonArray("results"), new TypeToken<ArrayList<Document>>(){}.getType()));
            }
            for (int i = 0; i < documents.size(); ++i) {
                String content = doactionHelper.getContentFromUrl(documents.get(i).getContent_url());
                ((Document)documents.get(i)).setContent(content);
                ((Document)documents.get(i)).setUserId(userInfo.getUser_id());
                ((Document)documents.get(i)).setPureContent(Jsoup.parse((String)content).text());
                ((Document)documents.get(i)).setDeletion_status(1);
            }
            Document.put(documents);
            return documents;
        }
        catch (IOException e) {
            if (doactionHelper.checkUserConnection()) {
                Sentry.captureException((Throwable)e);
                throw new ServerException();
            }
            throw new ConnectionException();
        }
    }

    public void deleteArchivedDocument(String uuid) throws ConnectionException, NotExistException, InvalidTokenException, GeneralException, SuccessException, ServerException {
        block11: {
            String access = userInfo.getAccess();
            try {
                Response response = dictationService.deleteArchivedDocument("fa-ir", "Token " + access, uuid).execute();
                if (!response.isSuccessful()) {
                    if (response.code() == 500) {
                        doactionHelper.captureExceptionSentryServerError();
                    }
                    ApiResponse apiResponse = null;
                    try {
                        apiResponse = (ApiResponse)new Gson().fromJson(response.errorBody().string(), ApiResponse.class);
                    }
                    catch (JsonSyntaxException e) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                TrayNotification tray = new TrayNotification("\u0644\u0637\u0641\u0627 \u0628\u0639\u062f\u0627 \u062a\u0644\u0627\u0634 \u06a9\u0646\u06cc\u062f.", Notifications.ERROR);
                                tray.showAndDismiss();
                            }
                        });
                    }
                    if (apiResponse.getCode() != null) {
                        if (apiResponse.getCode().equals("document_not_found")) {
                            throw new NotExistException(apiResponse.getMessage());
                        }
                        if (apiResponse.getCode().equals("token_not_valid")) {
                            throw new InvalidTokenException(apiResponse.getMessages().get(0).getMessage());
                        }
                        throw new GeneralException();
                    }
                    break block11;
                }
                System.out.println(response.body());
                Document document = doactionHelper.updateDocument(uuid, (JsonObject)response.body());
                Document.put(document);
                throw new SuccessException("\u0633\u0646\u062f \u0645\u0648\u0631\u062f \u0646\u0638\u0631 \u0628\u0627 \u0645\u0648\u0641\u0642\u06cc\u062a \u062d\u0630\u0641 \u0634\u062f.");
            }
            catch (IOException e) {
                if (e instanceof ProtocolException) {
                    Document document = Document.get(uuid);
                    document.setDeletion_status(2);
                    document.setUpdated_at(new Date());
                    document.setTrashed_date(new Date());
                    Document.put(document);
                    throw new SuccessException("\u0633\u0646\u062f \u0645\u0648\u0631\u062f \u0646\u0638\u0631 \u0628\u0627 \u0645\u0648\u0641\u0642\u06cc\u062a \u062d\u0630\u0641 \u0634\u062f");
                }
                if (doactionHelper.checkUserConnection()) {
                    Sentry.captureException((Throwable)e);
                    throw new ServerException();
                }
                throw new ConnectionException();
            }
        }
    }

    public void restoreArchivedDocument(String uuid) throws ConnectionException, NotExistException, InvalidTokenException, GeneralException, SuccessException, ServerException {
        block10: {
            String access = userInfo.getAccess();
            try {
                Response response = dictationService.restoreArchivedDocument("fa-ir", "Token " + access, uuid).execute();
                if (!response.isSuccessful()) {
                    if (response.code() == 500) {
                        doactionHelper.captureExceptionSentryServerError();
                    }
                    ApiResponse apiResponse = null;
                    try {
                        apiResponse = (ApiResponse)new Gson().fromJson(response.errorBody().string(), ApiResponse.class);
                    }
                    catch (JsonSyntaxException e) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                TrayNotification tray = new TrayNotification("\u0644\u0637\u0641\u0627 \u0628\u0639\u062f\u0627 \u062a\u0644\u0627\u0634 \u06a9\u0646\u06cc\u062f.", Notifications.ERROR);
                                tray.showAndDismiss();
                            }
                        });
                    }
                    if (apiResponse.getCode() != null) {
                        if (apiResponse.getCode().equals("document_not_found")) {
                            throw new NotExistException(apiResponse.getMessage());
                        }
                        if (apiResponse.getCode().equals("token_not_valid")) {
                            throw new InvalidTokenException(apiResponse.getMessages().get(0).getMessage());
                        }
                        throw new GeneralException();
                    }
                    break block10;
                }
                Document document = doactionHelper.updateDocument(uuid, (JsonObject)response.body());
                Document.put(document);
                throw new SuccessException("\u0633\u0646\u062f \u0645\u0648\u0631\u062f \u0646\u0638\u0631 \u0645\u062c\u062f\u062f\u0627 \u0630\u062e\u06cc\u0631\u0647 \u0634\u062f.");
            }
            catch (IOException e) {
                if (doactionHelper.checkUserConnection()) {
                    Sentry.captureException((Throwable)e);
                    throw new ServerException();
                }
                throw new ConnectionException();
            }
        }
    }

    public void exportDocument(String uuid, String format, String directory) throws ConnectionException, NotExistException, InvalidTokenException, GeneralException, ServerException {
        block10: {
            String access = userInfo.getAccess();
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("document_uuid", uuid);
            info.put("format", format);
            try {
                Response response = dictationService.postExportDocument("fa-ir", "Token " + access, info).execute();
                if (!response.isSuccessful()) {
                    if (response.code() == 500) {
                        doactionHelper.captureExceptionSentryServerError();
                    }
                    ApiResponse apiResponse = null;
                    try {
                        apiResponse = (ApiResponse)new Gson().fromJson(response.errorBody().string(), ApiResponse.class);
                    }
                    catch (JsonSyntaxException e) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                TrayNotification tray = new TrayNotification("\u0644\u0637\u0641\u0627 \u0628\u0639\u062f\u0627 \u062a\u0644\u0627\u0634 \u06a9\u0646\u06cc\u062f.", Notifications.ERROR);
                                tray.showAndDismiss();
                            }
                        });
                    }
                    if (apiResponse.getCode() != null) {
                        if (apiResponse.getCode().equals("document_not_found")) {
                            throw new NotExistException(apiResponse.getMessage());
                        }
                        if (apiResponse.getCode().equals("token_not_valid")) {
                            throw new InvalidTokenException(apiResponse.getMessages().get(0).getMessage());
                        }
                        throw new GeneralException();
                    }
                    break block10;
                }
                String target = String.valueOf(((JsonObject)response.body()).get("file_url"));
                target = target.replace("\"", "");
                System.out.println("target: " + target);
                doactionHelper.download(directory, target);
            }
            catch (IOException e) {
                if (doactionHelper.checkUserConnection()) {
                    Sentry.captureException((Throwable)e);
                    throw new ServerException();
                }
                throw new ConnectionException();
            }
        }
    }

    public DocumentLabel addLabelToDocument(String uuid, long labelId) throws ConnectionException, NotExistException, InvalidTokenException, GeneralException, ServerException {
        String access = userInfo.getAccess();
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("document_uuid", uuid);
        info.put("label_id", String.valueOf(labelId));
        try {
            Response response = dictationService.postDocumentLabelList("fa-ir", "Token " + access, info).execute();
            if (!response.isSuccessful()) {
                String error;
                if (response.code() == 500) {
                    doactionHelper.captureExceptionSentryServerError();
                }
                if ((error = response.errorBody().string()).contains("label_id")) {
                    throw new NotExistException("\u0628\u0631 \u0686\u0633\u0628 \u0645\u0648\u0631\u062f \u0646\u0638\u0631 \u0645\u0648\u062c\u0648\u062f \u0646\u06cc\u0633\u062a");
                }
                if (error.contains("document_uuid")) {
                    throw new NotExistException("\u0633\u0646\u062f \u0645\u0648\u0631\u062f \u0646\u0638\u0631 \u0645\u0648\u062c\u0648\u062f \u0646\u06cc\u0633\u062a");
                }
                ApiResponse apiResponse = null;
                try {
                    apiResponse = (ApiResponse)new Gson().fromJson(response.errorBody().string(), ApiResponse.class);
                }
                catch (JsonSyntaxException e) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            TrayNotification tray = new TrayNotification("\u0644\u0637\u0641\u0627 \u0628\u0639\u062f\u0627 \u062a\u0644\u0627\u0634 \u06a9\u0646\u06cc\u062f.", Notifications.ERROR);
                            tray.showAndDismiss();
                        }
                    });
                }
                if (apiResponse.getCode() != null) {
                    if (apiResponse.getCode().equals("document_not_found")) {
                        throw new NotExistException(apiResponse.getMessage());
                    }
                    if (apiResponse.getCode().equals("token_not_valid")) {
                        throw new InvalidTokenException(apiResponse.getMessages().get(0).getMessage());
                    }
                }
                throw new GeneralException();
            }
            DocumentLabel documentLabel = (DocumentLabel)new Gson().fromJson((JsonElement)response.body(), DocumentLabel.class);
            documentLabel.setUserId(userInfo.getUser_id());
            DocumentLabel.put(documentLabel);
            Document document = this.getDocument(uuid, false);
            return documentLabel;
        }
        catch (IOException e) {
            if (doactionHelper.checkUserConnection()) {
                Sentry.captureException((Throwable)e);
                throw new ServerException();
            }
            throw new ConnectionException();
        }
    }

    public ArrayList<DocumentLabel> getDocumentLabels() throws ConnectionException, GeneralException, InvalidTokenException, ServerException {
        String access = userInfo.getAccess();
        try {
            Response response = dictationService.getDocumentLabelList("fa-ir", "Token " + access, 10, 0).execute();
            if (!response.isSuccessful()) {
                ApiResponse apiResponse;
                if (response.code() == 500) {
                    doactionHelper.captureExceptionSentryServerError();
                }
                if ((apiResponse = (ApiResponse)new Gson().fromJson(response.errorBody().string(), ApiResponse.class)).getCode().equals("token_not_valid")) {
                    throw new InvalidTokenException(apiResponse.getMessages().get(0).getMessage());
                }
                throw new GeneralException();
            }
            String cnt = String.valueOf(((JsonObject)response.body()).get("count"));
            int count = Integer.parseInt(cnt);
            ArrayList documentLabels = new ArrayList();
            if (count > 0) {
                documentLabels = (ArrayList)new Gson().fromJson((JsonElement)((JsonObject)response.body()).getAsJsonArray("results"), new TypeToken<ArrayList<DocumentLabel>>(){}.getType());
            }
            if (count > 10) {
                response = dictationService.getDocumentLabelList("fa-ir", "Token " + access, count - 10, 10).execute();
                if (!response.isSuccessful()) {
                    ApiResponse apiResponse = (ApiResponse)new Gson().fromJson(response.errorBody().string(), ApiResponse.class);
                    if (apiResponse.getCode() != null && apiResponse.getCode().equals("token_not_valid")) {
                        throw new InvalidTokenException(apiResponse.getMessages().get(0).getMessage());
                    }
                    throw new GeneralException();
                }
                documentLabels.addAll((Collection)new Gson().fromJson((JsonElement)((JsonObject)response.body()).getAsJsonArray("results"), new TypeToken<ArrayList<DocumentLabel>>(){}.getType()));
            }
            for (int i = 0; i < documentLabels.size(); ++i) {
                documentLabels.get(i).setUserId(userInfo.getUser_id());
            }
            DocumentLabel.put(documentLabels);
            return documentLabels;
        }
        catch (IOException e) {
            if (doactionHelper.checkUserConnection()) {
                Sentry.captureException((Throwable)e);
                throw new ServerException();
            }
            throw new ConnectionException();
        }
    }

    public void removeDocumentLabel(long id) throws NotExistException, InvalidTokenException, GeneralException, SuccessException, ConnectionException, ServerException {
        String access = userInfo.getAccess();
        try {
            Response response = dictationService.deleteDocumentLabel("fa-ir", "Token " + access, String.valueOf(id)).execute();
            if (!response.isSuccessful()) {
                if (response.code() == 500) {
                    doactionHelper.captureExceptionSentryServerError();
                }
                ApiResponse apiResponse = null;
                try {
                    apiResponse = (ApiResponse)new Gson().fromJson(response.errorBody().string(), ApiResponse.class);
                }
                catch (JsonSyntaxException e) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            TrayNotification tray = new TrayNotification("\u0644\u0637\u0641\u0627 \u0628\u0639\u062f\u0627 \u062a\u0644\u0627\u0634 \u06a9\u0646\u06cc\u062f.", Notifications.ERROR);
                            tray.showAndDismiss();
                        }
                    });
                }
                if (apiResponse.getCode() != null) {
                    if (apiResponse.getCode().contains("document_not_found")) {
                        throw new NotExistException(apiResponse.getMessage());
                    }
                    if (apiResponse.getCode().contains("token_not_valid")) {
                        throw new InvalidTokenException(apiResponse.getMessages().get(0).getMessage());
                    }
                }
                if (apiResponse.getDetail() != null && apiResponse.getDetail().equals("Not found.")) {
                    throw new NotExistException("\u0628\u0631\u0686\u0633\u0628 \u0645\u0648\u0631\u062f \u0646\u0638\u0631 \u0645\u0648\u062c\u0648\u062f \u0646\u0645\u06cc \u0628\u0627\u0634\u062f");
                }
                throw new GeneralException();
            }
            this.getDocument(DocumentLabel.get(id).getDocument_uuid(), false);
            DocumentLabel.remove(id);
            throw new SuccessException();
        }
        catch (IOException e) {
            if (e instanceof ProtocolException) {
                this.getDocument(DocumentLabel.get(id).getDocument_uuid(), false);
                throw new SuccessException();
            }
            if (doactionHelper.checkUserConnection()) {
                Sentry.captureException((Throwable)e);
                throw new ServerException();
            }
            throw new ConnectionException();
        }
    }

    public ArrayList<Plan> getUserPlans() throws ConnectionException, GeneralException, InvalidTokenException, ServerException {
        String access = userInfo.getAccess();
        try {
            Response response = dictationService.getUserPlanList("fa-ir", "Token " + access, 10, 0).execute();
            if (!response.isSuccessful()) {
                ApiResponse apiResponse;
                if (response.code() == 500) {
                    doactionHelper.captureExceptionSentryServerError();
                }
                if ((apiResponse = (ApiResponse)new Gson().fromJson(response.errorBody().string(), ApiResponse.class)).getCode().contains("token_not_valid")) {
                    throw new InvalidTokenException(apiResponse.getMessages().get(0).getMessage());
                }
                throw new GeneralException();
            }
            String cnt = String.valueOf(((JsonObject)response.body()).get("count"));
            int count = Integer.parseInt(cnt);
            ArrayList plans = new ArrayList();
            if (count > 0) {
                plans = (ArrayList)new Gson().fromJson((JsonElement)((JsonObject)response.body()).getAsJsonArray("results"), new TypeToken<ArrayList<Plan>>(){}.getType());
            }
            if (count > 10) {
                response = dictationService.getUserPlanList("fa-ir", "Token " + access, count - 10, 10).execute();
                if (!response.isSuccessful()) {
                    if (response.code() == 500) {
                        doactionHelper.captureExceptionSentryServerError();
                    }
                    ApiResponse apiResponse = null;
                    try {
                        apiResponse = (ApiResponse)new Gson().fromJson(response.errorBody().string(), ApiResponse.class);
                    }
                    catch (JsonSyntaxException e) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                TrayNotification tray = new TrayNotification("\u0644\u0637\u0641\u0627 \u0628\u0639\u062f\u0627 \u062a\u0644\u0627\u0634 \u06a9\u0646\u06cc\u062f.", Notifications.ERROR);
                                tray.showAndDismiss();
                            }
                        });
                    }
                    if (apiResponse.getCode() != null && apiResponse.getCode().equals("token_not_valid")) {
                        throw new InvalidTokenException(apiResponse.getMessages().get(0).getMessage());
                    }
                    throw new GeneralException();
                }
                plans.addAll((Collection)new Gson().fromJson((JsonElement)((JsonObject)response.body()).getAsJsonArray("results"), new TypeToken<ArrayList<Plan>>(){}.getType()));
            }
            boolean flag = false;
            for (int i = 0; i < plans.size(); ++i) {
                plans.get(i).setUser(userInfo.getUser_id());
                if (!((Plan)plans.get(i)).getPlan_speciality().equals("basic") && !((Plan)plans.get(i)).isIs_expired()) {
                    userInfo.setHaveGoldenPlan(true);
                    flag = true;
                }
                if (flag) continue;
                userInfo.setHaveGoldenPlan(false);
            }
            Plan.put(plans);
            return plans;
        }
        catch (IOException e) {
            if (doactionHelper.checkUserConnection()) {
                Sentry.captureException((Throwable)e);
                throw new ServerException();
            }
            throw new ConnectionException();
        }
    }

    public ArrayList<DefaultPlan> getDefaultPlans() throws ConnectionException, NotExistException, InvalidTokenException, GeneralException, ServerException {
        String access = userInfo.getAccess();
        try {
            Response response = dictationService.getPlans("fa-ir", "Token " + access, 10, 0).execute();
            if (!response.isSuccessful()) {
                if (response.code() == 500) {
                    doactionHelper.captureExceptionSentryServerError();
                }
                ApiResponse apiResponse = null;
                try {
                    apiResponse = (ApiResponse)new Gson().fromJson(response.errorBody().string(), ApiResponse.class);
                }
                catch (JsonSyntaxException e) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            TrayNotification tray = new TrayNotification("\u0644\u0637\u0641\u0627 \u0628\u0639\u062f\u0627 \u062a\u0644\u0627\u0634 \u06a9\u0646\u06cc\u062f.", Notifications.ERROR);
                            tray.showAndDismiss();
                        }
                    });
                }
                if (apiResponse.getDetail() != null && apiResponse.getDetail().equals("Not found.")) {
                    throw new NotExistException("\u0637\u0631\u062d \u0645\u0648\u0631\u062f \u0646\u0638\u0631 \u0648\u062c\u0648\u062f \u0646\u062f\u0627\u0631\u062f.");
                }
                if (apiResponse.getCode() != null && apiResponse.getCode().equals("token_not_valid")) {
                    throw new InvalidTokenException(apiResponse.getMessages().get(0).getMessage());
                }
                throw new GeneralException();
            }
            String cnt = String.valueOf(((JsonObject)response.body()).get("count"));
            int count = Integer.parseInt(cnt);
            ArrayList plans = new ArrayList();
            if (count > 0) {
                plans = (ArrayList)new Gson().fromJson((JsonElement)((JsonObject)response.body()).getAsJsonArray("results"), new TypeToken<ArrayList<DefaultPlan>>(){}.getType());
            }
            if (count > 10) {
                response = dictationService.getPlans("fa-ir", "Token " + access, count - 10, 10).execute();
                if (!response.isSuccessful()) {
                    if (response.code() == 500) {
                        doactionHelper.captureExceptionSentryServerError();
                    }
                    ApiResponse apiResponse = null;
                    try {
                        apiResponse = (ApiResponse)new Gson().fromJson(response.errorBody().string(), ApiResponse.class);
                    }
                    catch (JsonSyntaxException e) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                TrayNotification tray = new TrayNotification("\u0644\u0637\u0641\u0627 \u0628\u0639\u062f\u0627 \u062a\u0644\u0627\u0634 \u06a9\u0646\u06cc\u062f.", Notifications.ERROR);
                                tray.showAndDismiss();
                            }
                        });
                    }
                    if (apiResponse.getCode() != null && apiResponse.getCode().equals("token_not_valid")) {
                        throw new InvalidTokenException(apiResponse.getMessages().get(0).getMessage());
                    }
                    throw new GeneralException();
                }
                plans.addAll((Collection)new Gson().fromJson((JsonElement)((JsonObject)response.body()).getAsJsonArray("results"), new TypeToken<ArrayList<DefaultPlan>>(){}.getType()));
                boolean bl = false;
            }
            if (plans.size() > 0) {
                DefaultPlan.put(plans);
            }
            return plans;
        }
        catch (IOException e) {
            if (doactionHelper.checkUserConnection()) {
                Sentry.captureException((Throwable)e);
                throw new ServerException();
            }
            throw new ConnectionException();
        }
    }

    public String buyPaidPlan(long plan_id) throws GeneralException, ServerException, ConnectionException {
        String access = userInfo.getAccess();
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("plan_id", String.valueOf(plan_id));
        try {
            Response response = dictationService.buyPainPlan("fa-ir", "Token " + access, info).execute();
            if (!response.isSuccessful()) {
                if (response.code() == 500) {
                    doactionHelper.captureExceptionSentryServerError();
                }
                ApiResponse apiResponse = null;
                try {
                    apiResponse = (ApiResponse)new Gson().fromJson(response.errorBody().string(), ApiResponse.class);
                }
                catch (JsonSyntaxException e) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            TrayNotification tray = new TrayNotification("\u0644\u0637\u0641\u0627 \u0628\u0639\u062f\u0627 \u062a\u0644\u0627\u0634 \u06a9\u0646\u06cc\u062f.", Notifications.ERROR);
                            tray.showAndDismiss();
                        }
                    });
                }
                throw new GeneralException();
            }
            String url = ((JsonObject)response.body()).get("redirect_url").toString();
            return url.replace("\"", "");
        }
        catch (IOException e) {
            if (doactionHelper.checkUserConnection()) {
                Sentry.captureException((Throwable)e);
                throw new ServerException();
            }
            throw new ConnectionException();
        }
    }

    public PunctuationMark createPunctuationMark(String word, String mark) throws AlreadyExistException, InvalidTokenException, GeneralException, ConnectionException, ServerException {
        String access = userInfo.getAccess();
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("mark", mark);
        info.put("word", word);
        try {
            Response response = dictationService.createPunctuationMark("fa-ir", "Token " + access, info).execute();
            if (!response.isSuccessful()) {
                if (response.code() == 500) {
                    doactionHelper.captureExceptionSentryServerError();
                }
                String error = response.errorBody().string();
                ApiResponse apiResponse = null;
                try {
                    apiResponse = (ApiResponse)new Gson().fromJson(response.errorBody().string(), ApiResponse.class);
                }
                catch (JsonSyntaxException e) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            TrayNotification tray = new TrayNotification("\u0644\u0637\u0641\u0627 \u0628\u0639\u062f\u0627 \u062a\u0644\u0627\u0634 \u06a9\u0646\u06cc\u062f.", Notifications.ERROR);
                            tray.showAndDismiss();
                        }
                    });
                }
                if (apiResponse.getCode() != null) {
                    if (apiResponse.getCode().equals("punctuation_exists")) {
                        throw new AlreadyExistException(apiResponse.getMessage());
                    }
                    if (apiResponse.getCode().equals("token_not_valid")) {
                        throw new InvalidTokenException(apiResponse.getMessages().get(0).getMessage());
                    }
                }
                throw new GeneralException();
            }
            PunctuationMark punctuationMark = (PunctuationMark)new Gson().fromJson((JsonElement)response.body(), PunctuationMark.class);
            punctuationMark.setUserId(userInfo.getUser_id());
            punctuationMark.setActive(true);
            punctuationsProcessing.add(word, mark);
            PunctuationMark.put(punctuationMark);
            return punctuationMark;
        }
        catch (IOException e) {
            if (doactionHelper.checkUserConnection()) {
                Sentry.captureException((Throwable)e);
                throw new ServerException();
            }
            throw new ConnectionException();
        }
    }

    public ArrayList<PunctuationMark> getUserPunctuationMark() throws GeneralException, InvalidTokenException, ConnectionException, ServerException {
        String access = userInfo.getAccess();
        try {
            Response response = dictationService.getUserPunctuationMarkList("fa-ir", "Token " + access, 10, 0).execute();
            if (!response.isSuccessful()) {
                ApiResponse apiResponse;
                if (response.code() == 500) {
                    doactionHelper.captureExceptionSentryServerError();
                }
                if ((apiResponse = (ApiResponse)new Gson().fromJson(response.errorBody().string(), ApiResponse.class)).getCode().equals("token_not_valid")) {
                    throw new InvalidTokenException(apiResponse.getMessages().get(0).getMessage());
                }
                throw new GeneralException();
            }
            String cnt = String.valueOf(((JsonObject)response.body()).get("count"));
            int count = Integer.parseInt(cnt);
            ArrayList punctuationMarks = new ArrayList();
            if (count > 0) {
                punctuationMarks = (ArrayList)new Gson().fromJson((JsonElement)((JsonObject)response.body()).getAsJsonArray("results"), new TypeToken<ArrayList<PunctuationMark>>(){}.getType());
            }
            if (count > 10) {
                response = dictationService.getUserPunctuationMarkList("fa-ir", "Token " + access, count - 10, 10).execute();
                if (!response.isSuccessful()) {
                    if (response.code() == 500) {
                        doactionHelper.captureExceptionSentryServerError();
                    }
                    ApiResponse apiResponse = null;
                    try {
                        apiResponse = (ApiResponse)new Gson().fromJson(response.errorBody().string(), ApiResponse.class);
                    }
                    catch (JsonSyntaxException e) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                TrayNotification tray = new TrayNotification("\u0644\u0637\u0641\u0627 \u0628\u0639\u062f\u0627 \u062a\u0644\u0627\u0634 \u06a9\u0646\u06cc\u062f.", Notifications.ERROR);
                                tray.showAndDismiss();
                            }
                        });
                    }
                    if (apiResponse.getCode() != null && apiResponse.getCode().equals("token_not_valid")) {
                        throw new InvalidTokenException(apiResponse.getMessages().get(0).getMessage());
                    }
                    throw new GeneralException();
                }
                punctuationMarks.addAll((Collection)new Gson().fromJson((JsonElement)((JsonObject)response.body()).getAsJsonArray("results"), new TypeToken<ArrayList<PunctuationMark>>(){}.getType()));
            }
            for (PunctuationMark punctuationMark : punctuationMarks) {
                PunctuationMark DBMark = PunctuationMark.get(punctuationMark.getId());
                if (DBMark == null) {
                    punctuationMark.setActive(true);
                } else {
                    punctuationMark.setActive(DBMark.isActive());
                }
                punctuationMark.setUserId(userInfo.getUser_id());
            }
            PunctuationMark.put(punctuationMarks);
            doactionHelper.coordinationRemovedUserPunc(punctuationMarks);
            return punctuationMarks;
        }
        catch (IOException e) {
            if (doactionHelper.checkUserConnection()) {
                Sentry.captureException((Throwable)e);
                throw new ServerException();
            }
            throw new ConnectionException();
        }
    }

    public PunctuationMark editPunctuationMark(String word, String mark, long punctuationId) throws GeneralException, InvalidTokenException, AlreadyExistException, NotExistException, ConnectionException, ServerException {
        String access = userInfo.getAccess();
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("mark", mark);
        info.put("word", word);
        try {
            Response response = dictationService.editPunctuationMark("fa-ir", "Token " + access, String.valueOf(punctuationId), info).execute();
            if (!response.isSuccessful()) {
                if (response.code() == 500) {
                    doactionHelper.captureExceptionSentryServerError();
                }
                String error = response.errorBody().string();
                ApiResponse apiResponse = null;
                try {
                    apiResponse = (ApiResponse)new Gson().fromJson(response.errorBody().string(), ApiResponse.class);
                }
                catch (JsonSyntaxException e) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            TrayNotification tray = new TrayNotification("\u0644\u0637\u0641\u0627 \u0628\u0639\u062f\u0627 \u062a\u0644\u0627\u0634 \u06a9\u0646\u06cc\u062f.", Notifications.ERROR);
                            tray.showAndDismiss();
                        }
                    });
                }
                if (apiResponse.getCode() != null) {
                    if (apiResponse.getDetail().contains("\u0645\u0648\u0631\u062f\u06cc \u06cc\u0627\u0641\u062a \u0646\u0634\u062f")) {
                        throw new NotExistException("\u0639\u0644\u0627 \u0645\u062a \u0646\u06af\u0627\u0631\u0634\u06cc \u0645\u0648\u0631\u062f \u0646\u0638\u0631 \u0648\u062c\u0648\u062f \u0646\u062f\u0627\u0631\u062f.");
                    }
                    if (apiResponse.getCode().equals("token_not_valid")) {
                        throw new InvalidTokenException(apiResponse.getMessages().get(0).getMessage());
                    }
                }
                throw new GeneralException();
            }
            PunctuationMark punctuationMark = (PunctuationMark)new Gson().fromJson((JsonElement)response.body(), PunctuationMark.class);
            punctuationMark.setUserId(userInfo.getUser_id());
            if (PunctuationMark.get(punctuationId).isActive()) {
                punctuationMark.setActive(true);
            }
            PunctuationMark.put(punctuationMark);
            return punctuationMark;
        }
        catch (IOException e) {
            if (doactionHelper.checkUserConnection()) {
                Sentry.captureException((Throwable)e);
                throw new ServerException();
            }
            throw new ConnectionException();
        }
    }

    public void deletePunctuationMark(long punctuationId) throws SuccessException, InvalidTokenException, NotExistException, GeneralException, ConnectionException, ServerException {
        String access = userInfo.getAccess();
        try {
            Response response = dictationService.deletePunctuationMark("fa-ir", "Token " + access, String.valueOf(punctuationId)).execute();
            if (!response.isSuccessful()) {
                if (response.code() == 500) {
                    doactionHelper.captureExceptionSentryServerError();
                }
                ApiResponse apiResponse = null;
                try {
                    apiResponse = (ApiResponse)new Gson().fromJson(response.errorBody().string(), ApiResponse.class);
                }
                catch (JsonSyntaxException e) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            TrayNotification tray = new TrayNotification("\u0644\u0637\u0641\u0627 \u0628\u0639\u062f\u0627 \u062a\u0644\u0627\u0634 \u06a9\u0646\u06cc\u062f.", Notifications.ERROR);
                            tray.showAndDismiss();
                        }
                    });
                }
                if (response.code() == 206) {
                    PunctuationMark.remove(punctuationId);
                    throw new SuccessException("\u0639\u0644\u0627\u0645\u062a \u0646\u06af\u0627\u0631\u0634\u06cc \u0645\u0648\u0631\u062f \u0646\u0638\u0631 \u0628\u0627 \u0645\u0648\u0641\u0642\u06cc\u062a \u062d\u0630\u0641 \u0634\u062f.");
                }
                if (response.code() == 404) {
                    throw new NotExistException("\u0639\u0644\u0627\u0645\u062a \u0646\u06af\u0627\u0631\u0634\u06cc \u0645\u0648\u0631\u062f \u0646\u0638\u0631 \u0648\u062c\u0648\u062f \u0646\u062f\u0627\u0631\u062f.");
                }
                if (apiResponse.getCode() != null) {
                    if (apiResponse.getDetail().contains("\u06cc\u0627\u0641\u062a \u0646\u0634\u062f")) {
                        throw new NotExistException("\u0639\u0644\u0627\u0645\u062a \u0646\u06af\u0627\u0631\u0634\u06cc \u0645\u0648\u0631\u062f \u0646\u0638\u0631 \u0648\u062c\u0648\u062f \u0646\u062f\u0627\u0631\u062f.");
                    }
                    if (response.code() == 206) {
                        PunctuationMark.remove(punctuationId);
                        throw new SuccessException(apiResponse.getMessage());
                    }
                    if (apiResponse.getCode().equals("token_not_valid")) {
                        throw new InvalidTokenException(apiResponse.getMessages().get(0).getMessage());
                    }
                }
                throw new GeneralException();
            }
            punctuationsProcessing.remove(PunctuationMark.get(punctuationId).getWord());
            PunctuationMark.remove(punctuationId);
            throw new SuccessException("\u0639\u0644\u0627\u0645\u062a \u0646\u06af\u0627\u0631\u0634\u06cc \u0645\u0648\u0631\u062f \u0646\u0638\u0631 \u0628\u0627 \u0645\u0648\u0641\u0642\u06cc\u062a \u062d\u0630\u0641 \u0634\u062f.");
        }
        catch (IOException e) {
            if (doactionHelper.checkUserConnection()) {
                Sentry.captureException((Throwable)e);
                throw new ServerException();
            }
            throw new ConnectionException();
        }
    }

    public ArrayList<Accent> getAccents() throws ConnectionException, GeneralException, ServerException {
        try {
            Response response = dictationService.getAccentList("fa-ir", 10, 0).execute();
            if (!response.isSuccessful()) {
                if (response.code() == 500) {
                    doactionHelper.captureExceptionSentryServerError();
                }
                throw new GeneralException();
            }
            String cnt = String.valueOf(((JsonObject)response.body()).get("count"));
            int count = Integer.valueOf(cnt);
            ArrayList accents = new ArrayList();
            if (count > 0) {
                accents = (ArrayList)new Gson().fromJson((JsonElement)((JsonObject)response.body()).getAsJsonArray("results"), new TypeToken<ArrayList<Accent>>(){}.getType());
            }
            if (count > 10) {
                response = dictationService.getAccentList("fa-ir", count - 10, 10).execute();
                if (!response.isSuccessful()) {
                    throw new GeneralException();
                }
                accents.addAll((Collection)new Gson().fromJson((JsonElement)((JsonObject)response.body()).getAsJsonArray("results"), new TypeToken<ArrayList<Accent>>(){}.getType()));
            }
            Accent.put(accents);
            return accents;
        }
        catch (IOException e) {
            if (doactionHelper.checkUserConnection()) {
                Sentry.captureException((Throwable)e);
                throw new ServerException();
            }
            throw new ConnectionException();
        }
    }

    public ArrayList<SpeechModel> getSpeechModel() throws ServerException, ConnectionException, GeneralException {
        System.out.println("get speech model");
        try {
            Response response = dictationService.getSpeechModel("fa-ir", 10, 0).execute();
            if (!response.isSuccessful()) {
                System.out.println("not successfull");
                if (response.code() == 500) {
                    doactionHelper.captureExceptionSentryServerError();
                }
                throw new GeneralException();
            }
            String cnt = String.valueOf(((JsonObject)response.body()).get("count"));
            int count = Integer.valueOf(cnt);
            ArrayList speechModels = new ArrayList();
            if (count > 0) {
                speechModels = (ArrayList)new Gson().fromJson((JsonElement)((JsonObject)response.body()).getAsJsonArray("results"), new TypeToken<ArrayList<SpeechModel>>(){}.getType());
            }
            if (count > 10) {
                response = dictationService.getSpeechModel("fa-ir", count - 10, 10).execute();
                if (!response.isSuccessful()) {
                    throw new GeneralException();
                }
                speechModels.addAll((Collection)new Gson().fromJson((JsonElement)((JsonObject)response.body()).getAsJsonArray("results"), new TypeToken<ArrayList<SpeechModel>>(){}.getType()));
            }
            System.out.println("size: " + speechModels.size());
            SpeechModel.put(speechModels);
            return speechModels;
        }
        catch (IOException e) {
            if (doactionHelper.checkUserConnection()) {
                Sentry.captureException((Throwable)e);
                throw new ServerException();
            }
            throw new ConnectionException();
        }
    }

    public ArrayList<Province> getProvinces() throws GeneralException, ConnectionException, ServerException {
        try {
            Response response = dictationService.getProvinceList("fa-ir", 10, 0).execute();
            if (!response.isSuccessful()) {
                if (response.code() == 500) {
                    doactionHelper.captureExceptionSentryServerError();
                }
                throw new GeneralException();
            }
            String cnt = String.valueOf(((JsonObject)response.body()).get("count"));
            int count = Integer.valueOf(cnt);
            ArrayList provinces = new ArrayList();
            if (count > 0) {
                provinces = (ArrayList)new Gson().fromJson((JsonElement)((JsonObject)response.body()).getAsJsonArray("results"), new TypeToken<ArrayList<Province>>(){}.getType());
            }
            if (count > 10) {
                response = dictationService.getProvinceList("fa-ir", count - 10, 10).execute();
                if (!response.isSuccessful()) {
                    throw new GeneralException();
                }
                provinces.addAll((Collection)new Gson().fromJson((JsonElement)((JsonObject)response.body()).getAsJsonArray("results"), new TypeToken<ArrayList<Province>>(){}.getType()));
            }
            Province.put(provinces);
            return provinces;
        }
        catch (IOException e) {
            if (doactionHelper.checkUserConnection()) {
                Sentry.captureException((Throwable)e);
                throw new ServerException();
            }
            throw new ConnectionException();
        }
    }

    public ArrayList<Education> getEducations() throws GeneralException, ConnectionException, ServerException {
        try {
            Response response = dictationService.getEducationList("fa-ir", 10, 0).execute();
            if (!response.isSuccessful()) {
                if (response.code() == 500) {
                    doactionHelper.captureExceptionSentryServerError();
                }
                throw new GeneralException();
            }
            String cnt = String.valueOf(((JsonObject)response.body()).get("count"));
            int count = Integer.valueOf(cnt);
            ArrayList educations = new ArrayList();
            if (count > 0) {
                educations = (ArrayList)new Gson().fromJson((JsonElement)((JsonObject)response.body()).getAsJsonArray("results"), new TypeToken<ArrayList<Education>>(){}.getType());
            }
            if (count > 10) {
                response = dictationService.getEducationList("fa-ir", count - 10, 10).execute();
                if (!response.isSuccessful()) {
                    throw new GeneralException();
                }
                educations.addAll((Collection)new Gson().fromJson((JsonElement)((JsonObject)response.body()).getAsJsonArray("results"), new TypeToken<ArrayList<Education>>(){}.getType()));
            }
            Education.put(educations);
            return educations;
        }
        catch (IOException e) {
            if (doactionHelper.checkUserConnection()) {
                Sentry.captureException((Throwable)e);
                doactionHelper.captureExceptionServer();
                throw new ServerException();
            }
            throw new ConnectionException();
        }
    }

    public ArrayList<DefaultPunctuationMark> getDefaultPunctuation() throws GeneralException, ConnectionException, ServerException {
        try {
            Response response = dictationService.getDefaultPunctuationMarkList("fa-ir", 10, 0).execute();
            if (!response.isSuccessful()) {
                throw new GeneralException();
            }
            String cnt = String.valueOf(((JsonObject)response.body()).get("count"));
            int count = Integer.valueOf(cnt);
            ArrayList defaultPunctuationMarks = new ArrayList();
            if (count > 0) {
                defaultPunctuationMarks = (ArrayList)new Gson().fromJson((JsonElement)((JsonObject)response.body()).getAsJsonArray("results"), new TypeToken<ArrayList<DefaultPunctuationMark>>(){}.getType());
            }
            if (count > 10) {
                response = dictationService.getDefaultPunctuationMarkList("fa-ir", count - 10, 10).execute();
                if (!response.isSuccessful()) {
                    if (response.code() == 500) {
                        doactionHelper.captureExceptionSentryServerError();
                    }
                    throw new GeneralException();
                }
                defaultPunctuationMarks.addAll((Collection)new Gson().fromJson((JsonElement)((JsonObject)response.body()).getAsJsonArray("results"), new TypeToken<ArrayList<DefaultPunctuationMark>>(){}.getType()));
            }
            for (DefaultPunctuationMark defaultPunctuationMark : defaultPunctuationMarks) {
                DefaultPunctuationMark punctuationMark = DefaultPunctuationMark.get(defaultPunctuationMark.getId());
                System.out.println("default punc");
                if (punctuationMark == null) {
                    System.out.println("set active default");
                    defaultPunctuationMark.setActive(true);
                    continue;
                }
                System.out.println("before");
                defaultPunctuationMark.setActive(punctuationMark.isActive());
            }
            DefaultPunctuationMark.put(defaultPunctuationMarks);
            return defaultPunctuationMarks;
        }
        catch (IOException e) {
            if (doactionHelper.checkUserConnection()) {
                Sentry.captureException((Throwable)e);
                throw new ServerException();
            }
            throw new ConnectionException();
        }
    }

    public HashMap<String, String> login(String username, String password) throws ConnectionException, UserNotFoundException, GeneralException, InvalidTokenException, InvalidDataException, ServerException {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("username", username);
        info.put("password", password);
        try {
            Response response = dictationService.login("fa-ir", info).execute();
            if (!response.isSuccessful()) {
                ApiResponse apiResponse;
                if (response.code() == 500) {
                    doactionHelper.captureExceptionSentryServerError();
                }
                if ((apiResponse = (ApiResponse)new Gson().fromJson(response.errorBody().string(), ApiResponse.class)).getCode() != null) {
                    if (apiResponse.getCode().equals("user_not_found")) {
                        throw new UserNotFoundException(apiResponse.getMessage());
                    }
                    if (apiResponse.getCode().equals("invalid_username")) {
                        throw new InvalidDataException("\u0646\u0627\u0645 \u06a9\u0627\u0631\u0628\u0631\u06cc \u0646\u0627\u0645\u0639\u062a\u0628\u0631 \u0627\u0633\u062a.");
                    }
                    if (apiResponse.getCode().equals("token_not_valid")) {
                        throw new InvalidTokenException(apiResponse.getMessages().get(0).getMessage());
                    }
                }
                throw new GeneralException();
            }
            info = this.getHashMap((JsonObject)response.body());
            userInfo.setAccess(info.get("access"));
            userInfo.setRefresh(info.get("refresh"));
            userInfo.setUser_id(userInfo.decodeToken(userInfo.getAccess()));
            UserData userData = UserData.get();
            if (userData != null) {
                userData.setUserId(userInfo.getUser_id());
                userData.setRefresh(userInfo.getRefresh());
                userData.setAccess(userInfo.getAccess());
                UserData.put(userData);
            }
            return info;
        }
        catch (IOException e) {
            if (doactionHelper.checkUserConnection()) {
                Sentry.captureException((Throwable)e);
                throw new ServerException();
            }
            throw new ConnectionException();
        }
    }

    public HashMap<String, String> renewAccessWithRefresh() throws ConnectionException, InvalidTokenException, GeneralException, ServerException {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("refresh", userInfo.getRefresh());
        try {
            Response response = dictationService.renewAccessWithRefresh("fa-ir", info).execute();
            if (!response.isSuccessful()) {
                if (response.code() == 500) {
                    doactionHelper.captureExceptionSentryServerError();
                }
                ApiResponse apiResponse = null;
                try {
                    apiResponse = (ApiResponse)new Gson().fromJson(response.errorBody().string(), ApiResponse.class);
                }
                catch (JsonSyntaxException e) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            TrayNotification tray = new TrayNotification("\u0644\u0637\u0641\u0627 \u0628\u0639\u062f\u0627 \u062a\u0644\u0627\u0634 \u06a9\u0646\u06cc\u062f.", Notifications.ERROR);
                            tray.showAndDismiss();
                        }
                    });
                }
                if (apiResponse.getCode() != null && apiResponse.getCode().equals("token_not_valid")) {
                    throw new InvalidTokenException("\u0644\u0637\u0641\u0627 \u0645\u062c\u062f\u062f\u0627 \u0646\u0627\u0645 \u06a9\u0627\u0631\u0628\u0631\u06cc \u0648 \u0631\u0645\u0632 \u0639\u0628\u0648\u0631 \u062e\u0648\u062f \u0631\u0627 \u0648\u0627\u0631\u062f \u06a9\u0646\u06cc\u062f.");
                }
                throw new GeneralException();
            }
            info = this.getHashMap((JsonObject)response.body());
            userInfo.setAccess(info.get("access"));
            userInfo.setUser_id(userInfo.decodeToken(userInfo.getAccess()));
            UserData userData = UserData.get();
            if (userData != null) {
                userData.setUserId(userInfo.getUser_id());
                userData.setRefresh(userInfo.getRefresh());
                userData.setAccess(userInfo.getAccess());
                UserData.put(userData);
            }
            return info;
        }
        catch (IOException e) {
            if (doactionHelper.checkUserConnection()) {
                Sentry.captureException((Throwable)e);
                throw new ServerException();
            }
            throw new ConnectionException();
        }
    }

    public void phoneRegister(String mobile_number) throws InvalidFormatException, AlreadyExistException, ServerException, ConnectionException, SuccessException, TooManyRequestException, GeneralException {
        block10: {
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("mobile_number", mobile_number);
            try {
                Response response = dictationService.phoneRegister("fa_ir", info).execute();
                ApiResponse apiResponse = null;
                if (!response.isSuccessful()) {
                    if (response.code() == 500) {
                        doactionHelper.captureExceptionSentryServerError();
                    }
                    try {
                        apiResponse = (ApiResponse)new Gson().fromJson(response.errorBody().string(), ApiResponse.class);
                    }
                    catch (JsonSyntaxException e) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                TrayNotification tray = new TrayNotification("\u0644\u0637\u0641\u0627 \u0628\u0639\u062f\u0627 \u062a\u0644\u0627\u0634 \u06a9\u0646\u06cc\u062f.", Notifications.ERROR);
                                tray.showAndDismiss();
                            }
                        });
                    }
                    if (apiResponse.getCode().equals("invalid_mobile")) {
                        throw new InvalidFormatException(apiResponse.getMessage());
                    }
                    if (apiResponse.getCode().equals("mobile_exists")) {
                        throw new AlreadyExistException(apiResponse.getMessage());
                    }
                    if (apiResponse.getCode().equals("too_many_requests")) {
                        throw new TooManyRequestException(apiResponse.getMessage());
                    }
                    break block10;
                }
                apiResponse = (ApiResponse)new Gson().fromJson((JsonElement)response.body(), ApiResponse.class);
                throw new SuccessException(apiResponse.getMessage());
            }
            catch (IOException e) {
                if (doactionHelper.checkUserConnection()) {
                    Sentry.captureException((Throwable)e);
                    throw new ServerException();
                }
                throw new ConnectionException();
            }
        }
    }

    public void emailRegister(String email) throws InvalidFormatException, AlreadyExistException, ServerException, ConnectionException, SuccessException, TooManyRequestException {
        block10: {
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("email", email);
            try {
                Response response = dictationService.emailRegister("fa_ir", info).execute();
                ApiResponse apiResponse = null;
                if (!response.isSuccessful()) {
                    try {
                        apiResponse = (ApiResponse)new Gson().fromJson(response.errorBody().string(), ApiResponse.class);
                    }
                    catch (JsonSyntaxException e) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                TrayNotification tray = new TrayNotification("\u0644\u0637\u0641\u0627 \u0628\u0639\u062f\u0627 \u062a\u0644\u0627\u0634 \u06a9\u0646\u06cc\u062f.", Notifications.ERROR);
                                tray.showAndDismiss();
                            }
                        });
                    }
                    if (apiResponse.getCode().equals("invalid_email")) {
                        throw new InvalidFormatException(apiResponse.getMessage());
                    }
                    if (apiResponse.getCode().equals("email_exists")) {
                        throw new AlreadyExistException(apiResponse.getMessage());
                    }
                    if (apiResponse.getCode().equals("too_many_requests")) {
                        throw new TooManyRequestException(apiResponse.getMessage());
                    }
                    if (response.code() == 400) {
                        throw new InvalidFormatException(apiResponse.getMessage());
                    }
                    break block10;
                }
                apiResponse = (ApiResponse)new Gson().fromJson((JsonElement)response.body(), ApiResponse.class);
                throw new SuccessException(apiResponse.getMessage());
            }
            catch (IOException e) {
                if (doactionHelper.checkUserConnection()) {
                    Sentry.captureException((Throwable)e);
                    throw new ServerException();
                }
                throw new ConnectionException();
            }
        }
    }

    public void phoneCodeVerification(String mobile_number, String code) throws ServerException, ConnectionException, InvalidFormatException, ExpiredCodeVerificationException, SuccessException, InvalidCodeVerificationException, GeneralException {
        block10: {
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("mobile_number", mobile_number);
            info.put("code", code);
            try {
                Response response = dictationService.phoneCodeVerification("fa_ir", info).execute();
                ApiResponse apiResponse = null;
                if (!response.isSuccessful()) {
                    if (response.code() == 500) {
                        doactionHelper.captureExceptionSentryServerError();
                    }
                    try {
                        apiResponse = (ApiResponse)new Gson().fromJson(response.errorBody().string(), ApiResponse.class);
                    }
                    catch (JsonSyntaxException e) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                TrayNotification tray = new TrayNotification("\u0644\u0637\u0641\u0627 \u0628\u0639\u062f\u0627 \u062a\u0644\u0627\u0634 \u06a9\u0646\u06cc\u062f.", Notifications.ERROR);
                                tray.showAndDismiss();
                            }
                        });
                    }
                    if (apiResponse.getCode().equals("invalid_mobile")) {
                        throw new InvalidFormatException(apiResponse.getMessage());
                    }
                    if (apiResponse.getCode().equals("invalid_verification_code")) {
                        throw new InvalidCodeVerificationException(apiResponse.getMessage());
                    }
                    if (apiResponse.getCode().equals("expired_verification_code")) {
                        throw new ExpiredCodeVerificationException(apiResponse.getMessage());
                    }
                    break block10;
                }
                apiResponse = (ApiResponse)new Gson().fromJson((JsonElement)response.body(), ApiResponse.class);
                throw new SuccessException(apiResponse.getMessage());
            }
            catch (IOException e) {
                if (doactionHelper.checkUserConnection()) {
                    Sentry.captureException((Throwable)e);
                    throw new ServerException();
                }
                throw new ConnectionException();
            }
        }
    }

    public void emailCodeVerification(String email, String code) throws ServerException, ConnectionException, InvalidFormatException, ExpiredCodeVerificationException, SuccessException, InvalidCodeVerificationException, GeneralException {
        block10: {
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("email", email);
            info.put("code", code);
            try {
                Response response = dictationService.emailCodeVerification("fa_ir", info).execute();
                ApiResponse apiResponse = null;
                if (!response.isSuccessful()) {
                    if (response.code() == 500) {
                        doactionHelper.captureExceptionSentryServerError();
                    }
                    try {
                        apiResponse = (ApiResponse)new Gson().fromJson(response.errorBody().string(), ApiResponse.class);
                    }
                    catch (JsonSyntaxException e) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                TrayNotification tray = new TrayNotification("\u0644\u0637\u0641\u0627 \u0628\u0639\u062f\u0627 \u062a\u0644\u0627\u0634 \u06a9\u0646\u06cc\u062f.", Notifications.ERROR);
                                tray.showAndDismiss();
                            }
                        });
                    }
                    if (apiResponse.getCode().equals("invalid_email")) {
                        throw new InvalidFormatException(apiResponse.getMessage());
                    }
                    if (apiResponse.getCode().equals("invalid_verification_code")) {
                        throw new InvalidCodeVerificationException(apiResponse.getMessage());
                    }
                    if (apiResponse.getCode().equals("expired_verification_code")) {
                        throw new ExpiredCodeVerificationException(apiResponse.getMessage());
                    }
                    break block10;
                }
                apiResponse = (ApiResponse)new Gson().fromJson((JsonElement)response.body(), ApiResponse.class);
                throw new SuccessException(apiResponse.getMessage());
            }
            catch (IOException e) {
                if (doactionHelper.checkUserConnection()) {
                    Sentry.captureException((Throwable)e);
                    throw new ServerException();
                }
                throw new ConnectionException();
            }
        }
    }

    public HashMap<String, String> phoneRegistrationSetPassword(String first_name, String last_name, String password, String mobile_number) throws ServerException, ConnectionException, AlreadyExistException, ExpiredCodeVerificationException, GeneralException {
        HashMap<String, String> info = new HashMap<String, String>();
        HashMap<String, String> result = new HashMap<String, String>();
        info.put("first_name", first_name);
        info.put("last_name", last_name);
        info.put("password", password);
        info.put("mobile_number", mobile_number);
        try {
            Response response = dictationService.phoneRegisterSetPassword("fa_ir", info).execute();
            ApiResponse apiResponse = null;
            if (!response.isSuccessful()) {
                if (response.code() == 500) {
                    doactionHelper.captureExceptionSentryServerError();
                }
                try {
                    apiResponse = (ApiResponse)new Gson().fromJson(response.errorBody().string(), ApiResponse.class);
                }
                catch (JsonSyntaxException e) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            TrayNotification tray = new TrayNotification("\u0644\u0637\u0641\u0627 \u0628\u0639\u062f\u0627 \u062a\u0644\u0627\u0634 \u06a9\u0646\u06cc\u062f.", Notifications.ERROR);
                            tray.showAndDismiss();
                        }
                    });
                }
                if (apiResponse.getCode().equals("mobile_exists")) {
                    throw new AlreadyExistException(apiResponse.getMessage());
                }
                if (apiResponse.getCode().equals("expired_verification_code")) {
                    throw new ExpiredCodeVerificationException(apiResponse.getMessage());
                }
            } else {
                System.out.println("refresh : " + String.valueOf(((JsonObject)response.body()).getAsJsonObject("extra").get("refresh").toString().split("\"")[1]));
                System.out.println("access : " + String.valueOf(((JsonObject)response.body()).getAsJsonObject("extra").get("access").toString().split("\"")[1]));
                result.put("refresh", String.valueOf(((JsonObject)response.body()).getAsJsonObject("extra").get("refresh").toString().split("\"")[1]));
                result.put("access", String.valueOf(((JsonObject)response.body()).getAsJsonObject("extra").get("access").toString().split("\"")[1]));
                userInfo.setRefresh(result.get("refresh"));
                userInfo.setAccess(result.get("access"));
                userInfo.setUser_id(userInfo.decodeToken(userInfo.getAccess()));
                UserData userData = UserData.get();
                if (userData != null) {
                    userData.setUserId(userInfo.getUser_id());
                    userData.setRefresh(userInfo.getRefresh());
                    userData.setAccess(userInfo.getAccess());
                    UserData.put(userData);
                }
            }
            return result;
        }
        catch (IOException e) {
            if (doactionHelper.checkUserConnection()) {
                Sentry.captureException((Throwable)e);
                throw new ServerException();
            }
            throw new ConnectionException();
        }
    }

    public HashMap<String, String> emailRegistrationSetPassword(String first_name, String last_name, String password, String email) throws ServerException, ConnectionException, AlreadyExistException, ExpiredCodeVerificationException, GeneralException {
        HashMap<String, String> info = new HashMap<String, String>();
        HashMap<String, String> result = new HashMap<String, String>();
        info.put("first_name", first_name);
        info.put("last_name", last_name);
        info.put("password", password);
        info.put("email", email);
        try {
            Response response = dictationService.emailRegisterSetPassword("fa_ir", info).execute();
            ApiResponse apiResponse = null;
            if (!response.isSuccessful()) {
                if (response.code() == 500) {
                    doactionHelper.captureExceptionSentryServerError();
                }
                System.out.println("not success");
                String temp = response.errorBody().string();
                System.out.println(temp);
                try {
                    apiResponse = (ApiResponse)new Gson().fromJson(response.errorBody().string(), ApiResponse.class);
                }
                catch (JsonSyntaxException e) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            TrayNotification tray = new TrayNotification("\u0644\u0637\u0641\u0627 \u0628\u0639\u062f\u0627 \u062a\u0644\u0627\u0634 \u06a9\u0646\u06cc\u062f.", Notifications.ERROR);
                            tray.showAndDismiss();
                        }
                    });
                }
                if (apiResponse.getCode().equals("email_exists")) {
                    throw new AlreadyExistException(apiResponse.getMessage());
                }
                if (apiResponse.getCode().equals("expired_verification_code")) {
                    throw new ExpiredCodeVerificationException(apiResponse.getMessage());
                }
            } else {
                System.out.println(((JsonObject)response.body()).toString());
                System.out.println("here");
                System.out.println("refresh : " + String.valueOf(((JsonObject)response.body()).getAsJsonObject("extra").get("refresh").toString().split("\"")[1]));
                System.out.println("access : " + String.valueOf(((JsonObject)response.body()).getAsJsonObject("extra").get("access").toString().split("\"")[1]));
                result.put("refresh", String.valueOf(((JsonObject)response.body()).getAsJsonObject("extra").get("refresh").toString().split("\"")[1]));
                result.put("access", String.valueOf(((JsonObject)response.body()).getAsJsonObject("extra").get("access").toString().split("\"")[1]));
                userInfo.setRefresh(result.get("refresh"));
                userInfo.setAccess(result.get("access"));
                userInfo.setUser_id(userInfo.decodeToken(userInfo.getAccess()));
                UserData userData = UserData.get();
                if (userData != null) {
                    userData.setUserId(userInfo.getUser_id());
                    userData.setRefresh(userInfo.getRefresh());
                    userData.setAccess(userInfo.getAccess());
                    UserData.put(userData);
                }
            }
            return result;
        }
        catch (IOException e) {
            if (doactionHelper.checkUserConnection()) {
                Sentry.captureException((Throwable)e);
                throw new ServerException();
            }
            throw new ConnectionException();
        }
    }

    public void phoneForget(String mobile_number) throws InvalidFormatException, SuccessException, ServerException, ConnectionException, TooManyRequestException, UserNotFoundException, GeneralException {
        block10: {
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("mobile_number", mobile_number);
            try {
                Response response = dictationService.phoneForgetList("fa_ir", info).execute();
                ApiResponse apiResponse = null;
                if (!response.isSuccessful()) {
                    if (response.code() == 500) {
                        doactionHelper.captureExceptionSentryServerError();
                    }
                    try {
                        apiResponse = (ApiResponse)new Gson().fromJson(response.errorBody().string(), ApiResponse.class);
                    }
                    catch (JsonSyntaxException e) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                TrayNotification tray = new TrayNotification("\u0644\u0637\u0641\u0627 \u0628\u0639\u062f\u0627 \u062a\u0644\u0627\u0634 \u06a9\u0646\u06cc\u062f.", Notifications.ERROR);
                                tray.showAndDismiss();
                            }
                        });
                    }
                    if (apiResponse.getCode().equals("invalid_mobile")) {
                        throw new InvalidFormatException(apiResponse.getMessage());
                    }
                    if (apiResponse.getCode().equals("user_not_found")) {
                        throw new UserNotFoundException(apiResponse.getMessage());
                    }
                    if (apiResponse.getCode().equals("too_many_requests")) {
                        throw new TooManyRequestException(apiResponse.getMessage());
                    }
                    break block10;
                }
                apiResponse = (ApiResponse)new Gson().fromJson((JsonElement)response.body(), ApiResponse.class);
                throw new SuccessException(apiResponse.getMessage());
            }
            catch (IOException e) {
                if (doactionHelper.checkUserConnection()) {
                    Sentry.captureException((Throwable)e);
                    throw new ServerException();
                }
                throw new ConnectionException();
            }
        }
    }

    public void emailForget(String email) throws InvalidFormatException, SuccessException, ServerException, ConnectionException, TooManyRequestException, UserNotFoundException, GeneralException {
        block10: {
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("email", email);
            try {
                Response response = dictationService.emailForgetList("fa_ir", info).execute();
                ApiResponse apiResponse = null;
                if (!response.isSuccessful()) {
                    if (response.code() == 500) {
                        doactionHelper.captureExceptionSentryServerError();
                    }
                    try {
                        apiResponse = (ApiResponse)new Gson().fromJson(response.errorBody().string(), ApiResponse.class);
                    }
                    catch (JsonSyntaxException e) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                TrayNotification tray = new TrayNotification("\u0644\u0637\u0641\u0627 \u0628\u0639\u062f\u0627 \u062a\u0644\u0627\u0634 \u06a9\u0646\u06cc\u062f.", Notifications.ERROR);
                                tray.showAndDismiss();
                            }
                        });
                    }
                    if (apiResponse.getCode().equals("invalid_email")) {
                        throw new InvalidFormatException(apiResponse.getMessage());
                    }
                    if (apiResponse.getCode().equals("user_not_found")) {
                        throw new UserNotFoundException(apiResponse.getMessage());
                    }
                    if (apiResponse.getCode().equals("too_many_requests")) {
                        throw new TooManyRequestException(apiResponse.getMessage());
                    }
                    break block10;
                }
                apiResponse = (ApiResponse)new Gson().fromJson((JsonElement)response.body(), ApiResponse.class);
                throw new SuccessException(apiResponse.getMessage());
            }
            catch (IOException e) {
                if (doactionHelper.checkUserConnection()) {
                    Sentry.captureException((Throwable)e);
                    throw new ServerException();
                }
                throw new ConnectionException();
            }
        }
    }

    public HashMap<String, String> phoneForgetSetPassword(String mobile_number, String password) throws ServerException, ConnectionException, ExpiredCodeVerificationException, UserNotFoundException, GeneralException {
        block10: {
            HashMap<String, String> info = new HashMap<String, String>();
            HashMap<String, String> result = new HashMap<String, String>();
            info.put("mobile_number", mobile_number);
            info.put("password", password);
            try {
                Response response = dictationService.phoneForgetSetPassword("fa_ir", info).execute();
                ApiResponse apiResponse = null;
                if (!response.isSuccessful()) {
                    if (response.code() == 500) {
                        doactionHelper.captureExceptionSentryServerError();
                    }
                    try {
                        apiResponse = (ApiResponse)new Gson().fromJson(response.errorBody().string(), ApiResponse.class);
                    }
                    catch (JsonSyntaxException e) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                TrayNotification tray = new TrayNotification("\u0644\u0637\u0641\u0627 \u0628\u0639\u062f\u0627 \u062a\u0644\u0627\u0634 \u06a9\u0646\u06cc\u062f.", Notifications.ERROR);
                                tray.showAndDismiss();
                            }
                        });
                    }
                    if (apiResponse.getCode().equals("expired_verification_code")) {
                        throw new ExpiredCodeVerificationException(apiResponse.getMessage());
                    }
                    if (apiResponse.getCode().equals("user_not_found")) {
                        throw new UserNotFoundException(apiResponse.getMessage());
                    }
                    break block10;
                }
                System.out.println(((JsonObject)response.body()).toString());
                System.out.println("here");
                System.out.println("refresh : " + String.valueOf(((JsonObject)response.body()).getAsJsonObject("extra").get("refresh").toString().split("\"")[1]));
                System.out.println("access : " + String.valueOf(((JsonObject)response.body()).getAsJsonObject("extra").get("access").toString().split("\"")[1]));
                result.put("refresh", String.valueOf(((JsonObject)response.body()).getAsJsonObject("extra").get("refresh").toString().split("\"")[1]));
                result.put("access", String.valueOf(((JsonObject)response.body()).getAsJsonObject("extra").get("access").toString().split("\"")[1]));
                userInfo.setRefresh((String)result.get("refresh"));
                System.out.println("here3");
                userInfo.setAccess((String)result.get("access"));
                userInfo.setUser_id(userInfo.decodeToken(userInfo.getAccess()));
                System.out.println("here4");
                UserData userData = UserData.get();
                System.out.println("here2");
                if (userData != null) {
                    userData.setUserId(userInfo.getUser_id());
                    userData.setRefresh(userInfo.getRefresh());
                    userData.setAccess(userInfo.getAccess());
                    UserData.put(userData);
                }
                System.out.println("here2");
                return result;
            }
            catch (IOException e) {
                if (doactionHelper.checkUserConnection()) {
                    Sentry.captureException((Throwable)e);
                    throw new ServerException();
                }
                throw new ConnectionException();
            }
        }
        return null;
    }

    public HashMap<String, String> emailForgetSetPassword(String email, String password) throws ServerException, ConnectionException, ExpiredCodeVerificationException, UserNotFoundException, GeneralException {
        block10: {
            HashMap<String, String> info = new HashMap<String, String>();
            HashMap<String, String> result = new HashMap<String, String>();
            info.put("mobile_number", email);
            info.put("password", password);
            try {
                Response response = dictationService.emailForgetSetPassword("fa_ir", info).execute();
                ApiResponse apiResponse = null;
                if (!response.isSuccessful()) {
                    if (response.code() == 500) {
                        doactionHelper.captureExceptionSentryServerError();
                    }
                    try {
                        apiResponse = (ApiResponse)new Gson().fromJson(response.errorBody().string(), ApiResponse.class);
                    }
                    catch (JsonSyntaxException e) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                TrayNotification tray = new TrayNotification("\u0644\u0637\u0641\u0627 \u0628\u0639\u062f\u0627 \u062a\u0644\u0627\u0634 \u06a9\u0646\u06cc\u062f.", Notifications.ERROR);
                                tray.showAndDismiss();
                            }
                        });
                    }
                    if (apiResponse.getCode().equals("expired_verification_code")) {
                        throw new ExpiredCodeVerificationException(apiResponse.getMessage());
                    }
                    if (apiResponse.getCode().equals("user_not_found")) {
                        throw new UserNotFoundException(apiResponse.getMessage());
                    }
                    break block10;
                }
                System.out.println(((JsonObject)response.body()).toString());
                System.out.println("here");
                System.out.println("refresh : " + String.valueOf(((JsonObject)response.body()).getAsJsonObject("extra").get("refresh").toString().split("\"")[1]));
                System.out.println("access : " + String.valueOf(((JsonObject)response.body()).getAsJsonObject("extra").get("access").toString().split("\"")[1]));
                result.put("refresh", String.valueOf(((JsonObject)response.body()).getAsJsonObject("extra").get("refresh").toString().split("\"")[1]));
                result.put("access", String.valueOf(((JsonObject)response.body()).getAsJsonObject("extra").get("access").toString().split("\"")[1]));
                userInfo.setRefresh((String)result.get("refresh"));
                userInfo.setAccess((String)result.get("access"));
                userInfo.setUser_id(userInfo.decodeToken(userInfo.getAccess()));
                UserData userData = UserData.get();
                if (userData != null) {
                    userData.setUserId(userInfo.getUser_id());
                    userData.setRefresh(userInfo.getRefresh());
                    userData.setAccess(userInfo.getAccess());
                    UserData.put(userData);
                }
                return result;
            }
            catch (IOException e) {
                if (doactionHelper.checkUserConnection()) {
                    Sentry.captureException((Throwable)e);
                    throw new ServerException();
                }
                throw new ConnectionException();
            }
        }
        return null;
    }

    public String getTermsAndConditions() throws ServerException, ConnectionException, GeneralException {
        block5: {
            try {
                Response response = dictationService.getTermsAndConditions().execute();
                if (!response.isSuccessful()) {
                    if (response.code() == 500) {
                        doactionHelper.captureExceptionSentryServerError();
                    }
                    break block5;
                }
                return ((ResponseBody)response.body()).string();
            }
            catch (IOException e) {
                if (doactionHelper.checkUserConnection()) {
                    Sentry.captureException((Throwable)e);
                    throw new ServerException();
                }
                throw new ConnectionException();
            }
        }
        return null;
    }

    public String getPrivacyAndPolicy() throws ServerException, ConnectionException, GeneralException {
        try {
            Response response = dictationService.getPrivacyAndPolicy().execute();
            if (!response.isSuccessful()) {
                if (response.code() == 500) {
                    doactionHelper.captureExceptionSentryServerError();
                }
                throw new GeneralException();
            }
            return ((ResponseBody)response.body()).string();
        }
        catch (IOException e) {
            if (doactionHelper.checkUserConnection()) {
                Sentry.captureException((Throwable)e);
                throw new ServerException();
            }
            throw new ConnectionException();
        }
    }

    public JsonObject appVersion() throws ServerException, ConnectionException, GeneralException {
        try {
            Response response = dictationService.appVersion("desktop").execute();
            if (!response.isSuccessful()) {
                if (response.code() == 500) {
                    doactionHelper.captureExceptionSentryServerError();
                }
                throw new GeneralException();
            }
            return (JsonObject)response.body();
        }
        catch (IOException e) {
            if (doactionHelper.checkUserConnection()) {
                Sentry.captureException((Throwable)e);
                throw new ServerException();
            }
            throw new ConnectionException();
        }
    }

    public HashMap<String, Integer> getFileNameHashCode() throws ServerException, ConnectionException {
        try {
            Response response = dictationService.getFileNameHashCode().execute();
            if (response.isSuccessful()) {
                ArrayList fileNameHashCodes = (ArrayList)new Gson().fromJson((JsonElement)((JsonObject)response.body()).getAsJsonArray("results"), new TypeToken<ArrayList<FileNameHashCode>>(){}.getType());
                HashMap<String, Integer> res = new HashMap<String, Integer>();
                for (FileNameHashCode fileNameHashCode : fileNameHashCodes) {
                    res.put(fileNameHashCode.getFileName(), fileNameHashCode.getHashCode());
                }
                return res;
            }
        }
        catch (IOException e) {
            if (doactionHelper.checkUserConnection()) {
                Sentry.captureException((Throwable)e);
                throw new ServerException();
            }
            throw new ConnectionException();
        }
        return null;
    }

    public void updateDocumentWithEditedLabel(Label label) throws InvalidTokenException, NotExistException, GeneralException, ConnectionException, ServerException {
        List<Document> documents = Document.getAll(label);
        for (int i = 0; i < documents.size(); ++i) {
            this.getDocument(documents.get(i).getUuid(), false);
        }
    }
}

