/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.utils;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.sentry.Sentry;
import ir.deepmine.dictation.api.ContentFromUrl;
import ir.deepmine.dictation.api.DictationService;
import ir.deepmine.dictation.api.ServerSingleton;
import ir.deepmine.dictation.database.Document;
import ir.deepmine.dictation.database.PunctuationMark;
import ir.deepmine.dictation.exceptions.ConnectionException;
import ir.deepmine.dictation.exceptions.ForceUpdateException;
import ir.deepmine.dictation.exceptions.GeneralException;
import ir.deepmine.dictation.exceptions.InternalServerException;
import ir.deepmine.dictation.exceptions.ServerException;
import ir.deepmine.dictation.exceptions.SoftUpdateException;
import ir.deepmine.dictation.utils.DoActions;
import ir.deepmine.dictation.utils.UserInfo;
import ir.deepmine.dictation.utils.VersionInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import javafx.scene.image.Image;
import javax.net.ssl.HttpsURLConnection;
import org.jsoup.Jsoup;
import retrofit2.Response;

public class DoActionHelper {
    private static final UserInfo userInfo = UserInfo.getInstance();
    private static final DictationService dictationService = ServerSingleton.getInstance().getDictationService();
    private static final ContentFromUrl contentUrlService = ServerSingleton.getInstance().getContentUrlService();
    private static DoActionHelper doActionHelper;

    public static DoActionHelper getInstance() {
        if (doActionHelper == null) {
            doActionHelper = new DoActionHelper();
        }
        return doActionHelper;
    }

    public boolean checkUserConnection() {
        try {
            URL url = new URL("http://www.google.com");
            URLConnection urlConnection = url.openConnection();
            urlConnection.connect();
            System.out.println("connect to google");
            return true;
        }
        catch (MalformedURLException e) {
            System.out.println("not connect to google");
            return false;
        }
        catch (IOException e) {
            System.out.println("not connect to google");
            return false;
        }
    }

    public Image downloadAvatar(String path) throws IOException {
        URL url = new URL("https://file-access.deepmine.ir/file?path=" + path);
        URLConnection urlConnection = url.openConnection();
        urlConnection.setConnectTimeout(4000);
        urlConnection.setReadTimeout(4000);
        urlConnection.setRequestProperty("Authorization", "Token " + UserInfo.getInstance().getAccess());
        try (InputStream stream = urlConnection.getInputStream();){
            Image image = new Image(stream);
            return image;
        }
    }

    public void captureExceptionServer() {
        Sentry.captureException((Throwable)new ServerException());
    }

    public void captureExceptionSentryServerError() throws GeneralException {
        Sentry.captureException((Throwable)new InternalServerException());
        throw new GeneralException();
    }

    public void downloadWithoutAuth(String outputUrl, String inputPath) throws IOException {
        HttpURLConnection connection;
        URL input = new URL("https://assets.deepmine.ir/desktop/" + inputPath);
        System.out.println("input : " + input);
        if ("http".equals(input.getProtocol())) {
            connection = (HttpURLConnection)input.openConnection();
        } else if ("https".equals(input.getProtocol())) {
            connection = (HttpsURLConnection)input.openConnection();
        } else {
            System.err.println("UNSUPPORTED PROTOCOL!");
            return;
        }
        connection.connect();
        if (connection.getResponseCode() / 100 != 2) {
            System.out.println("connection error");
            throw new IOException(connection.getResponseCode() + connection.getResponseMessage());
        }
        File file = new File(outputUrl);
        long contentLength = connection.getContentLengthLong();
        System.out.println("Content Length = " + contentLength + " bytes.");
        try (InputStream in = connection.getInputStream();
             FileOutputStream out = new FileOutputStream(file);){
            int read;
            int totalRead = 0;
            byte[] buffer = new byte[1024];
            while ((long)totalRead < contentLength && (read = in.read(buffer)) != -1) {
                out.write(buffer, 0, read);
                System.out.println("Downloading>>total read is " + (totalRead += read) + " bytes.");
            }
            System.out.println("Download finished!\nTotal Read = " + totalRead);
        }
        catch (IOException ex) {
            System.err.println("");
        }
    }

    public void download(String outputUrl, String inputPath) throws IOException {
        HttpURLConnection connection;
        System.out.println(outputUrl);
        System.out.println(inputPath);
        URL input = new URL("https://file-access.deepmine.ir/file?path=" + inputPath);
        System.out.println("input : " + input);
        if ("http".equals(input.getProtocol())) {
            connection = (HttpURLConnection)input.openConnection();
        } else if ("https".equals(input.getProtocol())) {
            connection = (HttpsURLConnection)input.openConnection();
        } else {
            System.err.println("UNSUPPORTED PROTOCOL!");
            return;
        }
        connection.setRequestProperty("Authorization", "Token " + UserInfo.getInstance().getAccess());
        connection.connect();
        if (connection.getResponseCode() / 100 != 2) {
            System.out.println("connection error");
            throw new IOException(connection.getResponseCode() + connection.getResponseMessage());
        }
        File file = new File(outputUrl);
        long contentLength = connection.getContentLengthLong();
        System.out.println("Content Length = " + contentLength + " bytes.");
        try (InputStream in = connection.getInputStream();
             FileOutputStream out = new FileOutputStream(file);){
            int read;
            int totalRead = 0;
            byte[] buffer = new byte[1024];
            while ((long)totalRead < contentLength && (read = in.read(buffer)) != -1) {
                out.write(buffer, 0, read);
                System.out.println("Downloading>>total read is " + (totalRead += read) + " bytes.");
            }
            System.out.println("Download finished!\nTotal Read = " + totalRead);
        }
        catch (IOException ex) {
            System.err.println("");
        }
    }

    public boolean checkExistId(long[] ids, long id) {
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i] != id) continue;
            return true;
        }
        return false;
    }

    public Document updateDocument(String uuid, JsonObject jsonObject) {
        Document document1 = (Document)new Gson().fromJson((JsonElement)jsonObject, Document.class);
        Document document = Document.get(uuid);
        document.setUserId(userInfo.getUser_id());
        document.setPureContent(Jsoup.parse((String)document.getContent()).text());
        document.setUpdated_at(document1.getUpdated_at());
        document.setDeletion_status(document1.getDeletion_status());
        document.setTrashed_date(document1.getTrashed_date());
        return document;
    }

    public String getContentFromUrl(String url) throws ConnectionException, GeneralException, ServerException {
        String access = userInfo.getAccess();
        Response response = null;
        System.out.println("access: " + access);
        System.out.println("url: " + url);
        try {
            response = contentUrlService.getContentUrl("Token " + access, url).execute();
            if (!response.isSuccessful()) {
                System.out.println("error body: " + response.errorBody().string());
                System.out.println(response.errorBody().string());
                throw new GeneralException("\u062e\u0637\u0627\u06cc\u06cc \u0631\u062e \u062f\u0627\u062f\u0647 \u0627\u0633\u062a");
            }
        }
        catch (IOException e) {
            if (this.checkUserConnection()) {
                Sentry.captureException((Throwable)e);
                throw new ServerException();
            }
            throw new ConnectionException();
        }
        return (String)response.body();
    }

    public void checkExistUpdate(int version_code) throws ServerException, ConnectionException, ForceUpdateException, SoftUpdateException, GeneralException {
        JsonObject body = DoActions.getInstance().appVersion();
        VersionInfo versionInfo = (VersionInfo)new Gson().fromJson((JsonElement)body, VersionInfo.class);
        if (!versionInfo.is_soft_update && versionInfo.min_support_version > version_code) {
            throw new ForceUpdateException();
        }
        if (!versionInfo.is_soft_update) {
            throw new SoftUpdateException();
        }
        if (version_code < versionInfo.min_support_version) {
            throw new SoftUpdateException();
        }
    }

    public void downloadFileForUpdate(String pathToSave, String pathToUpdate) {
    }

    public void coordinationRemovedUserPunc(ArrayList<PunctuationMark> punctuationMarks) {
        int i;
        long[] serverId = new long[punctuationMarks.size()];
        long[] DBId = PunctuationMark.getIDs(userInfo.getUser_id());
        for (i = 0; i < punctuationMarks.size(); ++i) {
            serverId[i] = punctuationMarks.get(i).getId();
        }
        for (i = 0; i < DBId.length; ++i) {
            if (this.checkExistId(serverId, DBId[i])) continue;
            PunctuationMark.remove(DBId[i]);
        }
    }
}

