/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.ui.notification.animations;

import ir.deepmine.dictation.ui.notification.animations.AbstractAnimation;
import ir.deepmine.dictation.ui.notification.models.CustomStage;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.util.Duration;

final class SlideAnimation
extends AbstractAnimation {
    SlideAnimation(CustomStage customStage) {
        super(customStage);
    }

    @Override
    protected Timeline setupShowAnimation() {
        Timeline tl = new Timeline();
        double offScreenX = this.stage.getOffScreenBounds().getX();
        KeyValue kvX = new KeyValue((WritableValue)this.stage.xLocationProperty(), (Object)offScreenX);
        KeyFrame frame1 = new KeyFrame(Duration.ZERO, new KeyValue[]{kvX});
        Interpolator interpolator = Interpolator.TANGENT((Duration)Duration.millis((double)300.0), (double)50.0);
        KeyValue kvInter = new KeyValue((WritableValue)this.stage.xLocationProperty(), (Object)this.stage.getBottomRight().getX(), interpolator);
        KeyFrame frame2 = new KeyFrame(Duration.millis((double)1300.0), new KeyValue[]{kvInter});
        KeyValue kvOpacity = new KeyValue((WritableValue)this.stage.opacityProperty(), (Object)0.0);
        KeyFrame frame3 = new KeyFrame(Duration.ZERO, new KeyValue[]{kvOpacity});
        KeyValue kvOpacity2 = new KeyValue((WritableValue)this.stage.opacityProperty(), (Object)1.0);
        KeyFrame frame4 = new KeyFrame(Duration.millis((double)1000.0), new KeyValue[]{kvOpacity2});
        tl.getKeyFrames().addAll((Object[])new KeyFrame[]{frame1, frame2, frame3, frame4});
        tl.setOnFinished(e -> {
            this.trayIsShowing = true;
        });
        return tl;
    }

    @Override
    protected Timeline setupDismissAnimation() {
        Timeline tl = new Timeline();
        double offScreenX = this.stage.getOffScreenBounds().getX();
        Interpolator interpolator = Interpolator.TANGENT((Duration)Duration.millis((double)300.0), (double)50.0);
        double trayPadding = 3.0;
        KeyValue kvX = new KeyValue((WritableValue)this.stage.xLocationProperty(), (Object)(offScreenX + trayPadding), interpolator);
        KeyFrame frame1 = new KeyFrame(Duration.millis((double)1400.0), new KeyValue[]{kvX});
        KeyValue kvOpacity = new KeyValue((WritableValue)this.stage.opacityProperty(), (Object)0.4);
        KeyFrame frame2 = new KeyFrame(Duration.millis((double)2000.0), new KeyValue[]{kvOpacity});
        tl.getKeyFrames().addAll((Object[])new KeyFrame[]{frame1, frame2});
        tl.setOnFinished(e -> {
            this.trayIsShowing = false;
            this.stage.close();
            this.stage.setLocation(this.stage.getBottomRight());
        });
        return tl;
    }
}

