/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.ui.gauge;

import ir.deepmine.dictation.ui.gauge.RingProgressIndicatorSkin;
import ir.deepmine.dictation.utils.AudioRecorder;
import ir.deepmine.dictation.utils.EnergyCalculator;
import ir.deepmine.dictation.utils.Settings;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.util.Duration;

public class RingProgressIndicator
extends Control
implements AudioRecorder.RecordObserver {
    private DoubleProperty ringWidth = new SimpleDoubleProperty(6.0);
    private DoubleProperty innerCircleRadius;
    private DoubleProperty progress = new SimpleDoubleProperty(0.0);
    private ReadOnlyBooleanWrapper indeterminate = new ReadOnlyBooleanWrapper(false);
    private final EnergyCalculator energyCalculator;
    private final float range;
    private int maxValue;
    private String type;
    private boolean up = true;

    public RingProgressIndicator(int maxValue, int range, int radius, String type) {
        this.type = type;
        this.maxValue = maxValue;
        this.range = range;
        this.energyCalculator = EnergyCalculator.getInstance(Settings.getInstance().getIntegerProperty("recorder.sample_rate"));
        this.innerCircleRadius = new SimpleDoubleProperty((double)radius);
        this.getStylesheets().add((Object)RingProgressIndicator.class.getResource("/style/ringprogress.css").toExternalForm());
    }

    public RingProgressIndicator(int maxValue, int range, int radius) {
        this(maxValue, range, radius, "plan");
    }

    public void setProgress(double progressValue) {
        this.progressProperty().setValue((Number)this.defaultToMax(progressValue));
        this.indeterminate.set(progressValue < 0.0);
    }

    public void setProgressForPlan(double progressValue) {
        double dif = Math.abs(this.defaultToMax(progressValue) - this.progress.get());
        if (dif != 0.0) {
            Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)(200.0 / (dif * 1000.0))), event -> {
                if (this.defaultToMax(progressValue) - this.progress.get() > 0.0) {
                    this.progressProperty().setValue((Number)(this.progressProperty().getValue() + 0.001));
                } else if (this.progressProperty().getValue() - 0.001 <= 0.0) {
                    this.progressProperty().setValue((Number)0);
                } else {
                    this.progressProperty().setValue((Number)(this.progressProperty().getValue() - 0.001));
                }
            }, new KeyValue[0])});
            timeline.setCycleCount((int)dif * 1000);
            timeline.play();
        }
        this.indeterminate.set(progressValue < 0.0);
    }

    public double defaultToMax(double value) {
        if (value > (double)this.maxValue) {
            return this.maxValue;
        }
        if (value < 0.0) {
            return 0.0;
        }
        return value;
    }

    protected Skin<?> createDefaultSkin() {
        return new RingProgressIndicatorSkin(this);
    }

    public final DoubleProperty ringWidthProperty() {
        return this.ringWidth;
    }

    public final double getRingWidth() {
        return this.ringWidthProperty().get();
    }

    public double getProgress() {
        return this.progress.get();
    }

    public DoubleProperty progressProperty() {
        return this.progress;
    }

    public boolean isIndeterminate() {
        return this.indeterminate.get();
    }

    public ReadOnlyBooleanProperty indeterminateProperty() {
        return this.indeterminate.getReadOnlyProperty();
    }

    public final DoubleProperty innerCircleRadiusProperty() {
        return this.innerCircleRadius;
    }

    public final double getInnerCircleRadius() {
        return this.innerCircleRadiusProperty().get();
    }

    @Override
    public void onBufferReady(byte[] speechBuffer, int length) {
        int energyLevel = this.energyCalculator.processBuffer(speechBuffer, length);
        this.setProgress(energyLevel);
    }

    public float getRange() {
        return this.range;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

