/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.ui;

import ir.deepmine.dictation.Main;
import java.awt.Component;
import java.awt.Window;
import java.io.IOException;
import java.net.URL;
import javafx.application.Platform;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.embed.swing.JFXPanel;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javax.swing.JFrame;

public class PartialResultsForm
extends JFrame {
    private static PartialResultsForm instance = null;
    private final Scene scene = this.loadScene();
    private static final StringProperty partialResult = new SimpleStringProperty();

    private PartialResultsForm() {
        if (this.scene == null) {
            return;
        }
        JFXPanel fxContainer = new JFXPanel();
        fxContainer.setScene(this.scene);
        this.getContentPane().add((Component)fxContainer);
        this.setType(Window.Type.UTILITY);
        this.setAlwaysOnTop(true);
        this.setSize((int)this.scene.getWidth(), (int)this.scene.getHeight());
        this.setUndecorated(true);
        this.setFocusable(false);
        this.setFocusableWindowState(false);
        this.setLocation(10, 10);
    }

    private Scene loadScene() {
        Parent root;
        System.setProperty("prism.lcdtext", "false");
        URL fxmlUrl = Main.class.getResource("/fxml/partial_results.fxml");
        if (fxmlUrl == null) {
            return null;
        }
        try {
            root = (Parent)FXMLLoader.load((URL)fxmlUrl);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        Scene scene = new Scene(root);
        scene.setFill((Paint)Color.TRANSPARENT);
        return scene;
    }

    public static synchronized PartialResultsForm getInstance() {
        if (instance == null) {
            instance = new PartialResultsForm();
        }
        return instance;
    }

    public Scene getScene() {
        return this.scene;
    }

    public static StringProperty getPartialResult() {
        return partialResult;
    }

    public void setPartialResult(String result) {
        Platform.runLater(() -> partialResult.set((Object)result));
    }
}

