/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.ui;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.geometry.Rectangle2D;
import javafx.scene.Scene;
import javafx.stage.Screen;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class MainFrame
extends JFrame {
    private JFXPanel fxContainer;
    private boolean isFocusable;

    public MainFrame(Scene scene) {
        this.isFocusable = this.isFocusable;
        this.fxContainer = new JFXPanel();
        this.fxContainer.setScene(scene);
        this.getContentPane().add((Component)this.fxContainer);
        this.setAlwaysOnTop(true);
        this.setType(Window.Type.UTILITY);
        this.setDefaultCloseOperation(3);
        this.setSize(260, 100);
        this.setUndecorated(true);
        this.setFocusable(false);
        this.setFocusableWindowState(false);
        SwingUtilities.invokeLater(this::addAppToTray);
        Rectangle2D bounds = Screen.getPrimary().getVisualBounds();
        int x = (int)((bounds.getWidth() - scene.getWidth()) * 0.5);
        this.setLocation(x, 0);
        this.setBackground(new Color(1.0f, 1.0f, 1.0f, 0.0f));
    }

    private void addAppToTray() {
        try {
            Toolkit.getDefaultToolkit();
            if (!SystemTray.isSupported()) {
                System.out.println("No system tray support, application exiting.");
                this.setVisible(false);
                this.dispose();
                System.exit(0);
            }
            SystemTray tray = SystemTray.getSystemTray();
            BufferedImage image = ImageIO.read(this.getClass().getResource("/icons/mic-small.png"));
            TrayIcon trayIcon = new TrayIcon(image);
            trayIcon.addActionListener(event -> Platform.runLater(this::showStage));
            MenuItem openItem = new MenuItem("Show");
            openItem.addActionListener(event -> Platform.runLater(this::showStage));
            Font defaultFont = Font.decode(null);
            Font boldFont = defaultFont.deriveFont(1);
            openItem.setFont(boldFont);
            MenuItem exitItem = new MenuItem("Exit");
            exitItem.addActionListener(event -> {
                this.setVisible(false);
                this.dispose();
                System.exit(0);
                tray.remove(trayIcon);
            });
            PopupMenu popup = new PopupMenu();
            popup.add(openItem);
            popup.addSeparator();
            popup.add(exitItem);
            trayIcon.setPopupMenu(popup);
            tray.add(trayIcon);
        }
        catch (AWTException | IOException e) {
            System.out.println("Unable to init system tray");
            e.printStackTrace();
        }
    }

    private void showStage() {
        this.setVisible(true);
        this.toFront();
    }
}

