/*
 * Decompiled with CFR 0.152.
 */
package ir.deepmine.dictation.ui;

import com.jfoenix.controls.JFXButton;
import ir.deepmine.dictation.database.DefaultPlan;
import ir.deepmine.dictation.utils.Utilities;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;

public class CustomGoldenPlan
extends AnchorPane {
    private DefaultPlan defaultPlan;
    private Label nameLabel;
    private Label minuteLabelNum;
    private Label dayLabelNum;
    private Text priceWithoutDiscountLabel;
    private Text priceWithDiscountLabel;
    private Label discountLabel;
    private JFXButton buyButton;
    private JFXButton descriptionButton;
    private Label descriptionLabel;
    private Label minute;
    private Label day;
    private Text tooman1;
    private Text tooman2;
    private HBox discountBox;
    private HBox withoutDiscountBox;
    private Image expandMore;
    private Image expandLess;
    private ImageView expand;
    private String state;

    public CustomGoldenPlan(DefaultPlan defaultPlan) {
        this.defaultPlan = defaultPlan;
        this.nameLabel = new Label(defaultPlan.getName());
        String minuteNum = String.valueOf((int)((double)defaultPlan.getQuota_sec() / 60.0));
        String dayNum = String.valueOf((int)((double)defaultPlan.getExpire_at_hours() / 24.0));
        String priceNum = String.valueOf(defaultPlan.getPrice());
        String priceWithDiscount = String.valueOf((int)((double)defaultPlan.getPrice() - (double)defaultPlan.getPrice() * ((double)defaultPlan.getDiscount() / 100.0)));
        String discount = String.valueOf(defaultPlan.getDiscount());
        minuteNum = Utilities.normalizeDigits(minuteNum);
        dayNum = Utilities.normalizeDigits(dayNum);
        priceNum = Utilities.normalizeDigits(priceNum);
        priceWithDiscount = Utilities.normalizeDigits(priceWithDiscount);
        discount = Utilities.normalizeDigits(discount);
        this.minuteLabelNum = new Label(minuteNum);
        this.dayLabelNum = new Label(dayNum);
        this.priceWithoutDiscountLabel = new Text(priceNum);
        this.priceWithDiscountLabel = new Text(priceWithDiscount);
        this.discountLabel = new Label("%" + discount);
        this.buyButton = new JFXButton("\u0641\u0639\u0627\u0644 \u0633\u0627\u0632\u06cc");
        this.descriptionButton = new JFXButton("\u062a\u0648\u0636\u06cc\u062d\u0627\u062a");
        this.descriptionLabel = new Label(defaultPlan.getDescription());
        this.minute = new Label("\u062f\u0642\u06cc\u0642\u0647");
        this.day = new Label("\u0631\u0648\u0632\u0647");
        this.tooman1 = new Text("\u062a\u0648\u0645\u0627\u0646");
        this.tooman2 = new Text("\u062a\u0648\u0645\u0627\u0646");
        this.discountBox = new HBox(new Node[]{this.tooman1, this.priceWithDiscountLabel});
        this.withoutDiscountBox = new HBox(new Node[]{this.discountLabel, this.tooman2, this.priceWithoutDiscountLabel});
        this.expandLess = new Image(String.valueOf(((Object)((Object)this)).getClass().getResource("/icons/expand_less.png")));
        this.expandMore = new Image(String.valueOf(((Object)((Object)this)).getClass().getResource("/icons/expand_more.png")));
        this.expand = new ImageView();
        this.getChildren().addAll((Object[])new Node[]{this.nameLabel, this.minuteLabelNum, this.dayLabelNum, this.discountBox, this.withoutDiscountBox, this.buyButton, this.descriptionLabel, this.descriptionButton, this.minute, this.day});
        this.state = "normal";
        this.setStyle();
    }

    private void setStyle() {
        this.setPrefSize(340.0, 138.0);
        this.setStyle("-fx-background-color: #2f2f2f;-fx-background-radius: 8 8 8 8px;");
        this.buyButton.setStyle("-fx-background-radius:10;-fx-border-radius:10;-fx-border-color:#69f0ae;");
        this.buyButton.setRipplerFill(Paint.valueOf((String)"#69f0ae"));
        this.buyButton.setTextFill(Paint.valueOf((String)"#69f0ae"));
        this.buyButton.setFont(Font.font((String)"IranSans", (FontWeight)FontWeight.BOLD, (double)14.0));
        this.buyButton.setPrefSize(-1.0, -1.0);
        this.descriptionButton.setFont(Font.font((String)"IranSans", (FontWeight)FontWeight.BLACK, (double)12.0));
        this.descriptionButton.setMaxSize(-1.0, 20.0);
        this.descriptionButton.setTextFill(Paint.valueOf((String)"#fff59d"));
        this.descriptionButton.setRipplerFill(Paint.valueOf((String)"#fff59d"));
        this.nameLabel.setTextAlignment(TextAlignment.RIGHT);
        this.nameLabel.setTextFill(Paint.valueOf((String)"#ffff8d"));
        this.nameLabel.setFont(Font.font((String)"IranSans", (FontWeight)FontWeight.BOLD, (double)16.0));
        this.priceWithDiscountLabel.setFill(Paint.valueOf((String)"#69f0ae"));
        this.priceWithDiscountLabel.setTextAlignment(TextAlignment.RIGHT);
        this.priceWithDiscountLabel.setFont(Font.font((String)"IranSans", (FontWeight)FontWeight.BLACK, (double)14.0));
        this.priceWithoutDiscountLabel.setFill(Paint.valueOf((String)"#ef9a9a"));
        this.priceWithoutDiscountLabel.setTextAlignment(TextAlignment.RIGHT);
        this.priceWithoutDiscountLabel.setFont(Font.font((String)"IranSans", (FontWeight)FontWeight.LIGHT, (double)12.0));
        this.priceWithoutDiscountLabel.setStrikethrough(true);
        this.tooman1.setFill(Paint.valueOf((String)"#69f0ae"));
        this.tooman1.setTextAlignment(TextAlignment.RIGHT);
        this.tooman1.setFont(Font.font((String)"IranSans", (FontWeight)FontWeight.BLACK, (double)14.0));
        this.tooman2.setFill(Paint.valueOf((String)"#ef9a9a"));
        this.tooman2.setTextAlignment(TextAlignment.RIGHT);
        this.tooman2.setFont(Font.font((String)"IranSans", (FontWeight)FontWeight.LIGHT, (double)12.0));
        this.tooman2.setStrikethrough(true);
        this.discountLabel.setTextAlignment(TextAlignment.LEFT);
        this.discountLabel.setTextFill(Paint.valueOf((String)"#2f2f2f"));
        this.discountLabel.setFont(Font.font((String)"IranSans", (FontWeight)FontWeight.BOLD, (double)12.0));
        this.discountLabel.setStyle("-fx-background-color:#69f0ae;-fx-background-radius:10;-fx-border-radius:10;");
        this.discountLabel.setPrefSize(-1.0, 20.0);
        this.descriptionLabel.setTextAlignment(TextAlignment.LEFT);
        this.descriptionLabel.setTextFill(Paint.valueOf((String)"#fafafa"));
        this.descriptionLabel.setFont(Font.font((String)"IranSans", (FontWeight)FontWeight.BOLD, (double)12.0));
        this.descriptionLabel.setWrapText(true);
        this.descriptionLabel.setPrefWidth(336.0);
        this.descriptionLabel.setTextAlignment(TextAlignment.RIGHT);
        this.descriptionLabel.setVisible(false);
        this.day.setTextFill(Paint.valueOf((String)"#fafafa"));
        this.day.setFont(Font.font((String)"IranSans", (FontWeight)FontWeight.BLACK, (double)12.0));
        this.minute.setTextFill(Paint.valueOf((String)"#fafafa"));
        this.minute.setFont(Font.font((String)"IranSans", (FontWeight)FontWeight.BLACK, (double)12.0));
        this.minuteLabelNum.setFont(Font.font((String)"IranSans", (FontWeight)FontWeight.BOLD, (double)14.0));
        this.minuteLabelNum.setTextFill(Paint.valueOf((String)"#ffff8d"));
        this.dayLabelNum.setFont(Font.font((String)"IranSans", (FontWeight)FontWeight.BOLD, (double)14.0));
        this.dayLabelNum.setTextFill(Paint.valueOf((String)"#ffff8d"));
        this.expand.setFitHeight(20.0);
        this.expand.setFitWidth(20.0);
        this.expand.setImage(this.expandMore);
        this.descriptionButton.setGraphic((Node)this.expand);
        this.discountBox.setSpacing(5.0);
        this.withoutDiscountBox.setSpacing(5.0);
        this.setLocation();
    }

    private void setLocation() {
        AnchorPane.setLeftAnchor((Node)this.buyButton, (Double)12.0);
        AnchorPane.setTopAnchor((Node)this.buyButton, (Double)63.0);
        AnchorPane.setTopAnchor((Node)this.nameLabel, (Double)6.0);
        AnchorPane.setRightAnchor((Node)this.nameLabel, (Double)18.0);
        AnchorPane.setTopAnchor((Node)this.minute, (Double)12.0);
        AnchorPane.setLeftAnchor((Node)this.minute, (Double)14.0);
        AnchorPane.setLeftAnchor((Node)this.day, (Double)18.0);
        AnchorPane.setTopAnchor((Node)this.day, (Double)28.0);
        AnchorPane.setTopAnchor((Node)this.minuteLabelNum, (Double)8.0);
        AnchorPane.setLeftAnchor((Node)this.minuteLabelNum, (Double)45.0);
        AnchorPane.setTopAnchor((Node)this.dayLabelNum, (Double)28.0);
        AnchorPane.setLeftAnchor((Node)this.dayLabelNum, (Double)45.0);
        AnchorPane.setBottomAnchor((Node)this.descriptionButton, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)this.descriptionButton, (Double)0.0);
        AnchorPane.setRightAnchor((Node)this.descriptionButton, (Double)0.0);
        AnchorPane.setRightAnchor((Node)this.discountBox, (Double)18.0);
        AnchorPane.setTopAnchor((Node)this.discountBox, (Double)48.0);
        AnchorPane.setRightAnchor((Node)this.withoutDiscountBox, (Double)18.0);
        AnchorPane.setTopAnchor((Node)this.withoutDiscountBox, (Double)72.0);
        AnchorPane.setBottomAnchor((Node)this.descriptionLabel, (Double)0.0);
        AnchorPane.setRightAnchor((Node)this.descriptionLabel, (Double)18.0);
        AnchorPane.setLeftAnchor((Node)this.descriptionLabel, (Double)18.0);
        this.setActions();
    }

    public JFXButton getBuyButton() {
        return this.buyButton;
    }

    public DefaultPlan getDefaultPlan() {
        return this.defaultPlan;
    }

    private void setActions() {
        this.descriptionButton.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (CustomGoldenPlan.this.state.equals("normal")) {
                    CustomGoldenPlan.this.setPrefSize(340.0, 138.0 + CustomGoldenPlan.this.descriptionLabel.getHeight());
                    CustomGoldenPlan.this.expand.setImage(CustomGoldenPlan.this.expandLess);
                    AnchorPane.setBottomAnchor((Node)CustomGoldenPlan.this.descriptionButton, (Double)CustomGoldenPlan.this.descriptionLabel.getHeight());
                    CustomGoldenPlan.this.state = "big";
                    CustomGoldenPlan.this.descriptionLabel.setVisible(true);
                } else {
                    CustomGoldenPlan.this.descriptionLabel.setVisible(false);
                    CustomGoldenPlan.this.setPrefSize(340.0, 138.0);
                    CustomGoldenPlan.this.expand.setImage(CustomGoldenPlan.this.expandMore);
                    AnchorPane.setBottomAnchor((Node)CustomGoldenPlan.this.descriptionButton, (Double)0.0);
                    CustomGoldenPlan.this.state = "normal";
                }
            }
        });
    }
}

